/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SocialProfile.Builder.class)
public final class SocialProfile {
    private final String name;

    private final String url;

    private final Map<String, Object> additionalProperties;

    private SocialProfile(String name, String url, Map<String, Object> additionalProperties) {
        this.name = name;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return value is &quot;social_profile&quot;
     */
    @JsonProperty("type")
    public String getType() {
        return "social_profile";
    }

    /**
     * @return The name of the Social media profile
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The name of the Social media profile
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SocialProfile && equalTo((SocialProfile) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SocialProfile other) {
        return name.equals(other.name) && url.equals(other.url);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.name, this.url);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        /**
         * The name of the Social media profile
         */
        UrlStage name(@NotNull String name);

        Builder from(SocialProfile other);
    }

    public interface UrlStage {
        /**
         * The name of the Social media profile
         */
        _FinalStage url(@NotNull String url);
    }

    public interface _FinalStage {
        SocialProfile build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, UrlStage, _FinalStage {
        private String name;

        private String url;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SocialProfile other) {
            name(other.getName());
            url(other.getUrl());
            return this;
        }

        /**
         * The name of the Social media profile<p>The name of the Social media profile</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public UrlStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The name of the Social media profile<p>The name of the Social media profile</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @java.lang.Override
        public SocialProfile build() {
            return new SocialProfile(name, url, additionalProperties);
        }
    }
}
