/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.tags.types.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Tags.Builder.class)
public final class Tags {
    private final List<Tag> tags;

    private final Map<String, Object> additionalProperties;

    private Tags(List<Tag> tags, Map<String, Object> additionalProperties) {
        this.tags = tags;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object
     */
    @JsonProperty("type")
    public String getType() {
        return "tag.list";
    }

    /**
     * @return A list of tags objects associated with the conversation.
     */
    @JsonProperty("tags")
    public List<Tag> getTags() {
        return tags;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Tags && equalTo((Tags) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Tags other) {
        return tags.equals(other.tags);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.tags);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<Tag> tags = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(Tags other) {
            tags(other.getTags());
            return this;
        }

        /**
         * <p>A list of tags objects associated with the conversation.</p>
         */
        @JsonSetter(value = "tags", nulls = Nulls.SKIP)
        public Builder tags(List<Tag> tags) {
            this.tags.clear();
            this.tags.addAll(tags);
            return this;
        }

        public Builder addTags(Tag tags) {
            this.tags.add(tags);
            return this;
        }

        public Builder addAllTags(List<Tag> tags) {
            this.tags.addAll(tags);
            return this;
        }

        public Tags build() {
            return new Tags(tags, additionalProperties);
        }
    }
}
