/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TextAreaComponent.Builder.class)
public final class TextAreaComponent {
    private final String id;

    private final Optional<String> label;

    private final Optional<String> placeholder;

    private final Optional<String> value;

    private final Optional<Boolean> error;

    private final Optional<Boolean> disabled;

    private final Map<String, Object> additionalProperties;

    private TextAreaComponent(
            String id,
            Optional<String> label,
            Optional<String> placeholder,
            Optional<String> value,
            Optional<Boolean> error,
            Optional<Boolean> disabled,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.label = label;
        this.placeholder = placeholder;
        this.value = value;
        this.error = error;
        this.disabled = disabled;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return A unique identifier for the component.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The text shown above the text area.
     */
    @JsonProperty("label")
    public Optional<String> getLabel() {
        return label;
    }

    /**
     * @return An example value shown inside the component when it's empty.
     */
    @JsonProperty("placeholder")
    public Optional<String> getPlaceholder() {
        return placeholder;
    }

    /**
     * @return An entered value which is already inside the component.
     */
    @JsonProperty("value")
    public Optional<String> getValue() {
        return value;
    }

    /**
     * @return Styles the input as failed. Default is false.
     */
    @JsonProperty("error")
    public Optional<Boolean> getError() {
        return error;
    }

    /**
     * @return Styles the input and prevents the action. Default is false.
     */
    @JsonProperty("disabled")
    public Optional<Boolean> getDisabled() {
        return disabled;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TextAreaComponent && equalTo((TextAreaComponent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TextAreaComponent other) {
        return id.equals(other.id)
                && label.equals(other.label)
                && placeholder.equals(other.placeholder)
                && value.equals(other.value)
                && error.equals(other.error)
                && disabled.equals(other.disabled);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.label, this.placeholder, this.value, this.error, this.disabled);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * A unique identifier for the component.
         */
        _FinalStage id(@NotNull String id);

        Builder from(TextAreaComponent other);
    }

    public interface _FinalStage {
        TextAreaComponent build();

        /**
         * <p>The text shown above the text area.</p>
         */
        _FinalStage label(Optional<String> label);

        _FinalStage label(String label);

        /**
         * <p>An example value shown inside the component when it's empty.</p>
         */
        _FinalStage placeholder(Optional<String> placeholder);

        _FinalStage placeholder(String placeholder);

        /**
         * <p>An entered value which is already inside the component.</p>
         */
        _FinalStage value(Optional<String> value);

        _FinalStage value(String value);

        /**
         * <p>Styles the input as failed. Default is false.</p>
         */
        _FinalStage error(Optional<Boolean> error);

        _FinalStage error(Boolean error);

        /**
         * <p>Styles the input and prevents the action. Default is false.</p>
         */
        _FinalStage disabled(Optional<Boolean> disabled);

        _FinalStage disabled(Boolean disabled);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, _FinalStage {
        private String id;

        private Optional<Boolean> disabled = Optional.empty();

        private Optional<Boolean> error = Optional.empty();

        private Optional<String> value = Optional.empty();

        private Optional<String> placeholder = Optional.empty();

        private Optional<String> label = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TextAreaComponent other) {
            id(other.getId());
            label(other.getLabel());
            placeholder(other.getPlaceholder());
            value(other.getValue());
            error(other.getError());
            disabled(other.getDisabled());
            return this;
        }

        /**
         * A unique identifier for the component.<p>A unique identifier for the component.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>Styles the input and prevents the action. Default is false.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        /**
         * <p>Styles the input and prevents the action. Default is false.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "disabled", nulls = Nulls.SKIP)
        public _FinalStage disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        /**
         * <p>Styles the input as failed. Default is false.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage error(Boolean error) {
            this.error = Optional.ofNullable(error);
            return this;
        }

        /**
         * <p>Styles the input as failed. Default is false.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "error", nulls = Nulls.SKIP)
        public _FinalStage error(Optional<Boolean> error) {
            this.error = error;
            return this;
        }

        /**
         * <p>An entered value which is already inside the component.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage value(String value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        /**
         * <p>An entered value which is already inside the component.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "value", nulls = Nulls.SKIP)
        public _FinalStage value(Optional<String> value) {
            this.value = value;
            return this;
        }

        /**
         * <p>An example value shown inside the component when it's empty.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage placeholder(String placeholder) {
            this.placeholder = Optional.ofNullable(placeholder);
            return this;
        }

        /**
         * <p>An example value shown inside the component when it's empty.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "placeholder", nulls = Nulls.SKIP)
        public _FinalStage placeholder(Optional<String> placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        /**
         * <p>The text shown above the text area.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage label(String label) {
            this.label = Optional.ofNullable(label);
            return this;
        }

        /**
         * <p>The text shown above the text area.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "label", nulls = Nulls.SKIP)
        public _FinalStage label(Optional<String> label) {
            this.label = label;
            return this;
        }

        @java.lang.Override
        public TextAreaComponent build() {
            return new TextAreaComponent(id, label, placeholder, value, error, disabled, additionalProperties);
        }
    }
}
