/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketPartAuthor.Builder.class)
public final class TicketPartAuthor {
    private final Type type;

    private final String id;

    private final Optional<String> name;

    private final String email;

    private final Map<String, Object> additionalProperties;

    private TicketPartAuthor(
            Type type, String id, Optional<String> name, String email, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.email = email;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the author
     */
    @JsonProperty("type")
    public Type getType() {
        return type;
    }

    /**
     * @return The id of the author
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The name of the author
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The email of the author
     */
    @JsonProperty("email")
    public String getEmail() {
        return email;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketPartAuthor && equalTo((TicketPartAuthor) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketPartAuthor other) {
        return type.equals(other.type) && id.equals(other.id) && name.equals(other.name) && email.equals(other.email);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.email);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * The type of the author
         */
        IdStage type(@NotNull Type type);

        Builder from(TicketPartAuthor other);
    }

    public interface IdStage {
        /**
         * The id of the author
         */
        EmailStage id(@NotNull String id);
    }

    public interface EmailStage {
        /**
         * The email of the author
         */
        _FinalStage email(@NotNull String email);
    }

    public interface _FinalStage {
        TicketPartAuthor build();

        /**
         * <p>The name of the author</p>
         */
        _FinalStage name(Optional<String> name);

        _FinalStage name(String name);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, IdStage, EmailStage, _FinalStage {
        private Type type;

        private String id;

        private String email;

        private Optional<String> name = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TicketPartAuthor other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            email(other.getEmail());
            return this;
        }

        /**
         * The type of the author<p>The type of the author</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public IdStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * The id of the author<p>The id of the author</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public EmailStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The email of the author<p>The email of the author</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("email")
        public _FinalStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        /**
         * <p>The name of the author</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The name of the author</p>
         */
        @java.lang.Override
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @java.lang.Override
        public TicketPartAuthor build() {
            return new TicketPartAuthor(type, id, name, email, additionalProperties);
        }
    }

    public static final class Type {
        public static final Type BOT = new Type(Value.BOT, "bot");

        public static final Type ADMIN = new Type(Value.ADMIN, "admin");

        public static final Type USER = new Type(Value.USER, "user");

        public static final Type TEAM = new Type(Value.TEAM, "team");

        private final Value value;

        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case BOT:
                    return visitor.visitBot();
                case ADMIN:
                    return visitor.visitAdmin();
                case USER:
                    return visitor.visitUser();
                case TEAM:
                    return visitor.visitTeam();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "bot":
                    return BOT;
                case "admin":
                    return ADMIN;
                case "user":
                    return USER;
                case "team":
                    return TEAM;
                default:
                    return new Type(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            ADMIN,

            BOT,

            TEAM,

            USER,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitAdmin();

            T visitBot();

            T visitTeam();

            T visitUser();

            T visitUnknown(String unknownType);
        }
    }
}
