/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.companies.types.Company;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Visitor.Builder.class)
public final class Visitor {
    private final String id;

    private final String userId;

    private final boolean anonymous;

    private final String email;

    private final Optional<String> phone;

    private final Optional<String> name;

    private final Optional<String> pseudonym;

    private final Optional<Avatar> avatar;

    private final String appId;

    private final Optional<Companies> companies;

    private final Optional<LocationData> locationData;

    private final Optional<Integer> lasRequestAt;

    private final int createdAt;

    private final Optional<Integer> remoteCreatedAt;

    private final int signedUpAt;

    private final Optional<Integer> updatedAt;

    private final Optional<Integer> sessionCount;

    private final Optional<SocialProfiles> socialProfiles;

    private final Optional<String> ownerId;

    private final Optional<Boolean> unsubscribedFromEmails;

    private final Optional<Boolean> markedEmailAsSpam;

    private final Optional<Boolean> hasHardBounced;

    private final Optional<Tags> tags;

    private final Optional<Segments> segments;

    private final Optional<Map<String, Object>> customAttributes;

    private final Optional<String> referrer;

    private final Optional<String> utmCampaign;

    private final Optional<String> utmContent;

    private final Optional<String> utmMedium;

    private final Optional<String> utmSource;

    private final Optional<String> utmTerm;

    private final Optional<Boolean> doNotTrack;

    private final Map<String, Object> additionalProperties;

    private Visitor(
            String id,
            String userId,
            boolean anonymous,
            String email,
            Optional<String> phone,
            Optional<String> name,
            Optional<String> pseudonym,
            Optional<Avatar> avatar,
            String appId,
            Optional<Companies> companies,
            Optional<LocationData> locationData,
            Optional<Integer> lasRequestAt,
            int createdAt,
            Optional<Integer> remoteCreatedAt,
            int signedUpAt,
            Optional<Integer> updatedAt,
            Optional<Integer> sessionCount,
            Optional<SocialProfiles> socialProfiles,
            Optional<String> ownerId,
            Optional<Boolean> unsubscribedFromEmails,
            Optional<Boolean> markedEmailAsSpam,
            Optional<Boolean> hasHardBounced,
            Optional<Tags> tags,
            Optional<Segments> segments,
            Optional<Map<String, Object>> customAttributes,
            Optional<String> referrer,
            Optional<String> utmCampaign,
            Optional<String> utmContent,
            Optional<String> utmMedium,
            Optional<String> utmSource,
            Optional<String> utmTerm,
            Optional<Boolean> doNotTrack,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.userId = userId;
        this.anonymous = anonymous;
        this.email = email;
        this.phone = phone;
        this.name = name;
        this.pseudonym = pseudonym;
        this.avatar = avatar;
        this.appId = appId;
        this.companies = companies;
        this.locationData = locationData;
        this.lasRequestAt = lasRequestAt;
        this.createdAt = createdAt;
        this.remoteCreatedAt = remoteCreatedAt;
        this.signedUpAt = signedUpAt;
        this.updatedAt = updatedAt;
        this.sessionCount = sessionCount;
        this.socialProfiles = socialProfiles;
        this.ownerId = ownerId;
        this.unsubscribedFromEmails = unsubscribedFromEmails;
        this.markedEmailAsSpam = markedEmailAsSpam;
        this.hasHardBounced = hasHardBounced;
        this.tags = tags;
        this.segments = segments;
        this.customAttributes = customAttributes;
        this.referrer = referrer;
        this.utmCampaign = utmCampaign;
        this.utmContent = utmContent;
        this.utmMedium = utmMedium;
        this.utmSource = utmSource;
        this.utmTerm = utmTerm;
        this.doNotTrack = doNotTrack;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Value is 'visitor'
     */
    @JsonProperty("type")
    public String getType() {
        return "visitor";
    }

    /**
     * @return The Intercom defined id representing the Visitor.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return Automatically generated identifier for the Visitor.
     */
    @JsonProperty("user_id")
    public String getUserId() {
        return userId;
    }

    /**
     * @return Identifies if this visitor is anonymous.
     */
    @JsonProperty("anonymous")
    public boolean getAnonymous() {
        return anonymous;
    }

    /**
     * @return The email of the visitor.
     */
    @JsonProperty("email")
    public String getEmail() {
        return email;
    }

    /**
     * @return The phone number of the visitor.
     */
    @JsonProperty("phone")
    public Optional<String> getPhone() {
        return phone;
    }

    /**
     * @return The name of the visitor.
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The pseudonym of the visitor.
     */
    @JsonProperty("pseudonym")
    public Optional<String> getPseudonym() {
        return pseudonym;
    }

    @JsonProperty("avatar")
    public Optional<Avatar> getAvatar() {
        return avatar;
    }

    /**
     * @return The id of the app the visitor is associated with.
     */
    @JsonProperty("app_id")
    public String getAppId() {
        return appId;
    }

    @JsonProperty("companies")
    public Optional<Companies> getCompanies() {
        return companies;
    }

    @JsonProperty("location_data")
    public Optional<LocationData> getLocationData() {
        return locationData;
    }

    /**
     * @return The time the Lead last recorded making a request.
     */
    @JsonProperty("las_request_at")
    public Optional<Integer> getLasRequestAt() {
        return lasRequestAt;
    }

    /**
     * @return The time the Visitor was added to Intercom.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time the Visitor was added to Intercom.
     */
    @JsonProperty("remote_created_at")
    public Optional<Integer> getRemoteCreatedAt() {
        return remoteCreatedAt;
    }

    /**
     * @return The time the Visitor signed up for your product.
     */
    @JsonProperty("signed_up_at")
    public int getSignedUpAt() {
        return signedUpAt;
    }

    /**
     * @return The last time the Visitor was updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The number of sessions the Visitor has had.
     */
    @JsonProperty("session_count")
    public Optional<Integer> getSessionCount() {
        return sessionCount;
    }

    @JsonProperty("social_profiles")
    public Optional<SocialProfiles> getSocialProfiles() {
        return socialProfiles;
    }

    /**
     * @return The id of the admin that owns the Visitor.
     */
    @JsonProperty("owner_id")
    public Optional<String> getOwnerId() {
        return ownerId;
    }

    /**
     * @return Whether the Visitor is unsubscribed from emails.
     */
    @JsonProperty("unsubscribed_from_emails")
    public Optional<Boolean> getUnsubscribedFromEmails() {
        return unsubscribedFromEmails;
    }

    /**
     * @return Identifies if this visitor has marked an email as spam.
     */
    @JsonProperty("marked_email_as_spam")
    public Optional<Boolean> getMarkedEmailAsSpam() {
        return markedEmailAsSpam;
    }

    /**
     * @return Identifies if this visitor has had a hard bounce.
     */
    @JsonProperty("has_hard_bounced")
    public Optional<Boolean> getHasHardBounced() {
        return hasHardBounced;
    }

    @JsonProperty("tags")
    public Optional<Tags> getTags() {
        return tags;
    }

    @JsonProperty("segments")
    public Optional<Segments> getSegments() {
        return segments;
    }

    /**
     * @return The custom attributes you have set on the Visitor.
     */
    @JsonProperty("custom_attributes")
    public Optional<Map<String, Object>> getCustomAttributes() {
        return customAttributes;
    }

    /**
     * @return The referer of the visitor.
     */
    @JsonProperty("referrer")
    public Optional<String> getReferrer() {
        return referrer;
    }

    /**
     * @return The utm_campaign of the visitor.
     */
    @JsonProperty("utm_campaign")
    public Optional<String> getUtmCampaign() {
        return utmCampaign;
    }

    /**
     * @return The utm_content of the visitor.
     */
    @JsonProperty("utm_content")
    public Optional<String> getUtmContent() {
        return utmContent;
    }

    /**
     * @return The utm_medium of the visitor.
     */
    @JsonProperty("utm_medium")
    public Optional<String> getUtmMedium() {
        return utmMedium;
    }

    /**
     * @return The utm_source of the visitor.
     */
    @JsonProperty("utm_source")
    public Optional<String> getUtmSource() {
        return utmSource;
    }

    /**
     * @return The utm_term of the visitor.
     */
    @JsonProperty("utm_term")
    public Optional<String> getUtmTerm() {
        return utmTerm;
    }

    /**
     * @return Identifies if this visitor has do not track enabled.
     */
    @JsonProperty("do_not_track")
    public Optional<Boolean> getDoNotTrack() {
        return doNotTrack;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Visitor && equalTo((Visitor) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Visitor other) {
        return id.equals(other.id)
                && userId.equals(other.userId)
                && anonymous == other.anonymous
                && email.equals(other.email)
                && phone.equals(other.phone)
                && name.equals(other.name)
                && pseudonym.equals(other.pseudonym)
                && avatar.equals(other.avatar)
                && appId.equals(other.appId)
                && companies.equals(other.companies)
                && locationData.equals(other.locationData)
                && lasRequestAt.equals(other.lasRequestAt)
                && createdAt == other.createdAt
                && remoteCreatedAt.equals(other.remoteCreatedAt)
                && signedUpAt == other.signedUpAt
                && updatedAt.equals(other.updatedAt)
                && sessionCount.equals(other.sessionCount)
                && socialProfiles.equals(other.socialProfiles)
                && ownerId.equals(other.ownerId)
                && unsubscribedFromEmails.equals(other.unsubscribedFromEmails)
                && markedEmailAsSpam.equals(other.markedEmailAsSpam)
                && hasHardBounced.equals(other.hasHardBounced)
                && tags.equals(other.tags)
                && segments.equals(other.segments)
                && customAttributes.equals(other.customAttributes)
                && referrer.equals(other.referrer)
                && utmCampaign.equals(other.utmCampaign)
                && utmContent.equals(other.utmContent)
                && utmMedium.equals(other.utmMedium)
                && utmSource.equals(other.utmSource)
                && utmTerm.equals(other.utmTerm)
                && doNotTrack.equals(other.doNotTrack);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.userId,
                this.anonymous,
                this.email,
                this.phone,
                this.name,
                this.pseudonym,
                this.avatar,
                this.appId,
                this.companies,
                this.locationData,
                this.lasRequestAt,
                this.createdAt,
                this.remoteCreatedAt,
                this.signedUpAt,
                this.updatedAt,
                this.sessionCount,
                this.socialProfiles,
                this.ownerId,
                this.unsubscribedFromEmails,
                this.markedEmailAsSpam,
                this.hasHardBounced,
                this.tags,
                this.segments,
                this.customAttributes,
                this.referrer,
                this.utmCampaign,
                this.utmContent,
                this.utmMedium,
                this.utmSource,
                this.utmTerm,
                this.doNotTrack);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The Intercom defined id representing the Visitor.
         */
        UserIdStage id(@NotNull String id);

        Builder from(Visitor other);
    }

    public interface UserIdStage {
        /**
         * Automatically generated identifier for the Visitor.
         */
        AnonymousStage userId(@NotNull String userId);
    }

    public interface AnonymousStage {
        /**
         * Identifies if this visitor is anonymous.
         */
        EmailStage anonymous(boolean anonymous);
    }

    public interface EmailStage {
        /**
         * The email of the visitor.
         */
        AppIdStage email(@NotNull String email);
    }

    public interface AppIdStage {
        /**
         * The id of the app the visitor is associated with.
         */
        CreatedAtStage appId(@NotNull String appId);
    }

    public interface CreatedAtStage {
        /**
         * The time the Visitor was added to Intercom.
         */
        SignedUpAtStage createdAt(int createdAt);
    }

    public interface SignedUpAtStage {
        /**
         * The time the Visitor signed up for your product.
         */
        _FinalStage signedUpAt(int signedUpAt);
    }

    public interface _FinalStage {
        Visitor build();

        /**
         * <p>The phone number of the visitor.</p>
         */
        _FinalStage phone(Optional<String> phone);

        _FinalStage phone(String phone);

        /**
         * <p>The name of the visitor.</p>
         */
        _FinalStage name(Optional<String> name);

        _FinalStage name(String name);

        /**
         * <p>The pseudonym of the visitor.</p>
         */
        _FinalStage pseudonym(Optional<String> pseudonym);

        _FinalStage pseudonym(String pseudonym);

        _FinalStage avatar(Optional<Avatar> avatar);

        _FinalStage avatar(Avatar avatar);

        _FinalStage companies(Optional<Companies> companies);

        _FinalStage companies(Companies companies);

        _FinalStage locationData(Optional<LocationData> locationData);

        _FinalStage locationData(LocationData locationData);

        /**
         * <p>The time the Lead last recorded making a request.</p>
         */
        _FinalStage lasRequestAt(Optional<Integer> lasRequestAt);

        _FinalStage lasRequestAt(Integer lasRequestAt);

        /**
         * <p>The time the Visitor was added to Intercom.</p>
         */
        _FinalStage remoteCreatedAt(Optional<Integer> remoteCreatedAt);

        _FinalStage remoteCreatedAt(Integer remoteCreatedAt);

        /**
         * <p>The last time the Visitor was updated.</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);

        /**
         * <p>The number of sessions the Visitor has had.</p>
         */
        _FinalStage sessionCount(Optional<Integer> sessionCount);

        _FinalStage sessionCount(Integer sessionCount);

        _FinalStage socialProfiles(Optional<SocialProfiles> socialProfiles);

        _FinalStage socialProfiles(SocialProfiles socialProfiles);

        /**
         * <p>The id of the admin that owns the Visitor.</p>
         */
        _FinalStage ownerId(Optional<String> ownerId);

        _FinalStage ownerId(String ownerId);

        /**
         * <p>Whether the Visitor is unsubscribed from emails.</p>
         */
        _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails);

        _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails);

        /**
         * <p>Identifies if this visitor has marked an email as spam.</p>
         */
        _FinalStage markedEmailAsSpam(Optional<Boolean> markedEmailAsSpam);

        _FinalStage markedEmailAsSpam(Boolean markedEmailAsSpam);

        /**
         * <p>Identifies if this visitor has had a hard bounce.</p>
         */
        _FinalStage hasHardBounced(Optional<Boolean> hasHardBounced);

        _FinalStage hasHardBounced(Boolean hasHardBounced);

        _FinalStage tags(Optional<Tags> tags);

        _FinalStage tags(Tags tags);

        _FinalStage segments(Optional<Segments> segments);

        _FinalStage segments(Segments segments);

        /**
         * <p>The custom attributes you have set on the Visitor.</p>
         */
        _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes);

        _FinalStage customAttributes(Map<String, Object> customAttributes);

        /**
         * <p>The referer of the visitor.</p>
         */
        _FinalStage referrer(Optional<String> referrer);

        _FinalStage referrer(String referrer);

        /**
         * <p>The utm_campaign of the visitor.</p>
         */
        _FinalStage utmCampaign(Optional<String> utmCampaign);

        _FinalStage utmCampaign(String utmCampaign);

        /**
         * <p>The utm_content of the visitor.</p>
         */
        _FinalStage utmContent(Optional<String> utmContent);

        _FinalStage utmContent(String utmContent);

        /**
         * <p>The utm_medium of the visitor.</p>
         */
        _FinalStage utmMedium(Optional<String> utmMedium);

        _FinalStage utmMedium(String utmMedium);

        /**
         * <p>The utm_source of the visitor.</p>
         */
        _FinalStage utmSource(Optional<String> utmSource);

        _FinalStage utmSource(String utmSource);

        /**
         * <p>The utm_term of the visitor.</p>
         */
        _FinalStage utmTerm(Optional<String> utmTerm);

        _FinalStage utmTerm(String utmTerm);

        /**
         * <p>Identifies if this visitor has do not track enabled.</p>
         */
        _FinalStage doNotTrack(Optional<Boolean> doNotTrack);

        _FinalStage doNotTrack(Boolean doNotTrack);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage,
                    UserIdStage,
                    AnonymousStage,
                    EmailStage,
                    AppIdStage,
                    CreatedAtStage,
                    SignedUpAtStage,
                    _FinalStage {
        private String id;

        private String userId;

        private boolean anonymous;

        private String email;

        private String appId;

        private int createdAt;

        private int signedUpAt;

        private Optional<Boolean> doNotTrack = Optional.empty();

        private Optional<String> utmTerm = Optional.empty();

        private Optional<String> utmSource = Optional.empty();

        private Optional<String> utmMedium = Optional.empty();

        private Optional<String> utmContent = Optional.empty();

        private Optional<String> utmCampaign = Optional.empty();

        private Optional<String> referrer = Optional.empty();

        private Optional<Map<String, Object>> customAttributes = Optional.empty();

        private Optional<Segments> segments = Optional.empty();

        private Optional<Tags> tags = Optional.empty();

        private Optional<Boolean> hasHardBounced = Optional.empty();

        private Optional<Boolean> markedEmailAsSpam = Optional.empty();

        private Optional<Boolean> unsubscribedFromEmails = Optional.empty();

        private Optional<String> ownerId = Optional.empty();

        private Optional<SocialProfiles> socialProfiles = Optional.empty();

        private Optional<Integer> sessionCount = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<Integer> remoteCreatedAt = Optional.empty();

        private Optional<Integer> lasRequestAt = Optional.empty();

        private Optional<LocationData> locationData = Optional.empty();

        private Optional<Companies> companies = Optional.empty();

        private Optional<Avatar> avatar = Optional.empty();

        private Optional<String> pseudonym = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> phone = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Visitor other) {
            id(other.getId());
            userId(other.getUserId());
            anonymous(other.getAnonymous());
            email(other.getEmail());
            phone(other.getPhone());
            name(other.getName());
            pseudonym(other.getPseudonym());
            avatar(other.getAvatar());
            appId(other.getAppId());
            companies(other.getCompanies());
            locationData(other.getLocationData());
            lasRequestAt(other.getLasRequestAt());
            createdAt(other.getCreatedAt());
            remoteCreatedAt(other.getRemoteCreatedAt());
            signedUpAt(other.getSignedUpAt());
            updatedAt(other.getUpdatedAt());
            sessionCount(other.getSessionCount());
            socialProfiles(other.getSocialProfiles());
            ownerId(other.getOwnerId());
            unsubscribedFromEmails(other.getUnsubscribedFromEmails());
            markedEmailAsSpam(other.getMarkedEmailAsSpam());
            hasHardBounced(other.getHasHardBounced());
            tags(other.getTags());
            segments(other.getSegments());
            customAttributes(other.getCustomAttributes());
            referrer(other.getReferrer());
            utmCampaign(other.getUtmCampaign());
            utmContent(other.getUtmContent());
            utmMedium(other.getUtmMedium());
            utmSource(other.getUtmSource());
            utmTerm(other.getUtmTerm());
            doNotTrack(other.getDoNotTrack());
            return this;
        }

        /**
         * The Intercom defined id representing the Visitor.<p>The Intercom defined id representing the Visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public UserIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * Automatically generated identifier for the Visitor.<p>Automatically generated identifier for the Visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("user_id")
        public AnonymousStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        /**
         * Identifies if this visitor is anonymous.<p>Identifies if this visitor is anonymous.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("anonymous")
        public EmailStage anonymous(boolean anonymous) {
            this.anonymous = anonymous;
            return this;
        }

        /**
         * The email of the visitor.<p>The email of the visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("email")
        public AppIdStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        /**
         * The id of the app the visitor is associated with.<p>The id of the app the visitor is associated with.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("app_id")
        public CreatedAtStage appId(@NotNull String appId) {
            this.appId = Objects.requireNonNull(appId, "appId must not be null");
            return this;
        }

        /**
         * The time the Visitor was added to Intercom.<p>The time the Visitor was added to Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public SignedUpAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * The time the Visitor signed up for your product.<p>The time the Visitor signed up for your product.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("signed_up_at")
        public _FinalStage signedUpAt(int signedUpAt) {
            this.signedUpAt = signedUpAt;
            return this;
        }

        /**
         * <p>Identifies if this visitor has do not track enabled.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage doNotTrack(Boolean doNotTrack) {
            this.doNotTrack = Optional.ofNullable(doNotTrack);
            return this;
        }

        /**
         * <p>Identifies if this visitor has do not track enabled.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "do_not_track", nulls = Nulls.SKIP)
        public _FinalStage doNotTrack(Optional<Boolean> doNotTrack) {
            this.doNotTrack = doNotTrack;
            return this;
        }

        /**
         * <p>The utm_term of the visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage utmTerm(String utmTerm) {
            this.utmTerm = Optional.ofNullable(utmTerm);
            return this;
        }

        /**
         * <p>The utm_term of the visitor.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "utm_term", nulls = Nulls.SKIP)
        public _FinalStage utmTerm(Optional<String> utmTerm) {
            this.utmTerm = utmTerm;
            return this;
        }

        /**
         * <p>The utm_source of the visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage utmSource(String utmSource) {
            this.utmSource = Optional.ofNullable(utmSource);
            return this;
        }

        /**
         * <p>The utm_source of the visitor.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "utm_source", nulls = Nulls.SKIP)
        public _FinalStage utmSource(Optional<String> utmSource) {
            this.utmSource = utmSource;
            return this;
        }

        /**
         * <p>The utm_medium of the visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage utmMedium(String utmMedium) {
            this.utmMedium = Optional.ofNullable(utmMedium);
            return this;
        }

        /**
         * <p>The utm_medium of the visitor.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "utm_medium", nulls = Nulls.SKIP)
        public _FinalStage utmMedium(Optional<String> utmMedium) {
            this.utmMedium = utmMedium;
            return this;
        }

        /**
         * <p>The utm_content of the visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage utmContent(String utmContent) {
            this.utmContent = Optional.ofNullable(utmContent);
            return this;
        }

        /**
         * <p>The utm_content of the visitor.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "utm_content", nulls = Nulls.SKIP)
        public _FinalStage utmContent(Optional<String> utmContent) {
            this.utmContent = utmContent;
            return this;
        }

        /**
         * <p>The utm_campaign of the visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage utmCampaign(String utmCampaign) {
            this.utmCampaign = Optional.ofNullable(utmCampaign);
            return this;
        }

        /**
         * <p>The utm_campaign of the visitor.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "utm_campaign", nulls = Nulls.SKIP)
        public _FinalStage utmCampaign(Optional<String> utmCampaign) {
            this.utmCampaign = utmCampaign;
            return this;
        }

        /**
         * <p>The referer of the visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage referrer(String referrer) {
            this.referrer = Optional.ofNullable(referrer);
            return this;
        }

        /**
         * <p>The referer of the visitor.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "referrer", nulls = Nulls.SKIP)
        public _FinalStage referrer(Optional<String> referrer) {
            this.referrer = referrer;
            return this;
        }

        /**
         * <p>The custom attributes you have set on the Visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        /**
         * <p>The custom attributes you have set on the Visitor.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        @java.lang.Override
        public _FinalStage segments(Segments segments) {
            this.segments = Optional.ofNullable(segments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "segments", nulls = Nulls.SKIP)
        public _FinalStage segments(Optional<Segments> segments) {
            this.segments = segments;
            return this;
        }

        @java.lang.Override
        public _FinalStage tags(Tags tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "tags", nulls = Nulls.SKIP)
        public _FinalStage tags(Optional<Tags> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * <p>Identifies if this visitor has had a hard bounce.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage hasHardBounced(Boolean hasHardBounced) {
            this.hasHardBounced = Optional.ofNullable(hasHardBounced);
            return this;
        }

        /**
         * <p>Identifies if this visitor has had a hard bounce.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "has_hard_bounced", nulls = Nulls.SKIP)
        public _FinalStage hasHardBounced(Optional<Boolean> hasHardBounced) {
            this.hasHardBounced = hasHardBounced;
            return this;
        }

        /**
         * <p>Identifies if this visitor has marked an email as spam.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage markedEmailAsSpam(Boolean markedEmailAsSpam) {
            this.markedEmailAsSpam = Optional.ofNullable(markedEmailAsSpam);
            return this;
        }

        /**
         * <p>Identifies if this visitor has marked an email as spam.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "marked_email_as_spam", nulls = Nulls.SKIP)
        public _FinalStage markedEmailAsSpam(Optional<Boolean> markedEmailAsSpam) {
            this.markedEmailAsSpam = markedEmailAsSpam;
            return this;
        }

        /**
         * <p>Whether the Visitor is unsubscribed from emails.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails) {
            this.unsubscribedFromEmails = Optional.ofNullable(unsubscribedFromEmails);
            return this;
        }

        /**
         * <p>Whether the Visitor is unsubscribed from emails.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "unsubscribed_from_emails", nulls = Nulls.SKIP)
        public _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails) {
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            return this;
        }

        /**
         * <p>The id of the admin that owns the Visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage ownerId(String ownerId) {
            this.ownerId = Optional.ofNullable(ownerId);
            return this;
        }

        /**
         * <p>The id of the admin that owns the Visitor.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "owner_id", nulls = Nulls.SKIP)
        public _FinalStage ownerId(Optional<String> ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        @java.lang.Override
        public _FinalStage socialProfiles(SocialProfiles socialProfiles) {
            this.socialProfiles = Optional.ofNullable(socialProfiles);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "social_profiles", nulls = Nulls.SKIP)
        public _FinalStage socialProfiles(Optional<SocialProfiles> socialProfiles) {
            this.socialProfiles = socialProfiles;
            return this;
        }

        /**
         * <p>The number of sessions the Visitor has had.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage sessionCount(Integer sessionCount) {
            this.sessionCount = Optional.ofNullable(sessionCount);
            return this;
        }

        /**
         * <p>The number of sessions the Visitor has had.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "session_count", nulls = Nulls.SKIP)
        public _FinalStage sessionCount(Optional<Integer> sessionCount) {
            this.sessionCount = sessionCount;
            return this;
        }

        /**
         * <p>The last time the Visitor was updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The last time the Visitor was updated.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>The time the Visitor was added to Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage remoteCreatedAt(Integer remoteCreatedAt) {
            this.remoteCreatedAt = Optional.ofNullable(remoteCreatedAt);
            return this;
        }

        /**
         * <p>The time the Visitor was added to Intercom.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "remote_created_at", nulls = Nulls.SKIP)
        public _FinalStage remoteCreatedAt(Optional<Integer> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        /**
         * <p>The time the Lead last recorded making a request.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage lasRequestAt(Integer lasRequestAt) {
            this.lasRequestAt = Optional.ofNullable(lasRequestAt);
            return this;
        }

        /**
         * <p>The time the Lead last recorded making a request.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "las_request_at", nulls = Nulls.SKIP)
        public _FinalStage lasRequestAt(Optional<Integer> lasRequestAt) {
            this.lasRequestAt = lasRequestAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage locationData(LocationData locationData) {
            this.locationData = Optional.ofNullable(locationData);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "location_data", nulls = Nulls.SKIP)
        public _FinalStage locationData(Optional<LocationData> locationData) {
            this.locationData = locationData;
            return this;
        }

        @java.lang.Override
        public _FinalStage companies(Companies companies) {
            this.companies = Optional.ofNullable(companies);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "companies", nulls = Nulls.SKIP)
        public _FinalStage companies(Optional<Companies> companies) {
            this.companies = companies;
            return this;
        }

        @java.lang.Override
        public _FinalStage avatar(Avatar avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "avatar", nulls = Nulls.SKIP)
        public _FinalStage avatar(Optional<Avatar> avatar) {
            this.avatar = avatar;
            return this;
        }

        /**
         * <p>The pseudonym of the visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage pseudonym(String pseudonym) {
            this.pseudonym = Optional.ofNullable(pseudonym);
            return this;
        }

        /**
         * <p>The pseudonym of the visitor.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "pseudonym", nulls = Nulls.SKIP)
        public _FinalStage pseudonym(Optional<String> pseudonym) {
            this.pseudonym = pseudonym;
            return this;
        }

        /**
         * <p>The name of the visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The name of the visitor.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        /**
         * <p>The phone number of the visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage phone(String phone) {
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        /**
         * <p>The phone number of the visitor.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "phone", nulls = Nulls.SKIP)
        public _FinalStage phone(Optional<String> phone) {
            this.phone = phone;
            return this;
        }

        @java.lang.Override
        public Visitor build() {
            return new Visitor(
                    id,
                    userId,
                    anonymous,
                    email,
                    phone,
                    name,
                    pseudonym,
                    avatar,
                    appId,
                    companies,
                    locationData,
                    lasRequestAt,
                    createdAt,
                    remoteCreatedAt,
                    signedUpAt,
                    updatedAt,
                    sessionCount,
                    socialProfiles,
                    ownerId,
                    unsubscribedFromEmails,
                    markedEmailAsSpam,
                    hasHardBounced,
                    tags,
                    segments,
                    customAttributes,
                    referrer,
                    utmCampaign,
                    utmContent,
                    utmMedium,
                    utmSource,
                    utmTerm,
                    doNotTrack,
                    additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Avatar.Builder.class)
    public static final class Avatar {
        private final Optional<String> type;

        private final Optional<String> imageUrl;

        private final Map<String, Object> additionalProperties;

        private Avatar(Optional<String> type, Optional<String> imageUrl, Map<String, Object> additionalProperties) {
            this.type = type;
            this.imageUrl = imageUrl;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return This object represents the avatar associated with the visitor.
         */
        @JsonProperty("image_url")
        public Optional<String> getImageUrl() {
            return imageUrl;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Avatar && equalTo((Avatar) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Avatar other) {
            return type.equals(other.type) && imageUrl.equals(other.imageUrl);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.imageUrl);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<String> imageUrl = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Avatar other) {
                type(other.getType());
                imageUrl(other.getImageUrl());
                return this;
            }

            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>This object represents the avatar associated with the visitor.</p>
             */
            @JsonSetter(value = "image_url", nulls = Nulls.SKIP)
            public Builder imageUrl(Optional<String> imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Builder imageUrl(String imageUrl) {
                this.imageUrl = Optional.ofNullable(imageUrl);
                return this;
            }

            public Avatar build() {
                return new Avatar(type, imageUrl, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Companies.Builder.class)
    public static final class Companies {
        private final Optional<String> type;

        private final Optional<List<Company>> companies;

        private final Map<String, Object> additionalProperties;

        private Companies(
                Optional<String> type, Optional<List<Company>> companies, Map<String, Object> additionalProperties) {
            this.type = type;
            this.companies = companies;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The type of the object
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        @JsonProperty("companies")
        public Optional<List<Company>> getCompanies() {
            return companies;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Companies && equalTo((Companies) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Companies other) {
            return type.equals(other.type) && companies.equals(other.companies);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.companies);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<List<Company>> companies = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Companies other) {
                type(other.getType());
                companies(other.getCompanies());
                return this;
            }

            /**
             * <p>The type of the object</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value = "companies", nulls = Nulls.SKIP)
            public Builder companies(Optional<List<Company>> companies) {
                this.companies = companies;
                return this;
            }

            public Builder companies(List<Company> companies) {
                this.companies = Optional.ofNullable(companies);
                return this;
            }

            public Companies build() {
                return new Companies(type, companies, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Segments.Builder.class)
    public static final class Segments {
        private final Optional<String> type;

        private final Optional<List<String>> segments;

        private final Map<String, Object> additionalProperties;

        private Segments(
                Optional<String> type, Optional<List<String>> segments, Map<String, Object> additionalProperties) {
            this.type = type;
            this.segments = segments;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The type of the object
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        @JsonProperty("segments")
        public Optional<List<String>> getSegments() {
            return segments;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Segments && equalTo((Segments) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Segments other) {
            return type.equals(other.type) && segments.equals(other.segments);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.segments);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<List<String>> segments = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Segments other) {
                type(other.getType());
                segments(other.getSegments());
                return this;
            }

            /**
             * <p>The type of the object</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value = "segments", nulls = Nulls.SKIP)
            public Builder segments(Optional<List<String>> segments) {
                this.segments = segments;
                return this;
            }

            public Builder segments(List<String> segments) {
                this.segments = Optional.ofNullable(segments);
                return this;
            }

            public Segments build() {
                return new Segments(type, segments, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = LocationData.Builder.class)
    public static final class LocationData {
        private final Optional<String> type;

        private final Optional<String> cityName;

        private final Optional<String> continentCode;

        private final Optional<String> countryCode;

        private final Optional<String> countryName;

        private final Optional<String> postalCode;

        private final Optional<String> regionName;

        private final Optional<String> timezone;

        private final Map<String, Object> additionalProperties;

        private LocationData(
                Optional<String> type,
                Optional<String> cityName,
                Optional<String> continentCode,
                Optional<String> countryCode,
                Optional<String> countryName,
                Optional<String> postalCode,
                Optional<String> regionName,
                Optional<String> timezone,
                Map<String, Object> additionalProperties) {
            this.type = type;
            this.cityName = cityName;
            this.continentCode = continentCode;
            this.countryCode = countryCode;
            this.countryName = countryName;
            this.postalCode = postalCode;
            this.regionName = regionName;
            this.timezone = timezone;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return The city name of the visitor.
         */
        @JsonProperty("city_name")
        public Optional<String> getCityName() {
            return cityName;
        }

        /**
         * @return The continent code of the visitor.
         */
        @JsonProperty("continent_code")
        public Optional<String> getContinentCode() {
            return continentCode;
        }

        /**
         * @return The country code of the visitor.
         */
        @JsonProperty("country_code")
        public Optional<String> getCountryCode() {
            return countryCode;
        }

        /**
         * @return The country name of the visitor.
         */
        @JsonProperty("country_name")
        public Optional<String> getCountryName() {
            return countryName;
        }

        /**
         * @return The postal code of the visitor.
         */
        @JsonProperty("postal_code")
        public Optional<String> getPostalCode() {
            return postalCode;
        }

        /**
         * @return The region name of the visitor.
         */
        @JsonProperty("region_name")
        public Optional<String> getRegionName() {
            return regionName;
        }

        /**
         * @return The timezone of the visitor.
         */
        @JsonProperty("timezone")
        public Optional<String> getTimezone() {
            return timezone;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof LocationData && equalTo((LocationData) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(LocationData other) {
            return type.equals(other.type)
                    && cityName.equals(other.cityName)
                    && continentCode.equals(other.continentCode)
                    && countryCode.equals(other.countryCode)
                    && countryName.equals(other.countryName)
                    && postalCode.equals(other.postalCode)
                    && regionName.equals(other.regionName)
                    && timezone.equals(other.timezone);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(
                    this.type,
                    this.cityName,
                    this.continentCode,
                    this.countryCode,
                    this.countryName,
                    this.postalCode,
                    this.regionName,
                    this.timezone);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<String> cityName = Optional.empty();

            private Optional<String> continentCode = Optional.empty();

            private Optional<String> countryCode = Optional.empty();

            private Optional<String> countryName = Optional.empty();

            private Optional<String> postalCode = Optional.empty();

            private Optional<String> regionName = Optional.empty();

            private Optional<String> timezone = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(LocationData other) {
                type(other.getType());
                cityName(other.getCityName());
                continentCode(other.getContinentCode());
                countryCode(other.getCountryCode());
                countryName(other.getCountryName());
                postalCode(other.getPostalCode());
                regionName(other.getRegionName());
                timezone(other.getTimezone());
                return this;
            }

            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>The city name of the visitor.</p>
             */
            @JsonSetter(value = "city_name", nulls = Nulls.SKIP)
            public Builder cityName(Optional<String> cityName) {
                this.cityName = cityName;
                return this;
            }

            public Builder cityName(String cityName) {
                this.cityName = Optional.ofNullable(cityName);
                return this;
            }

            /**
             * <p>The continent code of the visitor.</p>
             */
            @JsonSetter(value = "continent_code", nulls = Nulls.SKIP)
            public Builder continentCode(Optional<String> continentCode) {
                this.continentCode = continentCode;
                return this;
            }

            public Builder continentCode(String continentCode) {
                this.continentCode = Optional.ofNullable(continentCode);
                return this;
            }

            /**
             * <p>The country code of the visitor.</p>
             */
            @JsonSetter(value = "country_code", nulls = Nulls.SKIP)
            public Builder countryCode(Optional<String> countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            public Builder countryCode(String countryCode) {
                this.countryCode = Optional.ofNullable(countryCode);
                return this;
            }

            /**
             * <p>The country name of the visitor.</p>
             */
            @JsonSetter(value = "country_name", nulls = Nulls.SKIP)
            public Builder countryName(Optional<String> countryName) {
                this.countryName = countryName;
                return this;
            }

            public Builder countryName(String countryName) {
                this.countryName = Optional.ofNullable(countryName);
                return this;
            }

            /**
             * <p>The postal code of the visitor.</p>
             */
            @JsonSetter(value = "postal_code", nulls = Nulls.SKIP)
            public Builder postalCode(Optional<String> postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            public Builder postalCode(String postalCode) {
                this.postalCode = Optional.ofNullable(postalCode);
                return this;
            }

            /**
             * <p>The region name of the visitor.</p>
             */
            @JsonSetter(value = "region_name", nulls = Nulls.SKIP)
            public Builder regionName(Optional<String> regionName) {
                this.regionName = regionName;
                return this;
            }

            public Builder regionName(String regionName) {
                this.regionName = Optional.ofNullable(regionName);
                return this;
            }

            /**
             * <p>The timezone of the visitor.</p>
             */
            @JsonSetter(value = "timezone", nulls = Nulls.SKIP)
            public Builder timezone(Optional<String> timezone) {
                this.timezone = timezone;
                return this;
            }

            public Builder timezone(String timezone) {
                this.timezone = Optional.ofNullable(timezone);
                return this;
            }

            public LocationData build() {
                return new LocationData(
                        type,
                        cityName,
                        continentCode,
                        countryCode,
                        countryName,
                        postalCode,
                        regionName,
                        timezone,
                        additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Tags.Builder.class)
    public static final class Tags {
        private final Optional<String> type;

        private final Optional<List<TagsItem>> tags;

        private final Map<String, Object> additionalProperties;

        private Tags(Optional<String> type, Optional<List<TagsItem>> tags, Map<String, Object> additionalProperties) {
            this.type = type;
            this.tags = tags;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The type of the object
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        @JsonProperty("tags")
        public Optional<List<TagsItem>> getTags() {
            return tags;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Tags && equalTo((Tags) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Tags other) {
            return type.equals(other.type) && tags.equals(other.tags);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.tags);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<List<TagsItem>> tags = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Tags other) {
                type(other.getType());
                tags(other.getTags());
                return this;
            }

            /**
             * <p>The type of the object</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value = "tags", nulls = Nulls.SKIP)
            public Builder tags(Optional<List<TagsItem>> tags) {
                this.tags = tags;
                return this;
            }

            public Builder tags(List<TagsItem> tags) {
                this.tags = Optional.ofNullable(tags);
                return this;
            }

            public Tags build() {
                return new Tags(type, tags, additionalProperties);
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = TagsItem.Builder.class)
        public static final class TagsItem {
            private final Optional<String> type;

            private final Optional<String> id;

            private final Optional<String> name;

            private final Map<String, Object> additionalProperties;

            private TagsItem(
                    Optional<String> type,
                    Optional<String> id,
                    Optional<String> name,
                    Map<String, Object> additionalProperties) {
                this.type = type;
                this.id = id;
                this.name = name;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return The type of the object
             */
            @JsonProperty("type")
            public Optional<String> getType() {
                return type;
            }

            /**
             * @return The id of the tag.
             */
            @JsonProperty("id")
            public Optional<String> getId() {
                return id;
            }

            /**
             * @return The name of the tag.
             */
            @JsonProperty("name")
            public Optional<String> getName() {
                return name;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof TagsItem && equalTo((TagsItem) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(TagsItem other) {
                return type.equals(other.type) && id.equals(other.id) && name.equals(other.name);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.type, this.id, this.name);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder {
                private Optional<String> type = Optional.empty();

                private Optional<String> id = Optional.empty();

                private Optional<String> name = Optional.empty();

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                public Builder from(TagsItem other) {
                    type(other.getType());
                    id(other.getId());
                    name(other.getName());
                    return this;
                }

                /**
                 * <p>The type of the object</p>
                 */
                @JsonSetter(value = "type", nulls = Nulls.SKIP)
                public Builder type(Optional<String> type) {
                    this.type = type;
                    return this;
                }

                public Builder type(String type) {
                    this.type = Optional.ofNullable(type);
                    return this;
                }

                /**
                 * <p>The id of the tag.</p>
                 */
                @JsonSetter(value = "id", nulls = Nulls.SKIP)
                public Builder id(Optional<String> id) {
                    this.id = id;
                    return this;
                }

                public Builder id(String id) {
                    this.id = Optional.ofNullable(id);
                    return this;
                }

                /**
                 * <p>The name of the tag.</p>
                 */
                @JsonSetter(value = "name", nulls = Nulls.SKIP)
                public Builder name(Optional<String> name) {
                    this.name = name;
                    return this;
                }

                public Builder name(String name) {
                    this.name = Optional.ofNullable(name);
                    return this;
                }

                public TagsItem build() {
                    return new TagsItem(type, id, name, additionalProperties);
                }
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = SocialProfiles.Builder.class)
    public static final class SocialProfiles {
        private final Optional<String> type;

        private final Optional<List<String>> socialProfiles;

        private final Map<String, Object> additionalProperties;

        private SocialProfiles(
                Optional<String> type,
                Optional<List<String>> socialProfiles,
                Map<String, Object> additionalProperties) {
            this.type = type;
            this.socialProfiles = socialProfiles;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The type of the object
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        @JsonProperty("social_profiles")
        public Optional<List<String>> getSocialProfiles() {
            return socialProfiles;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof SocialProfiles && equalTo((SocialProfiles) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(SocialProfiles other) {
            return type.equals(other.type) && socialProfiles.equals(other.socialProfiles);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.socialProfiles);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<List<String>> socialProfiles = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(SocialProfiles other) {
                type(other.getType());
                socialProfiles(other.getSocialProfiles());
                return this;
            }

            /**
             * <p>The type of the object</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value = "social_profiles", nulls = Nulls.SKIP)
            public Builder socialProfiles(Optional<List<String>> socialProfiles) {
                this.socialProfiles = socialProfiles;
                return this;
            }

            public Builder socialProfiles(List<String> socialProfiles) {
                this.socialProfiles = Optional.ofNullable(socialProfiles);
                return this;
            }

            public SocialProfiles build() {
                return new SocialProfiles(type, socialProfiles, additionalProperties);
            }
        }
    }
}
