/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.types;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.ao.EntityManager;
import net.java.ao.types.DatabaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class URIType
extends DatabaseType<URI> {
    public URIType() {
        super(12, 255, URI.class);
    }

    @Override
    public String getDefaultName() {
        return "VARCHAR";
    }

    @Override
    public void putToDatabase(EntityManager manager, PreparedStatement stmt, int index, URI value) throws SQLException {
        stmt.setString(index, value.toString());
    }

    @Override
    public URI pullFromDatabase(EntityManager manager, ResultSet res, Class<? extends URI> type, String field) throws SQLException {
        try {
            return new URI(res.getString(field));
        }
        catch (URISyntaxException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public URI defaultParseValue(String value) {
        try {
            return new URI(value);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

