/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.DBRef;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.EntityType;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.HetatomImpl;
import org.biojava.nbio.structure.NucleotideImpl;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.SeqMisMatchImpl;
import org.biojava.nbio.structure.Site;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.io.BondMaker;
import org.biojava.nbio.structure.io.ChargeAdder;
import org.biojava.nbio.structure.io.EntityFinder;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.SeqRes2AtomAligner;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.mmcif.MMcifConsumer;
import org.biojava.nbio.structure.io.mmcif.model.AtomSite;
import org.biojava.nbio.structure.io.mmcif.model.AtomSites;
import org.biojava.nbio.structure.io.mmcif.model.AuditAuthor;
import org.biojava.nbio.structure.io.mmcif.model.Cell;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompAtom;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompBond;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompDescriptor;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePDBremark;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePDBrev;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePdbrevRecord;
import org.biojava.nbio.structure.io.mmcif.model.Entity;
import org.biojava.nbio.structure.io.mmcif.model.EntityPoly;
import org.biojava.nbio.structure.io.mmcif.model.EntityPolySeq;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcGen;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcNat;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcSyn;
import org.biojava.nbio.structure.io.mmcif.model.Exptl;
import org.biojava.nbio.structure.io.mmcif.model.PdbxAuditRevisionHistory;
import org.biojava.nbio.structure.io.mmcif.model.PdbxChemCompDescriptor;
import org.biojava.nbio.structure.io.mmcif.model.PdbxChemCompIdentifier;
import org.biojava.nbio.structure.io.mmcif.model.PdbxDatabaseStatus;
import org.biojava.nbio.structure.io.mmcif.model.PdbxEntityNonPoly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxNonPolyScheme;
import org.biojava.nbio.structure.io.mmcif.model.PdbxPolySeqScheme;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList;
import org.biojava.nbio.structure.io.mmcif.model.Refine;
import org.biojava.nbio.structure.io.mmcif.model.Struct;
import org.biojava.nbio.structure.io.mmcif.model.StructAsym;
import org.biojava.nbio.structure.io.mmcif.model.StructConn;
import org.biojava.nbio.structure.io.mmcif.model.StructKeywords;
import org.biojava.nbio.structure.io.mmcif.model.StructNcsOper;
import org.biojava.nbio.structure.io.mmcif.model.StructRef;
import org.biojava.nbio.structure.io.mmcif.model.StructRefSeq;
import org.biojava.nbio.structure.io.mmcif.model.StructRefSeqDif;
import org.biojava.nbio.structure.io.mmcif.model.StructSite;
import org.biojava.nbio.structure.io.mmcif.model.StructSiteGen;
import org.biojava.nbio.structure.io.mmcif.model.Symmetry;
import org.biojava.nbio.structure.quaternary.BioAssemblyInfo;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyBuilder;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.xtal.CrystalCell;
import org.biojava.nbio.structure.xtal.SpaceGroup;
import org.biojava.nbio.structure.xtal.SymoplibParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMMcifConsumer
implements MMcifConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMMcifConsumer.class);
    private Structure structure;
    private Chain currentChain;
    private Group currentGroup;
    private ArrayList<List<Chain>> allModels;
    private List<Chain> currentModel;
    private List<Entity> entities;
    private List<EntityPoly> entityPolys;
    private List<StructRef> strucRefs;
    private List<Chain> seqResChains;
    private List<Chain> entityChains;
    private List<StructAsym> structAsyms;
    private List<PdbxStructOperList> structOpers;
    private List<PdbxStructAssembly> strucAssemblies;
    private List<PdbxStructAssemblyGen> strucAssemblyGens;
    private List<EntitySrcGen> entitySrcGens;
    private List<EntitySrcNat> entitySrcNats;
    private List<EntitySrcSyn> entitySrcSyns;
    private List<StructConn> structConn;
    private List<StructNcsOper> structNcsOper;
    private List<StructRefSeqDif> sequenceDifs;
    private List<StructSiteGen> structSiteGens;
    private Matrix4d parsedScaleMatrix;
    private Map<String, String> asymId2entityId;
    private Map<String, String> asymId2authorId;
    private String currentNmrModelNumber;
    private FileParsingParameters params = new FileParsingParameters();

    public SimpleMMcifConsumer() {
        this.documentStart();
    }

    @Override
    public void newEntity(Entity entity) {
        logger.debug("New entity: {}", (Object)entity.toString());
        this.entities.add(entity);
    }

    @Override
    public void newEntityPoly(EntityPoly entityPoly) {
        this.entityPolys.add(entityPoly);
    }

    @Override
    public void newPdbxStructOperList(PdbxStructOperList structOper) {
        this.structOpers.add(structOper);
    }

    @Override
    public void newStructAsym(StructAsym sasym) {
        this.structAsyms.add(sasym);
    }

    private Entity getEntity(int entity_id) {
        try {
            for (Entity e : this.entities) {
                int eId = Integer.parseInt(e.getId());
                if (eId != entity_id) continue;
                return e;
            }
        }
        catch (NumberFormatException e) {
            logger.warn("Entity id does not look like a number:", (Object)e.getMessage());
        }
        return null;
    }

    @Override
    public void newStructKeywords(StructKeywords kw) {
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        header.setDescription(kw.getPdbx_keywords());
        header.setClassification(kw.getPdbx_keywords());
    }

    @Override
    public void setStruct(Struct struct) {
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        header.setTitle(struct.getTitle());
        header.setIdCode(struct.getEntry_id());
        this.structure.setPDBHeader(header);
        this.structure.setPDBCode(struct.getEntry_id());
    }

    private Group getNewGroup(String recordName, Character aminoCode1, long seq_id, String groupCode3) {
        HetatomImpl group;
        Group g = ChemCompGroupFactory.getGroupFromChemCompDictionary(groupCode3);
        if (g != null && !g.getChemComp().isEmpty()) {
            if (g instanceof AminoAcidImpl) {
                AminoAcidImpl aa = (AminoAcidImpl)g;
                aa.setId(seq_id);
            } else if (g instanceof NucleotideImpl) {
                NucleotideImpl nuc = (NucleotideImpl)g;
                nuc.setId(seq_id);
            } else if (g instanceof HetatomImpl) {
                HetatomImpl het = (HetatomImpl)g;
                het.setId(seq_id);
            }
            return g;
        }
        if (recordName.equals("ATOM")) {
            if (StructureTools.isNucleotide(groupCode3)) {
                NucleotideImpl nu;
                group = nu = new NucleotideImpl();
                nu.setId(seq_id);
            } else if (aminoCode1 == null || aminoCode1.charValue() == 'X') {
                HetatomImpl h = new HetatomImpl();
                h.setId(seq_id);
                group = h;
            } else {
                AminoAcidImpl aa = new AminoAcidImpl();
                aa.setAminoType(aminoCode1);
                aa.setId(seq_id);
                group = aa;
            }
        } else if (StructureTools.isNucleotide(groupCode3)) {
            NucleotideImpl nu;
            group = nu = new NucleotideImpl();
            nu.setId(seq_id);
        } else if (aminoCode1 != null) {
            AminoAcidImpl aa = new AminoAcidImpl();
            aa.setAminoType(aminoCode1);
            aa.setId(seq_id);
            group = aa;
        } else {
            HetatomImpl h = new HetatomImpl();
            h.setId(seq_id);
            group = h;
        }
        return group;
    }

    private static Chain isKnownChain(String asymId, List<Chain> chains) {
        for (int i = 0; i < chains.size(); ++i) {
            Chain testchain = chains.get(i);
            if (!asymId.equals(testchain.getId())) continue;
            return testchain;
        }
        return null;
    }

    @Override
    public void newAtomSite(AtomSite atom) {
        if (this.params.isHeaderOnly()) {
            return;
        }
        boolean startOfNewChain = false;
        String asymId = atom.getLabel_asym_id();
        String authId = atom.getAuth_asym_id();
        String recordName = atom.getGroup_PDB();
        String residueNumberS = atom.getAuth_seq_id();
        Integer residueNrInt = Integer.parseInt(residueNumberS);
        String groupCode3 = atom.getLabel_comp_id();
        boolean isHetAtomInFile = false;
        Character aminoCode1 = null;
        if (recordName.equals("ATOM")) {
            aminoCode1 = StructureTools.get1LetterCodeAmino(groupCode3);
        } else {
            aminoCode1 = StructureTools.get1LetterCodeAmino(groupCode3);
            if (aminoCode1 != null && aminoCode1.equals(Character.valueOf('X'))) {
                aminoCode1 = null;
            }
            isHetAtomInFile = true;
        }
        String insCodeS = atom.getPdbx_PDB_ins_code();
        Character insCode = null;
        if (!insCodeS.equals("?")) {
            insCode = Character.valueOf(insCodeS.charAt(0));
        }
        long seq_id = -1L;
        try {
            seq_id = Long.parseLong(atom.getLabel_seq_id());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String nmrModelNumber = atom.getPdbx_PDB_model_num();
        if (this.currentNmrModelNumber == null) {
            this.currentNmrModelNumber = nmrModelNumber;
        }
        if (!this.currentNmrModelNumber.equals(nmrModelNumber)) {
            this.currentNmrModelNumber = nmrModelNumber;
            if (this.currentChain != null) {
                this.currentChain.addGroup(this.currentGroup);
                this.currentGroup.trimToSize();
            }
            this.allModels.add(this.currentModel);
            this.currentModel = new ArrayList<Chain>();
            this.currentChain = null;
            this.currentGroup = null;
        }
        if (this.currentChain == null) {
            this.currentChain = new ChainImpl();
            this.currentChain.setName(authId);
            this.currentChain.setId(asymId);
            this.currentModel.add(this.currentChain);
            startOfNewChain = true;
        }
        if (!asymId.equals(this.currentChain.getId())) {
            startOfNewChain = true;
            this.currentChain.addGroup(this.currentGroup);
            Chain testchain = SimpleMMcifConsumer.isKnownChain(asymId, this.currentModel);
            if (testchain == null) {
                this.currentChain = new ChainImpl();
                this.currentChain.setName(authId);
                this.currentChain.setId(asymId);
            } else {
                this.currentChain = testchain;
            }
            if (!this.currentModel.contains(this.currentChain)) {
                this.currentModel.add(this.currentChain);
            }
        }
        ResidueNumber residueNumber = new ResidueNumber(authId, residueNrInt, insCode);
        if (this.currentGroup == null) {
            this.currentGroup = this.getNewGroup(recordName, aminoCode1, seq_id, groupCode3);
            this.currentGroup.setResidueNumber(residueNumber);
            this.currentGroup.setPDBName(groupCode3);
            this.currentGroup.setHetAtomInFile(isHetAtomInFile);
        }
        Group altGroup = null;
        String altLocS = atom.getLabel_alt_id();
        Character altLoc = Character.valueOf(' ');
        if (altLocS.length() > 0 && (altLoc = Character.valueOf(altLocS.charAt(0))).equals(Character.valueOf('.'))) {
            altLoc = Character.valueOf(' ');
        }
        if (startOfNewChain) {
            this.currentGroup = this.getNewGroup(recordName, aminoCode1, seq_id, groupCode3);
            this.currentGroup.setResidueNumber(residueNumber);
            this.currentGroup.setPDBName(groupCode3);
            this.currentGroup.setHetAtomInFile(isHetAtomInFile);
        } else if (!residueNumber.equals(this.currentGroup.getResidueNumber())) {
            this.currentChain.addGroup(this.currentGroup);
            this.currentGroup.trimToSize();
            this.currentGroup = this.getNewGroup(recordName, aminoCode1, seq_id, groupCode3);
            this.currentGroup.setPDBName(groupCode3);
            this.currentGroup.setResidueNumber(residueNumber);
            this.currentGroup.setHetAtomInFile(isHetAtomInFile);
        } else if (!altLoc.equals(Character.valueOf(' ')) && !altLoc.equals(Character.valueOf('.'))) {
            logger.debug("found altLoc! " + altLoc + " " + this.currentGroup + " " + altGroup);
            altGroup = this.getCorrectAltLocGroup(altLoc, recordName, aminoCode1, groupCode3, seq_id);
            if (altGroup.getChain() == null) {
                altGroup.setChain(this.currentChain);
            }
        }
        if (!(!this.params.isParseCAOnly() || atom.getLabel_atom_id().equals("CA") && atom.getType_symbol().equals("C"))) {
            return;
        }
        Atom a = this.convertAtom(atom);
        if (altGroup != null) {
            altGroup.addAtom(a);
            altGroup = null;
        } else {
            this.currentGroup.addAtom(a);
        }
        String atomName = a.getName();
        if (!this.currentGroup.hasAtom(atomName) && this.currentGroup.getPDBName().equals(a.getGroup().getPDBName()) && !StructureTools.hasNonDeuteratedEquiv(a, this.currentGroup)) {
            this.currentGroup.addAtom(a);
        }
    }

    private Atom convertAtom(AtomSite atom) {
        AtomImpl a = new AtomImpl();
        a.setPDBserial(Integer.parseInt(atom.getId()));
        a.setName(atom.getLabel_atom_id());
        double x = Double.parseDouble(atom.getCartn_x());
        double y = Double.parseDouble(atom.getCartn_y());
        double z = Double.parseDouble(atom.getCartn_z());
        a.setX(x);
        a.setY(y);
        a.setZ(z);
        float occupancy = Float.parseFloat(atom.getOccupancy());
        a.setOccupancy(occupancy);
        float temp = Float.parseFloat(atom.getB_iso_or_equiv());
        a.setTempFactor(temp);
        String alt = atom.getLabel_alt_id();
        if (alt != null && alt.length() > 0 && !alt.equals(".")) {
            a.setAltLoc(new Character(alt.charAt(0)));
        } else {
            a.setAltLoc(new Character(' '));
        }
        Element element = Element.R;
        try {
            element = Element.valueOfIgnoreCase(atom.getType_symbol());
        }
        catch (IllegalArgumentException e) {
            logger.info("Element {} was not recognised as a BioJava-known element, the element will be represented as the generic element {}", (Object)atom.getType_symbol(), (Object)Element.R.name());
        }
        a.setElement(element);
        return a;
    }

    private Group getCorrectAltLocGroup(Character altLoc, String recordName, Character aminoCode1, String groupCode3, long seq_id) {
        Group altLocG;
        Atom a1;
        List<Atom> atoms = this.currentGroup.getAtoms();
        if (atoms.size() > 0 && (a1 = atoms.get(0)).getAltLoc().equals(altLoc)) {
            return this.currentGroup;
        }
        List<Group> altLocs = this.currentGroup.getAltLocs();
        for (Group altLocG2 : altLocs) {
            atoms = altLocG2.getAtoms();
            if (atoms.size() <= 0) continue;
            for (Atom a12 : atoms) {
                if (!a12.getAltLoc().equals(altLoc)) continue;
                return altLocG2;
            }
        }
        if (groupCode3.equals(this.currentGroup.getPDBName())) {
            if (this.currentGroup.getAtoms().size() == 0) {
                return this.currentGroup;
            }
            altLocG = (Group)this.currentGroup.clone();
            altLocG.setAtoms(new ArrayList<Atom>());
            altLocG.getAltLocs().clear();
            this.currentGroup.addAltLoc(altLocG);
            return altLocG;
        }
        altLocG = this.getNewGroup(recordName, aminoCode1, seq_id, groupCode3);
        altLocG.setPDBName(groupCode3);
        altLocG.setResidueNumber(this.currentGroup.getResidueNumber());
        this.currentGroup.addAltLoc(altLocG);
        return altLocG;
    }

    @Override
    public void documentStart() {
        this.structure = new StructureImpl();
        this.currentChain = null;
        this.currentGroup = null;
        this.currentNmrModelNumber = null;
        this.allModels = new ArrayList();
        this.currentModel = new ArrayList<Chain>();
        this.entities = new ArrayList<Entity>();
        this.entityPolys = new ArrayList<EntityPoly>();
        this.strucRefs = new ArrayList<StructRef>();
        this.seqResChains = new ArrayList<Chain>();
        this.entityChains = new ArrayList<Chain>();
        this.structAsyms = new ArrayList<StructAsym>();
        this.asymId2entityId = new HashMap<String, String>();
        this.asymId2authorId = new HashMap<String, String>();
        this.structOpers = new ArrayList<PdbxStructOperList>();
        this.strucAssemblies = new ArrayList<PdbxStructAssembly>();
        this.strucAssemblyGens = new ArrayList<PdbxStructAssemblyGen>();
        this.entitySrcGens = new ArrayList<EntitySrcGen>();
        this.entitySrcNats = new ArrayList<EntitySrcNat>();
        this.entitySrcSyns = new ArrayList<EntitySrcSyn>();
        this.structConn = new ArrayList<StructConn>();
        this.structNcsOper = new ArrayList<StructNcsOper>();
        this.sequenceDifs = new ArrayList<StructRefSeqDif>();
        this.structSiteGens = new ArrayList<StructSiteGen>();
    }

    @Override
    public void documentEnd() {
        if (this.currentChain != null) {
            this.currentChain.addGroup(this.currentGroup);
            if (SimpleMMcifConsumer.isKnownChain(this.currentChain.getId(), this.currentModel) == null) {
                this.currentModel.add(this.currentChain);
            }
        } else if (!this.params.isHeaderOnly()) {
            logger.warn("current chain is null at end of document.");
        }
        this.allModels.add(this.currentModel);
        this.initMaps();
        for (StructAsym structAsym : this.structAsyms) {
            logger.debug("Entity {} matches asym_id: {}", (Object)structAsym.getEntity_id(), (Object)structAsym.getId());
            Chain s = this.getEntityChain(structAsym.getEntity_id());
            Chain seqres = (Chain)s.clone();
            seqres = SimpleMMcifConsumer.removeSeqResHeterogeneity(seqres);
            seqres.setId(structAsym.getId());
            if (this.asymId2authorId.get(structAsym.getId()) != null) {
                seqres.setName(this.asymId2authorId.get(structAsym.getId()));
            } else {
                seqres.setName(structAsym.getId());
            }
            Object type = null;
            try {
                Entity ent = this.getEntity(Integer.parseInt(structAsym.getEntity_id()));
                type = EntityType.entityTypeFromString(ent.getType());
            }
            catch (NumberFormatException e) {
                logger.debug("Could not parse integer from entity id field {}", (Object)structAsym.getEntity_id());
            }
            if (type == null || type == EntityType.POLYMER) {
                this.seqResChains.add(seqres);
            }
            logger.debug(" seqres: " + structAsym.getId() + " " + seqres + "<");
            this.addEntities(structAsym);
        }
        if (this.structAsyms.isEmpty()) {
            logger.warn("No _struct_asym category in file, no SEQRES groups will be added.");
        }
        this.linkEntities();
        for (List list : this.allModels) {
            this.structure.addModel(list);
        }
        if (this.params.isAlignSeqRes() && !this.params.isHeaderOnly()) {
            logger.debug("Parsing mode align_seqres, will parse SEQRES and align to ATOM sequence");
            this.alignSeqRes();
        } else {
            logger.debug("Parsing mode unalign_seqres, will parse SEQRES but not align it to ATOM sequence");
            SeqRes2AtomAligner.storeUnAlignedSeqRes(this.structure, this.seqResChains, this.params.isHeaderOnly());
        }
        StructureTools.cleanUpAltLocs(this.structure);
        if (!this.params.isHeaderOnly()) {
            if (this.params.shouldCreateAtomBonds()) {
                this.addBonds();
            }
            if (this.params.shouldCreateAtomCharges()) {
                this.addCharges();
            }
        }
        if (!this.params.isHeaderOnly()) {
            this.addSites();
        }
        if (this.params.isParseBioAssembly()) {
            HashMap<Integer, BioAssemblyInfo> bioAssemblies = new HashMap<Integer, BioAssemblyInfo>();
            for (PdbxStructAssembly psa : this.strucAssemblies) {
                ArrayList<PdbxStructAssemblyGen> psags = new ArrayList<PdbxStructAssemblyGen>(1);
                for (PdbxStructAssemblyGen psag : this.strucAssemblyGens) {
                    if (!psag.getAssembly_id().equals(psa.getId())) continue;
                    psags.add(psag);
                }
                BiologicalAssemblyBuilder builder = new BiologicalAssemblyBuilder();
                ArrayList<BiologicalAssemblyTransformation> transformations = builder.getBioUnitTransformationList(psa, psags, this.structOpers);
                int bioAssemblyId = -1;
                try {
                    bioAssemblyId = Integer.parseInt(psa.getId());
                }
                catch (NumberFormatException e) {
                    logger.info("Could not parse a numerical bio assembly id from '{}'", (Object)psa.getId());
                }
                if (bioAssemblyId == -1) continue;
                int mmSize = 0;
                for (BiologicalAssemblyTransformation transf : transformations) {
                    Chain c = this.structure.getChain(transf.getChainId());
                    if (c == null) {
                        logger.info("Could not find asym id {} specified in struct_assembly_gen", (Object)transf.getChainId());
                        continue;
                    }
                    if (c.getEntityType() != EntityType.POLYMER || c.getEntityInfo().getDescription().contains("SUGAR")) continue;
                    ++mmSize;
                }
                BioAssemblyInfo bioAssembly = new BioAssemblyInfo();
                bioAssembly.setId(bioAssemblyId);
                bioAssembly.setMacromolecularSize(mmSize);
                bioAssembly.setTransforms(transformations);
                bioAssemblies.put(bioAssemblyId, bioAssembly);
            }
            this.structure.getPDBHeader().setBioAssemblies(bioAssemblies);
        }
        this.setStructNcsOps();
        this.setCrystallographicInfoMetadata();
        HashMap<String, ArrayList<SeqMisMatchImpl>> misMatchMap = new HashMap<String, ArrayList<SeqMisMatchImpl>>();
        for (StructRefSeqDif sdif : this.sequenceDifs) {
            SeqMisMatchImpl misMatch = new SeqMisMatchImpl();
            misMatch.setDetails(sdif.getDetails());
            String insCode = sdif.getPdbx_pdb_ins_code();
            if (insCode != null && insCode.equals("?")) {
                insCode = null;
            }
            misMatch.setInsCode(insCode);
            misMatch.setOrigGroup(sdif.getDb_mon_id());
            misMatch.setPdbGroup(sdif.getMon_id());
            misMatch.setPdbResNum(sdif.getPdbx_auth_seq_num());
            misMatch.setUniProtId(sdif.getPdbx_seq_db_accession_code());
            misMatch.setSeqNum(sdif.getSeq_num());
            ArrayList<SeqMisMatchImpl> mms = (ArrayList<SeqMisMatchImpl>)misMatchMap.get(sdif.getPdbx_pdb_strand_id());
            if (mms == null) {
                mms = new ArrayList<SeqMisMatchImpl>();
                misMatchMap.put(sdif.getPdbx_pdb_strand_id(), mms);
            }
            mms.add(misMatch);
        }
        for (String chainId : misMatchMap.keySet()) {
            Chain chain = this.structure.getPolyChainByPDB(chainId);
            if (chain == null) {
                logger.warn("Could not set mismatches for chain with author id" + chainId);
                continue;
            }
            chain.setSeqMisMatches((List)misMatchMap.get(chainId));
        }
    }

    private void linkEntities() {
        for (int i = 0; i < this.allModels.size(); ++i) {
            for (Chain chain : this.allModels.get(i)) {
                String entityId = this.asymId2entityId.get(chain.getId());
                if (entityId == null) {
                    logger.info("No entity id could be found for chain {}", (Object)chain.getId());
                    continue;
                }
                int eId = Integer.parseInt(entityId);
                EntityInfo entityInfo = this.structure.getEntityById(eId);
                if (entityInfo == null) {
                    logger.info("Could not find an Entity for entity_id {}, for chain id {}, creating a new Entity.", (Object)eId, (Object)chain.getId());
                    entityInfo = new EntityInfo();
                    entityInfo.setMolId(eId);
                    entityInfo.addChain(chain);
                    if (chain.isWaterOnly()) {
                        entityInfo.setType(EntityType.WATER);
                    } else {
                        entityInfo.setType(EntityType.NONPOLYMER);
                    }
                    chain.setEntityInfo(entityInfo);
                    this.structure.addEntityInfo(entityInfo);
                    continue;
                }
                logger.debug("Adding chain with chain id {} (auth id {}) to Entity with entity_id {}", new Object[]{chain.getId(), chain.getName(), eId});
                entityInfo.addChain(chain);
                chain.setEntityInfo(entityInfo);
            }
        }
        List<EntityInfo> entityInfos = this.structure.getEntityInfos();
        if (entityInfos == null || entityInfos.isEmpty()) {
            ArrayList<List<Chain>> polyModels = new ArrayList<List<Chain>>();
            ArrayList<List<Chain>> nonPolyModels = new ArrayList<List<Chain>>();
            ArrayList<List<Chain>> waterModels = new ArrayList<List<Chain>>();
            for (List<Chain> model : this.allModels) {
                ArrayList<Chain> polyChains = new ArrayList<Chain>();
                ArrayList<Chain> nonPolyChains = new ArrayList<Chain>();
                ArrayList<Chain> waterChains = new ArrayList<Chain>();
                polyModels.add(polyChains);
                nonPolyModels.add(nonPolyChains);
                waterModels.add(waterChains);
                for (Chain c : model) {
                    if (c.isWaterOnly()) {
                        waterChains.add(c);
                        continue;
                    }
                    if (c.isPureNonPolymer()) {
                        nonPolyChains.add(c);
                        continue;
                    }
                    polyChains.add(c);
                }
            }
            entityInfos = EntityFinder.findPolyEntities(polyModels);
            EntityFinder.createPurelyNonPolyEntities(nonPolyModels, waterModels, entityInfos);
            this.structure.setEntityInfos(entityInfos);
        }
        for (EntityInfo e : entityInfos) {
            if (!e.getChains().isEmpty()) continue;
            logger.info("Entity {} '{}' has no chains associated to it", e.getMolId() < 0 ? "with no entity id" : Integer.valueOf(e.getMolId()), (Object)e.getDescription());
        }
    }

    private void addCharges() {
        ChargeAdder.addCharges(this.structure);
    }

    private static Chain removeSeqResHeterogeneity(Chain c) {
        ChainImpl trimmedChain = new ChainImpl();
        ResidueNumber lastResNum = null;
        for (Group g : c.getAtomGroups()) {
            ResidueNumber currentResNum = new ResidueNumber(g.getResidueNumber().getChainName(), g.getResidueNumber().getSeqNum(), g.getResidueNumber().getInsCode());
            if (lastResNum == null || !lastResNum.equals(currentResNum)) {
                trimmedChain.addGroup(g);
            } else {
                logger.debug("Removing seqres group because it seems to be repeated in entity_poly_seq, most likely has hetero='y': " + g);
            }
            lastResNum = currentResNum;
        }
        return trimmedChain;
    }

    private void addBonds() {
        BondMaker maker = new BondMaker(this.structure, this.params);
        maker.makeBonds();
        maker.formBondsFromStructConn(this.structConn);
    }

    private void alignSeqRes() {
        logger.debug("Parsing mode align_seqres, will align to ATOM to SEQRES sequence");
        for (int model = 0; model < this.structure.nrModels(); ++model) {
            List<Chain> atomList = this.structure.getModel(model);
            for (Chain seqResChain : this.seqResChains) {
                Chain atomChain = SeqRes2AtomAligner.getMatchingAtomRes(seqResChain, atomList, true);
                if (atomChain == null) {
                    logger.info("Could not map SEQRES chain with asym_id={} to any ATOM chain. Most likely there's no observed residues in the chain.", (Object)seqResChain.getId());
                    continue;
                }
                ArrayList<Group> seqResGroups = new ArrayList<Group>();
                for (int i = 0; i < seqResChain.getAtomGroups().size(); ++i) {
                    seqResGroups.add((Group)seqResChain.getAtomGroups().get(i).clone());
                }
                for (int seqResPos = 0; seqResPos < seqResGroups.size(); ++seqResPos) {
                    Group seqresG = (Group)seqResGroups.get(seqResPos);
                    boolean found = false;
                    for (Group atomG : atomChain.getAtomGroups()) {
                        int internalNr = this.getInternalNr(atomG);
                        if (seqresG.getResidueNumber().getSeqNum() != internalNr) continue;
                        seqResGroups.set(seqResPos, atomG);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    seqresG.setResidueNumber(null);
                }
                atomChain.setSeqResGroups(seqResGroups);
            }
        }
    }

    private int getInternalNr(Group atomG) {
        if (atomG.getType().equals((Object)GroupType.AMINOACID)) {
            AminoAcidImpl aa = (AminoAcidImpl)atomG;
            return new Long(aa.getId()).intValue();
        }
        if (atomG.getType().equals((Object)GroupType.NUCLEOTIDE)) {
            NucleotideImpl nu = (NucleotideImpl)atomG;
            return new Long(nu.getId()).intValue();
        }
        HetatomImpl he = (HetatomImpl)atomG;
        return new Long(he.getId()).intValue();
    }

    private void addEntities(StructAsym asym) {
        int eId = 0;
        try {
            eId = Integer.parseInt(asym.getEntity_id());
        }
        catch (NumberFormatException e) {
            logger.warn("Could not parse mol_id from string {}. Will use 0 for creating Entity", (Object)asym.getEntity_id());
        }
        Entity e = this.getEntity(eId);
        EntityInfo entityInfo = this.structure.getEntityById(eId);
        if (entityInfo == null) {
            entityInfo = new EntityInfo();
            entityInfo.setMolId(eId);
            if (e != null) {
                entityInfo.setDescription(e.getPdbx_description());
                EntityType eType = EntityType.entityTypeFromString(e.getType());
                if (eType != null) {
                    entityInfo.setType(eType);
                } else {
                    logger.warn("Type '{}' is not recognised as a valid entity type for entity {}", (Object)e.getType(), (Object)eId);
                }
                this.addAncilliaryEntityData(asym, eId, e, entityInfo);
                this.structure.addEntityInfo(entityInfo);
                logger.debug("Adding Entity with entity id {} from _entity, with name: {}", (Object)eId, (Object)entityInfo.getDescription());
            }
        }
    }

    private void addAncilliaryEntityData(StructAsym asym, int entityId, Entity entity, EntityInfo entityInfo) {
        for (EntitySrcGen esg : this.entitySrcGens) {
            if (!esg.getEntity_id().equals(asym.getEntity_id())) continue;
            this.addInformationFromESG(esg, entityId, entityInfo);
        }
        for (EntitySrcNat esn : this.entitySrcNats) {
            if (!esn.getEntity_id().equals(asym.getEntity_id())) continue;
            this.addInformationFromESN(esn, entityId, entityInfo);
        }
        for (EntitySrcSyn ess : this.entitySrcSyns) {
            if (!ess.getEntity_id().equals(asym.getEntity_id())) continue;
            this.addInfoFromESS(ess, entityId, entityInfo);
        }
    }

    private void addInformationFromESG(EntitySrcGen entitySrcInfo, int entityId, EntityInfo c) {
        c.setAtcc(entitySrcInfo.getPdbx_gene_src_atcc());
        c.setCell(entitySrcInfo.getPdbx_gene_src_cell());
        c.setOrganismCommon(entitySrcInfo.getGene_src_common_name());
        c.setOrganismScientific(entitySrcInfo.getPdbx_gene_src_scientific_name());
        c.setOrganismTaxId(entitySrcInfo.getPdbx_gene_src_ncbi_taxonomy_id());
        c.setExpressionSystemTaxId(entitySrcInfo.getPdbx_host_org_ncbi_taxonomy_id());
        c.setExpressionSystem(entitySrcInfo.getPdbx_host_org_scientific_name());
    }

    private void addInformationFromESN(EntitySrcNat esn, int eId, EntityInfo c) {
        c.setAtcc(esn.getPdbx_atcc());
        c.setCell(esn.getPdbx_cell());
        c.setOrganismCommon(esn.getCommon_name());
        c.setOrganismScientific(esn.getPdbx_organism_scientific());
        c.setOrganismTaxId(esn.getPdbx_ncbi_taxonomy_id());
    }

    private void addInfoFromESS(EntitySrcSyn ess, int eId, EntityInfo c) {
        c.setOrganismCommon(ess.getOrganism_common_name());
        c.setOrganismScientific(ess.getOrganism_scientific());
        c.setOrganismTaxId(ess.getNcbi_taxonomy_id());
    }

    private void initMaps() {
        if (this.structAsyms == null || this.structAsyms.isEmpty()) {
            logger.info("No _struct_asym category found in file. No asym id to entity_id mapping will be available");
            return;
        }
        HashMap entityId2asymId = new HashMap();
        for (StructAsym asym : this.structAsyms) {
            List<String> asymIds;
            logger.debug("Entity {} matches asym_id: {}", (Object)asym.getEntity_id(), (Object)asym.getId());
            this.asymId2entityId.put(asym.getId(), asym.getEntity_id());
            if (entityId2asymId.containsKey(asym.getEntity_id())) {
                asymIds = (List)entityId2asymId.get(asym.getEntity_id());
                asymIds.add(asym.getId());
                continue;
            }
            asymIds = new ArrayList<String>();
            asymIds.add(asym.getId());
            entityId2asymId.put(asym.getEntity_id(), asymIds);
        }
        if (this.entityPolys == null || this.entityPolys.isEmpty()) {
            logger.info("No _entity_poly category found in file. No asym id to author id mapping will be available for header only parsing");
            return;
        }
        for (EntityPoly ep : this.entityPolys) {
            List asymIds;
            if (ep.getPdbx_strand_id() == null) {
                logger.info("_entity_poly.pdbx_strand_id is null for entity {}. Won't be able to map asym ids to author ids for this entity.", (Object)ep.getEntity_id());
                continue;
            }
            String[] chainNames = ep.getPdbx_strand_id().split(",");
            if (chainNames.length != (asymIds = (List)entityId2asymId.get(ep.getEntity_id())).size()) {
                logger.warn("The list of asym ids (from _struct_asym) and the list of author ids (from _entity_poly) for entity {} have different lengths! Can't provide a mapping from asym ids to author chain ids", (Object)ep.getEntity_id());
                continue;
            }
            for (int i = 0; i < chainNames.length; ++i) {
                this.asymId2authorId.put((String)asymIds.get(i), chainNames[i]);
            }
        }
    }

    private void setStructNcsOps() {
        ArrayList<Matrix4d> ncsOperators = new ArrayList<Matrix4d>();
        for (StructNcsOper sNcsOper : this.structNcsOper) {
            if (!sNcsOper.getCode().equals("generate")) continue;
            try {
                Matrix4d op = new Matrix4d();
                op.setElement(3, 0, 0.0);
                op.setElement(3, 1, 0.0);
                op.setElement(3, 2, 0.0);
                op.setElement(3, 3, 1.0);
                op.setElement(0, 0, Double.parseDouble(sNcsOper.getMatrix11()));
                op.setElement(0, 1, Double.parseDouble(sNcsOper.getMatrix12()));
                op.setElement(0, 2, Double.parseDouble(sNcsOper.getMatrix13()));
                op.setElement(1, 0, Double.parseDouble(sNcsOper.getMatrix21()));
                op.setElement(1, 1, Double.parseDouble(sNcsOper.getMatrix22()));
                op.setElement(1, 2, Double.parseDouble(sNcsOper.getMatrix23()));
                op.setElement(2, 0, Double.parseDouble(sNcsOper.getMatrix31()));
                op.setElement(2, 1, Double.parseDouble(sNcsOper.getMatrix32()));
                op.setElement(2, 2, Double.parseDouble(sNcsOper.getMatrix33()));
                op.setElement(0, 3, Double.parseDouble(sNcsOper.getVector1()));
                op.setElement(1, 3, Double.parseDouble(sNcsOper.getVector2()));
                op.setElement(2, 3, Double.parseDouble(sNcsOper.getVector3()));
                ncsOperators.add(op);
            }
            catch (NumberFormatException e) {
                logger.warn("Error parsing doubles in NCS operator list, skipping operator {}", (Object)(this.structNcsOper.indexOf(sNcsOper) + 1));
            }
        }
        if (ncsOperators.size() > 0) {
            this.structure.getCrystallographicInfo().setNcsOperators(ncsOperators.toArray(new Matrix4d[ncsOperators.size()]));
        }
    }

    private void setCrystallographicInfoMetadata() {
        if (this.parsedScaleMatrix != null) {
            PDBCrystallographicInfo crystalInfo = this.structure.getCrystallographicInfo();
            boolean nonStd = false;
            if (crystalInfo.getCrystalCell() != null && !crystalInfo.getCrystalCell().checkScaleMatrix(this.parsedScaleMatrix)) {
                nonStd = true;
            }
            crystalInfo.setNonStandardCoordFrameConvention(nonStd);
        }
    }

    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public void newDatabasePDBrevRecord(DatabasePdbrevRecord record) {
        List<DatabasePdbrevRecord> revRecords;
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
            this.structure.setPDBHeader(header);
        }
        if ((revRecords = header.getRevisionRecords()) == null) {
            revRecords = new ArrayList<DatabasePdbrevRecord>();
            header.setRevisionRecords(revRecords);
        }
        revRecords.add(record);
    }

    @Override
    public void newDatabasePDBrev(DatabasePDBrev dbrev) {
        logger.debug("got a database revision:" + dbrev);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        if (dbrev.getNum().equals("1")) {
            try {
                Date dep = dateFormat.parse(dbrev.getDate_original());
                header.setDepDate(dep);
            }
            catch (ParseException e) {
                logger.warn("Could not parse date string '{}', deposition date will be unavailable", (Object)dbrev.getDate_original());
            }
            try {
                Date rel = dateFormat.parse(dbrev.getDate());
                header.setRelDate(rel);
            }
            catch (ParseException e) {
                logger.warn("Could not parse date string '{}', modification date will be unavailable", (Object)dbrev.getDate());
            }
        } else {
            try {
                Date mod = dateFormat.parse(dbrev.getDate());
                header.setModDate(mod);
            }
            catch (ParseException e) {
                logger.warn("Could not parse date string '{}', modification date will be unavailable", (Object)dbrev.getDate());
            }
        }
        this.structure.setPDBHeader(header);
    }

    @Override
    public void newPdbxAuditRevisionHistory(PdbxAuditRevisionHistory history) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        if (history.getOrdinal().equals("1")) {
            try {
                Date releaseDate = dateFormat.parse(history.getRevision_date());
                header.setRelDate(releaseDate);
            }
            catch (ParseException e) {
                logger.warn("Could not parse date string '{}', release date will be unavailable", (Object)history.getRevision_date());
            }
        } else {
            try {
                Date revisionDate = dateFormat.parse(history.getRevision_date());
                header.setModDate(revisionDate);
            }
            catch (ParseException e) {
                logger.warn("Could not parse date string '{}', revision date will be unavailable", (Object)history.getRevision_date());
            }
        }
        this.structure.setPDBHeader(header);
    }

    @Override
    public void newPdbxDatabaseStatus(PdbxDatabaseStatus status) {
        if (status.getRecvd_initial_deposition_date() == null) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        try {
            Date depositionDate = dateFormat.parse(status.getRecvd_initial_deposition_date());
            header.setDepDate(depositionDate);
        }
        catch (ParseException e) {
            logger.warn("Could not parse date string '{}', deposition date will be unavailable", (Object)status.getRecvd_initial_deposition_date());
        }
        this.structure.setPDBHeader(header);
    }

    @Override
    public void newDatabasePDBremark(DatabasePDBremark remark) {
        String line;
        int i;
        String id = remark.getId();
        if (id.equals("2") && (i = (line = remark.getText()).indexOf("ANGSTROM")) > 5) {
            String resolution = line.substring(i - 5, i).trim();
            float res = 99.0f;
            try {
                res = Float.parseFloat(resolution);
            }
            catch (NumberFormatException e) {
                logger.info("could not parse resolution from line and ignoring it " + line);
                return;
            }
            PDBHeader pdbHeader = this.structure.getPDBHeader();
            pdbHeader.setResolution(res);
        }
    }

    @Override
    public void newRefine(Refine r) {
        PDBHeader pdbHeader = this.structure.getPDBHeader();
        if (pdbHeader.getResolution() != 99.0f) {
            logger.warn("More than 1 resolution value present, will use last one {} and discard previous {} ", (Object)r.getLs_d_res_high(), (Object)String.format("%4.2f", Float.valueOf(pdbHeader.getResolution())));
        }
        try {
            pdbHeader.setResolution(Float.parseFloat(r.getLs_d_res_high()));
        }
        catch (NumberFormatException e) {
            logger.info("Could not parse resolution from " + r.getLs_d_res_high() + " " + e.getMessage());
        }
        if (pdbHeader.getRfree() != 1.0f) {
            logger.warn("More than 1 Rfree value present, will use last one {} and discard previous {} ", (Object)r.getLs_R_factor_R_free(), (Object)String.format("%4.2f", Float.valueOf(pdbHeader.getRfree())));
        }
        if (r.getLs_R_factor_R_free() == null) {
            logger.info("_refine.ls_R_factor_R_free not present, not parsing Rfree value");
        } else {
            try {
                pdbHeader.setRfree(Float.parseFloat(r.getLs_R_factor_R_free()));
            }
            catch (NumberFormatException e) {
                logger.debug("Could not parse Rfree from string '{}'", (Object)r.getLs_R_factor_R_free());
            }
        }
        if (pdbHeader.getRwork() != 1.0f) {
            logger.warn("More than 1 R work value present, will use last one {} and discard previous {} ", (Object)r.getLs_R_factor_R_work(), (Object)String.format("%4.2f", Float.valueOf(pdbHeader.getRwork())));
        }
        if (r.getLs_R_factor_R_work() == null) {
            logger.info("_refine.ls_R_factor_R_work not present, not parsing R-work value");
        } else {
            try {
                pdbHeader.setRwork(Float.parseFloat(r.getLs_R_factor_R_work()));
            }
            catch (NumberFormatException e) {
                logger.debug("Could not parse R-work from string '{}'", (Object)r.getLs_R_factor_R_work());
            }
        }
    }

    @Override
    public void newAuditAuthor(AuditAuthor aa) {
        String name = aa.getName();
        StringBuffer famName = new StringBuffer();
        StringBuffer initials = new StringBuffer();
        boolean afterComma = false;
        for (char c : name.toCharArray()) {
            if (c == ' ') continue;
            if (c == ',') {
                afterComma = true;
                continue;
            }
            if (afterComma) {
                initials.append(c);
                continue;
            }
            famName.append(c);
        }
        StringBuffer newaa = new StringBuffer();
        newaa.append(initials);
        newaa.append(famName);
        PDBHeader header = this.structure.getPDBHeader();
        String auth = header.getAuthors();
        if (auth == null) {
            header.setAuthors(newaa.toString());
        } else {
            auth = auth + "," + newaa.toString();
            header.setAuthors(auth);
        }
    }

    @Override
    public void newExptl(Exptl exptl) {
        PDBHeader pdbHeader = this.structure.getPDBHeader();
        String method = exptl.getMethod();
        pdbHeader.setExperimentalTechnique(method);
    }

    @Override
    public void newCell(Cell cell) {
        try {
            float a = Float.parseFloat(cell.getLength_a());
            float b = Float.parseFloat(cell.getLength_b());
            float c = Float.parseFloat(cell.getLength_c());
            float alpha = Float.parseFloat(cell.getAngle_alpha());
            float beta = Float.parseFloat(cell.getAngle_beta());
            float gamma = Float.parseFloat(cell.getAngle_gamma());
            CrystalCell xtalCell = new CrystalCell();
            xtalCell.setA(a);
            xtalCell.setB(b);
            xtalCell.setC(c);
            xtalCell.setAlpha(alpha);
            xtalCell.setBeta(beta);
            xtalCell.setGamma(gamma);
            if (!xtalCell.isCellReasonable()) {
                logger.debug("The crystal cell read from file does not have reasonable dimensions (at least one dimension is below {}), discarding it.", (Object)10.0);
                return;
            }
            this.structure.getPDBHeader().getCrystallographicInfo().setCrystalCell(xtalCell);
        }
        catch (NumberFormatException e) {
            this.structure.getPDBHeader().getCrystallographicInfo().setCrystalCell(null);
            logger.info("could not parse some cell parameters (" + e.getMessage() + "), ignoring _cell ");
        }
    }

    @Override
    public void newSymmetry(Symmetry symmetry) {
        String spaceGroup = symmetry.getSpace_group_name_H_M();
        SpaceGroup sg = SymoplibParser.getSpaceGroup(spaceGroup);
        if (sg == null) {
            logger.warn("Space group '" + spaceGroup + "' not recognised as a standard space group");
            this.structure.getPDBHeader().getCrystallographicInfo().setNonStandardSg(true);
        } else {
            this.structure.getPDBHeader().getCrystallographicInfo().setSpaceGroup(sg);
            this.structure.getPDBHeader().getCrystallographicInfo().setNonStandardSg(false);
        }
    }

    @Override
    public void newStructNcsOper(StructNcsOper sNcsOper) {
        this.structNcsOper.add(sNcsOper);
    }

    @Override
    public void newAtomSites(AtomSites atomSites) {
        try {
            Matrix4d m;
            this.parsedScaleMatrix = m = new Matrix4d(Double.parseDouble(atomSites.getFract_transf_matrix11()), Double.parseDouble(atomSites.getFract_transf_matrix12()), Double.parseDouble(atomSites.getFract_transf_matrix13()), Double.parseDouble(atomSites.getFract_transf_vector1()), Double.parseDouble(atomSites.getFract_transf_matrix21()), Double.parseDouble(atomSites.getFract_transf_matrix22()), Double.parseDouble(atomSites.getFract_transf_matrix23()), Double.parseDouble(atomSites.getFract_transf_vector2()), Double.parseDouble(atomSites.getFract_transf_matrix31()), Double.parseDouble(atomSites.getFract_transf_matrix32()), Double.parseDouble(atomSites.getFract_transf_matrix33()), Double.parseDouble(atomSites.getFract_transf_vector3()), 0.0, 0.0, 0.0, 1.0);
        }
        catch (NumberFormatException e) {
            logger.warn("Some values in _atom_sites.fract_transf_matrix or _atom_sites.fract_transf_vector could not be parsed as numbers. Can't check whether coordinate frame convention is correct! Error: {}", (Object)e.getMessage());
            this.structure.getPDBHeader().getCrystallographicInfo().setNonStandardCoordFrameConvention(false);
        }
    }

    @Override
    public void newStructRef(StructRef sref) {
        logger.debug(sref.toString());
        this.strucRefs.add(sref);
    }

    private StructRef getStructRef(String ref_id) {
        for (StructRef structRef : this.strucRefs) {
            if (!structRef.getId().equals(ref_id)) continue;
            return structRef;
        }
        return null;
    }

    @Override
    public void newStructRefSeq(StructRefSeq sref) {
        int seqend;
        int seqbegin;
        DBRef r = new DBRef();
        r.setIdCode(sref.getPdbx_PDB_id_code());
        r.setDbAccession(sref.getPdbx_db_accession());
        r.setDbIdCode(sref.getPdbx_db_accession());
        r.setChainName(sref.getPdbx_strand_id());
        StructRef structRef = this.getStructRef(sref.getRef_id());
        if (structRef == null) {
            logger.info("could not find StructRef " + sref.getRef_id() + " for StructRefSeq " + sref);
        } else {
            r.setDatabase(structRef.getDb_name());
            r.setDbIdCode(structRef.getDb_code());
        }
        try {
            seqbegin = Integer.parseInt(sref.getPdbx_auth_seq_align_beg());
            seqend = Integer.parseInt(sref.getPdbx_auth_seq_align_end());
        }
        catch (NumberFormatException e) {
            logger.warn("Couldn't parse pdbx_auth_seq_align_beg/end in _struct_ref_seq. Will not store dbref alignment info for accession {}. Error: {}", (Object)r.getDbAccession(), (Object)e.getMessage());
            return;
        }
        Character begin_ins_code = Character.valueOf(' ');
        if (sref.getPdbx_seq_align_beg_ins_code() != null) {
            begin_ins_code = new Character(sref.getPdbx_seq_align_beg_ins_code().charAt(0));
        }
        Character end_ins_code = Character.valueOf(' ');
        if (sref.getPdbx_seq_align_end_ins_code() != null) {
            end_ins_code = new Character(sref.getPdbx_seq_align_end_ins_code().charAt(0));
        }
        if (begin_ins_code.charValue() == '?') {
            begin_ins_code = Character.valueOf(' ');
        }
        if (end_ins_code.charValue() == '?') {
            end_ins_code = Character.valueOf(' ');
        }
        r.setSeqBegin(seqbegin);
        r.setInsertBegin(begin_ins_code.charValue());
        r.setSeqEnd(seqend);
        r.setInsertEnd(end_ins_code.charValue());
        int dbseqbegin = Integer.parseInt(sref.getDb_align_beg());
        int dbseqend = Integer.parseInt(sref.getDb_align_end());
        Character db_begin_in_code = Character.valueOf(' ');
        if (sref.getPdbx_db_align_beg_ins_code() != null) {
            db_begin_in_code = new Character(sref.getPdbx_db_align_beg_ins_code().charAt(0));
        }
        Character db_end_in_code = Character.valueOf(' ');
        if (sref.getPdbx_db_align_end_ins_code() != null) {
            db_end_in_code = new Character(sref.getPdbx_db_align_end_ins_code().charAt(0));
        }
        if (db_begin_in_code.charValue() == '?') {
            db_begin_in_code = Character.valueOf(' ');
        }
        if (db_end_in_code.charValue() == '?') {
            db_end_in_code = Character.valueOf(' ');
        }
        r.setDbSeqBegin(dbseqbegin);
        r.setIdbnsBegin(db_begin_in_code.charValue());
        r.setDbSeqEnd(dbseqend);
        r.setIdbnsEnd(db_end_in_code.charValue());
        List<DBRef> dbrefs = this.structure.getDBRefs();
        if (dbrefs == null) {
            dbrefs = new ArrayList<DBRef>();
        }
        dbrefs.add(r);
        logger.debug(r.toPDB());
        this.structure.setDBRefs(dbrefs);
    }

    @Override
    public void newStructRefSeqDif(StructRefSeqDif sref) {
        this.sequenceDifs.add(sref);
    }

    private Chain getEntityChain(String entity_id) {
        for (Chain chain : this.entityChains) {
            if (!chain.getId().equals(entity_id)) continue;
            return chain;
        }
        ChainImpl chain = new ChainImpl();
        chain.setId(entity_id);
        this.entityChains.add(chain);
        return chain;
    }

    @Override
    public void newEntitySrcGen(EntitySrcGen entitySrcGen) {
        this.entitySrcGens.add(entitySrcGen);
    }

    @Override
    public void newEntitySrcNat(EntitySrcNat entitySrcNat) {
        this.entitySrcNats.add(entitySrcNat);
    }

    @Override
    public void newEntitySrcSyn(EntitySrcSyn entitySrcSyn) {
        this.entitySrcSyns.add(entitySrcSyn);
    }

    @Override
    public void newEntityPolySeq(EntityPolySeq epolseq) {
        logger.debug("NEW entity poly seq " + epolseq);
        int eId = -1;
        try {
            eId = Integer.parseInt(epolseq.getEntity_id());
        }
        catch (NumberFormatException e) {
            logger.warn("Could not parse entity id from EntityPolySeq: " + e.getMessage());
        }
        Entity e = this.getEntity(eId);
        if (e == null) {
            logger.info("Could not find entity " + epolseq.getEntity_id() + ". Can not match sequence to it.");
            return;
        }
        Chain entityChain = this.getEntityChain(epolseq.getEntity_id());
        Group g = ChemCompGroupFactory.getGroupFromChemCompDictionary(epolseq.getMon_id());
        if (g != null && !g.getChemComp().isEmpty()) {
            if (g instanceof AminoAcidImpl) {
                AminoAcidImpl aa = (AminoAcidImpl)g;
                aa.setRecordType("SEQRES");
            }
        } else if (epolseq.getMon_id().length() == 3 && StructureTools.get1LetterCodeAmino(epolseq.getMon_id()) != null) {
            AminoAcidImpl a = new AminoAcidImpl();
            a.setRecordType("SEQRES");
            Character code1 = StructureTools.get1LetterCodeAmino(epolseq.getMon_id());
            a.setAminoType(code1);
            g = a;
        } else if (StructureTools.isNucleotide(epolseq.getMon_id())) {
            NucleotideImpl n = new NucleotideImpl();
            g = n;
        } else {
            logger.debug("Residue {} {} is not a standard aminoacid or nucleotide, will create a het group for it", (Object)epolseq.getNum(), (Object)epolseq.getMon_id());
            HetatomImpl h = new HetatomImpl();
            g = h;
        }
        g.setResidueNumber(ResidueNumber.fromString(epolseq.getNum()));
        g.setPDBName(epolseq.getMon_id());
        entityChain.addGroup(g);
    }

    @Override
    public void newPdbxPolySeqScheme(PdbxPolySeqScheme ppss) {
    }

    @Override
    public void newPdbxNonPolyScheme(PdbxNonPolyScheme ppss) {
    }

    @Override
    public void newPdbxEntityNonPoly(PdbxEntityNonPoly pen) {
        logger.debug(pen.getEntity_id() + " " + pen.getName() + " " + pen.getComp_id());
    }

    @Override
    public void newChemComp(ChemComp c) {
    }

    @Override
    public void newGenericData(String category, List<String> loopFields, List<String> lineData) {
    }

    @Override
    public FileParsingParameters getFileParsingParameters() {
        return this.params;
    }

    @Override
    public void setFileParsingParameters(FileParsingParameters params) {
        this.params = params;
    }

    @Override
    public void newChemCompDescriptor(ChemCompDescriptor ccd) {
    }

    public List<PdbxStructOperList> getStructOpers() {
        return this.structOpers;
    }

    @Override
    public void newPdbxStrucAssembly(PdbxStructAssembly strucAssembly) {
        this.strucAssemblies.add(strucAssembly);
    }

    public List<PdbxStructAssembly> getStructAssemblies() {
        return this.strucAssemblies;
    }

    @Override
    public void newPdbxStrucAssemblyGen(PdbxStructAssemblyGen strucAssembly) {
        this.strucAssemblyGens.add(strucAssembly);
    }

    public List<PdbxStructAssemblyGen> getStructAssemblyGens() {
        return this.strucAssemblyGens;
    }

    @Override
    public void newChemCompAtom(ChemCompAtom atom) {
    }

    @Override
    public void newPdbxChemCompIndentifier(PdbxChemCompIdentifier id) {
    }

    @Override
    public void newChemCompBond(ChemCompBond bond) {
    }

    @Override
    public void newPdbxChemCompDescriptor(PdbxChemCompDescriptor desc) {
    }

    @Override
    public void newStructConn(StructConn structConn) {
        this.structConn.add(structConn);
    }

    @Override
    public void newStructSiteGen(StructSiteGen siteGen) {
        this.structSiteGens.add(siteGen);
    }

    @Override
    public void newStructSite(StructSite structSite) {
        if (this.params.isHeaderOnly()) {
            return;
        }
        List<Site> sites = this.structure.getSites();
        if (sites == null) {
            sites = new ArrayList<Site>();
        }
        Site site = null;
        for (Site asite : sites) {
            if (!asite.getSiteID().equals(structSite.getId())) continue;
            site = asite;
        }
        boolean addSite = false;
        if (site == null) {
            site = new Site();
            addSite = true;
        }
        site.setSiteID(structSite.getId());
        site.setDescription(structSite.getDetails());
        if (addSite) {
            sites.add(site);
        }
        this.structure.setSites(sites);
    }

    private void addSites() {
        List<Site> sites = this.structure.getSites();
        if (sites == null) {
            sites = new ArrayList<Site>();
        }
        for (StructSiteGen siteGen : this.structSiteGens) {
            List<Group> groups;
            String site_id = siteGen.getSite_id();
            if (site_id == null) {
                site_id = "";
            }
            String comp_id = siteGen.getLabel_comp_id();
            String asymId = siteGen.getLabel_asym_id();
            String authId = siteGen.getAuth_asym_id();
            String auth_seq_id = siteGen.getAuth_seq_id();
            String insCode = siteGen.getPdbx_auth_ins_code();
            if (insCode != null && insCode.equals("?")) {
                insCode = null;
            }
            Group g = null;
            try {
                Chain chain = this.structure.getChain(asymId);
                if (null != chain) {
                    try {
                        Character insChar = null;
                        if (null != insCode && insCode.length() > 0) {
                            insChar = Character.valueOf(insCode.charAt(0));
                        }
                        g = chain.getGroupByPDB(new ResidueNumber(null, Integer.parseInt(auth_seq_id), insChar));
                    }
                    catch (NumberFormatException e) {
                        logger.warn("Could not lookup residue : " + authId + auth_seq_id);
                    }
                }
            }
            catch (StructureException e) {
                logger.warn("Problem finding residue in site entry " + siteGen.getSite_id() + " - " + e.getMessage(), (Object)e.getMessage());
            }
            if (g == null) continue;
            Site site = null;
            for (Site asite : sites) {
                if (!site_id.equals(asite.getSiteID())) continue;
                site = asite;
            }
            boolean addSite = false;
            if (site == null) {
                addSite = true;
                site = new Site();
                site.setSiteID(site_id);
            }
            if ((groups = site.getGroups()) == null) {
                groups = new ArrayList<Group>();
            }
            if (!comp_id.equals(g.getPDBName())) {
                logger.warn("comp_id doesn't match the residue at " + authId + " " + auth_seq_id + " - skipping");
            } else {
                groups.add(g);
                site.setGroups(groups);
            }
            if (!addSite) continue;
            sites.add(site);
        }
        this.structure.setSites(sites);
    }
}

