/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cluster;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.cluster.Subunit;
import org.biojava.nbio.structure.cluster.SubunitCluster;
import org.biojava.nbio.structure.cluster.SubunitClustererMethod;
import org.biojava.nbio.structure.cluster.SubunitClustererParameters;
import org.biojava.nbio.structure.cluster.SubunitExtractor;
import org.biojava.nbio.structure.symmetry.core.Stoichiometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubunitClusterer {
    private static final Logger logger = LoggerFactory.getLogger(SubunitClusterer.class);

    private SubunitClusterer() {
    }

    public static Stoichiometry cluster(Structure structure, SubunitClustererParameters params) {
        List<Subunit> subunits = SubunitExtractor.extractSubunits(structure, params.getAbsoluteMinimumSequenceLength(), params.getMinimumSequenceLengthFraction(), params.getMinimumSequenceLength());
        return SubunitClusterer.cluster(subunits, params);
    }

    public static Stoichiometry cluster(List<Subunit> subunits, SubunitClustererParameters params) {
        ArrayList<SubunitCluster> clusters = new ArrayList<SubunitCluster>();
        if (subunits.size() == 0) {
            return new Stoichiometry(clusters);
        }
        for (Subunit s : subunits) {
            clusters.add(new SubunitCluster(s));
        }
        if (params.getClustererMethod() == SubunitClustererMethod.SEQUENCE || params.getClustererMethod() == SubunitClustererMethod.SEQUENCE_STRUCTURE) {
            for (int c1 = 0; c1 < clusters.size(); ++c1) {
                for (int c2 = clusters.size() - 1; c2 > c1; --c2) {
                    try {
                        if (params.isUseEntityIdForSeqIdentityDetermination() && ((SubunitCluster)clusters.get(c1)).mergeIdenticalByEntityId((SubunitCluster)clusters.get(c2))) {
                            clusters.remove(c2);
                            continue;
                        }
                        if (!((SubunitCluster)clusters.get(c1)).mergeSequence((SubunitCluster)clusters.get(c2), params)) continue;
                        clusters.remove(c2);
                        continue;
                    }
                    catch (CompoundNotFoundException e) {
                        logger.warn("Could not merge by Sequence. {}", (Object)e.getMessage());
                    }
                }
            }
        }
        if (params.getClustererMethod() == SubunitClustererMethod.STRUCTURE || params.getClustererMethod() == SubunitClustererMethod.SEQUENCE_STRUCTURE) {
            for (int c1 = 0; c1 < clusters.size(); ++c1) {
                for (int c2 = clusters.size() - 1; c2 > c1; --c2) {
                    try {
                        if (!((SubunitCluster)clusters.get(c1)).mergeStructure((SubunitCluster)clusters.get(c2), params)) continue;
                        clusters.remove(c2);
                        continue;
                    }
                    catch (StructureException e) {
                        logger.warn("Could not merge by Structure. {}", (Object)e.getMessage());
                    }
                }
            }
        }
        if (params.isInternalSymmetry()) {
            for (int c = 0; c < clusters.size(); ++c) {
                try {
                    ((SubunitCluster)clusters.get(c)).divideInternally(params);
                    continue;
                }
                catch (StructureException e) {
                    logger.warn("Error analyzing internal symmetry. {}", (Object)e.getMessage());
                }
            }
            for (int c1 = 0; c1 < clusters.size(); ++c1) {
                for (int c2 = clusters.size() - 1; c2 > c1; --c2) {
                    try {
                        if (!((SubunitCluster)clusters.get(c1)).mergeStructure((SubunitCluster)clusters.get(c2), params)) continue;
                        clusters.remove(c2);
                        continue;
                    }
                    catch (StructureException e) {
                        logger.warn("Could not merge by Structure. {}", (Object)e.getMessage());
                    }
                }
            }
        }
        return new Stoichiometry(clusters);
    }
}

