/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ws.hmmer;

import java.io.Serializable;
import java.util.SortedSet;
import org.biojava.nbio.ws.hmmer.HmmerDomain;

public class HmmerResult
implements Comparable<HmmerResult>,
Serializable {
    private static final long serialVersionUID = -6016026193090737943L;
    String desc;
    Float score;
    Float evalue;
    Double pvalue;
    String acc;
    Integer dcl;
    String name;
    Integer ndom;
    Integer nreported;
    SortedSet<HmmerDomain> domains;

    public SortedSet<HmmerDomain> getDomains() {
        return this.domains;
    }

    public void setDomains(SortedSet<HmmerDomain> domains) {
        this.domains = domains;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Float getScore() {
        return this.score;
    }

    public void setScore(Float score) {
        this.score = score;
    }

    public Float getEvalue() {
        return this.evalue;
    }

    public void setEvalue(Float evalue) {
        this.evalue = evalue;
    }

    public Double getPvalue() {
        return this.pvalue;
    }

    public void setPvalue(Double pvalue) {
        this.pvalue = pvalue;
    }

    public String getAcc() {
        return this.acc;
    }

    public void setAcc(String acc) {
        this.acc = acc;
    }

    public Integer getDcl() {
        return this.dcl;
    }

    public void setDcl(Integer dcl) {
        this.dcl = dcl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getNdom() {
        return this.ndom;
    }

    public void setNdom(Integer ndom) {
        this.ndom = ndom;
    }

    public Integer getNreported() {
        return this.nreported;
    }

    public void setNreported(Integer nreported) {
        this.nreported = nreported;
    }

    public String toString() {
        return "HmmerResult [acc=" + this.acc + ", desc=" + this.desc + ", score=" + this.score + ", evalue=" + this.evalue + ", pvalue=" + this.pvalue + ", dcl=" + this.dcl + ", name=" + this.name + ", ndom=" + this.ndom + ", nreported=" + this.nreported + ", domains=" + this.domains + "]";
    }

    @Override
    public int compareTo(HmmerResult o) {
        if (this.emptyDomains(this) && this.emptyDomains(o)) {
            return 0;
        }
        if (!this.emptyDomains(this) && this.emptyDomains(o)) {
            return -1;
        }
        if (this.emptyDomains(this) && !this.emptyDomains(o)) {
            return 1;
        }
        HmmerDomain me = this.getDomains().first();
        HmmerDomain other = o.getDomains().first();
        return me.getSqFrom().compareTo(other.getSqFrom());
    }

    private boolean emptyDomains(HmmerResult o) {
        return o.getDomains() == null || o.getDomains().size() == 0;
    }

    public int getOverlapLength(HmmerResult other) {
        int overlap = 0;
        for (HmmerDomain d1 : this.getDomains()) {
            for (HmmerDomain d2 : other.getDomains()) {
                overlap += this.getOverlap(d1, d2);
            }
        }
        return overlap;
    }

    private int getOverlap(HmmerDomain one, HmmerDomain other) {
        int xs = one.getSqFrom();
        int ys = one.getSqTo();
        int as = other.getSqFrom();
        int bs = other.getSqTo();
        int overlap = 0;
        if (xs < as && as < ys || xs < bs && bs <= ys || as < xs && ys < bs) {
            overlap = xs < as ? (ys < bs ? ys - as : bs - as) : (ys < bs ? ys - xs : bs - xs);
        }
        return overlap;
    }
}

