/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.booleans;

import java.util.Arrays;
import java.util.Iterator;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.booleans.BooleanExpression;
import org.sql.generation.api.grammar.booleans.BooleanTest;
import org.sql.generation.implementation.grammar.booleans.BooleanUtils;
import org.sql.generation.implementation.grammar.booleans.ComposedBooleanExpressionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanTestImpl
extends ComposedBooleanExpressionImpl<BooleanTest>
implements BooleanTest {
    private final BooleanExpression _booleanExpression;
    private final BooleanTest.TestType _testType;
    private final BooleanTest.TruthValue _truthValue;

    public BooleanTestImpl(BooleanExpression expression, BooleanTest.TestType testType, BooleanTest.TruthValue truthValue) {
        this(BooleanTest.class, expression, testType, truthValue);
    }

    protected BooleanTestImpl(Class<? extends BooleanTest> expressionClass, BooleanExpression expression, BooleanTest.TestType testType, BooleanTest.TruthValue truthValue) {
        super(expressionClass);
        NullArgumentException.validateNotNull((String)"expression", (Object)expression);
        if (BooleanUtils.isEmpty(expression).booleanValue()) {
            throw new IllegalArgumentException("Boolean test must be on something.");
        }
        this._booleanExpression = expression;
        this._testType = testType;
        this._truthValue = truthValue;
    }

    public BooleanExpression getBooleanExpression() {
        return this._booleanExpression;
    }

    public BooleanTest.TestType getTestType() {
        return this._testType;
    }

    public BooleanTest.TruthValue getTruthValue() {
        return this._truthValue;
    }

    public Iterator<BooleanExpression> iterator() {
        return Arrays.asList(this._booleanExpression).iterator();
    }
}

