/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Vector;
import javax.media.j3d.BHInsertStructure;
import javax.media.j3d.BHInternalNode;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.Locale;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderBin;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.UnorderList;
import javax.vecmath.Point4d;

class BHTree {
    Locale locale;
    private BHNode root;
    private BHInsertStructure insertStructure = null;
    Point4d tPoint4d = new Point4d();
    private boolean stable = false;
    int estMaxDepth;
    static final double LOG_OF_2 = Math.log(2.0);
    static final int DEPTH_UPPER_BOUND = 56;
    static final int INCR_DEPTH_BOUND = 5;
    int depthUpperBound = 56;

    BHTree() {
        this.locale = null;
        this.root = null;
    }

    BHTree(Locale loc) {
        this.locale = loc;
        this.root = null;
    }

    BHTree(BHNode[] bhArr) {
        this.locale = null;
        this.root = null;
        this.create(bhArr);
    }

    void setLocale(Locale loc) {
        this.locale = loc;
    }

    Locale getLocale() {
        return this.locale;
    }

    void cluster(BHInternalNode root, BHNode[] bhArr) {
        if (J3dDebug.doDebug(0, 4, "BHTree.java :In cluster length is " + bhArr.length + "\n")) {
            for (int i = 0; i < bhArr.length; ++i) {
                System.err.println(bhArr[i]);
            }
        }
        if (bhArr == null || bhArr.length < 2 || root == null) {
            J3dDebug.doDebug(0, 1, "BHTree.java : cluster : trouble! \n");
            return;
        }
        int[] centerValuesIndex = new int[bhArr.length];
        float[][] centerValues = this.computeCenterValues(bhArr, centerValuesIndex);
        this.constructTree(root, bhArr, centerValues, centerValuesIndex);
    }

    void boundsChanged(BHNode[] bhArr, int size) {
        this.markParentChain(bhArr, size);
        this.root.updateMarkedBoundingHull();
    }

    boolean getVisibleBHTrees(RenderBin rBin, ArrayList bhTrees, BoundingBox frustumBBox, long referenceTime, boolean stateChanged, int visibilityPolicy, boolean singleLocale) {
        if (frustumBBox != null && this.root != null) {
            boolean inSide = BHTree.aEncompassB(frustumBBox, this.root.bHull);
            if (singleLocale && !stateChanged && inSide && this.stable) {
                bhTrees.add(this.root);
                return true;
            }
            if (!stateChanged && inSide) {
                this.select(rBin, bhTrees, frustumBBox, this.root, referenceTime, visibilityPolicy, true);
                bhTrees.add(this.root);
                this.stable = true;
            } else {
                this.select(rBin, bhTrees, frustumBBox, this.root, referenceTime, visibilityPolicy, false);
                this.stable = false;
            }
        }
        return false;
    }

    private void select(RenderBin rBin, ArrayList bhTrees, BoundingBox frustumBBox, BHNode bh, long referenceTime, int visibilityPolicy, boolean inSide) {
        if (bh == null || bh.bHull.isEmpty()) {
            return;
        }
        switch (bh.nodeType) {
            case 2: {
                if (!(((BHLeafNode)bh).leafIF instanceof GeometryAtom) || !((BHLeafNode)bh).isEnable(visibilityPolicy) || !inSide && !frustumBBox.intersect(bh.bHull)) break;
                rBin.processGeometryAtom((GeometryAtom)((BHLeafNode)bh).leafIF, referenceTime);
                if (inSide) break;
                bhTrees.add(bh);
                break;
            }
            case 1: {
                if (inSide) {
                    this.select(rBin, bhTrees, frustumBBox, ((BHInternalNode)bh).getRightChild(), referenceTime, visibilityPolicy, true);
                    this.select(rBin, bhTrees, frustumBBox, ((BHInternalNode)bh).getLeftChild(), referenceTime, visibilityPolicy, true);
                    break;
                }
                if (BHTree.aEncompassB(frustumBBox, bh.bHull)) {
                    bhTrees.add(bh);
                    this.select(rBin, bhTrees, frustumBBox, ((BHInternalNode)bh).getRightChild(), referenceTime, visibilityPolicy, true);
                    this.select(rBin, bhTrees, frustumBBox, ((BHInternalNode)bh).getLeftChild(), referenceTime, visibilityPolicy, true);
                    break;
                }
                if (!frustumBBox.intersect(bh.bHull)) break;
                this.select(rBin, bhTrees, frustumBBox, ((BHInternalNode)bh).getRightChild(), referenceTime, visibilityPolicy, false);
                this.select(rBin, bhTrees, frustumBBox, ((BHInternalNode)bh).getLeftChild(), referenceTime, visibilityPolicy, false);
            }
        }
    }

    static boolean aEncompassB(BoundingBox aBox, BoundingBox bBox) {
        return aBox.upper.x >= bBox.upper.x && aBox.upper.y >= bBox.upper.y && aBox.upper.z >= bBox.upper.z && aBox.lower.x <= bBox.lower.x && aBox.lower.y <= bBox.lower.y && aBox.lower.z <= bBox.lower.z;
    }

    BHLeafInterface selectAny(GeometryAtom atom, int accurancyMode) {
        if (atom.source.geometryList == null) {
            return null;
        }
        BHNode bhNode = this.doSelectAny(atom, this.root, accurancyMode);
        if (bhNode == null) {
            return null;
        }
        return ((BHLeafNode)bhNode).leafIF;
    }

    BHLeafInterface selectAny(GeometryAtom[] atoms, int size, int accurancyMode) {
        BHNode bhNode = this.doSelectAny(atoms, size, this.root, accurancyMode);
        if (bhNode == null) {
            return null;
        }
        return ((BHLeafNode)bhNode).leafIF;
    }

    private BHNode doSelectAny(GeometryAtom[] atoms, int atomSize, BHNode bh, int accurancyMode) {
        if (bh == null || bh.bHull.isEmpty()) {
            return null;
        }
        switch (bh.nodeType) {
            case 2: {
                BHLeafInterface leaf = ((BHLeafNode)bh).leafIF;
                if (leaf instanceof GeometryAtom) {
                    GeometryAtom leafAtom = (GeometryAtom)leaf;
                    if (((BHLeafNode)bh).isEnable() && leafAtom.source.isCollidable) {
                        int i;
                        for (i = atomSize - 1; i >= 0; --i) {
                            if (atoms[i] != leafAtom) continue;
                            return null;
                        }
                        for (i = atomSize - 1; i >= 0; --i) {
                            GeometryAtom atom = atoms[i];
                            if (atom.source.sourceNode == leafAtom.source.sourceNode || !atom.source.collisionVwcBound.intersect(leafAtom.source.collisionVwcBound) || accurancyMode != 11 && (leafAtom.source.geometryList == null || !atom.source.intersectGeometryList(leafAtom.source))) continue;
                            return bh;
                        }
                    }
                } else if (leaf instanceof GroupRetained && ((BHLeafNode)bh).isEnable() && ((GroupRetained)leaf).sourceNode.collidable) {
                    for (int i = atomSize - 1; i >= 0; --i) {
                        GeometryAtom atom = atoms[i];
                        if (!atom.source.collisionVwcBound.intersect(bh.bHull) || accurancyMode != 11 && !atom.source.intersectGeometryList(atom.source.getCurrentLocalToVworld(0), bh.bHull)) continue;
                        return bh;
                    }
                }
                return null;
            }
            case 1: {
                for (int i = atomSize - 1; i >= 0; --i) {
                    GeometryAtom atom = atoms[i];
                    if (!atom.source.collisionVwcBound.intersect(bh.bHull)) continue;
                    BHNode hitNode = this.doSelectAny(atoms, atomSize, ((BHInternalNode)bh).getRightChild(), accurancyMode);
                    if (hitNode != null) {
                        return hitNode;
                    }
                    return this.doSelectAny(atoms, atomSize, ((BHInternalNode)bh).getLeftChild(), accurancyMode);
                }
                return null;
            }
        }
        return null;
    }

    private BHNode doSelectAny(GeometryAtom atom, BHNode bh, int accurancyMode) {
        if (bh == null || bh.bHull.isEmpty()) {
            return null;
        }
        switch (bh.nodeType) {
            case 2: {
                BHLeafInterface leaf = ((BHLeafNode)bh).leafIF;
                if (leaf instanceof GeometryAtom) {
                    GeometryAtom leafAtom = (GeometryAtom)leaf;
                    if (atom.source.sourceNode != leafAtom.source.sourceNode && ((BHLeafNode)bh).isEnable() && leafAtom.source.isCollidable && atom.source.collisionVwcBound.intersect(leafAtom.source.collisionVwcBound) && (accurancyMode == 11 || leafAtom.source.geometryList != null && atom.source.intersectGeometryList(leafAtom.source))) {
                        return bh;
                    }
                } else if (leaf instanceof GroupRetained && ((BHLeafNode)bh).isEnable() && ((GroupRetained)leaf).sourceNode.collidable && atom.source.collisionVwcBound.intersect(bh.bHull) && (accurancyMode == 11 || atom.source.intersectGeometryList(atom.source.getCurrentLocalToVworld(0), bh.bHull))) {
                    return bh;
                }
                return null;
            }
            case 1: {
                if (atom.source.collisionVwcBound.intersect(bh.bHull)) {
                    BHNode hitNode = this.doSelectAny(atom, ((BHInternalNode)bh).getRightChild(), accurancyMode);
                    if (hitNode != null) {
                        return hitNode;
                    }
                    return this.doSelectAny(atom, ((BHInternalNode)bh).getLeftChild(), accurancyMode);
                }
                return null;
            }
        }
        return null;
    }

    BHLeafInterface selectAny(Bounds bound, int accurancyMode, NodeRetained armingNode) {
        if (bound == null) {
            return null;
        }
        BHNode bhNode = this.doSelectAny(bound, this.root, accurancyMode, armingNode);
        if (bhNode == null) {
            return null;
        }
        return ((BHLeafNode)bhNode).leafIF;
    }

    private BHNode doSelectAny(Bounds bound, BHNode bh, int accurancyMode, NodeRetained armingNode) {
        if (bh == null || bh.bHull.isEmpty()) {
            return null;
        }
        switch (bh.nodeType) {
            case 2: {
                BHLeafInterface leaf = ((BHLeafNode)bh).leafIF;
                if (leaf instanceof GeometryAtom) {
                    GeometryAtom leafAtom = (GeometryAtom)leaf;
                    if (((BHLeafNode)bh).isEnable() && leafAtom.source.isCollidable && bound.intersect(leafAtom.source.collisionVwcBound) && (accurancyMode == 11 || leafAtom.source.geometryList != null && leafAtom.source.intersectGeometryList(leafAtom.source.getCurrentLocalToVworld(0), bound))) {
                        return bh;
                    }
                } else if (leaf instanceof GroupRetained && leaf != armingNode && ((BHLeafNode)bh).isEnable() && ((GroupRetained)leaf).sourceNode.collidable && bound.intersect(bh.bHull)) {
                    return bh;
                }
                return null;
            }
            case 1: {
                if (bound.intersect(bh.bHull)) {
                    BHNode hitNode = this.doSelectAny(bound, ((BHInternalNode)bh).getRightChild(), accurancyMode, armingNode);
                    if (hitNode != null) {
                        return hitNode;
                    }
                    return this.doSelectAny(bound, ((BHInternalNode)bh).getLeftChild(), accurancyMode, armingNode);
                }
                return null;
            }
        }
        return null;
    }

    BHLeafInterface selectAny(Bounds bound, int accurancyMode, GroupRetained armingGroup) {
        if (bound == null) {
            return null;
        }
        BHNode bhNode = this.doSelectAny(bound, this.root, accurancyMode, armingGroup);
        if (bhNode == null) {
            return null;
        }
        return ((BHLeafNode)bhNode).leafIF;
    }

    private BHNode doSelectAny(Bounds bound, BHNode bh, int accurancyMode, GroupRetained armingGroup) {
        if (bh == null || bh.bHull.isEmpty()) {
            return null;
        }
        switch (bh.nodeType) {
            case 2: {
                BHLeafInterface leaf = ((BHLeafNode)bh).leafIF;
                if (leaf instanceof GeometryAtom) {
                    GeometryAtom leafAtom = (GeometryAtom)leaf;
                    if (((BHLeafNode)bh).isEnable() && leafAtom.source.isCollidable && bound.intersect(leafAtom.source.collisionVwcBound) && !this.isDescendent(leafAtom.source.sourceNode, armingGroup, leafAtom.source.key) && (accurancyMode == 11 || leafAtom.source.geometryList != null && leafAtom.source.intersectGeometryList(leafAtom.source.getCurrentLocalToVworld(0), bound))) {
                        return bh;
                    }
                } else if (leaf instanceof GroupRetained) {
                    GroupRetained group = (GroupRetained)leaf;
                    if (((BHLeafNode)bh).isEnable() && group.sourceNode.collidable && bound.intersect(bh.bHull) && !this.isDescendent(group.sourceNode, armingGroup, group.key)) {
                        return bh;
                    }
                }
                return null;
            }
            case 1: {
                if (bound.intersect(bh.bHull)) {
                    BHNode hitNode = this.doSelectAny(bound, ((BHInternalNode)bh).getRightChild(), accurancyMode, armingGroup);
                    if (hitNode != null) {
                        return hitNode;
                    }
                    return this.doSelectAny(bound, ((BHInternalNode)bh).getLeftChild(), accurancyMode, armingGroup);
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDescendent(NodeRetained node, GroupRetained group, HashKey key) {
        Object object = group.universe.sceneGraphLock;
        synchronized (object) {
            if (node.inSharedGroup && key != null) {
                key = new HashKey(key);
            }
            do {
                if (node == group) {
                    return true;
                }
                if (!(node instanceof SharedGroupRetained)) continue;
                String nodeId = key.getLastNodeId();
                NodeRetained prevNode = node;
                Vector<NodeRetained> parents = ((SharedGroupRetained)node).parents;
                for (int i = parents.size() - 1; i >= 0; --i) {
                    NodeRetained link = parents.get(i);
                    if (!link.nodeId.equals(nodeId)) continue;
                    node = link;
                    break;
                }
                if (prevNode != node) continue;
                return true;
            } while ((node = node.parent) != null);
        }
        return false;
    }

    void select(PickShape pickShape, UnorderList hitArrList) {
        if (pickShape == null || this.root == null) {
            return;
        }
        this.doSelect(pickShape, hitArrList, this.root, this.tPoint4d);
    }

    private void doSelect(PickShape pickShape, UnorderList hitArrList, BHNode bh, Point4d pickPos) {
        if (bh == null || bh.bHull.isEmpty()) {
            return;
        }
        switch (bh.nodeType) {
            case 2: {
                if (!((BHLeafNode)bh).isEnable() || !(((BHLeafNode)bh).leafIF instanceof GeometryAtom) || !((GeometryAtom)((BHLeafNode)bh).leafIF).source.isPickable || !pickShape.intersect(bh.bHull, pickPos)) break;
                hitArrList.add(bh);
                break;
            }
            case 1: {
                if (!pickShape.intersect(bh.bHull, pickPos)) break;
                this.doSelect(pickShape, hitArrList, ((BHInternalNode)bh).getRightChild(), pickPos);
                this.doSelect(pickShape, hitArrList, ((BHInternalNode)bh).getLeftChild(), pickPos);
            }
        }
    }

    BHNode selectAny(PickShape pickShape) {
        if (pickShape == null || this.root == null) {
            return null;
        }
        return this.doSelectAny(pickShape, this.root, this.tPoint4d);
    }

    private BHNode doSelectAny(PickShape pickShape, BHNode bh, Point4d pickPos) {
        BHNode hitNode = null;
        if (bh == null || bh.bHull.isEmpty()) {
            return null;
        }
        switch (bh.nodeType) {
            case 2: {
                if (!((BHLeafNode)bh).isEnable() || !(((BHLeafNode)bh).leafIF instanceof GeometryAtom) || !((GeometryAtom)((BHLeafNode)bh).leafIF).source.isPickable || !pickShape.intersect(bh.bHull, pickPos)) break;
                return bh;
            }
            case 1: {
                if (!pickShape.intersect(bh.bHull, pickPos)) break;
                hitNode = this.doSelectAny(pickShape, ((BHInternalNode)bh).getRightChild(), pickPos);
                if (hitNode != null) {
                    return hitNode;
                }
                return this.doSelectAny(pickShape, ((BHInternalNode)bh).getLeftChild(), pickPos);
            }
        }
        return null;
    }

    private void create(BHNode[] bhArr) {
        if (bhArr == null) {
            this.root = null;
            return;
        }
        if (bhArr.length == 1) {
            bhArr[0].computeBoundingHull();
            this.root = bhArr[0];
            return;
        }
        int[] centerValuesIndex = new int[bhArr.length];
        float[][] centerValues = this.computeCenterValues(bhArr, centerValuesIndex);
        this.root = new BHInternalNode();
        this.constructTree((BHInternalNode)this.root, bhArr, centerValues, centerValuesIndex);
        if (J3dDebug.debug) {
            this.gatherTreeStatistics();
        }
    }

    void insert(BHNode[] bhArr, int size) {
        if (J3dDebug.debug) {
            J3dDebug.doDebug(0, 4, "BHTree.java : Insert - bhArr.length is " + bhArr.length + "\n");
        }
        if (bhArr == null || size < 1 || bhArr.length < 1) {
            return;
        }
        if (this.root == null) {
            J3dDebug.doDebug(0, 4, "BHTree.java : Tree has not be created yet.\n");
            BHNode[] newbhArr = new BHNode[size];
            System.arraycopy(bhArr, 0, newbhArr, 0, size);
            this.create(newbhArr);
            return;
        }
        if (this.root.nodeType == 2) {
            BHNode[] oldBhArr = bhArr;
            bhArr = new BHNode[size + 1];
            System.arraycopy(oldBhArr, 0, bhArr, 0, size);
            bhArr[size] = this.root;
            this.create(bhArr);
            return;
        }
        if (this.insertStructure == null) {
            this.insertStructure = new BHInsertStructure(size);
        } else {
            this.insertStructure.clear();
        }
        for (int i = 0; i < size; ++i) {
            if (this.root.isInside(bhArr[i].bHull)) {
                ((BHInternalNode)this.root).insert(bhArr[i], this.insertStructure);
                continue;
            }
            this.root.bHull.combine(bhArr[i].bHull);
            this.insertStructure.lookupAndInsert(this.root, bhArr[i]);
        }
        this.insertStructure.updateBoundingTree(this);
        this.insertStructure.clear();
        this.estMaxDepth += (int)(Math.log(size) / LOG_OF_2) + 1;
        if (this.estMaxDepth > this.depthUpperBound) {
            int maxDepth = this.root.computeMaxDepth(0);
            int leafCount = this.root.countNumberOfLeaves();
            double compDepth = Math.log(leafCount) / LOG_OF_2;
            if (maxDepth > this.depthUpperBound) {
                this.reConstructTree(leafCount);
                maxDepth = this.root.computeMaxDepth(0);
            }
            if (maxDepth > this.depthUpperBound) {
                this.depthUpperBound += 5;
            } else if (this.depthUpperBound != 56 && (double)maxDepth * 1.5 < (double)this.depthUpperBound) {
                this.depthUpperBound -= 5;
                if (this.depthUpperBound < 56) {
                    this.depthUpperBound = 56;
                }
            }
            this.estMaxDepth = maxDepth;
        }
    }

    private void markParentChain(BHNode[] nArr, int size) {
        for (int i = 0; i < size; ++i) {
            BHNode node = nArr[i];
            node.mark = true;
            while (node.parent != null && !node.parent.mark) {
                node = node.parent;
                node.mark = true;
            }
        }
    }

    private void markParentChain(BHNode node) {
        node.mark = true;
        while (node.parent != null && !node.parent.mark) {
            node = node.parent;
            node.mark = true;
        }
    }

    void delete(BHNode[] bhArr, int size) {
        for (int i = 0; i < size; ++i) {
            if (bhArr[i] != null && bhArr[i].nodeType == 2) {
                this.markParentChain(bhArr[i]);
                continue;
            }
            J3dDebug.doDebug(0, 1, "Warning, element " + i + " is null/not leaf node.\n" + "Error in deletion routine, element " + bhArr[i] + "\n" + "In tree = " + this + " can not delete it ...\n");
        }
        this.root = this.root.deleteAndUpdateMarkedNodes();
        if (this.root == null) {
            J3dDebug.doDebug(0, 4, "Tree has been completely deleted ...\n");
        }
    }

    float[][] computeCenterValues(BHNode[] bhArr, int[] cIndex) {
        float[][] centers = new float[bhArr.length][3];
        for (int i = 0; i < bhArr.length; ++i) {
            cIndex[i] = i;
            bhArr[i].computeBoundingHull();
            centers[i][0] = (float)(bhArr[i].bHull.upper.x + bhArr[i].bHull.lower.x) / 2.0f;
            centers[i][1] = (float)(bhArr[i].bHull.upper.y + bhArr[i].bHull.lower.y) / 2.0f;
            centers[i][2] = (float)(bhArr[i].bHull.upper.z + bhArr[i].bHull.lower.z) / 2.0f;
        }
        return centers;
    }

    void computeMeansAndSumSquares(float[][] centerValues, int[] centerValuesIndex, float[] means, float[] ss) {
        int i;
        float[] sumCenters = new float[3];
        float temp = 0.0f;
        int arrLen = centerValuesIndex.length;
        for (i = 2; i >= 0; --i) {
            sumCenters[i] = 0.0f;
            ss[i] = 0.0f;
        }
        for (i = arrLen - 1; i >= 0; --i) {
            sumCenters[0] = sumCenters[0] + centerValues[centerValuesIndex[i]][0];
            sumCenters[1] = sumCenters[1] + centerValues[centerValuesIndex[i]][1];
            sumCenters[2] = sumCenters[2] + centerValues[centerValuesIndex[i]][2];
        }
        means[0] = sumCenters[0] / (float)arrLen;
        means[1] = sumCenters[1] / (float)arrLen;
        means[2] = sumCenters[2] / (float)arrLen;
        for (i = arrLen - 1; i >= 0; --i) {
            temp = centerValues[centerValuesIndex[i]][0] - means[0];
            ss[0] = ss[0] + temp * temp;
            temp = centerValues[centerValuesIndex[i]][1] - means[1];
            ss[1] = ss[1] + temp * temp;
            temp = centerValues[centerValuesIndex[i]][2] - means[2];
            ss[2] = ss[2] + temp * temp;
        }
    }

    int findSplitAxis(float[] ss) {
        int splitAxis = -1;
        float maxSS = 0.0f;
        for (int i = 0; i < 3; ++i) {
            if (!(ss[i] > maxSS)) continue;
            maxSS = ss[i];
            splitAxis = i;
        }
        return splitAxis;
    }

    void constructTree(BHInternalNode parent, BHNode[] bhArr, float[][] centerValues, int[] centerValuesIndex) {
        int i;
        int rightSetCount = 0;
        int leftSetCount = 0;
        float[] means = new float[3];
        float[] ss = new float[3];
        if (bhArr.length <= 1) {
            J3dDebug.doDebug(0, 1, "constructTree - bhArr.length <= 1. Bad !!!\n");
        }
        this.computeMeansAndSumSquares(centerValues, centerValuesIndex, means, ss);
        int splitAxis = this.findSplitAxis(ss);
        boolean[] leftOrRightSet = new boolean[bhArr.length];
        if (splitAxis == -1) {
            for (i = 0; i < bhArr.length; ++i) {
                if (leftSetCount > rightSetCount) {
                    ++rightSetCount;
                    leftOrRightSet[i] = false;
                    continue;
                }
                ++leftSetCount;
                leftOrRightSet[i] = true;
            }
        } else {
            for (i = 0; i < bhArr.length; ++i) {
                if (centerValues[centerValuesIndex[i]][splitAxis] < means[splitAxis]) {
                    J3dDebug.doDebug(0, 4, "Found a left element\n");
                    ++leftSetCount;
                    leftOrRightSet[i] = true;
                    continue;
                }
                if (centerValues[centerValuesIndex[i]][splitAxis] > means[splitAxis]) {
                    J3dDebug.doDebug(0, 4, "Found a right element\n");
                    ++rightSetCount;
                    leftOrRightSet[i] = false;
                    continue;
                }
                J3dDebug.doDebug(0, 4, "Found an equal element\n");
                if (leftSetCount > rightSetCount) {
                    ++rightSetCount;
                    leftOrRightSet[i] = false;
                    continue;
                }
                ++leftSetCount;
                leftOrRightSet[i] = true;
            }
        }
        J3dDebug.doDebug(0, 2, "LeftSetCount " + leftSetCount + " RightSetCount " + rightSetCount + "\n");
        if (leftSetCount == bhArr.length) {
            J3dDebug.doDebug(0, 1, "Split Axis of = " + splitAxis + " didn't yield " + "any split among the objects ?\n");
            rightSetCount = 0;
            leftSetCount = 0;
            for (i = 0; i < bhArr.length; ++i) {
                if (leftSetCount > rightSetCount) {
                    ++rightSetCount;
                    leftOrRightSet[i] = false;
                    continue;
                }
                ++leftSetCount;
                leftOrRightSet[i] = true;
            }
        } else if (rightSetCount == bhArr.length) {
            J3dDebug.doDebug(0, 1, "Split Axis of = " + splitAxis + " didn't yield " + "any split among the objects ?\n");
            rightSetCount = 0;
            leftSetCount = 0;
            for (i = 0; i < bhArr.length; ++i) {
                if (leftSetCount > rightSetCount) {
                    ++rightSetCount;
                    leftOrRightSet[i] = false;
                    continue;
                }
                ++leftSetCount;
                leftOrRightSet[i] = true;
            }
        }
        if (J3dDebug.doDebug(0, 4) && bhArr.length != rightSetCount + leftSetCount) {
            System.err.println("An error has occurred in spliting");
        }
        BHNode[] rightSet = new BHNode[rightSetCount];
        BHNode[] leftSet = new BHNode[leftSetCount];
        int[] centerValuesIndexR = new int[rightSetCount];
        int[] centerValuesIndexL = new int[leftSetCount];
        rightSetCount = 0;
        leftSetCount = 0;
        for (i = 0; i < bhArr.length; ++i) {
            if (leftOrRightSet[i]) {
                leftSet[leftSetCount] = bhArr[i];
                centerValuesIndexL[leftSetCount] = centerValuesIndex[i];
                ++leftSetCount;
                continue;
            }
            rightSet[rightSetCount] = bhArr[i];
            centerValuesIndexR[rightSetCount] = centerValuesIndex[i];
            ++rightSetCount;
        }
        if (rightSet.length != 1) {
            parent.rChild = new BHInternalNode();
            parent.rChild.setParent(parent);
            this.constructTree((BHInternalNode)parent.rChild, rightSet, centerValues, centerValuesIndexR);
        } else {
            parent.rChild = rightSet[0];
            parent.rChild.setParent(parent);
        }
        if (leftSet.length != 1) {
            parent.lChild = new BHInternalNode();
            parent.lChild.setParent(parent);
            this.constructTree((BHInternalNode)parent.lChild, leftSet, centerValues, centerValuesIndexL);
        } else {
            parent.lChild = leftSet[0];
            parent.lChild.setParent(parent);
        }
        parent.combineBHull(parent.rChild, parent.lChild);
    }

    void reConstructTree(int numOfLeaf) {
        if (this.root == null) {
            return;
        }
        BHNode[] bhArr = new BHNode[numOfLeaf];
        int[] index = new int[]{0};
        this.root.destroyTree(bhArr, index);
        this.create(bhArr);
    }

    void gatherTreeStatistics() {
        int leafCount = this.root.countNumberOfLeaves();
        int internalCount = this.root.countNumberOfInternals();
        int maxDepth = this.root.computeMaxDepth(0);
        float averageDepth = this.root.computeAverageLeafDepth(leafCount, 0);
        System.err.println("Statistics for tree = " + this);
        System.err.println("Total Number of nodes in tree = " + (leafCount + internalCount));
        System.err.println("Number of Leaf Nodes = " + leafCount);
        System.err.println("Number of Internal Nodes = " + internalCount);
        System.err.println("Maximum Leaf depth = " + maxDepth);
        System.err.println("Average Leaf depth = " + averageDepth);
        System.err.println("root.bHull = " + this.root.bHull);
    }

    void printTree(BHNode bh) {
        if (bh != null) {
            if (bh.nodeType == 1) {
                System.err.println("BH_TYPE_INTERNAL - bHull : " + bh);
                System.err.println(bh.bHull);
                System.err.println("rChild : " + ((BHInternalNode)bh).rChild + " lChild : " + ((BHInternalNode)bh).lChild);
                this.printTree(((BHInternalNode)bh).rChild);
                this.printTree(((BHInternalNode)bh).lChild);
            } else if (bh.nodeType == 2) {
                System.err.println("BH_TYPE_LEAF - bHull : " + bh);
                System.err.println(bh.bHull);
            }
        }
    }
}

