/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;

public class Background
extends Leaf {
    public static final int ALLOW_APPLICATION_BOUNDS_READ = 12;
    public static final int ALLOW_APPLICATION_BOUNDS_WRITE = 13;
    public static final int ALLOW_IMAGE_READ = 14;
    public static final int ALLOW_IMAGE_WRITE = 15;
    public static final int ALLOW_COLOR_READ = 16;
    public static final int ALLOW_COLOR_WRITE = 17;
    public static final int ALLOW_GEOMETRY_READ = 18;
    public static final int ALLOW_GEOMETRY_WRITE = 19;
    public static final int ALLOW_IMAGE_SCALE_MODE_READ = 20;
    public static final int ALLOW_IMAGE_SCALE_MODE_WRITE = 21;
    public static final int SCALE_NONE = 0;
    public static final int SCALE_FIT_MIN = 1;
    public static final int SCALE_FIT_MAX = 2;
    public static final int SCALE_FIT_ALL = 3;
    public static final int SCALE_REPEAT = 4;
    public static final int SCALE_NONE_CENTER = 5;
    private static final int[] readCapabilities = new int[]{12, 16, 18, 14, 20};

    public Background() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Background(Color3f color) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((BackgroundRetained)this.retained).setColor(color);
    }

    public Background(float r, float g, float b) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((BackgroundRetained)this.retained).setColor(r, g, b);
    }

    public Background(ImageComponent2D image) {
        this.setDefaultReadCapabilities(readCapabilities);
        if (image != null && image.getImageClass() == ImageComponent.ImageClass.NIO_IMAGE_BUFFER) {
            throw new IllegalArgumentException(J3dI18N.getString("Background14"));
        }
        ((BackgroundRetained)this.retained).setImage(image);
    }

    public Background(BranchGroup branch) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((BackgroundRetained)this.retained).setGeometry(branch);
    }

    public void setColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background0"));
        }
        if (this.isLive()) {
            ((BackgroundRetained)this.retained).setColor(color);
        } else {
            ((BackgroundRetained)this.retained).initColor(color);
        }
    }

    public void setColor(float r, float g, float b) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background0"));
        }
        if (this.isLive()) {
            ((BackgroundRetained)this.retained).setColor(r, g, b);
        } else {
            ((BackgroundRetained)this.retained).initColor(r, g, b);
        }
    }

    public void getColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background2"));
        }
        ((BackgroundRetained)this.retained).getColor(color);
    }

    public void setImage(ImageComponent2D image) {
        ImageComponent2DRetained imageRetained;
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background3"));
        }
        BackgroundRetained bgRetained = (BackgroundRetained)this.retained;
        if (image != null && image.getImageClass() == ImageComponent.ImageClass.NIO_IMAGE_BUFFER) {
            throw new IllegalArgumentException(J3dI18N.getString("Background14"));
        }
        if (image != null && (imageRetained = (ImageComponent2DRetained)image.retained).getUsedByOffScreen()) {
            if (this.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("Background12"));
            }
            if (bgRetained.getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("Background13"));
            }
        }
        if (this.isLive()) {
            bgRetained.setImage(image);
        } else {
            bgRetained.initImage(image);
        }
    }

    public ImageComponent2D getImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background4"));
        }
        return ((BackgroundRetained)this.retained).getImage();
    }

    public void setImageScaleMode(int imageScaleMode) {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background9"));
        }
        switch (imageScaleMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Background11"));
            }
        }
        if (this.isLive()) {
            ((BackgroundRetained)this.retained).setImageScaleMode(imageScaleMode);
        } else {
            ((BackgroundRetained)this.retained).initImageScaleMode(imageScaleMode);
        }
    }

    public int getImageScaleMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background10"));
        }
        return ((BackgroundRetained)this.retained).getImageScaleMode();
    }

    public void setGeometry(BranchGroup branch) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background5"));
        }
        if (this.isLive()) {
            ((BackgroundRetained)this.retained).setGeometry(branch);
        } else {
            ((BackgroundRetained)this.retained).initGeometry(branch);
        }
    }

    public BranchGroup getGeometry() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background6"));
        }
        return ((BackgroundRetained)this.retained).getGeometry();
    }

    public void setApplicationBounds(Bounds region) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background7"));
        }
        if (this.isLive()) {
            ((BackgroundRetained)this.retained).setApplicationBounds(region);
        } else {
            ((BackgroundRetained)this.retained).initApplicationBounds(region);
        }
    }

    public Bounds getApplicationBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background8"));
        }
        return ((BackgroundRetained)this.retained).getApplicationBounds();
    }

    public void setApplicationBoundingLeaf(BoundingLeaf region) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background7"));
        }
        if (this.isLive()) {
            ((BackgroundRetained)this.retained).setApplicationBoundingLeaf(region);
        } else {
            ((BackgroundRetained)this.retained).initApplicationBoundingLeaf(region);
        }
    }

    public BoundingLeaf getApplicationBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Background8"));
        }
        return ((BackgroundRetained)this.retained).getApplicationBoundingLeaf();
    }

    @Override
    void createRetained() {
        this.retained = new BackgroundRetained();
        this.retained.setSource(this);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        Background b = new Background();
        b.duplicateNode(this, forceDuplicate);
        return b;
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        this.checkDuplicateNode(originalNode, forceDuplicate);
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        BackgroundRetained attr = (BackgroundRetained)originalNode.retained;
        BackgroundRetained rt = (BackgroundRetained)this.retained;
        Color3f c = new Color3f();
        attr.getColor(c);
        rt.initColor(c);
        rt.initApplicationBounds(attr.getApplicationBounds());
        rt.initGeometry(attr.getGeometry());
        rt.initGeometry((BranchGroup)(attr.getGeometry() == null ? null : attr.getGeometry().cloneTree(true)));
        rt.initImage((ImageComponent2D)this.getNodeComponent(attr.getImage(), forceDuplicate, originalNode.nodeHashtable));
        rt.initApplicationBoundingLeaf(attr.getApplicationBoundingLeaf());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        super.updateNodeReferences(referenceTable);
        BackgroundRetained rt = (BackgroundRetained)this.retained;
        BoundingLeaf bl = rt.getApplicationBoundingLeaf();
        if (bl != null) {
            SceneGraphObject o = referenceTable.getNewObjectReference(bl);
            rt.initApplicationBoundingLeaf((BoundingLeaf)o);
        }
    }
}

