/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSceneGraphException;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.OrderedPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture2DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

class BackgroundRetained
extends LeafRetained {
    static final int COLOR_CHANGED = 1;
    static final int IMAGE_CHANGED = 2;
    static final int GEOMETRY_CHANGED = 4;
    static final int BOUNDS_CHANGED = 8;
    static final int BOUNDINGLEAF_CHANGED = 16;
    static final int IMAGE_SCALE_CHANGED = 32;
    Color3f color = new Color3f(0.0f, 0.0f, 0.0f);
    ImageComponent2DRetained image = null;
    Texture2DRetained texture = null;
    int imageScaleMode = 0;
    Bounds applicationRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    BranchGroup geometryBranch = null;
    Bounds transformedRegion = null;
    SetLiveState setLiveState = null;
    Locale cachedLocale = null;
    boolean inImmCtx = false;
    ArrayList<LightRetained> lights = new ArrayList();
    ArrayList<FogRetained> fogs = new ArrayList();
    ArrayList<GeometryAtom> bgGeometryAtomList = new ArrayList();
    boolean bgGeometryAtomListDirty = true;
    GeometryAtom[] bgGeometryAtoms = null;
    static final int targetThreads = 4224;
    boolean isViewScoped = false;

    BackgroundRetained() {
        this.nodeType = 1;
        this.localBounds = new BoundingBox((Bounds)null);
    }

    final void initColor(Color3f color) {
        this.color.set((Tuple3f)color);
    }

    final void setColor(Color3f color) {
        this.initColor(color);
        if (this.source.isLive()) {
            this.sendMessage(1, new Color3f(color));
        }
    }

    final void initColor(float r, float g, float b) {
        this.color.x = r;
        this.color.y = g;
        this.color.z = b;
    }

    final void setColor(float r, float g, float b) {
        this.setColor(new Color3f(r, g, b));
    }

    final void getColor(Color3f color) {
        color.set((Tuple3f)this.color);
    }

    final void initImageScaleMode(int imageScaleMode) {
        this.imageScaleMode = imageScaleMode;
    }

    final void setImageScaleMode(int imageScaleMode) {
        this.initImageScaleMode(imageScaleMode);
        if (this.source.isLive()) {
            this.sendMessage(32, new Integer(imageScaleMode));
        }
    }

    final int getImageScaleMode() {
        return this.imageScaleMode;
    }

    final void initImage(ImageComponent2D img) {
        if (img == null) {
            this.image = null;
            this.texture = null;
            return;
        }
        if (img.retained != this.image) {
            int texFormat;
            this.image = (ImageComponent2DRetained)img.retained;
            this.image.setEnforceNonPowerOfTwoSupport(true);
            switch (this.image.getNumberOfComponents()) {
                case 1: {
                    texFormat = 1;
                    break;
                }
                case 2: {
                    texFormat = 4;
                    break;
                }
                case 3: {
                    texFormat = 5;
                    break;
                }
                case 4: {
                    texFormat = 6;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            Texture2D tex2D = new Texture2D(1, texFormat, img.getWidth(), img.getHeight());
            this.texture = (Texture2DRetained)tex2D.retained;
            this.texture.setUseAsRaster(true);
            this.image.addUser(this.texture);
            this.texture.initImage(0, img);
        }
    }

    final void setImage(ImageComponent2D img) {
        if (this.source.isLive() && this.texture != null) {
            this.texture.clearLive(this.refCount);
        }
        this.initImage(img);
        if (this.source.isLive()) {
            if (this.texture != null) {
                this.texture.setLive(this.inBackgroundGroup, this.refCount);
            }
            this.sendMessage(2, this.texture != null ? this.texture.mirror : null);
        }
    }

    final ImageComponent2D getImage() {
        return this.image == null ? null : (ImageComponent2D)this.image.source;
    }

    final void initGeometry(BranchGroup branch) {
        this.geometryBranch = branch;
    }

    final void setGeometry(BranchGroup branch) {
        int numMessages = 0;
        if (this.source.isLive()) {
            int i;
            if (this.geometryBranch != null) {
                numMessages += 2;
            }
            if (branch != null) {
                numMessages += 2;
            }
            J3dMessage[] m = new J3dMessage[numMessages];
            for (i = 0; i < numMessages; ++i) {
                m[i] = new J3dMessage();
            }
            i = 0;
            if (this.geometryBranch != null) {
                this.clearGeometryBranch((BranchGroupRetained)this.geometryBranch.retained);
                m[i].threads = 4224;
                m[i].type = 33;
                m[i].universe = this.universe;
                m[i].args[0] = this.setLiveState.ogList.toArray();
                m[i].args[1] = this.setLiveState.ogChildIdList.toArray();
                m[i].args[3] = this.setLiveState.ogCIOList.toArray();
                m[i].args[4] = this.setLiveState.ogCIOTableList.toArray();
                m[++i].threads = this.setLiveState.notifyThreads;
                m[i].type = 1;
                m[i].universe = this.universe;
                m[i].args[0] = this.setLiveState.nodeList.toArray();
                ++i;
            }
            if (branch != null) {
                this.setGeometryBranch((BranchGroupRetained)branch.retained);
                m[i].threads = 4224;
                m[i].type = 32;
                m[i].universe = this.universe;
                m[i].args[0] = this.setLiveState.ogList.toArray();
                m[i].args[1] = this.setLiveState.ogChildIdList.toArray();
                m[i].args[2] = this.setLiveState.ogOrderedIdList.toArray();
                m[i].args[3] = this.setLiveState.ogCIOList.toArray();
                m[i].args[4] = this.setLiveState.ogCIOTableList.toArray();
                m[++i].threads = this.setLiveState.notifyThreads;
                m[i].type = 0;
                m[i].universe = this.universe;
                m[i].args[0] = this.setLiveState.nodeList.toArray();
            }
            VirtualUniverse.mc.processMessage(m);
            this.setLiveState.reset(null);
        }
        this.initGeometry(branch);
    }

    final BranchGroup getGeometry() {
        return this.geometryBranch;
    }

    final void initApplicationBounds(Bounds region) {
        this.applicationRegion = region != null ? (Bounds)region.clone() : null;
    }

    final void setApplicationBounds(Bounds region) {
        this.initApplicationBounds(region);
        if (this.boundingLeaf == null) {
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 4224;
            createMessage.type = 20;
            createMessage.universe = this.universe;
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(8);
            createMessage.args[2] = region != null ? region.clone() : null;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    final Bounds getApplicationBounds() {
        return this.applicationRegion != null ? (Bounds)this.applicationRegion.clone() : null;
    }

    void initApplicationBoundingLeaf(BoundingLeaf region) {
        this.boundingLeaf = region != null ? (BoundingLeafRetained)region.retained : null;
    }

    void setApplicationBoundingLeaf(BoundingLeaf region) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
        if (region != null) {
            this.boundingLeaf = (BoundingLeafRetained)region.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
        } else {
            this.boundingLeaf = null;
        }
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.type = 20;
        createMessage.universe = this.universe;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(16);
        if (this.boundingLeaf != null) {
            createMessage.args[2] = this.boundingLeaf.mirrorBoundingLeaf;
            createMessage.args[3] = null;
        } else {
            createMessage.args[2] = null;
            createMessage.args[3] = this.applicationRegion != null ? this.applicationRegion.clone() : null;
        }
        VirtualUniverse.mc.processMessage(createMessage);
    }

    BoundingLeaf getApplicationBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    void setInImmCtx(boolean inCtx) {
        this.inImmCtx = inCtx;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    void setGeometryBranch(BranchGroupRetained branch) {
        this.setLiveState.reset(this.locale);
        this.setLiveState.inBackgroundGroup = true;
        this.setLiveState.geometryBackground = this;
        this.setLiveState.currentTransforms[0] = new Transform3D[2];
        this.setLiveState.currentTransforms[0][0] = new Transform3D();
        this.setLiveState.currentTransforms[0][1] = new Transform3D();
        this.setLiveState.currentTransformsIndex[0] = new int[2];
        this.setLiveState.currentTransformsIndex[0][0] = 0;
        this.setLiveState.currentTransformsIndex[0][1] = 0;
        this.setLiveState.localToVworld = this.setLiveState.currentTransforms;
        this.setLiveState.localToVworldIndex = this.setLiveState.currentTransformsIndex;
        this.setLiveState.branchGroupPaths = new ArrayList();
        this.setLiveState.branchGroupPaths.add(new BranchGroupRetained[0]);
        this.setLiveState.orderedPaths = new ArrayList(1);
        this.setLiveState.orderedPaths.add(new OrderedPath());
        this.setLiveState.switchStates = new ArrayList(1);
        this.setLiveState.switchStates.add(new SwitchState(false));
        branch.setLive(this.setLiveState);
    }

    void clearGeometryBranch(BranchGroupRetained branch) {
        this.setLiveState.reset(this.locale);
        this.setLiveState.inBackgroundGroup = true;
        this.setLiveState.geometryBackground = this;
        branch.clearLive(this.setLiveState);
        branch.setParent(null);
        branch.setLocale(null);
    }

    @Override
    void setLive(SetLiveState s) {
        super.doSetLive(s);
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained1"));
        }
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("BackgroundRetained5"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained6"));
        }
        if (this.geometryBranch != null) {
            BranchGroupRetained branch = (BranchGroupRetained)this.geometryBranch.retained;
            if (branch.inBackgroundGroup) {
                throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained0"));
            }
            if (branch.parent != null) {
                throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained3"));
            }
            if (branch.locale != null) {
                throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained4"));
            }
            if (this.setLiveState == null) {
                this.setLiveState = new SetLiveState(this.universe);
                this.setLiveState.universe = this.universe;
            }
            this.setGeometryBranch((BranchGroupRetained)this.geometryBranch.retained);
            s.nodeList.addAll(this.setLiveState.nodeList);
            s.notifyThreads |= this.setLiveState.notifyThreads;
            s.ogList.addAll(this.setLiveState.ogList);
            s.ogChildIdList.addAll(this.setLiveState.ogChildIdList);
            s.ogOrderedIdList.addAll(this.setLiveState.ogOrderedIdList);
            this.setLiveState.reset(null);
        }
        if (s.viewScopedNodeList != null && s.viewLists != null) {
            s.viewScopedNodeList.add(this);
            s.scopedNodesViewList.add(s.viewLists.get(0));
        } else {
            s.nodeList.add(this);
        }
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this, 1);
        }
        this.switchState = s.switchStates.get(0);
        if (this.boundingLeaf != null) {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            this.transformedRegion.transform(this.applicationRegion, this.getLastLocalToVworld());
        } else {
            this.transformedRegion = null;
        }
        this.cachedLocale = s.locale;
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this, 1);
            s.notifyThreads |= 0x2000;
        }
        s.notifyThreads |= 0x1080;
        if (this.texture != null) {
            this.texture.setLive(this.inBackgroundGroup, this.refCount);
        }
        super.markAsLive();
    }

    @Override
    void clearLive(SetLiveState s) {
        super.clearLive(s);
        if (s.viewScopedNodeList != null && s.viewLists != null) {
            s.viewScopedNodeList.add(this);
            s.scopedNodesViewList.add(s.viewLists.get(0));
        } else {
            s.nodeList.add(this);
        }
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this, 1);
            s.notifyThreads |= 0x2000;
        }
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this, 1);
        }
        if (this.geometryBranch != null) {
            BranchGroupRetained branch = (BranchGroupRetained)this.geometryBranch.retained;
            this.clearGeometryBranch(branch);
            s.nodeList.addAll(this.setLiveState.nodeList);
            s.ogList.addAll(this.setLiveState.ogList);
            s.ogChildIdList.addAll(this.setLiveState.ogChildIdList);
            s.notifyThreads |= this.setLiveState.notifyThreads;
            this.setLiveState.reset(null);
            this.lights.clear();
            this.fogs.clear();
        }
        if (this.texture != null) {
            this.texture.clearLive(this.refCount);
        }
        s.notifyThreads |= 0x1080;
    }

    synchronized void updateImmediateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        if ((component & 8) != 0) {
            if (objs[2] != null) {
                this.transformedRegion = ((Bounds)objs[2]).copy(this.transformedRegion);
                this.transformedRegion.transform((Bounds)objs[2], this.getCurrentLocalToVworld());
            } else {
                this.transformedRegion = null;
            }
        } else if ((component & 0x10) != 0) {
            if (objs[2] != null) {
                this.transformedRegion = ((BoundingLeafRetained)objs[2]).transformedRegion;
            } else {
                Bounds appRegion = (Bounds)objs[3];
                if (appRegion != null) {
                    this.transformedRegion = appRegion.copy(this.transformedRegion);
                    this.transformedRegion.transform(appRegion, this.getCurrentLocalToVworld());
                } else {
                    this.transformedRegion = null;
                }
            }
        }
    }

    @Override
    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.mirrorBoundingLeaf.switchState.currentSwitchOn) {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = this.applicationRegion.copy(this.transformedRegion);
            this.transformedRegion.transform(this.applicationRegion, this.getCurrentLocalToVworld());
        } else {
            this.transformedRegion = null;
        }
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.applicationRegion != null) {
            this.transformedRegion = this.applicationRegion.copy(this.transformedRegion);
            this.transformedRegion.transform(this.applicationRegion, this.getCurrentLocalToVworld());
        }
    }

    final void sendMessage(int attrMask, Object attr) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.universe = this.universe;
        createMessage.type = 20;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    void addBgGeometryAtomList(GeometryAtom geomAtom) {
        this.bgGeometryAtomList.add(geomAtom);
        this.bgGeometryAtomListDirty = true;
    }

    void removeBgGeometryAtomList(GeometryAtom geomAtom) {
        this.bgGeometryAtomList.remove(geomAtom);
        this.bgGeometryAtomListDirty = true;
    }

    GeometryAtom[] getBackgroundGeometryAtoms() {
        if (this.bgGeometryAtomListDirty) {
            int nAtoms = this.bgGeometryAtomList.size();
            if (nAtoms == 0) {
                this.bgGeometryAtoms = null;
            } else {
                this.bgGeometryAtoms = this.bgGeometryAtomList.toArray(new GeometryAtom[nAtoms]);
                this.bgGeometryAtomListDirty = false;
            }
        }
        return this.bgGeometryAtoms;
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        if (this.applicationRegion != null) {
            this.applicationRegion.transform(xform.transform);
        }
    }

    void notifyImageComponentImageChanged(ImageComponentRetained image, ImageComponentUpdateInfo value) {
    }

    @Override
    void getMirrorObjects(ArrayList leafList, HashKey key) {
        leafList.add(this);
    }
}

