/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.logging.Level;
import javax.media.j3d.Behavior;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.IndexedUnorderSet;
import javax.media.j3d.J3dClock;
import javax.media.j3d.J3dThread;
import javax.media.j3d.MasterControl;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriteriaEnumerator;

class BehaviorScheduler
extends J3dThread {
    VirtualUniverse univ = null;
    UnorderList[] processList;
    IndexedUnorderSet scheduleList;
    BehaviorStructure behaviorStructure;
    int stopCount = -1;
    long lastStartTime;
    long lastStopTime;
    Object intervalTimeLock = new Object();
    private static int numInstances = 0;
    private int instanceNum = -1;

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    @Override
    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    BehaviorScheduler(ThreadGroup t, VirtualUniverse universe) {
        super(t);
        this.setName("J3D-BehaviorScheduler-" + this.getInstanceNum());
        this.univ = universe;
        this.behaviorStructure = universe.behaviorStructure;
        this.scheduleList = this.behaviorStructure.scheduleList;
        this.processList = this.behaviorStructure.processList;
        this.type = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopBehaviorScheduler(long[] intervalTime) {
        this.stopCount = 2;
        VirtualUniverse.mc.sendRunMessage(this.univ, 1);
        while (!this.userStop) {
            MasterControl.threadYield();
        }
        Object object = this.intervalTimeLock;
        synchronized (object) {
            intervalTime[0] = this.lastStartTime;
            intervalTime[1] = this.lastStopTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startBehaviorScheduler() {
        Object object = this.intervalTimeLock;
        synchronized (object) {
            this.stopCount = -1;
            this.userStop = false;
            VirtualUniverse.mc.setWork();
        }
    }

    void deactivate() {
        this.active = false;
        if (this.stopCount >= 0) {
            this.userStop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doWork(long referenceTime) {
        this.lastStartTime = J3dClock.currentTimeMillis();
        if (this.stopCount >= 0) {
            VirtualUniverse.mc.sendRunMessage(this.univ, 1);
            if (--this.stopCount == 0) {
                this.userStop = true;
            }
        }
        for (int interval = 0; interval < 10; ++interval) {
            UnorderList list = this.processList[interval];
            if (list.isEmpty()) continue;
            BehaviorRetained[] arr = (BehaviorRetained[])list.toArray(false);
            int size = list.arraySize();
            for (int i = 0; i < size; ++i) {
                BehaviorRetained behavret;
                BehaviorRetained behaviorRetained = behavret = arr[i];
                synchronized (behaviorRetained) {
                    Behavior behav = (Behavior)behavret.source;
                    if (!behav.isLive() || !behavret.conditionSet || behavret.wakeupCondition == null) {
                        continue;
                    }
                    if (behavret.wakeupCondition.trigEnum == null) {
                        behavret.wakeupCondition.trigEnum = new WakeupCriteriaEnumerator(behavret.wakeupCondition, 1);
                    } else {
                        behavret.wakeupCondition.trigEnum.reset(behavret.wakeupCondition, 1);
                    }
                    behavret.conditionSet = false;
                    WakeupCondition wakeupCond = behavret.wakeupCondition;
                    BehaviorRetained behaviorRetained2 = behavret;
                    synchronized (behaviorRetained2) {
                        behavret.inCallback = true;
                        this.univ.inBehavior = true;
                        try {
                            behav.processStimulus(wakeupCond.trigEnum);
                        }
                        catch (RuntimeException e) {
                            behavret.conditionSet = false;
                            System.err.println("Exception occurred during Behavior execution:");
                            e.printStackTrace();
                        }
                        catch (Error e) {
                            behavret.conditionSet = false;
                            System.err.println("Error occurred during Behavior execution:");
                            e.printStackTrace();
                        }
                        this.univ.inBehavior = false;
                        behavret.inCallback = false;
                    }
                    if (!behavret.conditionSet) {
                        if (wakeupCond != null) {
                            wakeupCond.cleanTree(this.behaviorStructure);
                        }
                        behavret.wakeupCondition = null;
                        behavret.active = false;
                        this.scheduleList.remove(behavret);
                    } else {
                        behavret.handleLastWakeupOn(wakeupCond, this.behaviorStructure);
                    }
                    continue;
                }
            }
            list.clear();
        }
        this.behaviorStructure.handleAWTEvent();
        this.behaviorStructure.handleBehaviorPost();
        this.lastStopTime = J3dClock.currentTimeMillis();
        if (MasterControl.isStatsLoggable(Level.FINE)) {
            VirtualUniverse.mc.recordTime(MasterControl.TimeType.BEHAVIOR, (this.lastStopTime - this.lastStartTime) * 1000000L);
        }
    }

    void free() {
        this.behaviorStructure = null;
        this.getThreadData(null, null).thread = null;
        this.univ = null;
        for (int i = 9; i >= 0; --i) {
            this.processList[i].clear();
        }
        this.scheduleList.clear();
    }
}

