/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Canvas3D;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.RenderMethod;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;

class DisplayListRenderMethod
implements RenderMethod {
    final int bufferSize = 128;
    int[] buffer = new int[128];

    DisplayListRenderMethod() {
    }

    @Override
    public boolean render(RenderMolecule rm, Canvas3D cv, RenderAtomListInfo ra, int dirtyBits) {
        if (rm.doInfinite || !VirtualUniverse.mc.viewFrustumCulling || rm.vwcBounds.intersect(cv.viewFrustum)) {
            cv.updateState(dirtyBits);
            cv.callDisplayList(cv.ctx, rm.displayListId, rm.isNonUniformScale);
            return true;
        }
        return false;
    }

    public boolean renderSeparateDlists(RenderMolecule rm, Canvas3D cv, RenderAtomListInfo r, int dirtyBits) {
        if (rm.doInfinite) {
            cv.updateState(dirtyBits);
            while (r != null) {
                cv.callDisplayList(cv.ctx, ((GeometryArrayRetained)r.geometry()).dlistId, rm.isNonUniformScale);
                r = r.next;
            }
            return true;
        }
        boolean isVisible = false;
        while (r != null) {
            if (cv.ra == r.renderAtom) {
                if (cv.raIsVisible) {
                    cv.updateState(dirtyBits);
                    cv.callDisplayList(cv.ctx, ((GeometryArrayRetained)r.geometry()).dlistId, rm.isNonUniformScale);
                    isVisible = true;
                }
            } else {
                if (r.renderAtom.localeVwcBounds.intersect(cv.viewFrustum)) {
                    cv.updateState(dirtyBits);
                    cv.raIsVisible = true;
                    cv.callDisplayList(cv.ctx, ((GeometryArrayRetained)r.geometry()).dlistId, rm.isNonUniformScale);
                    isVisible = true;
                } else {
                    cv.raIsVisible = false;
                }
                cv.ra = r.renderAtom;
            }
            r = r.next;
        }
        return isVisible;
    }

    public boolean renderSeparateDlistPerRinfo(RenderMolecule rm, Canvas3D cv, RenderAtomListInfo r, int dirtyBits) {
        if (rm.doInfinite) {
            cv.updateState(dirtyBits);
            while (r != null) {
                cv.callDisplayList(cv.ctx, r.renderAtom.dlistIds[r.index], rm.isNonUniformScale);
                r = r.next;
            }
            return true;
        }
        boolean isVisible = false;
        while (r != null) {
            if (cv.ra == r.renderAtom) {
                if (cv.raIsVisible) {
                    cv.updateState(dirtyBits);
                    cv.callDisplayList(cv.ctx, r.renderAtom.dlistIds[r.index], rm.isNonUniformScale);
                    isVisible = true;
                }
            } else {
                if (r.renderAtom.localeVwcBounds.intersect(cv.viewFrustum)) {
                    cv.updateState(dirtyBits);
                    cv.raIsVisible = true;
                    cv.callDisplayList(cv.ctx, r.renderAtom.dlistIds[r.index], rm.isNonUniformScale);
                    isVisible = true;
                } else {
                    cv.raIsVisible = false;
                }
                cv.ra = r.renderAtom;
            }
            r = r.next;
        }
        return isVisible;
    }

    void buildDisplayList(RenderMolecule rm, Canvas3D cv) {
        boolean useAlpha = rm.useAlpha;
        if (rm.primaryRenderAtomList != null && rm.texCoordSetMapLen <= cv.maxTexCoordSets) {
            cv.newDisplayList(cv.ctx, rm.displayListId);
            RenderAtomListInfo ra = rm.primaryRenderAtomList;
            while (ra != null) {
                Transform3D staticNormalTransform;
                Transform3D staticTransform;
                GeometryArrayRetained geo = (GeometryArrayRetained)ra.geometry();
                if (ra.renderAtom.geometryAtom.source.staticTransform == null) {
                    staticTransform = null;
                    staticNormalTransform = null;
                } else {
                    staticTransform = ra.renderAtom.geometryAtom.source.staticTransform.transform;
                    staticNormalTransform = (geo.vertexFormat & 2) != 0 ? ra.renderAtom.geometryAtom.source.staticTransform.getNormalTransform() : null;
                }
                geo.buildGA(cv, ra.renderAtom, false, useAlpha && (geo.vertexFormat & 4) != 0, rm.alpha, rm.textureBin.attributeBin.ignoreVertexColors, staticTransform, staticNormalTransform);
                ra = ra.next;
            }
            cv.endDisplayList(cv.ctx);
        }
    }

    void buildIndividualDisplayList(RenderAtomListInfo ra, Canvas3D cv, Context ctx) {
        GeometryArrayRetained geo = (GeometryArrayRetained)ra.geometry();
        if (geo.texCoordSetMap != null && geo.texCoordSetMap.length > cv.maxTexCoordSets) {
            return;
        }
        cv.newDisplayList(ctx, geo.dlistId);
        geo.buildGA(cv, ra.renderAtom, false, false, 1.0f, false, null, null);
        cv.endDisplayList(ctx);
    }

    void buildDlistPerRinfo(RenderAtomListInfo ra, RenderMolecule rm, Canvas3D cv) {
        boolean useAlpha = rm.useAlpha;
        GeometryArrayRetained geo = (GeometryArrayRetained)ra.geometry();
        if (rm.primaryRenderAtomList != null && rm.texCoordSetMapLen <= cv.maxTexCoordSets) {
            Transform3D staticNormalTransform;
            Transform3D staticTransform;
            int id = ra.renderAtom.dlistIds[ra.index];
            cv.newDisplayList(cv.ctx, id);
            geo = (GeometryArrayRetained)ra.geometry();
            if (ra.renderAtom.geometryAtom.source.staticTransform == null) {
                staticTransform = null;
                staticNormalTransform = null;
            } else {
                staticTransform = ra.renderAtom.geometryAtom.source.staticTransform.transform;
                staticNormalTransform = (geo.vertexFormat & 2) != 0 ? ra.renderAtom.geometryAtom.source.staticTransform.getNormalTransform() : null;
            }
            geo.buildGA(cv, ra.renderAtom, false, useAlpha && (geo.vertexFormat & 4) != 0, rm.alpha, rm.textureBin.attributeBin.ignoreVertexColors, staticTransform, staticNormalTransform);
            cv.endDisplayList(cv.ctx);
        }
    }
}

