/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SharedGroup;

public class Group
extends Node {
    public static final int ALLOW_CHILDREN_READ = 12;
    public static final int ALLOW_CHILDREN_WRITE = 13;
    public static final int ALLOW_CHILDREN_EXTEND = 14;
    public static final int ALLOW_COLLISION_BOUNDS_READ = 15;
    public static final int ALLOW_COLLISION_BOUNDS_WRITE = 16;
    private static final int[] readCapabilities = new int[]{12, 15};

    @Override
    void createRetained() {
        this.retained = new GroupRetained();
        this.retained.setSource(this);
    }

    public void setCollisionBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Group0"));
        }
        ((GroupRetained)this.retained).setCollisionBounds(bounds);
    }

    public Bounds getCollisionBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Group1"));
        }
        return ((GroupRetained)this.retained).getCollisionBounds();
    }

    public void setChild(Node child, int index) {
        if (child instanceof SharedGroup) {
            throw new IllegalArgumentException(J3dI18N.getString("Group2"));
        }
        if (this.isLiveOrCompiled()) {
            Node oldchild = ((GroupRetained)this.retained).getChild(index);
            if (!(child instanceof BranchGroup)) {
                throw new RestrictedAccessException(J3dI18N.getString("Group3"));
            }
            if (!this.getCapability(13)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group13"));
            }
            if (oldchild != null && !((BranchGroup)oldchild).getCapability(17)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group4"));
            }
        }
        ((GroupRetained)this.retained).setChild(child, index);
    }

    public void insertChild(Node child, int index) {
        if (child instanceof SharedGroup) {
            throw new IllegalArgumentException(J3dI18N.getString("Group2"));
        }
        if (this.isLiveOrCompiled()) {
            if (!(child instanceof BranchGroup)) {
                throw new RestrictedAccessException(J3dI18N.getString("Group6"));
            }
            if (!this.getCapability(13)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group14"));
            }
        }
        ((GroupRetained)this.retained).insertChild(child, index);
    }

    public void removeChild(int index) {
        if (this.isLiveOrCompiled()) {
            Node child = ((GroupRetained)this.retained).getChild(index);
            if (!(child instanceof BranchGroup)) {
                throw new RestrictedAccessException(J3dI18N.getString("Group7"));
            }
            if (!this.getCapability(13)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group15"));
            }
            if (!((BranchGroup)child).getCapability(17)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group4"));
            }
        }
        ((GroupRetained)this.retained).removeChild(index);
    }

    public Node getChild(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Group9"));
        }
        return ((GroupRetained)this.retained).getChild(index);
    }

    public Enumeration<Node> getAllChildren() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Group9"));
        }
        return ((GroupRetained)this.retained).getAllChildren();
    }

    public void addChild(Node child) {
        if (child instanceof SharedGroup) {
            throw new IllegalArgumentException(J3dI18N.getString("Group2"));
        }
        if (this.isLiveOrCompiled()) {
            if (!(child instanceof BranchGroup)) {
                throw new RestrictedAccessException(J3dI18N.getString("Group12"));
            }
            if (!this.getCapability(14)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group16"));
            }
        }
        ((GroupRetained)this.retained).addChild(child);
    }

    public void moveTo(BranchGroup branchGroup) {
        if (this.isLiveOrCompiled()) {
            if (!this.getCapability(14)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group16"));
            }
            if (!branchGroup.getCapability(17)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group4"));
            }
        }
        ((GroupRetained)this.retained).moveTo(branchGroup);
    }

    public int numChildren() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Group9"));
        }
        return ((GroupRetained)this.retained).numChildren();
    }

    public int indexOfChild(Node child) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Group9"));
        }
        return ((GroupRetained)this.retained).indexOfChild(child);
    }

    public void removeChild(Node child) {
        if (this.isLiveOrCompiled()) {
            if (!(child instanceof BranchGroup)) {
                throw new RestrictedAccessException(J3dI18N.getString("Group7"));
            }
            if (!this.getCapability(13)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group15"));
            }
            if (!((BranchGroup)child).getCapability(17)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group4"));
            }
        }
        ((GroupRetained)this.retained).removeChild(child);
    }

    public void removeAllChildren() {
        if (this.isLiveOrCompiled()) {
            GroupRetained groupR = (GroupRetained)this.retained;
            for (int index = groupR.numChildren() - 1; index >= 0; --index) {
                Node child = groupR.getChild(index);
                if (!(child instanceof BranchGroup)) {
                    throw new RestrictedAccessException(J3dI18N.getString("Group7"));
                }
                if (!this.getCapability(13)) {
                    throw new CapabilityNotSetException(J3dI18N.getString("Group15"));
                }
                if (((BranchGroup)child).getCapability(17)) continue;
                throw new CapabilityNotSetException(J3dI18N.getString("Group4"));
            }
        }
        ((GroupRetained)this.retained).removeAllChildren();
    }

    public void setAlternateCollisionTarget(boolean target) {
        ((GroupRetained)this.retained).setAlternateCollisionTarget(target);
    }

    public boolean getAlternateCollisionTarget() {
        return ((GroupRetained)this.retained).getAlternateCollisionTarget();
    }

    @Override
    Node cloneTree(boolean forceDuplicate, Hashtable nodeHashtable) {
        Group g = (Group)super.cloneTree(forceDuplicate, nodeHashtable);
        GroupRetained rt = (GroupRetained)this.retained;
        int nChildren = rt.numChildren();
        for (int i = 0; i < nChildren; ++i) {
            Node n = rt.getChild(i);
            Node clonedN = n.cloneTree(forceDuplicate, nodeHashtable);
            ((GroupRetained)g.retained).addChild(clonedN);
        }
        return g;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        GroupRetained attr = (GroupRetained)originalNode.retained;
        GroupRetained rt = (GroupRetained)this.retained;
        rt.setCollisionBounds(attr.getCollisionBounds());
        rt.setAlternateCollisionTarget(attr.getAlternateCollisionTarget());
        rt.children.clear();
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        Group g = new Group();
        g.duplicateNode(this, forceDuplicate);
        return g;
    }

    public Group() {
        this.setDefaultReadCapabilities(readCapabilities);
    }
}

