/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NioImageBuffer;

class ImageComponent2DRetained
extends ImageComponentRetained {
    ImageComponent2DRetained() {
    }

    void set(NioImageBuffer image) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (!this.byReference) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2D7"));
        }
        if (!this.yUp) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2D8"));
        }
        if (width != this.width) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained0"));
        }
        if (height != this.height) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained1"));
        }
        this.geomLock.getLock();
        this.setImageClass(image);
        this.setRefImage(image, 0);
        this.abgrSupported = true;
        this.imageTypeIsSupported = this.isImageTypeSupported(image);
        if (this.imageTypeIsSupported) {
            this.imageData = this.createNioImageBufferDataObject(image);
        } else {
            this.imageData = this.createNioImageBufferDataObject(null);
            this.copyUnsupportedNioImageToImageData(image, 0, 0, 0, 0, width, height, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.sendMessage(1, null);
        }
    }

    void set(RenderedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (width != this.width) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained0"));
        }
        if (height != this.height) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained1"));
        }
        this.setImageClass(image);
        this.geomLock.getLock();
        if (this.byReference) {
            this.setRefImage(image, 0);
        }
        this.abgrSupported = true;
        this.imageTypeIsSupported = this.isImageTypeSupported(image);
        if (this.imageTypeIsSupported) {
            if (this.byReference && this.yUp) {
                this.imageData = image instanceof BufferedImage ? this.createRenderedImageDataObject(image) : null;
            } else {
                this.imageData = this.createRenderedImageDataObject(null);
                this.copySupportedImageToImageData(image, 0, this.imageData);
            }
        } else {
            this.imageData = this.createRenderedImageDataObject(null);
            this.copyUnsupportedImageToImageData(image, 0, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.sendMessage(1, null);
        }
    }

    void setSubImage(RenderedImage image, int width, int height, int srcX, int srcY, int dstX, int dstY) {
        if (!this.isSubImageTypeEqual(image)) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D6"));
        }
        assert (!this.byReference);
        assert (this.imageData != null);
        this.geomLock.getLock();
        if (this.imageTypeIsSupported) {
            if (image instanceof BufferedImage) {
                this.copyImageLineByLine((BufferedImage)image, srcX, srcY, dstX, dstY, 0, width, height, this.imageData);
            } else {
                this.copySupportedImageToImageData(image, srcX, srcY, dstX, dstY, 0, width, height, this.imageData);
            }
        } else if (image instanceof BufferedImage) {
            this.copyUnsupportedImageToImageData((BufferedImage)image, srcX, srcY, dstX, dstY, 0, width, height, this.imageData);
        } else {
            this.copyUnsupportedImageToImageData(image, srcX, srcY, dstX, dstY, 0, width, height, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            ImageComponentUpdateInfo info = new ImageComponentUpdateInfo();
            info.x = dstX;
            info.y = dstY;
            info.z = 0;
            info.width = width;
            info.height = height;
            this.sendMessage(2, info);
        }
    }

    RenderedImage getImage() {
        if (this.isByReference()) {
            return (RenderedImage)this.getRefImage(0);
        }
        if (this.imageData != null) {
            return this.imageData.createBufferedImage(0);
        }
        return null;
    }

    NioImageBuffer getNioImage() {
        if (this.getImageClass() != ImageComponent.ImageClass.NIO_IMAGE_BUFFER) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D9"));
        }
        assert (this.byReference);
        return (NioImageBuffer)this.getRefImage(0);
    }

    void updateData(ImageComponent2D.Updater updater, int x, int y, int width, int height) {
        this.geomLock.getLock();
        updater.updateData((ImageComponent2D)this.source, x, y, width, height);
        Object refImage = this.getRefImage(0);
        assert (refImage != null);
        assert (this.imageData != null);
        if (!this.imageData.isDataByRef()) {
            RenderedImage ri;
            if (this.imageTypeIsSupported) {
                assert (!(refImage instanceof NioImageBuffer));
                if (refImage instanceof BufferedImage) {
                    this.copyImageLineByLine((BufferedImage)refImage, x, y, x, y, 0, width, height, this.imageData);
                } else {
                    ri = (RenderedImage)refImage;
                    this.copySupportedImageToImageData(ri, x + ri.getMinX(), y + ri.getMinY(), x, y, 0, width, height, this.imageData);
                }
            } else if (refImage instanceof BufferedImage) {
                this.copyUnsupportedImageToImageData((BufferedImage)refImage, x, y, x, y, 0, width, height, this.imageData);
            } else if (refImage instanceof RenderedImage) {
                ri = (RenderedImage)refImage;
                this.copyUnsupportedImageToImageData(ri, x + ri.getMinX(), y + ri.getMinY(), x, y, 0, width, height, this.imageData);
            } else if (refImage instanceof NioImageBuffer) {
                this.copyUnsupportedNioImageToImageData((NioImageBuffer)refImage, x, y, x, y, width, height, this.imageData);
            } else assert (false);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            ImageComponentUpdateInfo info = new ImageComponentUpdateInfo();
            info.x = x;
            info.y = y;
            info.z = 0;
            info.width = width;
            info.height = height;
            this.sendMessage(2, info);
        }
    }

    @Override
    void clearLive(int refCount) {
        super.clearLive(refCount);
    }
}

