/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedQuadArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;

public class IndexedQuadArray
extends IndexedGeometryArray {
    IndexedQuadArray() {
    }

    public IndexedQuadArray(int vertexCount, int vertexFormat, int indexCount) {
        super(vertexCount, vertexFormat, indexCount);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedQuadArray0"));
        }
        if (indexCount < 4 || indexCount % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedQuadArray1"));
        }
    }

    public IndexedQuadArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int indexCount) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, indexCount);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedQuadArray0"));
        }
        if (indexCount < 4 || indexCount % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedQuadArray1"));
        }
    }

    public IndexedQuadArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes, int indexCount) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes, indexCount);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedQuadArray0"));
        }
        if (indexCount < 4 || indexCount % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedQuadArray1"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new IndexedQuadArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        IndexedQuadArrayRetained rt = (IndexedQuadArrayRetained)this.retained;
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        IndexedQuadArray q = new IndexedQuadArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes, rt.getIndexCount());
        q.duplicateNodeComponent(this);
        return q;
    }
}

