/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.media.j3d.J3dI18N;

public class J3DBuffer {
    private Buffer originalBuffer = null;
    private Buffer readonlyBuffer = null;
    Type bufferType = Type.NULL;

    public J3DBuffer() {
        this(null);
    }

    public J3DBuffer(Buffer buffer) {
        this.setBuffer(buffer);
    }

    public void setBuffer(Buffer buffer) {
        Type bType = Type.NULL;
        boolean direct = false;
        ByteOrder order = ByteOrder.BIG_ENDIAN;
        if (buffer == null) {
            bType = Type.NULL;
        } else if (buffer instanceof ByteBuffer) {
            bType = Type.BYTE;
            direct = ((ByteBuffer)buffer).isDirect();
            order = ((ByteBuffer)buffer).order();
        } else if (buffer instanceof CharBuffer) {
            bType = Type.CHAR;
            direct = ((CharBuffer)buffer).isDirect();
            order = ((CharBuffer)buffer).order();
        } else if (buffer instanceof ShortBuffer) {
            bType = Type.SHORT;
            direct = ((ShortBuffer)buffer).isDirect();
            order = ((ShortBuffer)buffer).order();
        } else if (buffer instanceof IntBuffer) {
            bType = Type.INT;
            direct = ((IntBuffer)buffer).isDirect();
            order = ((IntBuffer)buffer).order();
        } else if (buffer instanceof LongBuffer) {
            bType = Type.LONG;
            direct = ((LongBuffer)buffer).isDirect();
            order = ((LongBuffer)buffer).order();
        } else if (buffer instanceof FloatBuffer) {
            bType = Type.FLOAT;
            direct = ((FloatBuffer)buffer).isDirect();
            order = ((FloatBuffer)buffer).order();
        } else if (buffer instanceof DoubleBuffer) {
            bType = Type.DOUBLE;
            direct = ((DoubleBuffer)buffer).isDirect();
            order = ((DoubleBuffer)buffer).order();
        } else {
            bType = Type.UNKNOWN;
        }
        if (buffer != null) {
            if (!direct) {
                throw new IllegalArgumentException(J3dI18N.getString("J3DBuffer1"));
            }
            if (order != ByteOrder.nativeOrder()) {
                throw new IllegalArgumentException(J3dI18N.getString("J3DBuffer2"));
            }
        }
        this.bufferType = bType;
        this.originalBuffer = buffer;
        switch (this.bufferType) {
            case BYTE: {
                ByteBuffer byteBuffer = ((ByteBuffer)buffer).asReadOnlyBuffer();
                byteBuffer.rewind();
                this.readonlyBuffer = byteBuffer;
                break;
            }
            case FLOAT: {
                FloatBuffer floatBuffer = ((FloatBuffer)buffer).asReadOnlyBuffer();
                floatBuffer.rewind();
                this.readonlyBuffer = floatBuffer;
                break;
            }
            case DOUBLE: {
                DoubleBuffer doubleBuffer = ((DoubleBuffer)buffer).asReadOnlyBuffer();
                doubleBuffer.rewind();
                this.readonlyBuffer = doubleBuffer;
                break;
            }
            default: {
                this.readonlyBuffer = null;
            }
        }
    }

    public Buffer getBuffer() {
        return this.originalBuffer;
    }

    Buffer getROBuffer() {
        return this.readonlyBuffer;
    }

    static enum Type {
        NULL,
        UNKNOWN,
        BYTE,
        CHAR,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

