/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;

public abstract class Light
extends Leaf {
    public static final int ALLOW_STATE_READ = 12;
    public static final int ALLOW_STATE_WRITE = 13;
    public static final int ALLOW_COLOR_READ = 14;
    public static final int ALLOW_COLOR_WRITE = 15;
    public static final int ALLOW_INFLUENCING_BOUNDS_READ = 16;
    public static final int ALLOW_INFLUENCING_BOUNDS_WRITE = 17;
    public static final int ALLOW_SCOPE_READ = 28;
    public static final int ALLOW_SCOPE_WRITE = 29;
    private static final int[] readCapabilities = new int[]{12, 14, 16, 28};

    public Light() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Light(Color3f color) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((LightRetained)this.retained).initColor(color);
    }

    public Light(boolean lightOn, Color3f color) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((LightRetained)this.retained).initEnable(lightOn);
        ((LightRetained)this.retained).initColor(color);
    }

    public void setEnable(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light0"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).setEnable(state);
        } else {
            ((LightRetained)this.retained).initEnable(state);
        }
    }

    public boolean getEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light1"));
        }
        return ((LightRetained)this.retained).getEnable();
    }

    public void setColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light2"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).setColor(color);
        } else {
            ((LightRetained)this.retained).initColor(color);
        }
    }

    public void getColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light3"));
        }
        ((LightRetained)this.retained).getColor(color);
    }

    public void setScope(Group scope, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light4"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).setScope(scope, index);
        } else {
            ((LightRetained)this.retained).initScope(scope, index);
        }
    }

    public Group getScope(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(28)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light5"));
        }
        return ((LightRetained)this.retained).getScope(index);
    }

    public void insertScope(Group scope, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light6"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).insertScope(scope, index);
        } else {
            ((LightRetained)this.retained).initInsertScope(scope, index);
        }
    }

    public void removeScope(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light7"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).removeScope(index);
        } else {
            ((LightRetained)this.retained).initRemoveScope(index);
        }
    }

    public Enumeration<Group> getAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(28)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light8"));
        }
        return ((LightRetained)this.retained).getAllScopes();
    }

    public void addScope(Group scope) {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light9"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).addScope(scope);
        } else {
            ((LightRetained)this.retained).initAddScope(scope);
        }
    }

    public int numScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(28)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light8"));
        }
        return ((LightRetained)this.retained).numScopes();
    }

    public int indexOfScope(Group scope) {
        if (this.isLiveOrCompiled() && !this.getCapability(28)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light8"));
        }
        return ((LightRetained)this.retained).indexOfScope(scope);
    }

    public void removeScope(Group scope) {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light7"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).removeScope(scope);
        } else {
            ((LightRetained)this.retained).initRemoveScope(scope);
        }
    }

    public void removeAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light7"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).removeAllScopes();
        } else {
            ((LightRetained)this.retained).initRemoveAllScopes();
        }
    }

    public void setInfluencingBounds(Bounds region) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light11"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).setInfluencingBounds(region);
        } else {
            ((LightRetained)this.retained).initInfluencingBounds(region);
        }
    }

    public Bounds getInfluencingBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light12"));
        }
        return ((LightRetained)this.retained).getInfluencingBounds();
    }

    public void setInfluencingBoundingLeaf(BoundingLeaf region) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light11"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).setInfluencingBoundingLeaf(region);
        } else {
            ((LightRetained)this.retained).initInfluencingBoundingLeaf(region);
        }
    }

    public BoundingLeaf getInfluencingBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light12"));
        }
        return ((LightRetained)this.retained).getInfluencingBoundingLeaf();
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        LightRetained attr = (LightRetained)originalNode.retained;
        LightRetained rt = (LightRetained)this.retained;
        Color3f c = new Color3f();
        attr.getColor(c);
        rt.initColor(c);
        rt.initInfluencingBounds(attr.getInfluencingBounds());
        Enumeration<Group> elm = attr.getAllScopes();
        while (elm.hasMoreElements()) {
            rt.initAddScope(elm.nextElement());
        }
        rt.initInfluencingBoundingLeaf(attr.getInfluencingBoundingLeaf());
        rt.initEnable(attr.getEnable());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        LightRetained rt = (LightRetained)this.retained;
        BoundingLeaf bl = rt.getInfluencingBoundingLeaf();
        if (bl != null) {
            SceneGraphObject o = referenceTable.getNewObjectReference(bl);
            rt.initInfluencingBoundingLeaf((BoundingLeaf)o);
        }
        int num = rt.numScopes();
        for (int i = 0; i < num; ++i) {
            rt.initScope((Group)referenceTable.getNewObjectReference(rt.getScope(i)), i);
        }
    }
}

