/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.MasterControl;
import javax.media.j3d.NnuId;

class NnuIdManager {
    static int nnuId = 0;

    NnuIdManager() {
    }

    static final int getId() {
        if (nnuId == Integer.MAX_VALUE) {
            nnuId = 0;
        }
        return nnuId++;
    }

    static final int equals(NnuId[] nnuIdArr, NnuId key, int start, int end) {
        int mid = start + (end - start) / 2;
        if (nnuIdArr[mid] != null) {
            int test = key.equal(nnuIdArr[mid]);
            if (test < 0 && start != mid) {
                return NnuIdManager.equals(nnuIdArr, key, start, mid);
            }
            if (test > 0 && start != mid) {
                return NnuIdManager.equals(nnuIdArr, key, mid, end);
            }
            if (test == 0) {
                int temp;
                if (key == nnuIdArr[mid]) {
                    return mid;
                }
                for (temp = mid - 1; temp >= start && key.equal(nnuIdArr[temp]) == 0; --temp) {
                    if (key != nnuIdArr[temp]) continue;
                    return temp;
                }
                for (temp = mid + 1; temp < end && key.equal(nnuIdArr[temp]) == 0; ++temp) {
                    if (key != nnuIdArr[temp]) continue;
                    return temp;
                }
                return -1;
            }
            return -1;
        }
        return -2;
    }

    static final boolean equals(NnuId[] nnuIdArr, NnuId key, int[] index, int start, int end) {
        int mid = start + (end - start) / 2;
        if (nnuIdArr[mid] != null) {
            int temp;
            int test = key.equal(nnuIdArr[mid]);
            if (start != mid) {
                if (test < 0) {
                    return NnuIdManager.equals(nnuIdArr, key, index, start, mid);
                }
                if (test > 0) {
                    return NnuIdManager.equals(nnuIdArr, key, index, mid, end);
                }
            } else {
                if (test < 0) {
                    index[0] = mid;
                    return false;
                }
                if (test > 0) {
                    index[0] = mid + 1;
                    return false;
                }
            }
            if (key == nnuIdArr[mid]) {
                index[0] = mid;
                return true;
            }
            for (temp = mid - 1; temp >= start && key.equal(nnuIdArr[temp]) == 0; --temp) {
                if (key != nnuIdArr[temp]) continue;
                index[0] = temp;
                return true;
            }
            for (temp = mid + 1; temp < end && key.equal(nnuIdArr[temp]) == 0; ++temp) {
                if (key != nnuIdArr[temp]) continue;
                index[0] = temp;
                return true;
            }
            index[0] = temp;
            return false;
        }
        index[0] = mid;
        return false;
    }

    static final void sort(NnuId[] nnuIdArr) {
        if (nnuIdArr.length < 20) {
            NnuIdManager.insertSort(nnuIdArr);
        } else {
            NnuIdManager.quicksort(nnuIdArr, 0, nnuIdArr.length - 1);
        }
    }

    static final void insertSort(NnuId[] nnuIdArr) {
        for (int i = 0; i < nnuIdArr.length; ++i) {
            for (int j = i; j > 0 && nnuIdArr[j - 1].getId() > nnuIdArr[j].getId(); --j) {
                NnuId temp = nnuIdArr[j];
                nnuIdArr[j] = nnuIdArr[j - 1];
                nnuIdArr[j - 1] = temp;
            }
        }
    }

    static final void quicksort(NnuId[] nnuIdArr, int l, int r) {
        int i = l;
        int j = r;
        int k = nnuIdArr[(l + r) / 2].getId();
        while (true) {
            if (nnuIdArr[i].getId() < k) {
                ++i;
                continue;
            }
            while (k < nnuIdArr[j].getId()) {
                --j;
            }
            if (i <= j) {
                NnuId tmp = nnuIdArr[i];
                nnuIdArr[i] = nnuIdArr[j];
                nnuIdArr[j] = tmp;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            NnuIdManager.quicksort(nnuIdArr, l, j);
        }
        if (l < r) {
            NnuIdManager.quicksort(nnuIdArr, i, r);
        }
    }

    static final NnuId[] delete(NnuId[] nnuIdArr0, NnuId[] nnuIdArr1) {
        int curStart = 0;
        int newStart = 0;
        boolean found = false;
        int size = nnuIdArr0.length - nnuIdArr1.length;
        if (size > 0) {
            int len;
            NnuId[] newNnuIdArr = new NnuId[size];
            for (int i = 0; i < nnuIdArr1.length; ++i) {
                int index = NnuIdManager.equals(nnuIdArr0, nnuIdArr1[i], 0, nnuIdArr0.length);
                if (index >= 0) {
                    found = true;
                    if (i < nnuIdArr1.length - 1 && nnuIdArr1[i].getId() == nnuIdArr1[i + 1].getId()) {
                        NnuId[] tmpNnuIdArr0 = new NnuId[nnuIdArr0.length - 1];
                        System.arraycopy(nnuIdArr0, 0, tmpNnuIdArr0, 0, index);
                        System.arraycopy(nnuIdArr0, index + 1, tmpNnuIdArr0, index, nnuIdArr0.length - index - 1);
                        nnuIdArr0 = tmpNnuIdArr0;
                        continue;
                    }
                    if (index == curStart) {
                        ++curStart;
                        continue;
                    }
                    len = index - curStart;
                    System.arraycopy(nnuIdArr0, curStart, newNnuIdArr, newStart, len);
                    curStart = index + 1;
                    newStart += len;
                    continue;
                }
                found = false;
                MasterControl.getCoreLogger().severe("Can't Find matching nnuId.");
            }
            if (found && curStart < nnuIdArr0.length) {
                len = nnuIdArr0.length - curStart;
                System.arraycopy(nnuIdArr0, curStart, newNnuIdArr, newStart, len);
            }
            return newNnuIdArr;
        }
        if (size != 0) {
            MasterControl.getCoreLogger().severe("Attempt to remove more elements than are present");
        }
        return null;
    }

    static final NnuId[] merge(NnuId[] nnuIdArr0, NnuId[] nnuIdArr1) {
        int[] index = new int[1];
        int size = nnuIdArr0.length + nnuIdArr1.length;
        NnuId[] newNnuIdArr = new NnuId[size];
        System.arraycopy(nnuIdArr0, 0, newNnuIdArr, 0, nnuIdArr0.length);
        int i = nnuIdArr0.length;
        int j = 0;
        while (i < size) {
            NnuIdManager.equals(newNnuIdArr, nnuIdArr1[j], index, 0, i);
            if (index[0] == i) {
                newNnuIdArr[i] = nnuIdArr1[j];
            } else {
                int indexPlus1 = index[0] + 1;
                int blkSize = i - index[0];
                System.arraycopy(newNnuIdArr, index[0], newNnuIdArr, indexPlus1, blkSize);
                newNnuIdArr[index[0]] = nnuIdArr1[j];
            }
            ++i;
            ++j;
        }
        return newNnuIdArr;
    }

    static final void replace(NnuId oldObj, NnuId newObj, NnuId[] nnuIdArr) {
        int blkSize;
        int[] index = new int[1];
        int lenLess1 = nnuIdArr.length - 1;
        index[0] = NnuIdManager.equals(nnuIdArr, oldObj, 0, nnuIdArr.length);
        if (index[0] == lenLess1) {
            nnuIdArr[index[0]] = null;
        } else if (index[0] >= 0) {
            blkSize = lenLess1 - index[0];
            System.arraycopy(nnuIdArr, index[0] + 1, nnuIdArr, index[0], blkSize);
            nnuIdArr[lenLess1] = null;
        } else {
            MasterControl.getCoreLogger().severe("Can't Find matching nnuId.");
        }
        NnuIdManager.equals(nnuIdArr, newObj, index, 0, lenLess1);
        if (index[0] == lenLess1) {
            nnuIdArr[index[0]] = newObj;
        } else {
            blkSize = lenLess1 - index[0];
            System.arraycopy(nnuIdArr, index[0], nnuIdArr, index[0] + 1, blkSize);
            nnuIdArr[index[0]] = newObj;
        }
    }

    static final void printIds(NnuId[] nnuIdArr) {
        for (int i = 0; i < nnuIdArr.length; ++i) {
            System.err.println("[" + i + "] is " + nnuIdArr[i].getId());
        }
    }
}

