/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.GeometryArray;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.PointArrayRetained;

public class PointArray
extends GeometryArray {
    PointArray() {
    }

    public PointArray(int vertexCount, int vertexFormat) {
        super(vertexCount, vertexFormat);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("PointArray0"));
        }
    }

    public PointArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("PointArray0"));
        }
    }

    public PointArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("PointArray0"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new PointArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        PointArrayRetained rt = (PointArrayRetained)this.retained;
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        PointArray p = new PointArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes);
        p.duplicateNodeComponent(this);
        return p;
    }
}

