/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Vector3d;

public class PositionInterpolator
extends TransformInterpolator {
    private Transform3D translation = new Transform3D();
    private Vector3d transv = new Vector3d();
    float startPosition;
    float endPosition;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    PositionInterpolator() {
    }

    public PositionInterpolator(Alpha alpha, TransformGroup target) {
        super(alpha, target);
        this.startPosition = 0.0f;
        this.endPosition = 1.0f;
    }

    public PositionInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, float startPosition, float endPosition) {
        super(alpha, target, axisOfTransform);
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public void setStartPosition(float position) {
        this.startPosition = position;
    }

    public float getStartPosition() {
        return this.startPosition;
    }

    public void setEndPosition(float position) {
        this.endPosition = position;
    }

    public float getEndPosition() {
        return this.endPosition;
    }

    public void setAxisOfTranslation(Transform3D axisOfTranslation) {
        this.setTransformAxis(axisOfTranslation);
    }

    public Transform3D getAxisOfTranslation() {
        return this.getTransformAxis();
    }

    @Override
    public void computeTransform(float alphaValue, Transform3D transform) {
        double val = (1.0 - (double)alphaValue) * (double)this.startPosition + (double)(alphaValue * this.endPosition);
        this.transv.set(val, 0.0, 0.0);
        this.translation.setTranslation(this.transv);
        transform.mul(this.axis, this.translation);
        transform.mul(transform, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        PositionInterpolator pi = new PositionInterpolator();
        pi.duplicateNode(this, forceDuplicate);
        return pi;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        PositionInterpolator pi = (PositionInterpolator)originalNode;
        this.setStartPosition(pi.getStartPosition());
        this.setEndPosition(pi.getEndPosition());
    }
}

