/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.Dimension;
import java.awt.Point;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.Geometry;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.RasterRetained;
import javax.vecmath.Point3f;

public class Raster
extends Geometry {
    public static final int RASTER_COLOR = 1;
    public static final int RASTER_DEPTH = 2;
    public static final int RASTER_COLOR_DEPTH = 3;
    public static final int CLIP_POSITION = 0;
    public static final int CLIP_IMAGE = 1;
    public static final int ALLOW_POSITION_READ = 0;
    public static final int ALLOW_POSITION_WRITE = 1;
    public static final int ALLOW_OFFSET_READ = 2;
    public static final int ALLOW_OFFSET_WRITE = 3;
    public static final int ALLOW_IMAGE_READ = 4;
    public static final int ALLOW_IMAGE_WRITE = 5;
    public static final int ALLOW_DEPTH_COMPONENT_READ = 6;
    public static final int ALLOW_DEPTH_COMPONENT_WRITE = 7;
    public static final int ALLOW_SIZE_READ = 8;
    public static final int ALLOW_SIZE_WRITE = 9;
    public static final int ALLOW_TYPE_READ = 10;
    public static final int ALLOW_CLIP_MODE_READ = 11;
    public static final int ALLOW_CLIP_MODE_WRITE = 12;
    private static final int[] readCapabilities = new int[]{0, 2, 4, 6, 8, 10, 11};

    public Raster() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Raster(Point3f pos, int type, int xSrcOffset, int ySrcOffset, int width, int height, ImageComponent2D image, DepthComponent depthComponent) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((RasterRetained)this.retained).setPosition(pos);
        ((RasterRetained)this.retained).setType(type);
        ((RasterRetained)this.retained).setSrcOffset(xSrcOffset, ySrcOffset);
        ((RasterRetained)this.retained).setSize(width, height);
        ((RasterRetained)this.retained).setImage(image);
        ((RasterRetained)this.retained).setDepthComponent(depthComponent);
    }

    public Raster(Point3f pos, int type, Point srcOffset, Dimension size, ImageComponent2D image, DepthComponent depthComponent) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((RasterRetained)this.retained).setPosition(pos);
        ((RasterRetained)this.retained).setType(type);
        ((RasterRetained)this.retained).setSrcOffset(srcOffset.x, srcOffset.y);
        ((RasterRetained)this.retained).setSize(size.width, size.height);
        ((RasterRetained)this.retained).setImage(image);
        ((RasterRetained)this.retained).setDepthComponent(depthComponent);
    }

    public Raster(Point3f pos, int type, int clipMode, Point srcOffset, Dimension size, Point dstOffset, ImageComponent2D image, DepthComponent depthComponent) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((RasterRetained)this.retained).setPosition(pos);
        ((RasterRetained)this.retained).setType(type);
        ((RasterRetained)this.retained).setClipMode(clipMode);
        ((RasterRetained)this.retained).setSrcOffset(srcOffset.x, srcOffset.y);
        ((RasterRetained)this.retained).setSize(size.width, size.height);
        ((RasterRetained)this.retained).setDstOffset(dstOffset.x, dstOffset.y);
        ((RasterRetained)this.retained).setImage(image);
        ((RasterRetained)this.retained).setDepthComponent(depthComponent);
    }

    @Override
    void createRetained() {
        this.retained = new RasterRetained();
        this.retained.setSource(this);
    }

    public void setPosition(Point3f pos) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster0"));
        }
        ((RasterRetained)this.retained).setPosition(pos);
    }

    public void getPosition(Point3f pos) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster1"));
        }
        ((RasterRetained)this.retained).getPosition(pos);
    }

    public void setType(int type) {
        this.checkForLiveOrCompiled();
        ((RasterRetained)this.retained).setType(type);
    }

    public int getType() {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster2"));
        }
        return ((RasterRetained)this.retained).getType();
    }

    public void setClipMode(int clipMode) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster10"));
        }
        ((RasterRetained)this.retained).setClipMode(clipMode);
    }

    public int getClipMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster11"));
        }
        return ((RasterRetained)this.retained).getClipMode();
    }

    public void setOffset(int xSrcOffset, int ySrcOffset) {
        this.setSrcOffset(xSrcOffset, ySrcOffset);
    }

    public void setOffset(Point srcOffset) {
        this.setSrcOffset(srcOffset);
    }

    public void getOffset(Point srcOffset) {
        this.getSrcOffset(srcOffset);
    }

    public void setSrcOffset(int xSrcOffset, int ySrcOffset) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster7"));
        }
        ((RasterRetained)this.retained).setSrcOffset(xSrcOffset, ySrcOffset);
    }

    public void setSrcOffset(Point srcOffset) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster7"));
        }
        ((RasterRetained)this.retained).setSrcOffset(srcOffset.x, srcOffset.y);
    }

    public void getSrcOffset(Point srcOffset) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster8"));
        }
        ((RasterRetained)this.retained).getSrcOffset(srcOffset);
    }

    public void setSize(int width, int height) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster9"));
        }
        ((RasterRetained)this.retained).setSize(width, height);
    }

    public void setSize(Dimension size) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster9"));
        }
        ((RasterRetained)this.retained).setSize(size.width, size.height);
    }

    public void getSize(Dimension size) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster1"));
        }
        ((RasterRetained)this.retained).getSize(size);
    }

    public void setDstOffset(int xDstOffset, int yDstOffset) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster7"));
        }
        ((RasterRetained)this.retained).setDstOffset(xDstOffset, yDstOffset);
    }

    public void setDstOffset(Point dstOffset) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster7"));
        }
        ((RasterRetained)this.retained).setDstOffset(dstOffset.x, dstOffset.y);
    }

    public void getDstOffset(Point dstOffset) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster8"));
        }
        ((RasterRetained)this.retained).getDstOffset(dstOffset);
    }

    public void setImage(ImageComponent2D image) {
        ImageComponent2DRetained imageRetained;
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster3"));
        }
        if (image != null && (imageRetained = (ImageComponent2DRetained)image.retained).getUsedByOffScreen() && this.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("Raster12"));
        }
        ((RasterRetained)this.retained).setImage(image);
    }

    public ImageComponent2D getImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster4"));
        }
        return ((RasterRetained)this.retained).getImage();
    }

    public void setDepthComponent(DepthComponent depthComponent) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster5"));
        }
        ((RasterRetained)this.retained).setDepthComponent(depthComponent);
    }

    public DepthComponent getDepthComponent() {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Raster6"));
        }
        return ((RasterRetained)this.retained).getDepthComponent();
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        Raster r = new Raster();
        r.duplicateNodeComponent(this);
        return r;
    }

    @Override
    public void duplicateNodeComponent(NodeComponent originalNodeComponent) {
        this.checkDuplicateNodeComponent(originalNodeComponent);
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        RasterRetained raster = (RasterRetained)originalNodeComponent.retained;
        RasterRetained rt = (RasterRetained)this.retained;
        Point3f p = new Point3f();
        raster.getPosition(p);
        rt.setPosition(p);
        rt.setType(raster.getType());
        rt.setClipMode(raster.getClipMode());
        Point offset = new Point();
        raster.getSrcOffset(offset);
        rt.setSrcOffset(offset.x, offset.y);
        raster.getDstOffset(offset);
        rt.setDstOffset(offset.x, offset.y);
        Dimension dim = new Dimension();
        raster.getSize(dim);
        rt.setSize(dim.width, dim.height);
        rt.setImage((ImageComponent2D)this.getNodeComponent(raster.getImage(), forceDuplicate, originalNodeComponent.nodeHashtable));
        rt.setDepthComponent((DepthComponent)this.getNodeComponent(raster.getDepthComponent(), forceDuplicate, originalNodeComponent.nodeHashtable));
    }

    @Override
    boolean duplicateChild() {
        if (this.getDuplicateOnCloneTree()) {
            return true;
        }
        RasterRetained rt = (RasterRetained)this.retained;
        NodeComponent nc = rt.getImage();
        if (nc != null && nc.getDuplicateOnCloneTree()) {
            return true;
        }
        nc = rt.getDepthComponent();
        return nc != null && nc.getDuplicateOnCloneTree();
    }
}

