/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import javax.media.j3d.Appearance;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.Background;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.Context;
import javax.media.j3d.Drawable;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.Fog;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dNotification;
import javax.media.j3d.J3dThread;
import javax.media.j3d.Light;
import javax.media.j3d.MasterControl;
import javax.media.j3d.ModelClip;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Raster;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.RendererStructure;
import javax.media.j3d.RenderingError;
import javax.media.j3d.RenderingErrorListener;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Sound;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

class Renderer
extends J3dThread {
    static final int WAIT = 0;
    static final int NOTIFY_AND_WAIT = 1;
    static final int NOTIFY = 2;
    static final int DECAL_NONE = 0;
    static final int DECAL_1ST_CHILD = 1;
    static final int DECAL_NTH_CHILD = 2;
    static final int NUM_ACCUMULATION_SAMPLES = 8;
    static final float[] ACCUM_SAMPLES_X = new float[]{-0.54818f, 0.56438f, 0.39462f, -0.54498f, -0.8379f, -0.39263f, 0.32254f, 0.84216f};
    static final float[] ACCUM_SAMPLES_Y = new float[]{0.55331f, -0.53495f, 0.4154f, -0.52829f, 0.82102f, -0.27383f, 0.09133f, -0.84399f};
    static final float accumValue = 0.125f;
    static final int RENDER = 0;
    static final int SWAP = 1;
    static final int REQUESTRENDER = 2;
    static final int REQUESTCLEANUP = 3;
    RendererStructure rendererStructure = new RendererStructure();
    Transform3D bgVworldToVpc = new Transform3D();
    private static int numInstances = 0;
    private int instanceNum = -1;
    boolean sharedStereoZBuffer;
    Context sharedCtx = null;
    long sharedCtxTimeStamp = 0L;
    private Drawable sharedCtxDrawable = null;
    Context currentCtx = null;
    Drawable currentDrawable = null;
    int rendererBit = 0;
    int rendererId = 0;
    ArrayList<RenderMolecule> dirtyRenderMoleculeList = new ArrayList();
    ArrayList<RenderAtomListInfo> dirtyRenderAtomList = new ArrayList();
    ArrayList<Object[]> dirtyDlistPerRinfoList = new ArrayList();
    ArrayList<Integer> textureIdResourceFreeList = new ArrayList();
    ArrayList<Integer> displayListResourceFreeList = new ArrayList();
    ArrayList<TextureRetained> textureReloadList = new ArrayList();
    J3dMessage[] renderMessage;
    Screen3D onScreen;
    Screen3D offScreen;
    Transform3D accumLeftProj = new Transform3D();
    Transform3D accumRightProj = new Transform3D();
    Transform3D accumInfLeftProj = new Transform3D();
    Transform3D accumInfRightProj = new Transform3D();
    J3dMessage[] m;
    int nmesg = 0;
    ArrayList<Context> listOfCtxs = new ArrayList();
    ArrayList<Canvas3D> listOfCanvases = new ArrayList();
    boolean needToRebuildDisplayList = false;
    boolean dirtyDisplayList = false;
    ArrayList<TextureRetained> textureIDResourceTable = new ArrayList(5);
    private long lastSwapTime = System.nanoTime();
    private static RenderingErrorListener defaultErrorListener = null;

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    @Override
    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    Renderer(ThreadGroup t) {
        super(t);
        this.setName("J3D-Renderer-" + this.getInstanceNum());
        this.type = 16;
        this.rendererId = VirtualUniverse.mc.getRendererId();
        this.rendererBit = 1 << this.rendererId;
        this.renderMessage = new J3dMessage[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doWork(long referenceTime) {
        block225: {
            RenderBin renderBin = null;
            Canvas3D canvas = null;
            View view = null;
            int num_accum_passes = 1;
            boolean doAccum = false;
            double accumDx = 0.0;
            double accumDy = 0.0;
            double accumDxFactor = 1.0;
            double accumDyFactor = 1.0;
            double accumLeftX = 0.0;
            double accumLeftY = 0.0;
            double accumRightX = 0.0;
            double accumRightY = 0.0;
            double accumInfLeftX = 0.0;
            double accumInfLeftY = 0.0;
            double accumInfRightX = 0.0;
            double accumInfRightY = 0.0;
            Transform3D t3d = null;
            int opArg = (Integer)this.args[0];
            try {
                if (opArg == 1) {
                    Object[] swapArray = (Object[])this.args[2];
                    view = (View)this.args[3];
                    for (int i = 0; i < swapArray.length; ++i) {
                        Canvas3D cv;
                        block224: {
                            cv = (Canvas3D)swapArray[i];
                            if (!cv.isRunning) continue;
                            try {
                                if (!cv.validCanvas) continue;
                                if (!cv.active || cv.ctx == null || cv.view == null || !cv.imageReady) break block224;
                                if (cv.useDoubleBuffer && !cv.offScreen) {
                                    DrawingSurfaceObject drawingSurfaceObject = cv.drawingSurfaceObject;
                                    synchronized (drawingSurfaceObject) {
                                        if (cv.validCtx) {
                                            if (VirtualUniverse.mc.doDsiRenderLock) {
                                                if (!cv.drawingSurfaceObject.renderLock()) {
                                                    break block224;
                                                }
                                                cv.makeCtxCurrent();
                                                cv.syncRender(cv.ctx, true);
                                                cv.swapBuffers(cv.ctx, cv.drawable);
                                                cv.drawingSurfaceObject.unLock();
                                            } else {
                                                cv.makeCtxCurrent();
                                                cv.syncRender(cv.ctx, true);
                                                cv.swapBuffers(cv.ctx, cv.drawable);
                                            }
                                        }
                                    }
                                }
                                cv.view.inCanvasCallback = true;
                                try {
                                    cv.postSwap();
                                }
                                catch (RuntimeException e) {
                                    System.err.println("Exception occurred during Canvas3D callback:");
                                    e.printStackTrace();
                                }
                                catch (Error e) {
                                    System.err.println("Error occurred during Canvas3D callback:");
                                    e.printStackTrace();
                                }
                                cv.imageReady = false;
                                cv.view.inCanvasCallback = false;
                                if (MasterControl.isStatsLoggable(Level.INFO)) {
                                    long currSwapTime = System.nanoTime();
                                    long deltaTime = currSwapTime - this.lastSwapTime;
                                    this.lastSwapTime = currSwapTime;
                                    VirtualUniverse.mc.recordTime(MasterControl.TimeType.TOTAL_FRAME, deltaTime);
                                }
                                if (!cv.ctxChanged) {
                                    cv.canvasDirty = 7743;
                                    cv.modelMatrix = null;
                                    cv.ra = null;
                                } else {
                                    cv.ctxChanged = false;
                                }
                            }
                            catch (NullPointerException ne) {
                                if (VirtualUniverse.mc.doDsiRenderLock) {
                                    cv.drawingSurfaceObject.unLock();
                                }
                            }
                            catch (RuntimeException ex) {
                                ex.printStackTrace();
                                if (VirtualUniverse.mc.doDsiRenderLock) {
                                    cv.drawingSurfaceObject.unLock();
                                }
                                cv.setFatalError();
                                RenderingError err = new RenderingError(1, J3dI18N.getString("Renderer0"));
                                err.setCanvas3D(cv);
                                err.setGraphicsDevice(cv.graphicsConfiguration.getDevice());
                                Renderer.notifyErrorListeners(err);
                            }
                        }
                        cv.releaseCtx();
                    }
                    if (view != null && view.viewCache.getDoHeadTracking()) {
                        VirtualUniverse.mc.sendRunMessage(view, 16);
                    }
                    break block225;
                }
                if (opArg == 3) {
                    Integer mtype = (Integer)this.args[2];
                    if (mtype == MasterControl.REMOVEALLCTXS_CLEANUP) {
                        this.removeAllCtxs();
                    } else if (mtype == MasterControl.FREECONTEXT_CLEANUP) {
                        Canvas3D cv = (Canvas3D)this.args[1];
                        this.removeCtx(cv, cv.drawable, cv.ctx, true, true, false);
                    } else if (mtype == MasterControl.RESETCANVAS_CLEANUP) {
                        Canvas3D cv = (Canvas3D)this.args[1];
                        if (cv.ctx != null) {
                            cv.makeCtxCurrent();
                        }
                        cv.freeContextResources(cv.screen.renderer, true, cv.ctx);
                    } else if (mtype == MasterControl.REMOVECTX_CLEANUP) {
                        Object[] obj = (Object[])this.args[1];
                        Canvas3D c = (Canvas3D)obj[0];
                        this.removeCtx(c, (Drawable)obj[2], (Context)obj[3], false, !c.offScreen, false);
                    }
                    return;
                }
                this.nmesg = 0;
                int totalMessages = 0;
                if (opArg == 0) {
                    this.m = this.renderMessage;
                    this.m[0] = new J3dMessage();
                    this.m[0].type = ((Canvas3D)this.args[1]).offScreen ? 42 : 43;
                    this.m[0].incRefcount();
                    this.m[0].args[0] = this.args[1];
                    totalMessages = 1;
                } else {
                    this.m = this.rendererStructure.getMessages();
                    totalMessages = this.rendererStructure.getNumMessage();
                    if (totalMessages <= 0) {
                        return;
                    }
                }
                block81: while (this.nmesg < totalMessages) {
                    RenderingError err;
                    Object firstArg = this.m[this.nmesg].args[0];
                    if (firstArg == null) {
                        Object secondArg = this.m[this.nmesg].args[1];
                        if (secondArg instanceof Canvas3D) {
                            Integer reqType = (Integer)this.m[this.nmesg].args[2];
                            Canvas3D c = (Canvas3D)secondArg;
                            if (reqType == MasterControl.SET_GRAPHICSCONFIG_FEATURES) {
                                try {
                                    if (c.offScreen) {
                                        c.doubleBufferAvailable = c.hasDoubleBuffer();
                                        c.stereoAvailable = false;
                                    } else {
                                        c.doubleBufferAvailable = c.hasDoubleBuffer();
                                        c.stereoAvailable = c.hasStereo();
                                    }
                                    c.actualStencilSize = c.getStencilSize();
                                    boolean userOwnsStencil = c.requestedStencilSize > 0;
                                    c.userStencilAvailable = userOwnsStencil && c.actualStencilSize > 0;
                                    c.systemStencilAvailable = !userOwnsStencil && c.actualStencilSize > 0;
                                    c.sceneAntialiasingMultiSamplesAvailable = c.hasSceneAntialiasingMultisample();
                                    c.sceneAntialiasingAvailable = c.sceneAntialiasingMultiSamplesAvailable ? true : c.hasSceneAntialiasingAccum();
                                }
                                catch (RuntimeException ex) {
                                    ex.printStackTrace();
                                    c.setFatalError();
                                    err = new RenderingError(2, J3dI18N.getString("Renderer1"));
                                    err.setCanvas3D(c);
                                    err.setGraphicsDevice(c.graphicsConfiguration.getDevice());
                                    Renderer.notifyErrorListeners(err);
                                }
                                GraphicsConfigTemplate3D.runMonitor(2);
                            } else if (reqType == MasterControl.SET_QUERYPROPERTIES) {
                                try {
                                    c.createQueryContext();
                                }
                                catch (RuntimeException ex) {
                                    ex.printStackTrace();
                                    c.setFatalError();
                                    err = new RenderingError(3, J3dI18N.getString("Renderer2"));
                                    err.setCanvas3D(c);
                                    err.setGraphicsDevice(c.graphicsConfiguration.getDevice());
                                    Renderer.notifyErrorListeners(err);
                                }
                                GraphicsConfigTemplate3D.runMonitor(2);
                                this.currentCtx = null;
                                this.currentDrawable = null;
                            }
                        } else {
                            if (secondArg instanceof Integer) {
                                throw new AssertionError();
                            }
                            if (!(secondArg instanceof GeometryArrayRetained) && secondArg instanceof GraphicsConfigTemplate3D) {
                                RenderingError err2;
                                GraphicsConfigTemplate3D gct = (GraphicsConfigTemplate3D)secondArg;
                                Integer reqType = (Integer)this.m[this.nmesg].args[2];
                                if (reqType == MasterControl.GETBESTCONFIG) {
                                    GraphicsConfiguration gcfg = null;
                                    GraphicsConfiguration[] gcList = (GraphicsConfiguration[])gct.testCfg;
                                    try {
                                        gcfg = Pipeline.getPipeline().getBestConfiguration(gct, gcList);
                                    }
                                    catch (NullPointerException npe) {
                                        npe.printStackTrace();
                                    }
                                    catch (RuntimeException ex) {
                                        ex.printStackTrace();
                                        err2 = new RenderingError(2, J3dI18N.getString("Renderer3"));
                                        err2.setGraphicsDevice(gcList[0].getDevice());
                                        Renderer.notifyErrorListeners(err2);
                                    }
                                    gct.testCfg = gcfg;
                                } else if (reqType == MasterControl.ISCONFIGSUPPORT) {
                                    boolean rval = false;
                                    GraphicsConfiguration gc = (GraphicsConfiguration)gct.testCfg;
                                    try {
                                        if (Pipeline.getPipeline().isGraphicsConfigSupported(gct, gc)) {
                                            rval = true;
                                        }
                                    }
                                    catch (NullPointerException npe) {
                                        npe.printStackTrace();
                                    }
                                    catch (RuntimeException ex) {
                                        ex.printStackTrace();
                                        err2 = new RenderingError(2, J3dI18N.getString("Renderer4"));
                                        err2.setGraphicsDevice(gc.getDevice());
                                        Renderer.notifyErrorListeners(err2);
                                    }
                                    gct.testCfg = rval;
                                }
                                GraphicsConfigTemplate3D.runMonitor(2);
                            }
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    canvas = (Canvas3D)firstArg;
                    int renderType = this.m[this.nmesg].type;
                    if (renderType == 61) {
                        canvas.drawable = null;
                        try {
                            canvas.drawable = canvas.createOffScreenBuffer(null, canvas.offScreenCanvasSize.width, canvas.offScreenCanvasSize.height);
                        }
                        catch (RuntimeException ex) {
                            ex.printStackTrace();
                        }
                        if (canvas.drawable == null) {
                            canvas.setFatalError();
                            RenderingError err3 = new RenderingError(4, J3dI18N.getString("Renderer5"));
                            err3.setCanvas3D(canvas);
                            err3.setGraphicsDevice(canvas.graphicsConfiguration.getDevice());
                            Renderer.notifyErrorListeners(err3);
                        }
                        canvas.offScreenBufferPending = false;
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (renderType == 62) {
                        Object[] obj = this.m[this.nmesg].args;
                        this.removeCtx(canvas, (Drawable)obj[2], (Context)obj[3], false, !canvas.offScreen, true);
                        canvas.offScreenBufferPending = false;
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (renderType == 66) {
                        canvas.allocateCanvasId();
                    } else if (renderType == 67) {
                        canvas.freeCanvasId();
                    }
                    if (canvas.view == null || !canvas.firstPaintCalled) {
                        if (renderType == 42) {
                            canvas.offScreenRendering = false;
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (!canvas.validCanvas && renderType != 42) {
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (renderType == 52) {
                        VirtualUniverse.mc.sendRunMessage(canvas.view, 16);
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (renderType == 53) {
                        VirtualUniverse.mc.sendRunMessage(canvas.view, 16);
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (renderType == 44) {
                        int command = (Integer)this.m[this.nmesg].args[1];
                        if (canvas.isFatalError()) continue;
                        try {
                            switch (command) {
                                case 0: {
                                    canvas.graphicsContext3D.doClear();
                                    break;
                                }
                                case 1: {
                                    canvas.graphicsContext3D.doDraw((Geometry)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 2: {
                                    canvas.doSwap();
                                    break;
                                }
                                case 3: {
                                    canvas.graphicsContext3D.doReadRaster((Raster)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 4: {
                                    canvas.graphicsContext3D.doSetAppearance((Appearance)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 5: {
                                    canvas.graphicsContext3D.doSetBackground((Background)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 6: {
                                    canvas.graphicsContext3D.doSetFog((Fog)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 7: {
                                    canvas.graphicsContext3D.doSetLight((Light)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                    break;
                                }
                                case 8: {
                                    canvas.graphicsContext3D.doInsertLight((Light)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                    break;
                                }
                                case 9: {
                                    canvas.graphicsContext3D.doRemoveLight((Integer)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 10: {
                                    canvas.graphicsContext3D.doAddLight((Light)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 11: {
                                    canvas.graphicsContext3D.doSetHiRes((HiResCoord)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 12: {
                                    t3d = (Transform3D)this.m[this.nmesg].args[2];
                                    canvas.graphicsContext3D.doSetModelTransform(t3d);
                                    break;
                                }
                                case 13: {
                                    t3d = (Transform3D)this.m[this.nmesg].args[2];
                                    canvas.graphicsContext3D.doMultiplyModelTransform(t3d);
                                    break;
                                }
                                case 14: {
                                    canvas.graphicsContext3D.doSetSound((Sound)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                    break;
                                }
                                case 15: {
                                    canvas.graphicsContext3D.doInsertSound((Sound)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                    break;
                                }
                                case 16: {
                                    canvas.graphicsContext3D.doRemoveSound((Integer)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 17: {
                                    canvas.graphicsContext3D.doAddSound((Sound)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 18: {
                                    canvas.graphicsContext3D.doSetAuralAttributes((AuralAttributes)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 19: {
                                    canvas.graphicsContext3D.doSetBufferOverride((Boolean)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 20: {
                                    canvas.graphicsContext3D.doSetFrontBufferRendering((Boolean)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 21: {
                                    canvas.graphicsContext3D.doSetStereoMode((Integer)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 22: {
                                    canvas.graphicsContext3D.doFlush((Boolean)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 23: {
                                    canvas.graphics2D.doFlush();
                                    break;
                                }
                                case 24: {
                                    Object[] ar = this.m[this.nmesg].args;
                                    canvas.graphics2D.doDrawAndFlushImage((BufferedImage)ar[2], ((Point)ar[3]).x, ((Point)ar[3]).y, (ImageObserver)ar[4]);
                                    break;
                                }
                                case 26: {
                                    if (canvas.graphics2D == null) break;
                                    canvas.graphics2D.doDispose();
                                    break;
                                }
                                case 25: {
                                    canvas.graphicsContext3D.doSetModelClip((ModelClip)this.m[this.nmesg].args[2]);
                                    break;
                                }
                            }
                        }
                        catch (RuntimeException ex) {
                            ex.printStackTrace();
                            canvas.setFatalError();
                            RenderingError err4 = new RenderingError(3, J3dI18N.getString("Renderer6"));
                            err4.setCanvas3D(canvas);
                            err4.setGraphicsDevice(canvas.graphicsConfiguration.getDevice());
                            Renderer.notifyErrorListeners(err4);
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    long startRenderTime = 0L;
                    if (MasterControl.isStatsLoggable(Level.INFO)) {
                        startRenderTime = System.nanoTime();
                    }
                    this.m[this.nmesg++].decRefcount();
                    if (canvas.isFatalError()) continue;
                    ImageComponent2DRetained offBufRetained = null;
                    if (renderType == 42) {
                        canvas.offScreenRendering = true;
                        if (canvas.drawable == null || !canvas.active) {
                            canvas.offScreenRendering = false;
                            continue;
                        }
                        offBufRetained = (ImageComponent2DRetained)canvas.offScreenBuffer.retained;
                        if (offBufRetained.isByReference()) {
                            offBufRetained.geomLock.getLock();
                        }
                        offBufRetained.evaluateExtensions(canvas);
                    } else if (!canvas.active) continue;
                    if (!canvas.offScreen) {
                        canvas.drawingSurfaceObject.getDrawingSurfaceObjectInfo();
                    }
                    renderBin = canvas.view.renderBin;
                    if (canvas.useSharedCtx && this.sharedCtx == null) {
                        this.sharedCtxDrawable = canvas.drawable;
                        if (!canvas.drawingSurfaceObject.renderLock()) {
                            if (offBufRetained != null && offBufRetained.isByReference()) {
                                offBufRetained.geomLock.unLock();
                            }
                            canvas.offScreenRendering = false;
                            break;
                        }
                        Object rval = VirtualUniverse.mc.contextCreationLock;
                        synchronized (rval) {
                            this.sharedCtx = null;
                            try {
                                this.sharedCtx = canvas.createNewContext(null, true);
                            }
                            catch (RuntimeException ex) {
                                ex.printStackTrace();
                            }
                            if (this.sharedCtx == null) {
                                canvas.drawingSurfaceObject.unLock();
                                if (offBufRetained != null && offBufRetained.isByReference()) {
                                    offBufRetained.geomLock.unLock();
                                }
                                canvas.offScreenRendering = false;
                                canvas.setFatalError();
                                err = new RenderingError(3, J3dI18N.getString("Renderer7"));
                                err.setCanvas3D(canvas);
                                err.setGraphicsDevice(canvas.graphicsConfiguration.getDevice());
                                Renderer.notifyErrorListeners(err);
                                break;
                            }
                            this.sharedCtxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
                            this.needToRebuildDisplayList = true;
                        }
                        canvas.drawingSurfaceObject.unLock();
                    }
                    if (canvas.ctx == null) {
                        if (!canvas.drawingSurfaceObject.renderLock()) {
                            if (offBufRetained != null && offBufRetained.isByReference()) {
                                offBufRetained.geomLock.unLock();
                            }
                            canvas.offScreenRendering = false;
                            break;
                        }
                        Object rval = VirtualUniverse.mc.contextCreationLock;
                        synchronized (rval) {
                            canvas.ctx = null;
                            try {
                                canvas.ctx = canvas.createNewContext(this.sharedCtx, false);
                            }
                            catch (RuntimeException ex) {
                                ex.printStackTrace();
                            }
                            if (canvas.ctx == null) {
                                canvas.drawingSurfaceObject.unLock();
                                if (offBufRetained != null && offBufRetained.isByReference()) {
                                    offBufRetained.geomLock.unLock();
                                }
                                canvas.offScreenRendering = false;
                                canvas.setFatalError();
                                err = new RenderingError(3, J3dI18N.getString("Renderer7"));
                                err.setCanvas3D(canvas);
                                err.setGraphicsDevice(canvas.graphicsConfiguration.getDevice());
                                Renderer.notifyErrorListeners(err);
                                break;
                            }
                            if (canvas.graphics2D != null) {
                                canvas.graphics2D.init();
                            }
                            canvas.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
                            this.listOfCtxs.add(canvas.ctx);
                            this.listOfCanvases.add(canvas);
                            if (renderBin.nodeComponentList.size() > 0) {
                                for (int i = 0; i < renderBin.nodeComponentList.size(); ++i) {
                                    NodeComponentRetained nc = (NodeComponentRetained)renderBin.nodeComponentList.get(i);
                                    if (!(nc instanceof ImageComponentRetained)) continue;
                                    ((ImageComponentRetained)nc).evaluateExtensions(canvas);
                                }
                            }
                            canvas.enableSeparateSpecularColor();
                        }
                        if (canvas.texUnitState == null) {
                            canvas.createTexUnitState();
                        }
                        canvas.resetImmediateRendering();
                        canvas.drawingSurfaceObject.contextValidated();
                        if (!canvas.useSharedCtx) {
                            canvas.needToRebuildDisplayList = true;
                        }
                        canvas.drawingSurfaceObject.unLock();
                    } else if (canvas.isRunning) {
                        canvas.makeCtxCurrent();
                    }
                    if (renderBin != null) {
                        int stereo_mode;
                        int num_stereo_passes;
                        boolean useStereo;
                        if (VirtualUniverse.mc.doDsiRenderLock && !canvas.drawingSurfaceObject.renderLock()) {
                            if (offBufRetained != null && offBufRetained.isByReference()) {
                                offBufRetained.geomLock.unLock();
                            }
                            canvas.offScreenRendering = false;
                            break;
                        }
                        if (canvas.useSharedCtx) {
                            this.freeResourcesInFreeList(canvas);
                        } else {
                            canvas.freeResourcesInFreeList(canvas.ctx);
                        }
                        if (VirtualUniverse.mc.doDsiRenderLock) {
                            canvas.drawingSurfaceObject.unLock();
                        }
                        CanvasViewCache cvCache = canvas.canvasViewCache;
                        canvas.updateViewCache(false, null, null, renderBin.geometryBackground != null);
                        if (VirtualUniverse.mc.doDsiRenderLock && !canvas.drawingSurfaceObject.renderLock()) {
                            if (offBufRetained != null && offBufRetained.isByReference()) {
                                offBufRetained.geomLock.unLock();
                            }
                            canvas.offScreenRendering = false;
                            break;
                        }
                        int cvWidth = cvCache.getCanvasWidth();
                        int cvHeight = cvCache.getCanvasHeight();
                        canvas.setViewport(canvas.ctx, 0, 0, cvWidth, cvHeight);
                        if (canvas.useSharedCtx) {
                            int sz;
                            if (this.needToRebuildDisplayList) {
                                renderBin.updateAllRenderMolecule(this, canvas);
                                this.needToRebuildDisplayList = false;
                            }
                            if (this.dirtyDisplayList) {
                                renderBin.updateDirtyDisplayLists(canvas, this.dirtyRenderMoleculeList, this.dirtyDlistPerRinfoList, this.dirtyRenderAtomList, true);
                                this.dirtyDisplayList = false;
                            }
                            if ((sz = this.textureReloadList.size()) > 0) {
                                for (int j = sz - 1; j >= 0; --j) {
                                    this.textureReloadList.get(j).reloadTextureSharedContext(canvas);
                                }
                                this.textureReloadList.clear();
                            }
                        } else {
                            if (canvas.needToRebuildDisplayList) {
                                renderBin.updateAllRenderMolecule(canvas);
                                canvas.needToRebuildDisplayList = false;
                            }
                            if (canvas.dirtyDisplayList) {
                                renderBin.updateDirtyDisplayLists(canvas, canvas.dirtyRenderMoleculeList, canvas.dirtyDlistPerRinfoList, canvas.dirtyRenderAtomList, false);
                                canvas.dirtyDisplayList = false;
                            }
                        }
                        if (canvas.view.localEyeLightingEnable != canvas.ctxEyeLightingEnable) {
                            canvas.ctxUpdateEyeLightingEnable(canvas.ctx, canvas.view.localEyeLightingEnable);
                            canvas.ctxEyeLightingEnable = canvas.view.localEyeLightingEnable;
                        }
                        if (useStereo = cvCache.getUseStereo()) {
                            num_stereo_passes = 2;
                            stereo_mode = 0;
                            this.sharedStereoZBuffer = VirtualUniverse.mc.sharedStereoZBuffer;
                        } else {
                            num_stereo_passes = 1;
                            stereo_mode = 2;
                            this.sharedStereoZBuffer = false;
                        }
                        if (canvas.view.getSceneAntialiasingEnable() && canvas.sceneAntialiasingAvailable) {
                            if ((canvas.extensionsSupported & 8) == 0 || !canvas.sceneAntialiasingMultiSamplesAvailable) {
                                doAccum = true;
                                num_accum_passes = 8;
                                System.arraycopy(cvCache.getLeftProjection().mat, 0, this.accumLeftProj.mat, 0, 16);
                                accumDxFactor = canvas.canvasViewCache.getPhysicalWindowWidth() / (double)canvas.canvasViewCache.getCanvasWidth() * canvas.view.fieldOfView;
                                accumDyFactor = canvas.canvasViewCache.getPhysicalWindowHeight() / (double)canvas.canvasViewCache.getCanvasHeight() * canvas.view.fieldOfView;
                                accumLeftX = this.accumLeftProj.mat[3];
                                accumLeftY = this.accumLeftProj.mat[7];
                                if (useStereo) {
                                    System.arraycopy(cvCache.getRightProjection().mat, 0, this.accumRightProj.mat, 0, 16);
                                    accumRightX = this.accumRightProj.mat[3];
                                    accumRightY = this.accumRightProj.mat[7];
                                }
                                if (renderBin.geometryBackground != null) {
                                    System.arraycopy(cvCache.getInfLeftProjection().mat, 0, this.accumInfLeftProj.mat, 0, 16);
                                    accumInfLeftX = this.accumInfLeftProj.mat[3];
                                    accumInfLeftY = this.accumInfLeftProj.mat[7];
                                    if (useStereo) {
                                        System.arraycopy(cvCache.getInfRightProjection().mat, 0, this.accumInfRightProj.mat, 0, 16);
                                        accumInfRightX = this.accumInfRightProj.mat[3];
                                        accumInfRightY = this.accumInfRightProj.mat[7];
                                    }
                                }
                            } else if (!canvas.isAntialiasingSet()) {
                                canvas.setFullSceneAntialiasing(canvas.ctx, true);
                            }
                        } else if (canvas.isAntialiasingSet()) {
                            canvas.setFullSceneAntialiasing(canvas.ctx, false);
                        }
                        if (renderBin.geometryBackground != null) {
                            renderBin.updateInfVworldToVpc();
                        }
                        canvas.setRenderMode(canvas.ctx, 2, canvas.useDoubleBuffer);
                        if (!doAccum && !this.sharedStereoZBuffer) {
                            BackgroundRetained bg = renderBin.background;
                            canvas.clear(bg, cvWidth, cvHeight);
                        }
                        if (VirtualUniverse.mc.doDsiRenderLock) {
                            canvas.drawingSurfaceObject.unLock();
                        }
                        canvas.view.inCanvasCallback = true;
                        try {
                            canvas.preRender();
                        }
                        catch (RuntimeException e) {
                            System.err.println("Exception occurred during Canvas3D callback:");
                            e.printStackTrace();
                        }
                        catch (Error e) {
                            System.err.println("Error occurred during Canvas3D callback:");
                            e.printStackTrace();
                        }
                        canvas.view.inCanvasCallback = false;
                        if (VirtualUniverse.mc.doDsiRenderLock && !canvas.drawingSurfaceObject.renderLock()) {
                            if (offBufRetained != null && offBufRetained.isByReference()) {
                                offBufRetained.geomLock.unLock();
                            }
                            canvas.offScreenRendering = false;
                            break;
                        }
                        for (int pass = 0; pass < num_stereo_passes; ++pass) {
                            if (doAccum) {
                                canvas.clearAccum(canvas.ctx);
                            }
                            canvas.setRenderMode(canvas.ctx, stereo_mode, canvas.useDoubleBuffer);
                            for (int apass = 0; apass < num_accum_passes; ++apass) {
                                Object bg;
                                if (doAccum) {
                                    accumDx = (double)ACCUM_SAMPLES_X[apass] * accumDxFactor;
                                    accumDy = (double)ACCUM_SAMPLES_Y[apass] * accumDyFactor;
                                    this.accumLeftProj.mat[3] = accumLeftX + this.accumLeftProj.mat[0] * accumDx + this.accumLeftProj.mat[1] * accumDy;
                                    this.accumLeftProj.mat[7] = accumLeftY + this.accumLeftProj.mat[4] * accumDx + this.accumLeftProj.mat[5] * accumDy;
                                    if (useStereo) {
                                        this.accumRightProj.mat[3] = accumRightX + this.accumRightProj.mat[0] * accumDx + this.accumRightProj.mat[1] * accumDy;
                                        this.accumRightProj.mat[7] = accumRightY + this.accumRightProj.mat[4] * accumDx + this.accumRightProj.mat[5] * accumDy;
                                    }
                                    if (renderBin.geometryBackground != null) {
                                        this.accumInfLeftProj.mat[3] = accumInfLeftX + this.accumInfLeftProj.mat[0] * accumDx + this.accumInfLeftProj.mat[1] * accumDy;
                                        this.accumInfLeftProj.mat[7] = accumInfLeftY + this.accumInfLeftProj.mat[4] * accumDx + this.accumInfLeftProj.mat[5] * accumDy;
                                        if (useStereo) {
                                            this.accumInfRightProj.mat[3] = accumInfRightX + this.accumInfRightProj.mat[0] * accumDx + this.accumInfRightProj.mat[1] * accumDy;
                                            this.accumInfRightProj.mat[7] = accumInfRightY + this.accumInfRightProj.mat[4] * accumDx + this.accumInfRightProj.mat[5] * accumDy;
                                        }
                                    }
                                }
                                if (doAccum || this.sharedStereoZBuffer) {
                                    bg = renderBin.background;
                                    canvas.clear((BackgroundRetained)bg, cvWidth, cvHeight);
                                }
                                if (renderBin.geometryBackground != null) {
                                    if (pass == 0) {
                                        canvas.vpcToEc = cvCache.getInfLeftVpcToEc();
                                        if (doAccum) {
                                            canvas.setProjectionMatrix(canvas.ctx, this.accumInfLeftProj);
                                        } else {
                                            canvas.setProjectionMatrix(canvas.ctx, cvCache.getInfLeftProjection());
                                        }
                                    } else {
                                        canvas.vpcToEc = cvCache.getInfRightVpcToEc();
                                        if (doAccum) {
                                            canvas.setProjectionMatrix(canvas.ctx, this.accumInfRightProj);
                                        } else {
                                            canvas.setProjectionMatrix(canvas.ctx, cvCache.getInfRightProjection());
                                        }
                                    }
                                    canvas.vworldToEc.mul(canvas.vpcToEc, cvCache.getInfVworldToVpc());
                                    renderBin.renderBackground(canvas);
                                }
                                if (pass == 0) {
                                    canvas.vpcToEc = cvCache.getLeftVpcToEc();
                                    if (doAccum) {
                                        canvas.setProjectionMatrix(canvas.ctx, this.accumLeftProj);
                                    } else {
                                        canvas.setProjectionMatrix(canvas.ctx, cvCache.getLeftProjection());
                                    }
                                } else {
                                    canvas.vpcToEc = cvCache.getRightVpcToEc();
                                    if (doAccum) {
                                        canvas.setProjectionMatrix(canvas.ctx, this.accumRightProj);
                                    } else {
                                        canvas.setProjectionMatrix(canvas.ctx, cvCache.getRightProjection());
                                    }
                                }
                                canvas.vworldToEc.mul(canvas.vpcToEc, cvCache.getVworldToVpc());
                                bg = cvCache;
                                synchronized (bg) {
                                    if (pass == 0) {
                                        canvas.setFrustumPlanes(cvCache.getLeftFrustumPlanesInVworld());
                                    } else {
                                        canvas.setFrustumPlanes(cvCache.getRightFrustumPlanesInVworld());
                                    }
                                }
                                if (useStereo) {
                                    canvas.canvasDirty |= 0x8000;
                                }
                                renderBin.renderOpaque(canvas);
                                renderBin.renderOrdered(canvas);
                                if (VirtualUniverse.mc.doDsiRenderLock) {
                                    canvas.drawingSurfaceObject.unLock();
                                }
                                canvas.view.inCanvasCallback = true;
                                try {
                                    canvas.renderField(stereo_mode);
                                }
                                catch (RuntimeException e) {
                                    System.err.println("Exception occurred during Canvas3D callback:");
                                    e.printStackTrace();
                                }
                                catch (Error e) {
                                    System.err.println("Error occurred during Canvas3D callback:");
                                    e.printStackTrace();
                                }
                                canvas.view.inCanvasCallback = false;
                                if (VirtualUniverse.mc.doDsiRenderLock && !canvas.drawingSurfaceObject.renderLock()) {
                                    if (offBufRetained != null && offBufRetained.isByReference()) {
                                        offBufRetained.geomLock.unLock();
                                    }
                                    canvas.offScreenRendering = false;
                                    break block81;
                                }
                                renderBin.renderTransparent(canvas);
                                if (!doAccum) continue;
                                canvas.accum(canvas.ctx, 0.125f);
                            }
                            if (doAccum) {
                                canvas.accumReturn(canvas.ctx);
                            }
                            if (!useStereo) continue;
                            stereo_mode = 1;
                            canvas.rightStereoPass = true;
                        }
                        canvas.imageReady = true;
                        canvas.rightStereoPass = false;
                        canvas.setRenderMode(canvas.ctx, 2, canvas.useDoubleBuffer);
                        if (VirtualUniverse.mc.doDsiRenderLock) {
                            canvas.drawingSurfaceObject.unLock();
                        }
                        canvas.view.inCanvasCallback = true;
                        try {
                            canvas.postRender();
                        }
                        catch (RuntimeException e) {
                            System.err.println("Exception occurred during Canvas3D callback:");
                            e.printStackTrace();
                        }
                        catch (Error e) {
                            System.err.println("Error occurred during Canvas3D callback:");
                            e.printStackTrace();
                        }
                        canvas.view.inCanvasCallback = false;
                        if (canvas.offScreenRendering) {
                            canvas.syncRender(canvas.ctx, true);
                            canvas.endOffScreenRendering();
                            canvas.offScreenRendering = false;
                            if (canvas.manualRendering) {
                                canvas.view.inCanvasCallback = true;
                                try {
                                    canvas.postSwap();
                                }
                                catch (RuntimeException e) {
                                    System.err.println("Exception occurred during Canvas 3D callback:");
                                    e.printStackTrace();
                                }
                                catch (Error e) {
                                    System.err.println("Error occurred during Canvas3D callback:");
                                    e.printStackTrace();
                                }
                                if (offBufRetained.isByReference()) {
                                    offBufRetained.geomLock.unLock();
                                }
                                canvas.view.inCanvasCallback = false;
                                canvas.releaseCtx();
                            }
                        }
                        if (!MasterControl.isStatsLoggable(Level.INFO)) continue;
                        long deltaTime = System.nanoTime() - startRenderTime;
                        VirtualUniverse.mc.recordTime(MasterControl.TimeType.RENDER, deltaTime);
                        continue;
                    }
                    if (offBufRetained == null || !offBufRetained.isByReference()) continue;
                    offBufRetained.geomLock.unLock();
                }
                if (opArg == 0) {
                    this.m[0] = null;
                } else {
                    Arrays.fill(this.m, 0, totalMessages, null);
                }
            }
            catch (NullPointerException ne) {
                ne.printStackTrace();
                if (canvas != null) {
                    canvas.drawingSurfaceObject.unLock();
                }
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                if (canvas != null) {
                    canvas.drawingSurfaceObject.unLock();
                }
                canvas.setFatalError();
                RenderingError err = new RenderingError(1, J3dI18N.getString("Renderer8"));
                err.setCanvas3D(canvas);
                err.setGraphicsDevice(canvas.graphicsConfiguration.getDevice());
                Renderer.notifyErrorListeners(err);
            }
        }
    }

    @Override
    void shutdown() {
        this.removeAllCtxs();
    }

    @Override
    void cleanup() {
        super.cleanup();
        this.renderMessage = new J3dMessage[1];
        this.rendererStructure = new RendererStructure();
        this.bgVworldToVpc = new Transform3D();
        this.sharedCtx = null;
        this.sharedCtxTimeStamp = 0L;
        this.sharedCtxDrawable = null;
        this.dirtyRenderMoleculeList.clear();
        this.dirtyRenderAtomList.clear();
        this.dirtyDlistPerRinfoList.clear();
        this.textureIdResourceFreeList.clear();
        this.displayListResourceFreeList.clear();
        this.onScreen = null;
        this.offScreen = null;
        this.m = null;
        this.nmesg = 0;
    }

    final void makeCtxCurrent(Context sharedCtx, Drawable drawable) {
        if (sharedCtx != this.currentCtx || drawable != this.currentDrawable) {
            Canvas3D.useCtx(sharedCtx, drawable);
            this.currentCtx = sharedCtx;
            this.currentDrawable = drawable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCtx(Canvas3D cv, Drawable drawable, Context ctx, boolean resetCtx, boolean freeBackground, boolean destroyOffScreenBuffer) {
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            if (ctx != null) {
                int idx = this.listOfCtxs.indexOf(ctx);
                if (idx >= 0) {
                    this.listOfCtxs.remove(idx);
                    this.listOfCanvases.remove(idx);
                    if (drawable != null && cv.added && cv.drawingSurfaceObject.renderLock()) {
                        if (this.sharedCtx != null) {
                            if (this.listOfCtxs.isEmpty()) {
                                this.makeCtxCurrent(this.sharedCtx, this.sharedCtxDrawable);
                                this.freeResourcesInFreeList(null);
                                this.freeContextResources();
                                Canvas3D.destroyContext(this.sharedCtxDrawable, this.sharedCtx);
                                this.currentCtx = null;
                                this.currentDrawable = null;
                            } else {
                                this.freeResourcesInFreeList(cv);
                            }
                            cv.makeCtxCurrent(ctx, drawable);
                        } else {
                            cv.makeCtxCurrent(ctx, drawable);
                            cv.freeResourcesInFreeList(ctx);
                        }
                        cv.freeContextResources(this, freeBackground, ctx);
                        Canvas3D.destroyContext(drawable, ctx);
                        this.currentCtx = null;
                        this.currentDrawable = null;
                        cv.drawingSurfaceObject.unLock();
                    }
                }
                if (resetCtx) {
                    cv.ctx = null;
                }
                if (this.sharedCtx != null && this.listOfCtxs.isEmpty()) {
                    this.sharedCtx = null;
                    this.sharedCtxTimeStamp = 0L;
                }
                cv.ctxTimeStamp = 0L;
            }
            if (destroyOffScreenBuffer) {
                cv.destroyOffScreenBuffer(ctx, drawable);
                cv.offScreenBufferPending = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllCtxs() {
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            for (int i = this.listOfCanvases.size() - 1; i >= 0; --i) {
                Canvas3D cv = this.listOfCanvases.get(i);
                if (cv.screen != null && cv.ctx != null && cv.drawable != null && cv.added && cv.drawingSurfaceObject.renderLock()) {
                    if (i == 0 && this.sharedCtx != null) {
                        this.makeCtxCurrent(this.sharedCtx, this.sharedCtxDrawable);
                        this.freeResourcesInFreeList(null);
                        this.freeContextResources();
                        Canvas3D.destroyContext(this.sharedCtxDrawable, this.sharedCtx);
                        this.currentCtx = null;
                        this.currentDrawable = null;
                    }
                    cv.makeCtxCurrent();
                    cv.freeResourcesInFreeList(cv.ctx);
                    cv.freeContextResources(this, true, cv.ctx);
                    Canvas3D.destroyContext(cv.drawable, cv.ctx);
                    this.currentCtx = null;
                    this.currentDrawable = null;
                    cv.drawingSurfaceObject.unLock();
                }
                cv.ctx = null;
                cv.ctxTimeStamp = 0L;
            }
            if (this.sharedCtx != null) {
                this.sharedCtx = null;
                this.sharedCtxTimeStamp = 0L;
            }
            this.listOfCanvases.clear();
            this.listOfCtxs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeResourcesInFreeList(Canvas3D cv) {
        boolean isFreeDL;
        boolean isFreeTex = this.textureIdResourceFreeList.size() > 0;
        boolean bl = isFreeDL = this.displayListResourceFreeList.size() > 0;
        if (isFreeTex || isFreeDL) {
            if (cv != null) {
                cv.makeCtxCurrent(this.sharedCtx);
            }
            if (isFreeDL) {
                for (int val : this.displayListResourceFreeList) {
                    if (val <= 0) continue;
                    Canvas3D.freeDisplayList(this.sharedCtx, val);
                }
                this.displayListResourceFreeList.clear();
            }
            if (isFreeTex) {
                for (int val : this.textureIdResourceFreeList) {
                    if (val <= 0) continue;
                    if (val >= this.textureIDResourceTable.size()) {
                        MasterControl.getCoreLogger().severe("Error in freeResourcesInFreeList : ResourceIDTableSize = " + this.textureIDResourceTable.size() + " val = " + val);
                    } else {
                        TextureRetained tex = this.textureIDResourceTable.get(val);
                        if (tex != null) {
                            Object object = tex.resourceLock;
                            synchronized (object) {
                                tex.resourceCreationMask &= ~this.rendererBit;
                                if (tex.resourceCreationMask == 0) {
                                    tex.freeTextureId(val);
                                }
                            }
                        }
                        this.textureIDResourceTable.set(val, null);
                    }
                    Canvas3D.freeTexture(this.sharedCtx, val);
                }
                this.textureIdResourceFreeList.clear();
            }
            if (cv != null) {
                cv.makeCtxCurrent(cv.ctx);
            }
        }
    }

    final void addTextureResource(int id, TextureRetained obj) {
        if (this.textureIDResourceTable.size() <= id) {
            for (int i = this.textureIDResourceTable.size(); i < id; ++i) {
                this.textureIDResourceTable.add(null);
            }
            this.textureIDResourceTable.add(obj);
        } else {
            this.textureIDResourceTable.set(id, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeContextResources() {
        for (int id = this.textureIDResourceTable.size() - 1; id >= 0; --id) {
            TextureRetained tex = this.textureIDResourceTable.get(id);
            if (tex == null) continue;
            Canvas3D.freeTexture(this.sharedCtx, id);
            Object object = tex.resourceLock;
            synchronized (object) {
                tex.resourceCreationMask &= ~this.rendererBit;
                if (tex.resourceCreationMask == 0) {
                    tex.freeTextureId(id);
                }
                continue;
            }
        }
        this.textureIDResourceTable.clear();
    }

    static void notifyErrorListeners(RenderingError err) {
        J3dNotification notification = new J3dNotification();
        notification.type = 1;
        notification.universe = null;
        notification.args[0] = err;
        VirtualUniverse.mc.sendNotification(notification);
    }

    static synchronized RenderingErrorListener getDefaultErrorListener() {
        if (defaultErrorListener == null) {
            defaultErrorListener = new DefaultErrorListener();
        }
        return defaultErrorListener;
    }

    static class DefaultErrorListener
    implements RenderingErrorListener {
        DefaultErrorListener() {
        }

        @Override
        public void errorOccurred(RenderingError error) {
            System.err.println();
            System.err.println("DefaultRenderingErrorListener.errorOccurred:");
            error.printVerbose();
            System.exit(1);
        }
    }
}

