/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ClipRetained;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.View;
import javax.media.j3d.ViewSpecificGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Vector3d;

class RenderingEnvironmentStructure
extends J3dStructure
implements ObjectUpdate {
    ArrayList<LightRetained> nonViewScopedLights = new ArrayList();
    HashMap<View, ArrayList<LightRetained>> viewScopedLights = new HashMap();
    int numberOfLights = 0;
    ArrayList<FogRetained> nonViewScopedFogs = new ArrayList();
    HashMap<View, ArrayList<FogRetained>> viewScopedFogs = new HashMap();
    int numberOfFogs = 0;
    ArrayList<AlternateAppearanceRetained> nonViewScopedAltAppearances = new ArrayList();
    HashMap<View, ArrayList<AlternateAppearanceRetained>> viewScopedAltAppearances = new HashMap();
    int numberOfAltApps = 0;
    ArrayList<ModelClipRetained> nonViewScopedModelClips = new ArrayList();
    HashMap<View, ArrayList<ModelClipRetained>> viewScopedModelClips = new HashMap();
    int numberOfModelClips = 0;
    ArrayList<BackgroundRetained> nonViewScopedBackgrounds = new ArrayList();
    HashMap<View, ArrayList<BackgroundRetained>> viewScopedBackgrounds = new HashMap();
    int numberOfBgs = 0;
    ArrayList<ClipRetained> nonViewScopedClips = new ArrayList();
    HashMap<View, ArrayList<ClipRetained>> viewScopedClips = new HashMap();
    int numberOfClips = 0;
    BackgroundRetained[] intersectedBacks = new BackgroundRetained[1];
    ClipRetained[] intersectedClips = new ClipRetained[1];
    Bounds[] intersectedBounds = new Bounds[1];
    Transform3D localeXform = new Transform3D();
    Vector3d localeTranslation = new Vector3d();
    FogRetained[] intersectedFogs = new FogRetained[1];
    AlternateAppearanceRetained[] intersectedAltApps = new AlternateAppearanceRetained[1];
    ModelClipRetained[] intersectedModelClips = new ModelClipRetained[1];
    double backClipDistance;
    ArrayList<Object[]> objList = new ArrayList();
    ArrayList<LeafRetained> xformChangeList = new ArrayList();
    private final ArrayList<Object[]> objFreeList = new ArrayList();
    LightRetained[] retlights = new LightRetained[5];
    boolean transformMsg = false;
    UpdateTargets targets = null;
    ArrayList blUsers = null;
    Integer ogInsert = new Integer(32);
    Integer ogRemove = new Integer(33);
    Object lockObj = new Object();

    RenderingEnvironmentStructure(VirtualUniverse u) {
        super(u, 4096);
    }

    Object[] getObjectArray() {
        int size = this.objFreeList.size();
        if (size == 0) {
            return new Object[5];
        }
        return this.objFreeList.remove(size - 1);
    }

    void addObjArrayToFreeList(Object[] objs) {
        Arrays.fill(objs, null);
        this.objFreeList.add(objs);
    }

    @Override
    public void updateObject() {
        int i;
        int size = this.objList.size();
        for (i = 0; i < size; ++i) {
            Object[] args = this.objList.get(i);
            LeafRetained leaf = (LeafRetained)args[0];
            leaf.updateMirrorObject(args);
            this.addObjArrayToFreeList(args);
        }
        this.objList.clear();
        size = this.xformChangeList.size();
        for (i = 0; i < size; ++i) {
            this.xformChangeList.get(i).updateTransformChange();
        }
        this.xformChangeList.clear();
    }

    @Override
    void processMessages(long referenceTime) {
        Object[] messages = this.getMessages(referenceTime);
        int nMsg = this.getNumMessage();
        if (nMsg <= 0) {
            return;
        }
        for (int i = 0; i < nMsg; ++i) {
            J3dMessage m = messages[i];
            switch (m.type) {
                case 0: {
                    this.insertNodes(m);
                    break;
                }
                case 1: {
                    this.removeNodes(m);
                    break;
                }
                case 19: {
                    this.updateLight(m.args);
                    break;
                }
                case 23: {
                    this.updateBoundingLeaf(m.args);
                    break;
                }
                case 22: {
                    this.updateFog(m.args);
                    break;
                }
                case 41: {
                    this.updateAltApp(m.args);
                    break;
                }
                case 24: {
                    this.updateShape3D(m.args);
                    break;
                }
                case 46: {
                    this.updateOrientedShape3D(m.args);
                    break;
                }
                case 16: {
                    this.updateMorph(m.args);
                    break;
                }
                case 3: {
                    this.transformMsg = true;
                    break;
                }
                case 27: {
                    this.processSwitchChanged(m);
                    if (!this.universe.transformStructure.getLazyUpdate()) break;
                    this.transformMsg = true;
                    break;
                }
                case 36: {
                    this.updateModelClip(m.args);
                    break;
                }
                case 20: {
                    this.updateBackground(m.args);
                    break;
                }
                case 21: {
                    this.updateClip(m.args);
                    break;
                }
                case 32: {
                    this.updateOrderedGroupInserted(m);
                    break;
                }
                case 33: {
                    this.updateOrderedGroupsRemoved(m);
                    break;
                }
                case 56: {
                    this.updateViewSpecificGroupChanged(m);
                    break;
                }
                case 57: {
                    this.initViewSpecificInfo(m);
                    break;
                }
                case 58: {
                    this.clearViewSpecificInfo(m);
                }
            }
            m.decRefcount();
        }
        if (this.transformMsg) {
            this.updateTransformChange();
            this.transformMsg = false;
        }
        VirtualUniverse.mc.addMirrorObject(this);
        Arrays.fill(messages, 0, nMsg, null);
    }

    void updateOrderedGroupInserted(J3dMessage m) {
        Object[] ogList = (Object[])m.args[0];
        Object[] ogChildIdList = (Object[])m.args[1];
        Object[] ogOrderedIdList = (Object[])m.args[2];
        for (int n = 0; n < ogList.length; ++n) {
            OrderedGroupRetained og = (OrderedGroupRetained)ogList[n];
            og.updateChildIdTableInserted((Integer)ogChildIdList[n], (Integer)ogOrderedIdList[n]);
            og.incrChildCount();
        }
    }

    void updateOrderedGroupsRemoved(J3dMessage m) {
        Object[] ogList = (Object[])m.args[0];
        Object[] ogChildIdList = (Object[])m.args[1];
        for (int n = 0; n < ogList.length; ++n) {
            OrderedGroupRetained og = (OrderedGroupRetained)ogList[n];
            og.updateChildIdTableRemoved((Integer)ogChildIdList[n]);
            og.decrChildCount();
        }
    }

    void processSwitchChanged(J3dMessage m) {
        UpdateTargets targets = (UpdateTargets)m.args[0];
        UnorderList arrList = targets.targetList[5];
        if (arrList != null) {
            Object[] objArr = (Object[])m.args[1];
            int size = arrList.size();
            Object[] nodesArr = arrList.toArray(false);
            for (int h = 0; h < size; ++h) {
                Object[] nodes = (Object[])nodesArr[h];
                Object[] obj = (Object[])objArr[h];
                for (int i = 0; i < nodes.length; ++i) {
                    Object[] users = (Object[])obj[i];
                    BoundingLeafRetained mbleaf = (BoundingLeafRetained)nodes[i];
                    for (int j = 0; j < users.length; ++j) {
                        LeafRetained leaf = (LeafRetained)users[j];
                        if (!(leaf instanceof FogRetained) && !(leaf instanceof LightRetained) && !(leaf instanceof ModelClipRetained) && !(leaf instanceof ClipRetained) && !(leaf instanceof AlternateAppearanceRetained) && !(leaf instanceof BackgroundRetained)) continue;
                        leaf.updateBoundingLeaf();
                    }
                }
            }
        }
    }

    void insertNodes(J3dMessage m) {
        int i;
        Object[] nodes = (Object[])m.args[0];
        ArrayList viewScopedNodes = (ArrayList)m.args[3];
        ArrayList scopedNodesViewList = (ArrayList)m.args[4];
        for (i = 0; i < nodes.length; ++i) {
            Object n = nodes[i];
            if (n instanceof LightRetained) {
                LightRetained lt = (LightRetained)n;
                ++this.numberOfLights;
                if (lt.inBackgroundGroup) {
                    lt.geometryBackground.lights.add(lt);
                    continue;
                }
                this.nonViewScopedLights.add(lt);
                continue;
            }
            if (n instanceof FogRetained) {
                FogRetained fg = (FogRetained)n;
                ++this.numberOfFogs;
                if (fg.inBackgroundGroup) {
                    fg.geometryBackground.fogs.add(fg);
                    continue;
                }
                this.nonViewScopedFogs.add(fg);
                continue;
            }
            if (n instanceof AlternateAppearanceRetained) {
                AlternateAppearanceRetained altApp = (AlternateAppearanceRetained)n;
                ++this.numberOfAltApps;
                this.nonViewScopedAltAppearances.add(altApp);
                continue;
            }
            if (n instanceof BackgroundRetained) {
                BackgroundRetained bg = (BackgroundRetained)n;
                ++this.numberOfBgs;
                this.nonViewScopedBackgrounds.add(bg);
                continue;
            }
            if (n instanceof ClipRetained) {
                ClipRetained cl = (ClipRetained)n;
                ++this.numberOfClips;
                this.nonViewScopedClips.add(cl);
                continue;
            }
            if (!(n instanceof ModelClipRetained)) continue;
            ModelClipRetained mc = (ModelClipRetained)n;
            ++this.numberOfModelClips;
            this.nonViewScopedModelClips.add(mc);
        }
        if (viewScopedNodes != null) {
            int size = viewScopedNodes.size();
            for (i = 0; i < size; ++i) {
                ArrayList<LeafRetained> list;
                View view;
                int k;
                int vlsize;
                NodeRetained n = (NodeRetained)viewScopedNodes.get(i);
                ArrayList vl = (ArrayList)scopedNodesViewList.get(i);
                if (n instanceof LightRetained) {
                    LightRetained lt = (LightRetained)n;
                    lt.isViewScoped = true;
                    ++this.numberOfLights;
                    vlsize = vl.size();
                    for (k = 0; k < vlsize; ++k) {
                        view = (View)vl.get(k);
                        list = this.viewScopedLights.get(view);
                        if (list == null) {
                            list = new ArrayList();
                            this.viewScopedLights.put(view, list);
                        }
                        list.add(lt);
                    }
                    continue;
                }
                if (n instanceof FogRetained) {
                    FogRetained ft = (FogRetained)n;
                    ft.isViewScoped = true;
                    ++this.numberOfFogs;
                    vlsize = vl.size();
                    for (k = 0; k < vlsize; ++k) {
                        view = (View)vl.get(k);
                        list = this.viewScopedFogs.get(view);
                        if (list == null) {
                            list = new ArrayList();
                            this.viewScopedFogs.put(view, list);
                        }
                        list.add((LightRetained)((Object)ft));
                    }
                    continue;
                }
                if (n instanceof AlternateAppearanceRetained) {
                    AlternateAppearanceRetained aart = (AlternateAppearanceRetained)n;
                    aart.isViewScoped = true;
                    ++this.numberOfAltApps;
                    vlsize = vl.size();
                    for (k = 0; k < vlsize; ++k) {
                        view = (View)vl.get(k);
                        list = this.viewScopedAltAppearances.get(view);
                        if (list == null) {
                            list = new ArrayList();
                            this.viewScopedAltAppearances.put(view, list);
                        }
                        list.add((LightRetained)((Object)aart));
                    }
                    continue;
                }
                if (n instanceof BackgroundRetained) {
                    BackgroundRetained bt = (BackgroundRetained)n;
                    bt.isViewScoped = true;
                    ++this.numberOfBgs;
                    vlsize = vl.size();
                    for (k = 0; k < vlsize; ++k) {
                        view = (View)vl.get(k);
                        list = this.viewScopedBackgrounds.get(view);
                        if (list == null) {
                            list = new ArrayList();
                            this.viewScopedBackgrounds.put(view, list);
                        }
                        list.add((LightRetained)((Object)bt));
                    }
                    continue;
                }
                if (n instanceof ClipRetained) {
                    ClipRetained ct = (ClipRetained)n;
                    ct.isViewScoped = true;
                    ++this.numberOfClips;
                    vlsize = vl.size();
                    for (k = 0; k < vlsize; ++k) {
                        view = (View)vl.get(k);
                        list = this.viewScopedClips.get(view);
                        if (list == null) {
                            list = new ArrayList();
                            this.viewScopedClips.put(view, list);
                        }
                        list.add((LightRetained)((Object)ct));
                    }
                    continue;
                }
                if (!(n instanceof ModelClipRetained)) continue;
                ModelClipRetained mt = (ModelClipRetained)n;
                mt.isViewScoped = true;
                ++this.numberOfModelClips;
                vlsize = vl.size();
                for (k = 0; k < vlsize; ++k) {
                    view = (View)vl.get(k);
                    list = this.viewScopedModelClips.get(view);
                    if (list == null) {
                        list = new ArrayList();
                        this.viewScopedModelClips.put(view, list);
                    }
                    list.add((LightRetained)((Object)mt));
                }
            }
        }
        if (this.numberOfLights > this.retlights.length) {
            this.retlights = new LightRetained[this.numberOfLights];
        }
        if (this.intersectedFogs.length < this.numberOfFogs) {
            this.intersectedFogs = new FogRetained[this.numberOfFogs];
        }
        if (this.intersectedAltApps.length < this.numberOfAltApps) {
            this.intersectedAltApps = new AlternateAppearanceRetained[this.numberOfAltApps];
        }
        if (this.intersectedBacks.length < this.numberOfBgs) {
            this.intersectedBacks = new BackgroundRetained[this.numberOfBgs];
        }
        if (this.intersectedClips.length < this.numberOfClips) {
            this.intersectedClips = new ClipRetained[this.numberOfClips];
        }
        if (this.intersectedModelClips.length < this.numberOfModelClips) {
            this.intersectedModelClips = new ModelClipRetained[this.numberOfModelClips];
        }
    }

    @Override
    void removeNodes(J3dMessage m) {
        int i;
        Object[] nodes = (Object[])m.args[0];
        ArrayList viewScopedNodes = (ArrayList)m.args[3];
        ArrayList scopedNodesViewList = (ArrayList)m.args[4];
        Shape3DRetained oldsrc = null;
        for (i = 0; i < nodes.length; ++i) {
            Object n = nodes[i];
            if (n instanceof LightRetained) {
                LightRetained lt = (LightRetained)n;
                if (lt.inBackgroundGroup) {
                    lt.geometryBackground.lights.remove(lt);
                } else {
                    this.nonViewScopedLights.remove(lt);
                }
                --this.numberOfLights;
                continue;
            }
            if (n instanceof FogRetained) {
                --this.numberOfFogs;
                FogRetained fg = (FogRetained)n;
                if (fg.inBackgroundGroup) {
                    fg.geometryBackground.fogs.remove(fg);
                    continue;
                }
                this.nonViewScopedFogs.remove(this.nonViewScopedFogs.indexOf(n));
                continue;
            }
            if (n instanceof AlternateAppearanceRetained) {
                --this.numberOfAltApps;
                this.nonViewScopedAltAppearances.remove(this.nonViewScopedAltAppearances.indexOf(n));
                continue;
            }
            if (n instanceof BackgroundRetained) {
                --this.numberOfBgs;
                this.nonViewScopedBackgrounds.remove(this.nonViewScopedBackgrounds.indexOf(n));
                continue;
            }
            if (n instanceof ClipRetained) {
                --this.numberOfClips;
                this.nonViewScopedClips.remove(this.nonViewScopedClips.indexOf(n));
                continue;
            }
            if (n instanceof ModelClipRetained) {
                ModelClipRetained mc = (ModelClipRetained)n;
                --this.numberOfModelClips;
                this.nonViewScopedModelClips.remove(mc);
                continue;
            }
            if (n instanceof GeometryAtom) {
                GeometryAtom ga = (GeometryAtom)n;
                if (ga.source == oldsrc) continue;
                ga.source.clearMirrorShape();
                oldsrc = ga.source;
                continue;
            }
            if (!(n instanceof OrderedGroupRetained)) continue;
            ((OrderedGroupRetained)n).clearDerivedDataStructures();
        }
        if (viewScopedNodes != null) {
            int size = viewScopedNodes.size();
            for (i = 0; i < size; ++i) {
                ArrayList<LeafRetained> list;
                View view;
                int k;
                int vlsize;
                NodeRetained n = (NodeRetained)viewScopedNodes.get(i);
                ArrayList vl = (ArrayList)scopedNodesViewList.get(i);
                if (n instanceof LightRetained) {
                    LightRetained lt = (LightRetained)n;
                    lt.isViewScoped = false;
                    --this.numberOfLights;
                    vlsize = vl.size();
                    for (k = 0; k < vlsize; ++k) {
                        view = (View)vl.get(k);
                        list = this.viewScopedLights.get(view);
                        list.remove(lt);
                        if (list.size() != 0) continue;
                        this.viewScopedLights.remove(view);
                    }
                    continue;
                }
                if (n instanceof FogRetained) {
                    FogRetained ft = (FogRetained)n;
                    ft.isViewScoped = false;
                    --this.numberOfFogs;
                    vlsize = vl.size();
                    for (k = 0; k < vlsize; ++k) {
                        view = (View)vl.get(k);
                        list = this.viewScopedFogs.get(view);
                        list.remove(ft);
                        if (list.size() != 0) continue;
                        this.viewScopedFogs.remove(view);
                    }
                    continue;
                }
                if (n instanceof AlternateAppearanceRetained) {
                    AlternateAppearanceRetained aart = (AlternateAppearanceRetained)n;
                    aart.isViewScoped = false;
                    --this.numberOfAltApps;
                    vlsize = vl.size();
                    for (k = 0; k < vlsize; ++k) {
                        view = (View)vl.get(k);
                        list = this.viewScopedAltAppearances.get(view);
                        list.remove(aart);
                        if (list.size() != 0) continue;
                        this.viewScopedAltAppearances.remove(view);
                    }
                    continue;
                }
                if (n instanceof BackgroundRetained) {
                    BackgroundRetained bt = (BackgroundRetained)n;
                    bt.isViewScoped = false;
                    --this.numberOfBgs;
                    vlsize = vl.size();
                    for (k = 0; k < vlsize; ++k) {
                        view = (View)vl.get(k);
                        list = this.viewScopedBackgrounds.get(view);
                        list.remove(bt);
                        if (list.size() != 0) continue;
                        this.viewScopedBackgrounds.remove(view);
                    }
                    continue;
                }
                if (n instanceof ClipRetained) {
                    ClipRetained ct = (ClipRetained)n;
                    ct.isViewScoped = false;
                    --this.numberOfClips;
                    vlsize = vl.size();
                    for (k = 0; k < vlsize; ++k) {
                        view = (View)vl.get(k);
                        list = this.viewScopedClips.get(view);
                        list.remove(ct);
                        if (list.size() != 0) continue;
                        this.viewScopedClips.remove(view);
                    }
                    continue;
                }
                if (!(n instanceof ModelClipRetained)) continue;
                ModelClipRetained mt = (ModelClipRetained)n;
                mt.isViewScoped = false;
                --this.numberOfModelClips;
                vlsize = vl.size();
                for (k = 0; k < vlsize; ++k) {
                    view = (View)vl.get(k);
                    list = this.viewScopedModelClips.get(view);
                    list.remove(mt);
                    if (list.size() != 0) continue;
                    this.viewScopedModelClips.remove(view);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LightRetained[] getInfluencingLights(RenderAtom ra, View view) {
        LightRetained[] lightAry = null;
        LightRetained[] lightRetainedArray = this.retlights;
        synchronized (this.retlights) {
            int i;
            ArrayList<LightRetained> globalLights;
            int numLights = 0;
            if (ra.geometryAtom.source.inBackgroundGroup) {
                globalLights = ra.geometryAtom.source.geometryBackground.lights;
                numLights = this.processLights(globalLights, ra, numLights);
            } else {
                globalLights = this.viewScopedLights.get(view);
                if (globalLights != null) {
                    numLights = this.processLights(globalLights, ra, numLights);
                }
                numLights = this.processLights(this.nonViewScopedLights, ra, numLights);
            }
            boolean newLights = false;
            if (ra.lights != null && ra.lights.length == numLights) {
                for (i = 0; i < ra.lights.length; ++i) {
                    int j;
                    for (j = 0; j < numLights && ra.lights[i] != this.retlights[j]; ++j) {
                    }
                    if (j != numLights) continue;
                    newLights = true;
                    break;
                }
            } else {
                newLights = true;
            }
            if (newLights) {
                lightAry = new LightRetained[numLights];
                for (i = 0; i < numLights; ++i) {
                    lightAry[i] = this.retlights[i];
                }
                // ** MonitorExit[var6_4] (shouldn't be in output)
                return lightAry;
            }
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return ra.lights;
        }
    }

    private int processLights(ArrayList<LightRetained> globalLights, RenderAtom ra, int numLights) {
        BoundingBox bounds = ra.localeVwcBounds;
        int size = globalLights.size();
        if (size > 0) {
            block0: for (int i = 0; i < size; ++i) {
                LightRetained light = globalLights.get(i);
                if (!light.lightOn || !light.switchState.currentSwitchOn || !ra.geometryAtom.source.inBackgroundGroup && !((Bounds)bounds).intersect(light.region)) continue;
                int n = ra.geometryAtom.source.numlights;
                LightRetained[] shapeScopedLt = ra.geometryAtom.source.lights;
                if (light.isScoped) {
                    for (int j = 0; j < n; ++j) {
                        if (light != shapeScopedLt[j]) continue;
                        this.retlights[numLights++] = light;
                        continue block0;
                    }
                    continue;
                }
                this.retlights[numLights++] = light;
            }
        }
        return numLights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FogRetained getInfluencingFog(RenderAtom ra, View view) {
        FogRetained fog = null;
        Object object = this.lockObj;
        synchronized (object) {
            block10: {
                BoundingBox bounds;
                int nfogs;
                block9: {
                    nfogs = 0;
                    bounds = ra.localeVwcBounds;
                    if (this.intersectedBounds.length < this.numberOfFogs) {
                        this.intersectedBounds = new Bounds[this.numberOfFogs];
                    }
                    if (!ra.geometryAtom.source.inBackgroundGroup) break block9;
                    ArrayList<FogRetained> globalFogs = ra.geometryAtom.source.geometryBackground.fogs;
                    if ((nfogs = this.processFogs(globalFogs, ra, nfogs)) < 1) break block10;
                    fog = this.intersectedFogs[0];
                    break block10;
                }
                ArrayList<FogRetained> globalFogs = this.viewScopedFogs.get(view);
                if (globalFogs != null) {
                    nfogs = this.processFogs(globalFogs, ra, nfogs);
                }
                if ((nfogs = this.processFogs(this.nonViewScopedFogs, ra, nfogs)) == 1) {
                    fog = this.intersectedFogs[0];
                } else if (nfogs > 1) {
                    Bounds closestBounds = ((Bounds)bounds).closestIntersection(this.intersectedBounds);
                    for (int j = 0; j < nfogs; ++j) {
                        if (this.intersectedBounds[j] != closestBounds) continue;
                        fog = this.intersectedFogs[j];
                        break;
                    }
                }
            }
            return fog;
        }
    }

    int processFogs(ArrayList<FogRetained> globalFogs, RenderAtom ra, int numFogs) {
        int size = globalFogs.size();
        BoundingBox bounds = ra.localeVwcBounds;
        if (globalFogs.size() > 0) {
            block0: for (int i = 0; i < size; ++i) {
                FogRetained fog = globalFogs.get(i);
                if (fog.region == null || !fog.switchState.currentSwitchOn || !ra.geometryAtom.source.inBackgroundGroup && !fog.region.intersect(bounds)) continue;
                int n = ra.geometryAtom.source.numfogs;
                FogRetained[] shapeScopedFog = ra.geometryAtom.source.fogs;
                if (fog.isScoped) {
                    for (int k = 0; k < n; ++k) {
                        if (fog != shapeScopedFog[k]) continue;
                        this.intersectedBounds[numFogs] = fog.region;
                        this.intersectedFogs[numFogs++] = fog;
                        continue block0;
                    }
                    continue;
                }
                this.intersectedBounds[numFogs] = fog.region;
                this.intersectedFogs[numFogs++] = fog;
            }
        }
        return numFogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModelClipRetained getInfluencingModelClip(RenderAtom ra, View view) {
        if (ra.geometryAtom.source.inBackgroundGroup) {
            return null;
        }
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList<ModelClipRetained> globalModelClips;
            BoundingBox bounds = ra.localeVwcBounds;
            int nModelClips = 0;
            if (this.intersectedBounds.length < this.numberOfModelClips) {
                this.intersectedBounds = new Bounds[this.numberOfModelClips];
            }
            if ((globalModelClips = this.viewScopedModelClips.get(view)) != null) {
                nModelClips = this.processModelClips(globalModelClips, ra, nModelClips);
            }
            nModelClips = this.processModelClips(this.nonViewScopedModelClips, ra, nModelClips);
            ModelClipRetained modelClip = null;
            if (nModelClips == 1) {
                modelClip = this.intersectedModelClips[0];
            } else if (nModelClips > 1) {
                Bounds closestBounds = ((Bounds)bounds).closestIntersection(this.intersectedBounds);
                for (int j = 0; j < nModelClips; ++j) {
                    if (this.intersectedBounds[j] != closestBounds) continue;
                    modelClip = this.intersectedModelClips[j];
                    break;
                }
            }
            return modelClip;
        }
    }

    int processModelClips(ArrayList<ModelClipRetained> globalModelClips, RenderAtom ra, int nModelClips) {
        int size = globalModelClips.size();
        BoundingBox bounds = ra.localeVwcBounds;
        if (size > 0) {
            block0: for (int i = 0; i < size; ++i) {
                ModelClipRetained modelClip = globalModelClips.get(i);
                if (!modelClip.enableFlag || modelClip.region == null || !modelClip.switchState.currentSwitchOn || !modelClip.region.intersect(bounds)) continue;
                int n = ra.geometryAtom.source.numModelClips;
                ModelClipRetained[] shapeScopedModelClip = ra.geometryAtom.source.modelClips;
                if (modelClip.isScoped) {
                    for (int k = 0; k < n; ++k) {
                        if (shapeScopedModelClip[k] != modelClip) continue;
                        this.intersectedBounds[nModelClips] = modelClip.region;
                        this.intersectedModelClips[nModelClips++] = modelClip;
                        continue block0;
                    }
                    continue;
                }
                this.intersectedBounds[nModelClips] = modelClip.region;
                this.intersectedModelClips[nModelClips++] = modelClip;
            }
        }
        return nModelClips;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackgroundRetained getApplicationBackground(BoundingSphere bounds, Locale viewLocale, View view) {
        BackgroundRetained bg = null;
        int j = 0;
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList<BackgroundRetained> globalBgs;
            int nbacks = 0;
            if (this.intersectedBounds.length < this.numberOfBgs) {
                this.intersectedBounds = new Bounds[this.numberOfBgs];
            }
            if ((globalBgs = this.viewScopedBackgrounds.get(view)) != null) {
                nbacks = this.processBgs(globalBgs, bounds, nbacks, viewLocale);
            }
            if ((nbacks = this.processBgs(this.nonViewScopedBackgrounds, bounds, nbacks, viewLocale)) == 1) {
                bg = this.intersectedBacks[0];
            } else if (nbacks > 1) {
                Bounds closestBounds = bounds.closestIntersection(this.intersectedBounds);
                for (j = 0; j < nbacks; ++j) {
                    if (this.intersectedBounds[j] != closestBounds) continue;
                    bg = this.intersectedBacks[j];
                    break;
                }
            }
            return bg;
        }
    }

    int processBgs(ArrayList<BackgroundRetained> globalBgs, BoundingSphere bounds, int nbacks, Locale viewLocale) {
        int size = globalBgs.size();
        for (int i = 0; i < size; ++i) {
            BackgroundRetained back = globalBgs.get(i);
            if (back.transformedRegion == null || !back.switchState.currentSwitchOn) continue;
            if (back.cachedLocale != viewLocale) {
                Bounds localeBounds = (Bounds)back.transformedRegion.clone();
                back.cachedLocale.hiRes.difference(viewLocale.hiRes, this.localeTranslation);
                this.localeXform.setIdentity();
                this.localeXform.setTranslation(this.localeTranslation);
                localeBounds.transform(this.localeXform);
                if (!localeBounds.intersect(bounds)) continue;
                this.intersectedBounds[nbacks] = localeBounds;
                this.intersectedBacks[nbacks++] = back;
                continue;
            }
            if (!back.transformedRegion.intersect(bounds)) continue;
            this.intersectedBounds[nbacks] = back.transformedRegion;
            this.intersectedBacks[nbacks++] = back;
        }
        return nbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double[] backClipDistanceInVworld(BoundingSphere bounds, View view) {
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList<ClipRetained> globalClips;
            double[] backClipDistance = null;
            boolean backClipActive = false;
            int nclips = 0;
            double distance = 0.0;
            if (this.intersectedBounds.length < this.numberOfClips) {
                this.intersectedBounds = new Bounds[this.numberOfClips];
            }
            if ((globalClips = this.viewScopedClips.get(view)) != null) {
                nclips = this.processClips(globalClips, bounds, nclips);
            }
            if ((nclips = this.processClips(this.nonViewScopedClips, bounds, nclips)) == 1) {
                distance = this.intersectedClips[0].backDistanceInVworld;
                backClipActive = true;
            } else if (nclips > 1) {
                Bounds closestBounds = bounds.closestIntersection(this.intersectedBounds);
                for (int j = 0; j < nclips; ++j) {
                    if (this.intersectedBounds[j] != closestBounds) continue;
                    distance = this.intersectedClips[j].backDistanceInVworld;
                    backClipActive = true;
                    break;
                }
            }
            if (backClipActive) {
                backClipDistance = new double[]{distance};
            }
            return backClipDistance;
        }
    }

    int processClips(ArrayList<ClipRetained> globalClips, BoundingSphere bounds, int nclips) {
        int size = globalClips.size();
        for (int i = 0; i < size; ++i) {
            ClipRetained clip = globalClips.get(i);
            if (clip.transformedRegion == null || !clip.transformedRegion.intersect(bounds) || !clip.switchState.currentSwitchOn) continue;
            this.intersectedBounds[nclips] = clip.transformedRegion;
            this.intersectedClips[nclips++] = clip;
        }
        return nclips;
    }

    void updateLight(Object[] args) {
        LightRetained light = (LightRetained)args[0];
        int component = (Integer)args[1];
        if ((component & 0x20) != 0) {
            light.initMirrorObject(args);
        }
        if (light instanceof AmbientLightRetained && (component & 8) != 0) {
            light.updateImmediateMirrorObject(args);
        } else if ((component & 0xFA8) != 0) {
            Object[] objs = this.getObjectArray();
            objs[0] = args[0];
            objs[1] = args[1];
            objs[2] = args[2];
            objs[3] = args[3];
            objs[4] = args[4];
            this.objList.add(objs);
        } else if ((component & 0x40) != 0) {
            light.clearMirrorObject(args);
        } else {
            light.updateImmediateMirrorObject(args);
        }
    }

    void updateBackground(Object[] args) {
        BackgroundRetained bg = (BackgroundRetained)args[0];
        bg.updateImmediateMirrorObject(args);
    }

    void updateFog(Object[] args) {
        FogRetained fog = (FogRetained)args[0];
        int component = (Integer)args[1];
        if ((component & 0x10) != 0) {
            fog.initMirrorObject(args);
            Object[] objs = this.getObjectArray();
            objs[0] = args[0];
            objs[1] = args[1];
            objs[2] = args[2];
            objs[3] = args[3];
            objs[4] = args[4];
            this.objList.add(objs);
        } else if ((component & 0x20) != 0) {
            fog.clearMirrorObject(args);
        } else if ((component & 0xC1) != 0) {
            Object[] objs = this.getObjectArray();
            objs[0] = args[0];
            objs[1] = args[1];
            objs[2] = args[2];
            objs[3] = args[3];
            objs[4] = args[4];
            this.objList.add(objs);
        } else {
            fog.updateImmediateMirrorObject(args);
        }
    }

    void updateAltApp(Object[] args) {
        AlternateAppearanceRetained altApp = (AlternateAppearanceRetained)args[0];
        int component = (Integer)args[1];
        if ((component & 0x10) != 0) {
            AlternateAppearanceRetained altapp = (AlternateAppearanceRetained)args[0];
            altapp.initMirrorObject(args);
        } else if ((component & 0x20) != 0) {
            AlternateAppearanceRetained altapp = (AlternateAppearanceRetained)args[0];
            altapp.clearMirrorObject(args);
        } else {
            altApp.updateImmediateMirrorObject(args);
        }
    }

    void updateClip(Object[] args) {
        ClipRetained clip = (ClipRetained)args[0];
        clip.updateImmediateMirrorObject(args);
    }

    void updateModelClip(Object[] args) {
        ModelClipRetained modelClip = (ModelClipRetained)args[0];
        int component = (Integer)args[1];
        if ((component & 0x80) != 0) {
            modelClip.initMirrorObject(args);
        }
        if ((component & 0x100) != 0) {
            modelClip.clearMirrorObject(args);
        } else if ((component & 0x83) != 0) {
            Object[] objs = this.getObjectArray();
            objs[0] = args[0];
            objs[1] = args[1];
            objs[2] = args[2];
            objs[3] = args[3];
            objs[4] = args[4];
            this.objList.add(objs);
        } else {
            modelClip.updateImmediateMirrorObject(args);
        }
    }

    void updateBoundingLeaf(Object[] args) {
        BoundingLeafRetained bl = (BoundingLeafRetained)args[0];
        Object[] users = (Object[])args[3];
        bl.updateImmediateMirrorObject(args);
        for (int i = 0; i < users.length; ++i) {
            LeafRetained mLeaf = (LeafRetained)users[i];
            mLeaf.updateBoundingLeaf();
        }
    }

    void updateShape3D(Object[] args) {
        Shape3DRetained shape = (Shape3DRetained)args[0];
        shape.updateImmediateMirrorObject(args);
    }

    void updateOrientedShape3D(Object[] args) {
        OrientedShape3DRetained shape = (OrientedShape3DRetained)args[4];
        shape.updateImmediateMirrorObject(args);
    }

    void updateMorph(Object[] args) {
        MorphRetained morph = (MorphRetained)args[0];
        morph.updateImmediateMirrorObject(args);
    }

    void updateTransformChange() {
        int i;
        Object[] nodes;
        int j;
        Object[] nodesArr;
        int size;
        this.targets = this.universe.transformStructure.getTargetList();
        this.blUsers = this.universe.transformStructure.getBlUsers();
        UnorderList arrList = this.targets.targetList[1];
        if (arrList != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            for (j = 0; j < size; ++j) {
                nodes = (Object[])nodesArr[j];
                for (i = 0; i < nodes.length; ++i) {
                    if (nodes[i] instanceof LightRetained) {
                        LightRetained ml = (LightRetained)nodes[i];
                        ml.updateImmediateTransformChange();
                        this.xformChangeList.add(ml);
                        continue;
                    }
                    if (nodes[i] instanceof FogRetained) {
                        FogRetained mfog = (FogRetained)nodes[i];
                        mfog.updateImmediateTransformChange();
                        this.xformChangeList.add(mfog);
                        continue;
                    }
                    if (nodes[i] instanceof AlternateAppearanceRetained) {
                        AlternateAppearanceRetained mAltApp = (AlternateAppearanceRetained)nodes[i];
                        mAltApp.updateImmediateTransformChange();
                        this.xformChangeList.add(mAltApp);
                        continue;
                    }
                    if (nodes[i] instanceof BackgroundRetained) {
                        BackgroundRetained bg = (BackgroundRetained)nodes[i];
                        bg.updateImmediateTransformChange();
                        continue;
                    }
                    if (!(nodes[i] instanceof ModelClipRetained)) continue;
                    ModelClipRetained mc = (ModelClipRetained)nodes[i];
                    mc.updateImmediateTransformChange();
                }
            }
        }
        if ((arrList = this.targets.targetList[5]) != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            for (j = 0; j < size; ++j) {
                nodes = (Object[])nodesArr[j];
                for (i = 0; i < nodes.length; ++i) {
                    BoundingLeafRetained bl = (BoundingLeafRetained)nodes[i];
                    bl.updateImmediateTransformChange();
                }
            }
        }
        if (this.blUsers != null) {
            for (i = 0; i < this.blUsers.size(); ++i) {
                LeafRetained leaf = (LeafRetained)this.blUsers.get(i);
                leaf.updateBoundingLeaf();
            }
        }
        this.targets = null;
        this.blUsers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getInfluencingAppearance(RenderAtom ra, View view) {
        Object[] retVal = new Object[2];
        if (ra.geometryAtom.source.inBackgroundGroup) {
            retVal[0] = Boolean.FALSE;
            return retVal;
        }
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList<AlternateAppearanceRetained> globalAltApps;
            int nAltApp = 0;
            BoundingBox bounds = ra.localeVwcBounds;
            if (this.intersectedBounds.length < this.numberOfAltApps) {
                this.intersectedBounds = new Bounds[this.numberOfAltApps];
            }
            if ((globalAltApps = this.viewScopedAltAppearances.get(view)) != null) {
                nAltApp = this.processAltApps(globalAltApps, ra, nAltApp);
            }
            nAltApp = this.processAltApps(this.nonViewScopedAltAppearances, ra, nAltApp);
            AlternateAppearanceRetained altApp = null;
            if (nAltApp == 1) {
                altApp = this.intersectedAltApps[0];
            } else if (nAltApp > 1) {
                Bounds closestBounds = ((Bounds)bounds).closestIntersection(this.intersectedBounds);
                for (int j = 0; j < nAltApp; ++j) {
                    if (this.intersectedBounds[j] != closestBounds) continue;
                    altApp = this.intersectedAltApps[j];
                    break;
                }
            }
            if (altApp == null) {
                retVal[0] = Boolean.FALSE;
                return retVal;
            }
            retVal[0] = Boolean.TRUE;
            retVal[1] = altApp.appearance;
            return retVal;
        }
    }

    int processAltApps(ArrayList<AlternateAppearanceRetained> globalAltApps, RenderAtom ra, int nAltApp) {
        int size = globalAltApps.size();
        BoundingBox bounds = ra.localeVwcBounds;
        if (size == 0) {
            return nAltApp;
        }
        block0: for (int i = 0; i < size; ++i) {
            AlternateAppearanceRetained altApp = globalAltApps.get(i);
            if (altApp.region == null || !altApp.switchState.currentSwitchOn || !altApp.region.intersect(bounds)) continue;
            int n = ra.geometryAtom.source.numAltApps;
            AlternateAppearanceRetained[] shapeScopedAltApp = ra.geometryAtom.source.altApps;
            if (altApp.isScoped) {
                for (int k = 0; k < n; ++k) {
                    if (altApp != shapeScopedAltApp[k]) continue;
                    this.intersectedBounds[nAltApp] = altApp.region;
                    this.intersectedAltApps[nAltApp++] = altApp;
                    continue block0;
                }
                continue;
            }
            this.intersectedBounds[nAltApp] = altApp.region;
            this.intersectedAltApps[nAltApp++] = altApp;
        }
        return nAltApp;
    }

    void initViewSpecificInfo(J3dMessage m) {
        int[] keys = (int[])m.args[2];
        ArrayList vlists = (ArrayList)m.args[1];
        ArrayList vsgs = (ArrayList)m.args[0];
        if (vsgs != null) {
            int size = vsgs.size();
            for (int i = 0; i < size; ++i) {
                ViewSpecificGroupRetained v = (ViewSpecificGroupRetained)vsgs.get(i);
                ArrayList l = (ArrayList)vlists.get(i);
                int index = keys[i];
                v.cachedViewList.add(index, l);
            }
        }
    }

    void clearViewSpecificInfo(J3dMessage m) {
        int[] keys = (int[])m.args[1];
        ArrayList vsgs = (ArrayList)m.args[0];
        if (vsgs != null) {
            int size = vsgs.size();
            for (int i = 0; i < size; ++i) {
                ViewSpecificGroupRetained v = (ViewSpecificGroupRetained)vsgs.get(i);
                int index = keys[i];
                if (index == -1) {
                    int csize = v.cachedViewList.size();
                    for (int j = 0; j < csize; ++j) {
                        v.cachedViewList.get(j).clear();
                    }
                    v.cachedViewList.clear();
                    continue;
                }
                v.cachedViewList.remove(index).clear();
            }
        }
    }

    void updateViewSpecificGroupChanged(J3dMessage m) {
        Object obj;
        int index;
        ViewSpecificGroupRetained vsg;
        int i;
        int size;
        int component = (Integer)m.args[0];
        Object[] objAry = (Object[])m.args[1];
        ArrayList<LightRetained> ltList = null;
        ArrayList<FogRetained> fogList = null;
        ArrayList<ModelClipRetained> mclipList = null;
        ArrayList<AlternateAppearanceRetained> altAppList = null;
        ArrayList<BackgroundRetained> bgList = null;
        ArrayList<ClipRetained> clipList = null;
        if ((component & 2) != 0 || (component & 1) != 0) {
            View view = (View)objAry[0];
            ArrayList vsgList = (ArrayList)objAry[1];
            ArrayList leafList = (ArrayList)objAry[2];
            int[] keyList = (int[])objAry[3];
            size = vsgList.size();
            if (view != null) {
                for (i = 0; i < size; ++i) {
                    vsg = (ViewSpecificGroupRetained)vsgList.get(i);
                    index = keyList[i];
                    vsg.updateCachedInformation(2, view, index);
                }
                size = leafList.size();
                if (size > 0) {
                    for (i = 0; i < size; ++i) {
                        obj = leafList.get(i);
                        if (obj instanceof LightRetained) {
                            LightRetained lt = (LightRetained)obj;
                            lt.isViewScoped = true;
                            ++this.numberOfLights;
                            if (ltList == null && (ltList = this.viewScopedLights.get(view)) == null) {
                                ltList = new ArrayList();
                                this.viewScopedLights.put(view, ltList);
                            }
                            ltList.add(lt);
                        }
                        if (obj instanceof FogRetained) {
                            FogRetained ft = (FogRetained)obj;
                            ft.isViewScoped = true;
                            ++this.numberOfFogs;
                            if (fogList == null && (fogList = this.viewScopedFogs.get(view)) == null) {
                                fogList = new ArrayList();
                                this.viewScopedFogs.put(view, fogList);
                            }
                            fogList.add(ft);
                        }
                        if (obj instanceof ModelClipRetained) {
                            ModelClipRetained mc = (ModelClipRetained)obj;
                            mc.isViewScoped = true;
                            ++this.numberOfModelClips;
                            if (mclipList == null && (mclipList = this.viewScopedModelClips.get(view)) == null) {
                                mclipList = new ArrayList();
                                this.viewScopedModelClips.put(view, mclipList);
                            }
                            mclipList.add(mc);
                        }
                        if (obj instanceof AlternateAppearanceRetained) {
                            AlternateAppearanceRetained aart = (AlternateAppearanceRetained)obj;
                            aart.isViewScoped = true;
                            ++this.numberOfAltApps;
                            if (altAppList == null && (altAppList = this.viewScopedAltAppearances.get(view)) == null) {
                                altAppList = new ArrayList();
                                this.viewScopedAltAppearances.put(view, altAppList);
                            }
                            altAppList.add(aart);
                        }
                        if (obj instanceof ClipRetained) {
                            ClipRetained ct = (ClipRetained)obj;
                            ct.isViewScoped = true;
                            ++this.numberOfClips;
                            if (clipList == null && (clipList = this.viewScopedClips.get(view)) == null) {
                                clipList = new ArrayList();
                                this.viewScopedClips.put(view, clipList);
                            }
                            clipList.add(ct);
                        }
                        if (!(obj instanceof BackgroundRetained)) continue;
                        BackgroundRetained bg = (BackgroundRetained)obj;
                        bg.isViewScoped = true;
                        ++this.numberOfBgs;
                        if (bgList == null && (bgList = this.viewScopedBackgrounds.get(view)) == null) {
                            bgList = new ArrayList();
                            this.viewScopedBackgrounds.put(view, bgList);
                        }
                        bgList.add(bg);
                    }
                    if (this.numberOfLights > this.retlights.length) {
                        this.retlights = new LightRetained[this.numberOfLights];
                    }
                    if (this.intersectedFogs.length < this.numberOfFogs) {
                        this.intersectedFogs = new FogRetained[this.numberOfFogs];
                    }
                    if (this.intersectedAltApps.length < this.numberOfAltApps) {
                        this.intersectedAltApps = new AlternateAppearanceRetained[this.numberOfAltApps];
                    }
                    if (this.intersectedBacks.length < this.numberOfBgs) {
                        this.intersectedBacks = new BackgroundRetained[this.numberOfBgs];
                    }
                    if (this.intersectedClips.length < this.numberOfClips) {
                        this.intersectedClips = new ClipRetained[this.numberOfClips];
                    }
                    if (this.intersectedModelClips.length < this.numberOfModelClips) {
                        this.intersectedModelClips = new ModelClipRetained[this.numberOfModelClips];
                    }
                }
            }
        }
        if ((component & 4) != 0 || (component & 1) != 0) {
            int[] keyList;
            ArrayList leafList;
            ArrayList vsgList;
            View view;
            if ((component & 4) != 0) {
                view = (View)objAry[0];
                vsgList = (ArrayList)objAry[1];
                leafList = (ArrayList)objAry[2];
                keyList = (int[])objAry[3];
            } else {
                view = (View)objAry[4];
                vsgList = (ArrayList)objAry[5];
                leafList = (ArrayList)objAry[6];
                keyList = (int[])objAry[7];
            }
            if (view != null) {
                size = vsgList.size();
                for (i = 0; i < size; ++i) {
                    vsg = (ViewSpecificGroupRetained)vsgList.get(i);
                    index = keyList[i];
                    vsg.updateCachedInformation(4, view, index);
                }
                size = leafList.size();
                if (size > 0) {
                    for (i = 0; i < size; ++i) {
                        obj = leafList.get(i);
                        if (obj instanceof LightRetained) {
                            ((LightRetained)obj).isViewScoped = false;
                            --this.numberOfLights;
                            if (ltList == null) {
                                ltList = this.viewScopedLights.get(view);
                            }
                            ltList.remove(obj);
                        }
                        if (obj instanceof FogRetained) {
                            ((FogRetained)obj).isViewScoped = false;
                            --this.numberOfFogs;
                            if (fogList == null) {
                                fogList = this.viewScopedFogs.get(view);
                            }
                            fogList.remove(obj);
                        }
                        if (obj instanceof ModelClipRetained) {
                            ((ModelClipRetained)obj).isViewScoped = false;
                            --this.numberOfModelClips;
                            if (mclipList == null) {
                                mclipList = this.viewScopedModelClips.get(view);
                            }
                            mclipList.remove(obj);
                        }
                        if (obj instanceof AlternateAppearanceRetained) {
                            ((AlternateAppearanceRetained)obj).isViewScoped = false;
                            --this.numberOfAltApps;
                            if (altAppList == null) {
                                altAppList = this.viewScopedAltAppearances.get(view);
                            }
                            altAppList.remove(obj);
                        }
                        if (obj instanceof ClipRetained) {
                            ((ClipRetained)obj).isViewScoped = false;
                            --this.numberOfClips;
                            if (clipList == null) {
                                clipList = this.viewScopedClips.get(view);
                            }
                            clipList.remove(obj);
                        }
                        if (!(obj instanceof BackgroundRetained)) continue;
                        ((BackgroundRetained)obj).isViewScoped = false;
                        ++this.numberOfBgs;
                        if (bgList == null) {
                            bgList = this.viewScopedBackgrounds.get(view);
                        }
                        bgList.remove(obj);
                    }
                    if (ltList != null && ltList.size() == 0) {
                        this.viewScopedLights.remove(view);
                    }
                    if (fogList != null && fogList.size() == 0) {
                        this.viewScopedFogs.remove(view);
                    }
                    if (mclipList != null && mclipList.size() == 0) {
                        this.viewScopedModelClips.remove(view);
                    }
                    if (altAppList != null && altAppList.size() == 0) {
                        this.viewScopedAltAppearances.remove(view);
                    }
                    if (clipList != null && clipList.size() == 0) {
                        this.viewScopedClips.remove(view);
                    }
                    if (bgList != null && bgList.size() == 0) {
                        this.viewScopedBackgrounds.remove(view);
                    }
                }
            }
        }
    }

    boolean isLightScopedToThisView(Object obj, View view) {
        ArrayList<LightRetained> l;
        LightRetained light = (LightRetained)obj;
        return !light.isViewScoped || (l = this.viewScopedLights.get(view)) != null && l.contains(light);
    }

    boolean isFogScopedToThisView(Object obj, View view) {
        ArrayList<FogRetained> l;
        FogRetained fog = (FogRetained)obj;
        return !fog.isViewScoped || (l = this.viewScopedFogs.get(view)) != null && l.contains(fog);
    }

    boolean isAltAppScopedToThisView(Object obj, View view) {
        ArrayList<AlternateAppearanceRetained> l;
        AlternateAppearanceRetained altApp = (AlternateAppearanceRetained)obj;
        return !altApp.isViewScoped || (l = this.viewScopedAltAppearances.get(view)) != null && l.contains(altApp);
    }

    boolean isBgScopedToThisView(Object obj, View view) {
        ArrayList<BackgroundRetained> l;
        BackgroundRetained bg = (BackgroundRetained)obj;
        return !bg.isViewScoped || (l = this.viewScopedBackgrounds.get(view)) != null && l.contains(bg);
    }

    boolean isClipScopedToThisView(Object obj, View view) {
        ArrayList<ClipRetained> l;
        ClipRetained clip = (ClipRetained)obj;
        return !clip.isViewScoped || (l = this.viewScopedClips.get(view)) != null && l.contains(clip);
    }

    boolean isMclipScopedToThisView(Object obj, View view) {
        ArrayList<ModelClipRetained> l;
        ModelClipRetained mclip = (ModelClipRetained)obj;
        return !mclip.isViewScoped || (l = this.viewScopedModelClips.get(view)) != null && l.contains(mclip);
    }

    @Override
    void cleanup() {
    }
}

