/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.ShaderAppearanceRetained;
import javax.media.j3d.ShaderAttributeSet;
import javax.media.j3d.ShaderProgram;

public class ShaderAppearance
extends Appearance {
    public static final int ALLOW_SHADER_PROGRAM_READ = 22;
    public static final int ALLOW_SHADER_PROGRAM_WRITE = 23;
    public static final int ALLOW_SHADER_ATTRIBUTE_SET_READ = 24;
    public static final int ALLOW_SHADER_ATTRIBUTE_SET_WRITE = 25;
    private static final int[] readCapabilities = new int[]{22, 24};

    public ShaderAppearance() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    @Override
    void createRetained() {
        this.retained = new ShaderAppearanceRetained();
        this.retained.setSource(this);
    }

    public void setShaderProgram(ShaderProgram shaderProgram) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAppearance0"));
        }
        ((ShaderAppearanceRetained)this.retained).setShaderProgram(shaderProgram);
    }

    public ShaderProgram getShaderProgram() {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAppearance1"));
        }
        return ((ShaderAppearanceRetained)this.retained).getShaderProgram();
    }

    public void setShaderAttributeSet(ShaderAttributeSet shaderAttributeSet) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAppearance2"));
        }
        ((ShaderAppearanceRetained)this.retained).setShaderAttributeSet(shaderAttributeSet);
    }

    public ShaderAttributeSet getShaderAttributeSet() {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAppearance3"));
        }
        return ((ShaderAppearanceRetained)this.retained).getShaderAttributeSet();
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        ShaderAppearance a = new ShaderAppearance();
        a.duplicateNodeComponent(this);
        return a;
    }

    @Override
    public void duplicateNodeComponent(NodeComponent originalNodeComponent) {
        this.checkDuplicateNodeComponent(originalNodeComponent);
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        Hashtable hashtable = originalNodeComponent.nodeHashtable;
        ShaderAppearanceRetained app = (ShaderAppearanceRetained)originalNodeComponent.retained;
        ShaderAppearanceRetained rt = (ShaderAppearanceRetained)this.retained;
        rt.setShaderProgram((ShaderProgram)this.getNodeComponent(app.getShaderProgram(), forceDuplicate, hashtable));
    }

    @Override
    boolean duplicateChild() {
        if (super.duplicateChild()) {
            return true;
        }
        if (this.getDuplicateOnCloneTree()) {
            return true;
        }
        ShaderAppearanceRetained rt = (ShaderAppearanceRetained)this.retained;
        ShaderProgram nc = rt.getShaderProgram();
        return nc != null && nc.getDuplicateOnCloneTree();
    }
}

