/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Map;
import javax.media.j3d.AttributeBin;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderBin;
import javax.media.j3d.ShaderAppearanceRetained;
import javax.media.j3d.ShaderAttributeRetained;
import javax.media.j3d.ShaderAttributeSetRetained;
import javax.media.j3d.ShaderProgramRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureRetained;

class ShaderBin
implements ObjectUpdate {
    static final int SHADER_PROGRAM_DIRTY = 1;
    static final int SHADER_ATTRIBUTE_SET_DIRTY = 2;
    RenderBin renderBin = null;
    AttributeBin attributeBin = null;
    ShaderBin next = null;
    ShaderBin prev = null;
    TextureBin textureBinList = null;
    ArrayList<TextureBin> addTextureBins = new ArrayList();
    boolean onUpdateList = false;
    int numEditingTextureBins = 0;
    int componentDirty = 0;
    ShaderAppearanceRetained shaderAppearance = null;
    ShaderProgramRetained shaderProgram = null;
    ShaderAttributeSetRetained shaderAttributeSet = new ShaderAttributeSetRetained();

    ShaderBin(ShaderAppearanceRetained sApp, RenderBin rBin) {
        this.reset(sApp, rBin);
    }

    void reset(ShaderAppearanceRetained sApp, RenderBin rBin) {
        this.prev = null;
        this.next = null;
        this.renderBin = rBin;
        this.attributeBin = null;
        this.textureBinList = null;
        this.onUpdateList = false;
        this.numEditingTextureBins = 0;
        this.addTextureBins.clear();
        if (sApp != null) {
            this.shaderProgram = sApp.shaderProgram;
            this.shaderAttributeSet = sApp.shaderAttributeSet;
        } else {
            this.shaderProgram = null;
            this.shaderAttributeSet = null;
        }
        this.shaderAppearance = sApp;
    }

    void clear() {
        this.reset(null, null);
    }

    boolean equals(ShaderAppearanceRetained sApp) {
        ShaderAttributeSetRetained ss;
        ShaderProgramRetained sp;
        if (sApp == null) {
            sp = null;
            ss = null;
        } else {
            sp = sApp.shaderProgram;
            ss = sApp.shaderAttributeSet;
        }
        return this.shaderProgram == sp && this.shaderAttributeSet == ss;
    }

    @Override
    public void updateObject() {
        if (this.addTextureBins.size() > 0) {
            TextureBin t = this.addTextureBins.get(0);
            if (this.textureBinList == null) {
                this.textureBinList = t;
            } else {
                this.insertTextureBin(t);
            }
            for (int i = 1; i < this.addTextureBins.size(); ++i) {
                t = this.addTextureBins.get(i);
                this.insertTextureBin(t);
            }
        }
        this.addTextureBins.clear();
        this.onUpdateList = false;
    }

    void insertTextureBin(TextureBin t) {
        TextureRetained texture = null;
        if (t.texUnitState != null && t.texUnitState.length > 0 && t.texUnitState[0] != null) {
            texture = t.texUnitState[0].texture;
        }
        if (texture != null) {
            TextureBin tb = this.textureBinList;
            while (tb != null) {
                if (tb.texUnitState == null || tb.texUnitState[0] == null || tb.texUnitState[0].texture != texture) {
                    tb = tb.next;
                    continue;
                }
                t.next = tb;
                t.prev = tb.prev;
                if (tb.prev == null) {
                    this.textureBinList = t;
                } else {
                    tb.prev.next = t;
                }
                tb.prev = t;
                return;
            }
        }
        t.prev = null;
        t.next = this.textureBinList;
        this.textureBinList.prev = t;
        this.textureBinList = t;
        t.tbFlag &= 0xFFFFFFEF;
    }

    void reInsertTextureBin(TextureBin tb) {
        TextureRetained texture = null;
        TextureRetained prevTexture = null;
        TextureRetained nextTexture = null;
        if (tb.texUnitState != null && tb.texUnitState[0] != null) {
            texture = tb.texUnitState[0].texture;
        }
        if (tb.prev != null && tb.prev.texUnitState != null) {
            prevTexture = tb.prev.texUnitState[0].texture;
        }
        if (texture != prevTexture) {
            if (tb.next != null && tb.next.texUnitState != null) {
                nextTexture = tb.next.texUnitState[0].texture;
            }
            if (texture != nextTexture && tb.prev != null && tb.next != null) {
                tb.prev.next = tb.next;
                tb.next.prev = tb.prev;
                this.insertTextureBin(tb);
            }
        }
    }

    void addTextureBin(TextureBin t, RenderBin rb, RenderAtom ra) {
        t.environmentSet = this.attributeBin.environmentSet;
        t.attributeBin = this.attributeBin;
        t.shaderBin = this;
        this.attributeBin.updateFromShaderBin(ra);
        this.addTextureBins.add(t);
        if (!this.onUpdateList) {
            rb.objUpdateList.add(this);
            this.onUpdateList = true;
        }
    }

    void removeTextureBin(TextureBin t) {
        if (this.addTextureBins.contains(t)) {
            this.addTextureBins.remove(this.addTextureBins.indexOf(t));
        } else if (t.prev == null) {
            this.textureBinList = t.next;
            if (t.next != null) {
                t.next.prev = null;
            }
        } else {
            t.prev.next = t.next;
            if (t.next != null) {
                t.next.prev = t.prev;
            }
        }
        t.shaderBin = null;
        t.prev = null;
        t.next = null;
        t.clear();
        if (this.textureBinList == null && this.addTextureBins.size() == 0) {
            this.attributeBin.removeShaderBin(this);
        }
    }

    void render(Canvas3D cv) {
        cv.setStateToUpdate(6, this);
        TextureBin tb = this.textureBinList;
        while (tb != null) {
            tb.render(cv);
            tb = tb.next;
        }
    }

    void updateAttributes(Canvas3D cv) {
        if (this.shaderProgram != null) {
            this.shaderProgram.updateNative(cv, true);
            if (this.shaderAttributeSet != null) {
                this.shaderAttributeSet.updateNative(cv, this.shaderProgram);
            }
        } else if (cv.shaderProgram != null) {
            cv.shaderProgram.updateNative(cv, false);
        }
        cv.shaderBin = this;
        cv.shaderProgram = this.shaderProgram;
    }

    void updateNodeComponent() {
        if ((this.componentDirty & 1) != 0) {
            this.shaderProgram = this.shaderAppearance.shaderProgram;
        }
        if ((this.componentDirty & 2) != 0) {
            Map<String, ShaderAttributeRetained> attrs = this.shaderAttributeSet.getAttrs();
            attrs.clear();
            if (this.shaderAppearance.shaderAttributeSet != null) {
                attrs.putAll(this.shaderAppearance.shaderAttributeSet.getAttrs());
            }
        }
        this.componentDirty = 0;
    }

    void incrActiveTextureBin() {
        ++this.numEditingTextureBins;
    }

    void decrActiveTextureBin() {
        --this.numEditingTextureBins;
    }
}

