/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SharedGroupRetained;

public class SharedGroup
extends Group {
    public static final int ALLOW_LINK_READ = 17;
    private static final int[] readCapabilities = new int[]{17};

    public SharedGroup() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Link[] getLinks() {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SharedGroup1"));
        }
        return ((SharedGroupRetained)this.retained).getLinks();
    }

    @Override
    void createRetained() {
        this.retained = new SharedGroupRetained();
        this.retained.setSource(this);
    }

    public void compile() {
        if (this.isLive()) {
            throw new RestrictedAccessException(J3dI18N.getString("SharedGroup0"));
        }
        if (!this.isCompiled()) {
            this.checkForCycle();
            ((SharedGroupRetained)this.retained).compile();
        }
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        SharedGroup sg = new SharedGroup();
        sg.duplicateNode(this, forceDuplicate);
        return sg;
    }
}

