/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;

class Targets {
    static final int MAX_NODELIST = 7;
    static final int GEO_TARGETS = 0;
    static final int ENV_TARGETS = 1;
    static final int BEH_TARGETS = 2;
    static final int SND_TARGETS = 3;
    static final int VPF_TARGETS = 4;
    static final int BLN_TARGETS = 5;
    static final int GRP_TARGETS = 6;
    ArrayList<NnuId>[] targetList = new ArrayList[7];

    Targets() {
    }

    void addNode(NnuId node, int targetType) {
        if (this.targetList[targetType] == null) {
            this.targetList[targetType] = new ArrayList(1);
        }
        this.targetList[targetType].add(node);
    }

    void removeNode(int index, int targetType) {
        if (this.targetList[targetType] != null) {
            this.targetList[targetType].remove(index);
        }
    }

    void addNodes(ArrayList<NnuId> nodeList, int targetType) {
        if (this.targetList[targetType] == null) {
            this.targetList[targetType] = new ArrayList(1);
        }
        this.targetList[targetType].addAll(nodeList);
    }

    void clearNodes() {
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] == null) continue;
            this.targetList[i].clear();
        }
    }

    CachedTargets snapShotInit() {
        CachedTargets cachedTargets = new CachedTargets();
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] != null) {
                int size = this.targetList[i].size();
                NnuId[] nArr = new NnuId[size];
                this.targetList[i].toArray(nArr);
                cachedTargets.targetArr[i] = nArr;
                NnuIdManager.sort(cachedTargets.targetArr[i]);
                continue;
            }
            cachedTargets.targetArr[i] = null;
        }
        this.clearNodes();
        return cachedTargets;
    }

    CachedTargets snapShotAdd(CachedTargets cachedTargets) {
        CachedTargets newCachedTargets = new CachedTargets();
        for (int i = 0; i < 7; ++i) {
            int size;
            if (this.targetList[i] != null && cachedTargets.targetArr[i] == null) {
                size = this.targetList[i].size();
                NnuId[] nArr = new NnuId[size];
                this.targetList[i].toArray(nArr);
                newCachedTargets.targetArr[i] = nArr;
                NnuIdManager.sort(newCachedTargets.targetArr[i]);
                continue;
            }
            if (this.targetList[i] != null && cachedTargets.targetArr[i] != null) {
                size = this.targetList[i].size();
                NnuId[] targetArr = new NnuId[size];
                this.targetList[i].toArray(targetArr);
                NnuIdManager.sort(targetArr);
                newCachedTargets.targetArr[i] = NnuIdManager.merge(cachedTargets.targetArr[i], targetArr);
                continue;
            }
            if (this.targetList[i] != null || cachedTargets.targetArr[i] == null) continue;
            newCachedTargets.targetArr[i] = cachedTargets.targetArr[i];
        }
        this.clearNodes();
        return newCachedTargets;
    }

    CachedTargets snapShotRemove(CachedTargets cachedTargets) {
        CachedTargets newCachedTargets = new CachedTargets();
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] != null && cachedTargets.targetArr[i] != null) {
                int size = this.targetList[i].size();
                NnuId[] targetArr = new NnuId[size];
                this.targetList[i].toArray(targetArr);
                NnuIdManager.sort(targetArr);
                newCachedTargets.targetArr[i] = NnuIdManager.delete(cachedTargets.targetArr[i], targetArr);
                continue;
            }
            if (this.targetList[i] == null && cachedTargets.targetArr[i] != null) {
                newCachedTargets.targetArr[i] = cachedTargets.targetArr[i];
                continue;
            }
            if (this.targetList[i] == null || cachedTargets.targetArr[i] != null) continue;
            System.err.println("You can't remove something that isn't there");
        }
        this.clearNodes();
        return newCachedTargets;
    }

    boolean isEmpty() {
        boolean empty = true;
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] == null) continue;
            empty = false;
            break;
        }
        return empty;
    }

    void dump() {
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] == null) continue;
            System.err.println("  " + CachedTargets.typeString[i]);
            for (int j = 0; j < this.targetList[i].size(); ++j) {
                System.err.println("  " + this.targetList[i].get(j));
            }
        }
    }
}

