/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.RenderBin;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture2DRetained;
import javax.media.j3d.Texture3D;
import javax.media.j3d.Texture3DRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureCubeMap;
import javax.media.j3d.TextureCubeMapRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;

abstract class TextureRetained
extends NodeComponentRetained {
    static final int ENABLE_CHANGED = 1;
    static final int COLOR_CHANGED = 2;
    static final int IMAGE_CHANGED = 4;
    static final int STATE_CHANGED = 8;
    static final int UPDATE_IMAGE = 16;
    static final int IMAGES_CHANGED = 32;
    static final int BASE_LEVEL_CHANGED = 64;
    static final int MAX_LEVEL_CHANGED = 128;
    static final int MIN_LOD_CHANGED = 256;
    static final int MAX_LOD_CHANGED = 512;
    static final int LOD_OFFSET_CHANGED = 1024;
    static final int MIN_FILTER = 0;
    static final int MAG_FILTER = 1;
    int boundaryWidth = 0;
    int boundaryModeS = 3;
    int boundaryModeT = 3;
    int minFilter = 2;
    int magFilter = 2;
    int isDirty = 65535;
    Color4f boundaryColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    int objectId = -1;
    int mipmapMode = 1;
    int format = 5;
    int width = 1;
    int height = 1;
    private boolean widthOrHeightIsNPOT = false;
    ImageComponentRetained[][] images;
    int maxLevels = 0;
    private int maxMipMapLevels = 0;
    int numFaces = 1;
    int baseLevel = 0;
    int maximumLevel = 0;
    float minimumLod = -1000.0f;
    float maximumLod = 1000.0f;
    Point3f lodOffset = null;
    private boolean useAsRaster = false;
    boolean enable = true;
    boolean userSpecifiedEnable = true;
    boolean isAlphaNeedUpdate = false;
    int numSharpenTextureFuncPts = 0;
    float[] sharpenTextureFuncPts = null;
    float[] filter4FuncPts = null;
    int anisotropicFilterMode = 0;
    float anisotropicFilterDegree = 1.0f;
    int resourceCreationMask = 0;
    int resourceUpdatedMask = 0;
    int resourceLodUpdatedMask = 0;
    int resourceInReloadList = 0;
    ArrayList[][] imageUpdateInfo;
    int[] imageUpdatePruneMask;
    private HashMap<RenderBin, Integer> textureBinRefCount = new HashMap();
    Object resourceLock = new Object();

    TextureRetained() {
    }

    private static boolean isPowerOfTwo(int val) {
        return (val & val - 1) == 0;
    }

    void initialize(int format, int width, int widLevels, int height, int heiLevels, int mipmapMode, int boundaryWidth) {
        this.mipmapMode = mipmapMode;
        this.format = format;
        this.width = width;
        this.height = height;
        this.boundaryWidth = boundaryWidth;
        if (!TextureRetained.isPowerOfTwo(width) || !TextureRetained.isPowerOfTwo(height)) {
            this.widthOrHeightIsNPOT = true;
        }
        this.maxMipMapLevels = widLevels > heiLevels ? widLevels + 1 : heiLevels + 1;
        if (mipmapMode != 1) {
            this.baseLevel = 0;
            this.maximumLevel = this.maxMipMapLevels - 1;
            this.maxLevels = this.maxMipMapLevels;
        } else {
            this.baseLevel = 0;
            this.maximumLevel = 0;
            this.maxLevels = 1;
        }
        this.images = new ImageComponentRetained[this.numFaces][this.maxLevels];
        for (int j = 0; j < this.numFaces; ++j) {
            for (int i = 0; i < this.maxLevels; ++i) {
                this.images[j][i] = null;
            }
        }
    }

    final int getFormat() {
        return this.format;
    }

    final int getWidth() {
        return this.width;
    }

    final int getHeight() {
        return this.height;
    }

    final int numMipMapLevels() {
        return this.maximumLevel - this.baseLevel + 1;
    }

    final void initBoundaryModeS(int boundaryModeS) {
        this.boundaryModeS = boundaryModeS;
    }

    final int getBoundaryModeS() {
        return this.boundaryModeS;
    }

    final void initBoundaryModeT(int boundaryModeT) {
        this.boundaryModeT = boundaryModeT;
    }

    final int getBoundaryModeT() {
        return this.boundaryModeT;
    }

    final int getBoundaryWidth() {
        return this.boundaryWidth;
    }

    final void initMinFilter(int minFilter) {
        this.minFilter = minFilter;
    }

    final int getMinFilter() {
        return this.minFilter;
    }

    final void initMagFilter(int magFilter) {
        this.magFilter = magFilter;
    }

    final int getMagFilter() {
        return this.magFilter;
    }

    void initImage(int level, ImageComponent image) {
        this.checkImageSize(level, image);
        if (this.images == null) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureRetained0"));
        }
        if (this.source instanceof Texture2D) {
            if (image instanceof ImageComponent3D) {
                throw new IllegalArgumentException(J3dI18N.getString("Texture8"));
            }
        } else if (image instanceof ImageComponent2D) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture14"));
        }
        if (this.source.isLive()) {
            if (this.images[0][level] != null) {
                this.images[0][level].clearLive(this.refCount);
            }
            if (image != null) {
                ((ImageComponentRetained)image.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.images[0][level] = image != null ? (ImageComponentRetained)image.retained : null;
    }

    final void checkImageSize(int level, ImageComponent image) {
        if (image != null) {
            int imgWidth = ((ImageComponentRetained)image.retained).width;
            int imgHeight = ((ImageComponentRetained)image.retained).height;
            int wdh = this.width;
            int hgt = this.height;
            for (int i = 0; i < level; ++i) {
                wdh >>= 1;
                hgt >>= 1;
            }
            if (wdh < 1) {
                wdh = 1;
            }
            if (hgt < 1) {
                hgt = 1;
            }
            if (wdh != imgWidth - 2 * this.boundaryWidth || hgt != imgHeight - 2 * this.boundaryWidth) {
                throw new IllegalArgumentException(J3dI18N.getString("TextureRetained1"));
            }
        }
    }

    final void checkSizes(ImageComponentRetained[] images) {
        if (images != null) {
            int hgt = this.height;
            int wdh = this.width;
            for (int level = 0; level < images.length; ++level) {
                int imgWidth = images[level].width;
                int imgHeight = images[level].height;
                assert (wdh == imgWidth - 2 * this.boundaryWidth && hgt == imgHeight - 2 * this.boundaryWidth);
                hgt /= 2;
                if ((wdh /= 2) < 1) {
                    wdh = 1;
                }
                if (hgt >= 1) continue;
                hgt = 1;
            }
        }
    }

    final void setImage(int level, ImageComponent image) {
        this.initImage(level, image);
        Object[] arg = new Object[]{new Integer(level), image, new Integer(0)};
        this.sendMessage(4, arg);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            if (image != null && level >= this.baseLevel && level <= this.maximumLevel) {
                ImageComponentRetained img = (ImageComponentRetained)image.retained;
                if (img.isByReference()) {
                    if (img.getRefImage(0) == null) {
                        this.enable = false;
                    }
                } else if (img.getImageData(this.isUseAsRaster()).get() == null) {
                    this.enable = false;
                }
                if (!this.enable) {
                    this.sendMessage(1, Boolean.FALSE);
                }
            }
        }
    }

    void initImages(ImageComponent[] images) {
        if (images.length != this.maxLevels) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture20"));
        }
        for (int i = 0; i < images.length; ++i) {
            this.initImage(i, images[i]);
        }
    }

    final void setImages(ImageComponent[] images) {
        int i;
        this.initImages(images);
        ImageComponent[] imgs = new ImageComponent[images.length];
        for (i = 0; i < images.length; ++i) {
            imgs[i] = images[i];
        }
        Object[] arg = new Object[]{imgs, new Integer(0)};
        this.sendMessage(32, arg);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            for (i = this.baseLevel; i <= this.maximumLevel && this.enable; ++i) {
                if (images[i] == null) continue;
                ImageComponentRetained img = (ImageComponentRetained)images[i].retained;
                if (img.isByReference()) {
                    if (img.getRefImage(0) != null) continue;
                    this.enable = false;
                    continue;
                }
                if (img.getImageData(this.isUseAsRaster()).get() != null) continue;
                this.enable = false;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
    }

    final ImageComponent getImage(int level) {
        return this.images != null && this.images[0][level] != null ? (ImageComponent)this.images[0][level].source : null;
    }

    final ImageComponent[] getImages() {
        if (this.images == null) {
            return null;
        }
        ImageComponent[] rImages = new ImageComponent[this.images[0].length];
        for (int i = 0; i < this.images[0].length; ++i) {
            rImages[i] = this.images[0][i] != null ? (ImageComponent)this.images[0][i].source : null;
        }
        return rImages;
    }

    final void initMipMapMode(int mipmapMode) {
        if (this.mipmapMode == mipmapMode) {
            return;
        }
        int prevMaxLevels = this.maxLevels;
        this.mipmapMode = mipmapMode;
        if (mipmapMode != 1) {
            this.maxLevels = this.maxMipMapLevels;
        } else {
            this.baseLevel = 0;
            this.maximumLevel = 0;
            this.maxLevels = 1;
        }
        ImageComponentRetained[][] newImages = new ImageComponentRetained[this.numFaces][this.maxLevels];
        if (prevMaxLevels < this.maxLevels) {
            for (int f = 0; f < this.numFaces; ++f) {
                for (int i = 0; i < prevMaxLevels; ++i) {
                    newImages[f][i] = this.images[f][i];
                }
                for (int j = prevMaxLevels; j < this.maxLevels; ++j) {
                    newImages[f][j] = null;
                }
            }
        } else {
            for (int f = 0; f < this.numFaces; ++f) {
                for (int i = 0; i < this.maxLevels; ++i) {
                    newImages[f][i] = this.images[f][i];
                }
            }
        }
        this.images = newImages;
    }

    final int getMipMapMode() {
        return this.mipmapMode;
    }

    final void initEnable(boolean state) {
        this.userSpecifiedEnable = state;
    }

    final void setEnable(boolean state) {
        this.initEnable(state);
        if (state == this.enable) {
            return;
        }
        this.enable = state;
        for (int j = 0; j < this.numFaces && this.enable; ++j) {
            for (int i = this.baseLevel; i <= this.maximumLevel && this.enable; ++i) {
                if (this.images[j][i].isByReference()) {
                    if (this.images[j][i].getRefImage(0) != null) continue;
                    this.enable = false;
                    continue;
                }
                if (this.images[j][i].getImageData(this.isUseAsRaster()).get() != null) continue;
                this.enable = false;
            }
        }
        this.sendMessage(1, this.enable ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getEnable() {
        return this.userSpecifiedEnable;
    }

    final void initBaseLevel(int level) {
        if (level < 0 || level > this.maximumLevel) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture36"));
        }
        this.baseLevel = level;
    }

    final void setBaseLevel(int level) {
        if (level == this.baseLevel) {
            return;
        }
        this.initBaseLevel(level);
        this.sendMessage(64, new Integer(level));
    }

    final int getBaseLevel() {
        return this.baseLevel;
    }

    final void initMaximumLevel(int level) {
        if (level < this.baseLevel || level >= this.maxMipMapLevels) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture37"));
        }
        if (this.mipmapMode == 1 && level != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture48"));
        }
        this.maximumLevel = level;
    }

    final void setMaximumLevel(int level) {
        if (level == this.maximumLevel) {
            return;
        }
        this.initMaximumLevel(level);
        this.sendMessage(128, new Integer(level));
    }

    final int getMaximumLevel() {
        return this.maximumLevel;
    }

    final void initMinimumLOD(float lod) {
        if (lod > this.maximumLod) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture42"));
        }
        this.minimumLod = lod;
    }

    final void setMinimumLOD(float lod) {
        this.initMinimumLOD(lod);
        this.sendMessage(256, new Float(lod));
    }

    final float getMinimumLOD() {
        return this.minimumLod;
    }

    final void initMaximumLOD(float lod) {
        if (lod < this.minimumLod) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture42"));
        }
        this.maximumLod = lod;
    }

    final void setMaximumLOD(float lod) {
        this.initMaximumLOD(lod);
        this.sendMessage(512, new Float(lod));
    }

    final float getMaximumLOD() {
        return this.maximumLod;
    }

    final void initLodOffset(float s, float t, float r) {
        if (this.lodOffset == null) {
            this.lodOffset = new Point3f(s, t, r);
        } else {
            this.lodOffset.set(s, t, r);
        }
    }

    final void setLodOffset(float s, float t, float r) {
        this.initLodOffset(s, t, r);
        this.sendMessage(1024, new Point3f(s, t, r));
    }

    final void getLodOffset(Tuple3f offset) {
        if (this.lodOffset == null) {
            offset.set(0.0f, 0.0f, 0.0f);
        } else {
            offset.set((Tuple3f)this.lodOffset);
        }
    }

    final void initBoundaryColor(Color4f boundaryColor) {
        this.boundaryColor.set((Tuple4f)boundaryColor);
    }

    final void initBoundaryColor(float r, float g, float b, float a) {
        this.boundaryColor.set(r, g, b, a);
    }

    final void getBoundaryColor(Color4f boundaryColor) {
        boundaryColor.set((Tuple4f)this.boundaryColor);
    }

    final void initAnisotropicFilterMode(int mode) {
        this.anisotropicFilterMode = mode;
    }

    final int getAnisotropicFilterMode() {
        return this.anisotropicFilterMode;
    }

    final void initAnisotropicFilterDegree(float degree) {
        this.anisotropicFilterDegree = degree;
    }

    final float getAnisotropicFilterDegree() {
        return this.anisotropicFilterDegree;
    }

    final void initSharpenTextureFunc(float[] lod, float[] pts) {
        if (lod == null) {
            this.sharpenTextureFuncPts = null;
            this.numSharpenTextureFuncPts = 0;
        } else {
            this.numSharpenTextureFuncPts = lod.length;
            if (this.sharpenTextureFuncPts == null || this.sharpenTextureFuncPts.length != lod.length * 2) {
                this.sharpenTextureFuncPts = new float[lod.length * 2];
            }
            int j = 0;
            for (int i = 0; i < lod.length; ++i) {
                this.sharpenTextureFuncPts[j++] = lod[i];
                this.sharpenTextureFuncPts[j++] = pts[i];
            }
        }
    }

    final void initSharpenTextureFunc(Point2f[] pts) {
        if (pts == null) {
            this.sharpenTextureFuncPts = null;
            this.numSharpenTextureFuncPts = 0;
        } else {
            this.numSharpenTextureFuncPts = pts.length;
            if (this.sharpenTextureFuncPts == null || this.sharpenTextureFuncPts.length != pts.length * 2) {
                this.sharpenTextureFuncPts = new float[pts.length * 2];
            }
            int j = 0;
            for (int i = 0; i < pts.length; ++i) {
                this.sharpenTextureFuncPts[j++] = pts[i].x;
                this.sharpenTextureFuncPts[j++] = pts[i].y;
            }
        }
    }

    final void initSharpenTextureFunc(float[] pts) {
        if (pts == null) {
            this.sharpenTextureFuncPts = null;
            this.numSharpenTextureFuncPts = 0;
        } else {
            this.numSharpenTextureFuncPts = pts.length / 2;
            if (this.sharpenTextureFuncPts == null || this.sharpenTextureFuncPts.length != pts.length) {
                this.sharpenTextureFuncPts = new float[pts.length];
            }
            for (int i = 0; i < pts.length; ++i) {
                this.sharpenTextureFuncPts[i] = pts[i];
            }
        }
    }

    final int getSharpenTextureFuncPointsCount() {
        return this.numSharpenTextureFuncPts;
    }

    final void getSharpenTextureFunc(float[] lod, float[] pts) {
        if (this.sharpenTextureFuncPts != null) {
            int j = 0;
            for (int i = 0; i < this.numSharpenTextureFuncPts; ++i) {
                lod[i] = this.sharpenTextureFuncPts[j++];
                pts[i] = this.sharpenTextureFuncPts[j++];
            }
        }
    }

    final void getSharpenTextureFunc(Point2f[] pts) {
        if (this.sharpenTextureFuncPts != null) {
            int j = 0;
            for (int i = 0; i < this.numSharpenTextureFuncPts; ++i) {
                pts[i].x = this.sharpenTextureFuncPts[j++];
                pts[i].y = this.sharpenTextureFuncPts[j++];
            }
        }
    }

    final void initFilter4Func(float[] weights) {
        if (weights == null) {
            this.filter4FuncPts = null;
        } else {
            if (this.filter4FuncPts == null || this.filter4FuncPts.length != weights.length) {
                this.filter4FuncPts = new float[weights.length];
            }
            for (int i = 0; i < weights.length; ++i) {
                this.filter4FuncPts[i] = weights[i];
            }
        }
    }

    final int getFilter4FuncPointsCount() {
        if (this.filter4FuncPts == null) {
            return 0;
        }
        return this.filter4FuncPts.length;
    }

    final void getFilter4Func(float[] weights) {
        if (this.filter4FuncPts != null) {
            for (int i = 0; i < this.filter4FuncPts.length; ++i) {
                weights[i] = this.filter4FuncPts[i];
            }
        }
    }

    final float[] getSharpenTextureFunc() {
        return this.sharpenTextureFuncPts;
    }

    final float[] getFilter4Func() {
        return this.filter4FuncPts;
    }

    @Override
    void setLive(boolean backgroundGroup, int refCount) {
        int j;
        this.enable = this.userSpecifiedEnable;
        super.doSetLive(backgroundGroup, refCount);
        if (this.images != null) {
            for (j = 0; j < this.numFaces; ++j) {
                for (int i = 0; i < this.maxLevels; ++i) {
                    if (this.images[j][i] == null) {
                        throw new IllegalArgumentException(J3dI18N.getString("TextureRetained3") + i);
                    }
                    this.images[j][i].setLive(backgroundGroup, refCount);
                }
            }
        }
        if (this.images != null) {
            for (j = 0; j < this.numFaces; ++j) {
                this.checkSizes(this.images[j]);
            }
        }
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 15;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(16);
        createMessage.args[2] = null;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        if (this.userSpecifiedEnable) {
            if (this.images != null) {
                for (int j2 = 0; j2 < this.numFaces && this.enable; ++j2) {
                    for (int i = this.baseLevel; i <= this.maximumLevel && this.enable; ++i) {
                        if (this.images[j2][i].isByReference()) {
                            if (this.images[j2][i].getRefImage(0) != null) continue;
                            this.enable = false;
                            continue;
                        }
                        if (this.images[j2][i].getImageData(this.isUseAsRaster()).get() != null) continue;
                        this.enable = false;
                    }
                }
            } else {
                this.enable = false;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
        super.markAsLive();
    }

    @Override
    void clearLive(int refCount) {
        super.clearLive(refCount);
        if (this.images != null) {
            for (int j = 0; j < this.numFaces; ++j) {
                for (int i = 0; i < this.maxLevels; ++i) {
                    this.images[j][i].clearLive(refCount);
                    this.images[j][i].removeUser(this.mirror);
                }
            }
        }
    }

    void bindTexture(Context ctx, int objectId, boolean enable) {
        Pipeline.getPipeline().bindTexture2D(ctx, objectId, enable);
    }

    void updateTextureBoundary(Context ctx, int boundaryModeS, int boundaryModeT, float boundaryRed, float boundaryGreen, float boundaryBlue, float boundaryAlpha) {
        Pipeline.getPipeline().updateTexture2DBoundary(ctx, boundaryModeS, boundaryModeT, boundaryRed, boundaryGreen, boundaryBlue, boundaryAlpha);
    }

    void updateTextureFilterModes(Context ctx, int minFilter, int magFilter) {
        Pipeline.getPipeline().updateTexture2DFilterModes(ctx, minFilter, magFilter);
    }

    void updateTextureSharpenFunc(Context ctx, int numSharpenTextureFuncPts, float[] sharpenTextureFuncPts) {
        Pipeline.getPipeline().updateTexture2DSharpenFunc(ctx, numSharpenTextureFuncPts, sharpenTextureFuncPts);
    }

    void updateTextureFilter4Func(Context ctx, int numFilter4FuncPts, float[] filter4FuncPts) {
        Pipeline.getPipeline().updateTexture2DFilter4Func(ctx, numFilter4FuncPts, filter4FuncPts);
    }

    void updateTextureAnisotropicFilter(Context ctx, float degree) {
        Pipeline.getPipeline().updateTexture2DAnisotropicFilter(ctx, degree);
    }

    void updateTextureLodRange(Context ctx, int baseLevel, int maximumLevel, float minimumLod, float maximumLod) {
        Pipeline.getPipeline().updateTexture2DLodRange(ctx, baseLevel, maximumLevel, minimumLod, maximumLod);
    }

    void updateTextureLodOffset(Context ctx, float lodOffsetX, float lodOffsetY, float lodOffsetZ) {
        Pipeline.getPipeline().updateTexture2DLodOffset(ctx, lodOffsetX, lodOffsetY, lodOffsetZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeTextureId(int id) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.objectId == id) {
                this.objectId = -1;
            }
        }
    }

    private boolean isEnabled(Canvas3D cv) {
        if (this.widthOrHeightIsNPOT && !this.isUseAsRaster() && (cv.textureExtendedFeatures & 0x8000) == 0) {
            return false;
        }
        return this.enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindTexture(Canvas3D cv) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.objectId == -1) {
                this.objectId = Canvas3D.generateTexID(cv.ctx);
            }
            cv.addTextureResource(this.objectId, this);
        }
        this.bindTexture(cv.ctx, this.objectId, this.isEnabled(cv));
    }

    void updateTextureDimensions(Canvas3D cv) {
        if (this.images[0][0] != null) {
            this.updateTextureImage(cv, 0, this.maxLevels, 0, this.format, this.images[0][0].getImageFormatTypeIntValue(false), this.width, this.height, this.boundaryWidth, this.images[0][0].getImageDataTypeIntValue(), null);
        }
    }

    void updateTextureLOD(Canvas3D cv) {
        if ((cv.textureExtendedFeatures & 0x1000) != 0) {
            int max = 0;
            max = this.mipmapMode == 1 ? this.maxMipMapLevels : this.maximumLevel;
            this.updateTextureLodRange(cv.ctx, this.baseLevel, max, this.minimumLod, this.maximumLod);
        }
        if (this.lodOffset != null && (cv.textureExtendedFeatures & 0x2000) != 0) {
            this.updateTextureLodOffset(cv.ctx, this.lodOffset.x, this.lodOffset.y, this.lodOffset.z);
        }
    }

    void updateTextureBoundary(Canvas3D cv) {
        this.updateTextureBoundary(cv.ctx, this.boundaryModeS, this.boundaryModeT, this.boundaryColor.x, this.boundaryColor.y, this.boundaryColor.z, this.boundaryColor.w);
    }

    void updateTextureFields(Canvas3D cv) {
        int magnificationFilter = this.magFilter;
        int minificationFilter = this.minFilter;
        if (magnificationFilter >= 9 && magnificationFilter <= 11) {
            if ((cv.textureExtendedFeatures & 0x100) != 0) {
                this.updateTextureSharpenFunc(cv.ctx, this.numSharpenTextureFuncPts, this.sharpenTextureFuncPts);
            } else {
                magnificationFilter = 3;
            }
        } else if (magnificationFilter >= 6 && magnificationFilter <= 8 && (cv.textureExtendedFeatures & 0x200) == 0) {
            magnificationFilter = 3;
        }
        if (minificationFilter == 12 || magnificationFilter == 12) {
            boolean noFilter4 = false;
            if ((cv.textureExtendedFeatures & 0x400) != 0) {
                if (this.filter4FuncPts == null) {
                    noFilter4 = true;
                } else {
                    this.updateTextureFilter4Func(cv.ctx, this.filter4FuncPts.length, this.filter4FuncPts);
                }
            } else {
                noFilter4 = true;
            }
            if (noFilter4) {
                if (minificationFilter == 12) {
                    minificationFilter = 3;
                }
                if (magnificationFilter == 12) {
                    magnificationFilter = 3;
                }
            }
        }
        if (this.mipmapMode == 1 && (cv.textureExtendedFeatures & 0x10000) == 0) {
            if (minificationFilter == 1 || minificationFilter == 5) {
                minificationFilter = 3;
            } else if (minificationFilter == 4) {
                minificationFilter = 2;
            }
        }
        this.updateTextureFilterModes(cv.ctx, minificationFilter, magnificationFilter);
        if ((cv.textureExtendedFeatures & 0x800) != 0) {
            if (this.anisotropicFilterMode == 0) {
                this.updateTextureAnisotropicFilter(cv.ctx, 1.0f);
            } else {
                this.updateTextureAnisotropicFilter(cv.ctx, this.anisotropicFilterDegree);
            }
        }
        this.updateTextureBoundary(cv);
    }

    void updateTextureImage(Canvas3D cv, int face, int numLevels, int level, int textureFormat, int imageFormat, int width, int height, int boundaryWidth, int imageDataType, Object data) {
        Pipeline.getPipeline().updateTexture2DImage(cv.ctx, numLevels, level, textureFormat, imageFormat, width, height, boundaryWidth, imageDataType, data, this.useAutoMipMapGeneration(cv));
    }

    void updateTextureSubImage(Canvas3D cv, int face, int level, int xoffset, int yoffset, int textureFormat, int imageFormat, int imgXOffset, int imgYOffset, int tilew, int width, int height, int imageDataType, Object data) {
        Pipeline.getPipeline().updateTexture2DSubImage(cv.ctx, level, xoffset, yoffset, textureFormat, imageFormat, imgXOffset, imgYOffset, tilew, width, height, imageDataType, data, this.useAutoMipMapGeneration(cv));
    }

    void reloadTextureImage(Canvas3D cv, int face, int level, ImageComponentRetained image, int numLevels) {
        boolean useAsRaster = this.isUseAsRaster();
        ImageComponentRetained.ImageData imageData = image.getImageData(useAsRaster);
        assert (imageData != null);
        this.updateTextureImage(cv, face, numLevels, level, this.format, image.getImageFormatTypeIntValue(useAsRaster), imageData.getWidth(), imageData.getHeight(), this.boundaryWidth, image.getImageDataTypeIntValue(), imageData.get());
        if (imageData == null) {
            int xoffset = 0;
            int yoffset = 0;
            int tmpw = image.width;
            int tmph = image.height;
            int endXTile = image.tilew;
            int endYTile = image.tileh;
            int curw = endXTile;
            int curh = endYTile;
            if (tmpw < curw) {
                curw = tmpw;
            }
            if (tmph < curh) {
                curh = tmph;
            }
            int startw = curw;
            int imageXOffset = image.tilew - curw;
            int imageYOffset = image.tileh - curh;
            for (int m = 0; m < image.numYTiles; ++m) {
                xoffset = 0;
                tmpw = this.width;
                curw = startw;
                imageXOffset = image.tilew - curw;
                for (int n = 0; n < image.numXTiles; ++n) {
                    Raster ras = ((RenderedImage)image.getRefImage(0)).getTile(n, m);
                    byte[] data = ((DataBufferByte)ras.getDataBuffer()).getData();
                    this.updateTextureSubImage(cv, face, level, xoffset, yoffset, this.format, image.getImageFormatTypeIntValue(false), imageXOffset, imageYOffset, image.tilew, curw, curh, 4096, data);
                    xoffset += curw;
                    imageXOffset = 0;
                    curw = (tmpw -= curw) < image.tilew ? tmpw : image.tilew;
                }
                yoffset += curh;
                imageYOffset = 0;
                curh = (tmph -= curh) < image.tileh ? tmph : image.tileh;
            }
        }
    }

    void reloadTextureSubImage(Canvas3D cv, int face, int level, ImageComponentUpdateInfo info, ImageComponentRetained image) {
        int x = info.x;
        int y = info.y;
        int width = info.width;
        int height = info.height;
        ImageComponentRetained.ImageData imageData = image.getImageData(this.isUseAsRaster());
        if (imageData != null) {
            int xoffset = x;
            int yoffset = y;
            if (!image.yUp) {
                yoffset = image.height - yoffset - height;
            }
            this.updateTextureSubImage(cv, face, level, xoffset, yoffset, this.format, image.getImageFormatTypeIntValue(false), xoffset, yoffset, image.width, width, height, image.getImageDataTypeIntValue(), imageData.get());
        } else {
            assert (false);
            int rx = x;
            int ry = y;
            float mt = (float)rx / (float)image.tilew;
            int minTileX = mt < 0.0f ? (int)(mt - 1.0f) : (int)mt;
            mt = (float)ry / (float)image.tileh;
            int minTileY = mt < 0.0f ? (int)(mt - 1.0f) : (int)mt;
            int startXTile = minTileX * image.tilew;
            int startYTile = minTileY * image.tilew;
            int curw = startXTile + image.tilew - rx;
            int curh = startYTile + image.tileh - ry;
            if (curw > width) {
                curw = width;
            }
            if (curh > height) {
                curh = height;
            }
            int startw = curw;
            int tmpw = width;
            int tmph = height;
            int imgX = rx - startXTile;
            int imgY = ry - startYTile;
            int numXTiles = (width + imgX) / image.tilew;
            int numYTiles = (height + imgY) / image.tileh;
            if ((float)(width + imgX) % (float)image.tilew > 0.0f) {
                ++numXTiles;
            }
            if ((float)(height + imgY) % (float)image.tileh > 0.0f) {
                ++numYTiles;
            }
            int textureX = x;
            int textureY = y;
            for (int yTile = minTileY; yTile < minTileY + numYTiles; ++yTile) {
                tmpw = width;
                curw = startw;
                imgX = rx - startXTile;
                for (int xTile = minTileX; xTile < minTileX + numXTiles; ++xTile) {
                    Raster ras = ((RenderedImage)image.getRefImage(0)).getTile(xTile, yTile);
                    byte[] data = ((DataBufferByte)ras.getDataBuffer()).getData();
                    this.updateTextureSubImage(cv, face, level, textureX, textureY, this.format, image.getImageFormatTypeIntValue(false), imgX, imgY, image.tilew, curw, curh, 4096, data);
                    textureX += curw;
                    imgX = 0;
                    curw = (tmpw -= curw) < image.tilew ? tmpw : image.tilew;
                }
                textureY += curh;
                imgY = 0;
                curh = (tmph -= curh) < image.tileh ? tmph : image.tileh;
            }
        }
    }

    void reloadTexture(Canvas3D cv) {
        int mlevel;
        int blevel;
        if ((cv.textureExtendedFeatures & 0x1000) == 0) {
            blevel = 0;
            mlevel = this.maxLevels - 1;
        } else {
            blevel = this.baseLevel;
            mlevel = this.maximumLevel;
        }
        if (blevel != 0) {
            this.updateTextureDimensions(cv);
        }
        for (int j = 0; j < this.numFaces; ++j) {
            for (int i = blevel; i <= mlevel; ++i) {
                ImageComponentRetained image = this.images[j][i];
                if (image == null) continue;
                image.evaluateExtensions(cv);
                this.reloadTextureImage(cv, j, i, image, this.maxLevels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTexture(Canvas3D cv, int resourceBit) {
        for (int k = 0; k < this.numFaces; ++k) {
            for (int i = this.baseLevel; i <= this.maximumLevel; ++i) {
                if (this.imageUpdateInfo[k][i] == null) continue;
                for (int j = 0; j < this.imageUpdateInfo[k][i].size(); ++j) {
                    ImageComponentUpdateInfo info = (ImageComponentUpdateInfo)this.imageUpdateInfo[k][i].get(j);
                    Object object = this.resourceLock;
                    synchronized (object) {
                        if ((info.updateMask & resourceBit) == 0) {
                            continue;
                        }
                        info.updateMask &= ~resourceBit;
                        if ((info.updateMask & this.resourceCreationMask) == 0) {
                            info.updateMask = 0;
                            if (this.imageUpdatePruneMask == null) {
                                this.imageUpdatePruneMask = new int[this.numFaces];
                            }
                            this.imageUpdatePruneMask[k] = 1 << i;
                        }
                    }
                    if (info.entireImage) {
                        this.reloadTextureImage(cv, k, i, this.images[k][i], this.maxLevels);
                        continue;
                    }
                    this.reloadTextureSubImage(cv, k, i, info, this.images[k][i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadTextureSharedContext(Canvas3D cv) {
        if (!this.isEnabled(cv)) {
            return;
        }
        this.bindTexture(cv);
        this.updateTextureFields(cv);
        this.updateTextureLOD(cv);
        this.reloadTexture(cv);
        Object object = this.resourceLock;
        synchronized (object) {
            this.resourceCreationMask |= cv.screen.renderer.rendererBit;
            this.resourceUpdatedMask |= cv.screen.renderer.rendererBit;
            this.resourceLodUpdatedMask |= cv.screen.renderer.rendererBit;
            this.resourceInReloadList &= ~cv.screen.renderer.rendererBit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateNative(Canvas3D cv) {
        boolean reloadTexture = false;
        boolean updateTexture = false;
        boolean updateTextureLod = false;
        this.bindTexture(cv);
        if (!this.isEnabled(cv)) {
            return;
        }
        if (cv.useSharedCtx && cv.screen.renderer.sharedCtx != null) {
            if ((this.resourceCreationMask & cv.screen.renderer.rendererBit) == 0) {
                reloadTexture = true;
            } else {
                if ((this.resourceUpdatedMask & cv.screen.renderer.rendererBit) == 0 && this.imageUpdateInfo != null) {
                    updateTexture = true;
                }
                if ((this.resourceLodUpdatedMask & cv.screen.renderer.rendererBit) == 0) {
                    updateTextureLod = true;
                }
            }
            if (reloadTexture || updateTexture || updateTextureLod) {
                cv.makeCtxCurrent(cv.screen.renderer.sharedCtx);
                this.bindTexture(cv);
            }
        } else if ((this.resourceCreationMask & cv.canvasBit) == 0) {
            reloadTexture = true;
        } else {
            if ((this.resourceUpdatedMask & cv.canvasBit) == 0 && this.imageUpdateInfo != null) {
                updateTexture = true;
            }
            if ((this.resourceLodUpdatedMask & cv.canvasBit) == 0) {
                updateTextureLod = true;
            }
        }
        if (reloadTexture) {
            this.updateTextureFields(cv);
            this.updateTextureLOD(cv);
            this.reloadTexture(cv);
            if (cv.useSharedCtx) {
                cv.makeCtxCurrent(cv.ctx);
                Object object = this.resourceLock;
                synchronized (object) {
                    this.resourceCreationMask |= cv.screen.renderer.rendererBit;
                    this.resourceUpdatedMask |= cv.screen.renderer.rendererBit;
                    this.resourceLodUpdatedMask |= cv.screen.renderer.rendererBit;
                }
            } else {
                Object object = this.resourceLock;
                synchronized (object) {
                    this.resourceCreationMask |= cv.canvasBit;
                    this.resourceUpdatedMask |= cv.canvasBit;
                    this.resourceLodUpdatedMask |= cv.canvasBit;
                }
            }
        } else if (updateTextureLod || updateTexture) {
            if (updateTextureLod) {
                this.updateTextureLOD(cv);
            }
            if (updateTexture) {
                int resourceBit = 0;
                resourceBit = cv.useSharedCtx ? cv.screen.renderer.rendererBit : cv.canvasBit;
                this.updateTexture(cv, resourceBit);
            }
            if (cv.useSharedCtx) {
                cv.makeCtxCurrent(cv.ctx);
                Object object = this.resourceLock;
                synchronized (object) {
                    this.resourceUpdatedMask |= cv.screen.renderer.rendererBit;
                    this.resourceLodUpdatedMask |= cv.screen.renderer.rendererBit;
                }
            }
            Object object = this.resourceLock;
            synchronized (object) {
                this.resourceUpdatedMask |= cv.canvasBit;
                this.resourceLodUpdatedMask |= cv.canvasBit;
            }
        }
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this instanceof Texture3DRetained) {
                Texture3DRetained t3d = (Texture3DRetained)this;
                Texture3D tex = new Texture3D(t3d.mipmapMode, t3d.format, t3d.width, t3d.height, t3d.depth, t3d.boundaryWidth);
                this.mirror = (Texture3DRetained)tex.retained;
            } else if (this instanceof TextureCubeMapRetained) {
                TextureCubeMap tex = new TextureCubeMap(this.mipmapMode, this.format, this.width, this.boundaryWidth);
                this.mirror = (TextureCubeMapRetained)tex.retained;
            } else {
                Texture2D tex = new Texture2D(this.mipmapMode, this.format, this.width, this.height, this.boundaryWidth);
                this.mirror = (Texture2DRetained)tex.retained;
            }
            ((TextureRetained)this.mirror).objectId = -1;
        }
        this.initMirrorObject();
    }

    @Override
    synchronized void initMirrorObject() {
        int i;
        this.mirror.source = this.source;
        if (this instanceof Texture3DRetained) {
            Texture3DRetained t3d = (Texture3DRetained)this;
            ((Texture3DRetained)this.mirror).boundaryModeR = t3d.boundaryModeR;
            ((Texture3DRetained)this.mirror).depth = t3d.depth;
        }
        TextureRetained mirrorTexture = (TextureRetained)this.mirror;
        mirrorTexture.boundaryModeS = this.boundaryModeS;
        mirrorTexture.boundaryModeT = this.boundaryModeT;
        mirrorTexture.minFilter = this.minFilter;
        mirrorTexture.magFilter = this.magFilter;
        mirrorTexture.boundaryColor.set((Tuple4f)this.boundaryColor);
        mirrorTexture.enable = this.enable;
        mirrorTexture.userSpecifiedEnable = this.enable;
        mirrorTexture.enable = this.enable;
        mirrorTexture.numFaces = this.numFaces;
        mirrorTexture.resourceCreationMask = 0;
        mirrorTexture.resourceUpdatedMask = 0;
        mirrorTexture.resourceLodUpdatedMask = 0;
        mirrorTexture.resourceInReloadList = 0;
        mirrorTexture.baseLevel = this.baseLevel;
        mirrorTexture.maximumLevel = this.maximumLevel;
        mirrorTexture.minimumLod = this.minimumLod;
        mirrorTexture.maximumLod = this.maximumLod;
        mirrorTexture.lodOffset = this.lodOffset;
        mirrorTexture.numSharpenTextureFuncPts = this.numSharpenTextureFuncPts;
        if (this.sharpenTextureFuncPts == null) {
            mirrorTexture.sharpenTextureFuncPts = null;
        } else {
            if (mirrorTexture.sharpenTextureFuncPts == null || mirrorTexture.sharpenTextureFuncPts.length != this.sharpenTextureFuncPts.length) {
                mirrorTexture.sharpenTextureFuncPts = new float[this.sharpenTextureFuncPts.length];
            }
            for (i = 0; i < this.sharpenTextureFuncPts.length; ++i) {
                mirrorTexture.sharpenTextureFuncPts[i] = this.sharpenTextureFuncPts[i];
            }
        }
        if (this.filter4FuncPts == null) {
            mirrorTexture.filter4FuncPts = null;
        } else {
            if (mirrorTexture.filter4FuncPts == null || mirrorTexture.filter4FuncPts.length != this.filter4FuncPts.length) {
                mirrorTexture.filter4FuncPts = new float[this.filter4FuncPts.length];
            }
            for (i = 0; i < this.filter4FuncPts.length; ++i) {
                mirrorTexture.filter4FuncPts[i] = this.filter4FuncPts[i];
            }
        }
        mirrorTexture.anisotropicFilterMode = this.anisotropicFilterMode;
        mirrorTexture.anisotropicFilterDegree = this.anisotropicFilterDegree;
        mirrorTexture.maxLevels = this.maxLevels;
        if (this.images != null) {
            for (int j = 0; j < this.numFaces; ++j) {
                for (int i2 = 0; i2 < this.maxLevels; ++i2) {
                    mirrorTexture.images[j][i2] = this.images[j][i2];
                    if (this.images[j][i2] == null) continue;
                    this.images[j][i2].addUser(mirrorTexture);
                }
            }
        }
    }

    boolean useAutoMipMapGeneration(Canvas3D cv) {
        return this.mipmapMode == 1 && (this.minFilter == 1 || this.minFilter == 4 || this.minFilter == 5) && (cv.textureExtendedFeatures & 0x10000) != 0;
    }

    void pruneImageUpdateInfo() {
        for (int k = 0; k < this.numFaces; ++k) {
            for (int i = this.baseLevel; i <= this.maximumLevel; ++i) {
                if ((this.imageUpdatePruneMask[k] & 1 << i) == 0) continue;
                if (this.imageUpdateInfo[k][i] != null) {
                    for (int j = 0; j < this.imageUpdateInfo[k][i].size(); ++j) {
                        ImageComponentUpdateInfo info = (ImageComponentUpdateInfo)this.imageUpdateInfo[k][i].get(j);
                        if (info.updateMask != 0) continue;
                        this.imageUpdateInfo[k][i].remove(j);
                    }
                }
                int n = k;
                this.imageUpdatePruneMask[n] = this.imageUpdatePruneMask[n] & ~(1 << i);
            }
        }
    }

    void addImageUpdateInfo(int level, int face, ImageComponentUpdateInfo arg) {
        if (this.imageUpdateInfo == null) {
            this.imageUpdateInfo = new ArrayList[this.numFaces][this.maxLevels];
        }
        if (this.imageUpdateInfo[face][level] == null) {
            this.imageUpdateInfo[face][level] = new ArrayList();
        }
        ImageComponentUpdateInfo info = new ImageComponentUpdateInfo();
        info.entireImage = arg == null;
        if (info.entireImage) {
            this.imageUpdateInfo[face][level].clear();
            if (this.imageUpdatePruneMask != null) {
                int n = face;
                this.imageUpdatePruneMask[n] = this.imageUpdatePruneMask[n] & ~(1 << level);
            }
        } else {
            info.x = arg.x;
            info.y = arg.y;
            info.z = arg.z;
            info.width = arg.width;
            info.height = arg.height;
        }
        info.updateMask = this.resourceCreationMask;
        this.imageUpdateInfo[face][level].add(info);
        if (this.imageUpdatePruneMask != null) {
            this.pruneImageUpdateInfo();
        }
    }

    void validate() {
        this.enable = true;
        for (int j = 0; j < this.numFaces && this.enable; ++j) {
            for (int i = this.baseLevel; i <= this.maximumLevel && this.enable; ++i) {
                if (this.images[j][i] != null) continue;
                this.enable = false;
            }
        }
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        TextureRetained mirrorTexture = (TextureRetained)this.mirror;
        if ((component & 1) != 0) {
            mirrorTexture.enable = (Boolean)value;
        } else if ((component & 4) != 0) {
            Object[] arg = (Object[])value;
            int level = (Integer)arg[0];
            ImageComponent image = (ImageComponent)arg[1];
            int face = (Integer)arg[2];
            if (mirrorTexture.images[face][level] != null) {
                mirrorTexture.images[face][level].removeUser(this.mirror);
            }
            if (image == null) {
                mirrorTexture.images[face][level] = null;
            } else {
                mirrorTexture.images[face][level] = (ImageComponentRetained)image.retained;
                mirrorTexture.images[face][level].addUser(this.mirror);
            }
            mirrorTexture.resourceUpdatedMask = 0;
            mirrorTexture.addImageUpdateInfo(level, face, null);
        } else if ((component & 0x20) != 0) {
            Object[] arg = (Object[])value;
            ImageComponent[] images = (ImageComponent[])arg[0];
            int face = (Integer)arg[1];
            for (int i = 0; i < images.length; ++i) {
                if (mirrorTexture.images[face][i] != null) {
                    mirrorTexture.images[face][i].removeUser(this.mirror);
                }
                if (images[i] == null) {
                    mirrorTexture.images[face][i] = null;
                    continue;
                }
                mirrorTexture.images[face][i] = (ImageComponentRetained)images[i].retained;
                mirrorTexture.images[face][i].addUser(this.mirror);
            }
            mirrorTexture.updateResourceCreationMask();
        } else if ((component & 0x40) != 0) {
            int level = (Integer)value;
            if (level < mirrorTexture.baseLevel) {
                for (int j = 0; j < this.numFaces; ++j) {
                    for (int i = level; i < mirrorTexture.baseLevel; ++i) {
                        if (mirrorTexture.images[j][i] == null) {
                            mirrorTexture.enable = false;
                            continue;
                        }
                        mirrorTexture.addImageUpdateInfo(i, j, null);
                    }
                }
                mirrorTexture.baseLevel = level;
                mirrorTexture.resourceUpdatedMask = 0;
            } else {
                mirrorTexture.baseLevel = level;
                if (this.userSpecifiedEnable && !mirrorTexture.enable) {
                    mirrorTexture.validate();
                }
            }
            mirrorTexture.resourceLodUpdatedMask = 0;
        } else if ((component & 0x80) != 0) {
            int level = (Integer)value;
            if (level > mirrorTexture.maximumLevel) {
                for (int j = 0; j < this.numFaces; ++j) {
                    for (int i = mirrorTexture.maximumLevel; i < level; ++i) {
                        if (mirrorTexture.images[j][i] == null) {
                            mirrorTexture.enable = false;
                            continue;
                        }
                        mirrorTexture.addImageUpdateInfo(i, j, null);
                    }
                }
                mirrorTexture.maximumLevel = level;
                mirrorTexture.resourceUpdatedMask = 0;
            } else {
                mirrorTexture.maximumLevel = level;
                if (this.userSpecifiedEnable && !mirrorTexture.enable) {
                    mirrorTexture.validate();
                }
            }
            mirrorTexture.resourceLodUpdatedMask = 0;
        } else if ((component & 0x100) != 0) {
            mirrorTexture.minimumLod = ((Float)value).floatValue();
            mirrorTexture.resourceLodUpdatedMask = 0;
        } else if ((component & 0x200) != 0) {
            mirrorTexture.maximumLod = ((Float)value).floatValue();
            mirrorTexture.resourceLodUpdatedMask = 0;
        } else if ((component & 0x400) != 0) {
            if (mirrorTexture.lodOffset == null) {
                mirrorTexture.lodOffset = new Point3f((Point3f)value);
            } else {
                mirrorTexture.lodOffset.set((Tuple3f)((Point3f)value));
            }
            mirrorTexture.resourceLodUpdatedMask = 0;
        } else if ((component & 0x10) != 0) {
            mirrorTexture.updateResourceCreationMask();
        }
    }

    void notifyImageComponentImageChanged(ImageComponentRetained image, ImageComponentUpdateInfo value) {
        if (this.resourceCreationMask == 0) {
            if (this.imageUpdateInfo != null) {
                for (int face = 0; face < this.numFaces; ++face) {
                    for (int level = 0; level < this.maxLevels; ++level) {
                        if (this.imageUpdateInfo[face][level] == null) continue;
                        this.imageUpdateInfo[face][level].clear();
                    }
                    if (this.imageUpdatePruneMask == null) continue;
                    this.imageUpdatePruneMask[face] = 0;
                }
            }
            return;
        }
        for (int j = 0; j < this.numFaces; ++j) {
            boolean done = false;
            for (int i = this.baseLevel; i <= this.maximumLevel && !done; ++i) {
                if (this.images[j][i] != image) continue;
                this.resourceUpdatedMask = 0;
                this.addImageUpdateInfo(i, j, value);
                done = true;
            }
        }
    }

    void updateResourceCreationMask() {
        this.resourceCreationMask = 0;
    }

    void incTextureBinRefCount(TextureBin tb) {
        this.setTextureBinRefCount(tb, this.getTextureBinRefCount(tb) + 1);
        for (int j = 0; j < this.numFaces; ++j) {
            for (int i = 0; i < this.maxLevels; ++i) {
                ImageComponentRetained image = this.images[j][i];
                if (image == null || !image.isByReference() && (image.source == null || !image.source.getCapability(3))) continue;
                tb.renderBin.addNodeComponent(image);
            }
        }
    }

    void decTextureBinRefCount(TextureBin tb) {
        this.setTextureBinRefCount(tb, this.getTextureBinRefCount(tb) - 1);
        for (int j = 0; j < this.numFaces; ++j) {
            for (int i = 0; i < this.maxLevels; ++i) {
                ImageComponentRetained image = this.images[j][i];
                if (image == null || !image.isByReference() && (image.source == null || !image.source.getCapability(3))) continue;
                tb.renderBin.removeNodeComponent(image);
            }
        }
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 15;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i = 0; i < univList.size(); ++i) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 15;
            createMessage.universe = univList.get(i);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        switch (bit) {
            case 1: 
            case 7: 
            case 11: {
                this.setFrequencyChangeMask(bit, bit);
            }
        }
    }

    void setUseAsRaster(boolean useAsRaster) {
        this.useAsRaster = useAsRaster;
    }

    boolean isUseAsRaster() {
        return this.useAsRaster;
    }

    int getTextureBinRefCount(TextureBin tb) {
        Integer i = this.textureBinRefCount.get(tb.renderBin);
        return i == null ? 0 : i;
    }

    private void setTextureBinRefCount(TextureBin tb, int refCount) {
        if (refCount == 0) {
            this.textureBinRefCount.remove(tb.renderBin);
        } else {
            this.textureBinRefCount.put(tb.renderBin, new Integer(refCount));
        }
    }
}

