/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BadTransformException;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;

public class TransformGroup
extends Group {
    public static final int ALLOW_TRANSFORM_READ = 17;
    public static final int ALLOW_TRANSFORM_WRITE = 18;
    private static final int[] readCapabilities = new int[]{17};

    public TransformGroup() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public TransformGroup(Transform3D t1) {
        if (!t1.isAffine()) {
            throw new BadTransformException(J3dI18N.getString("TransformGroup0"));
        }
        this.setDefaultReadCapabilities(readCapabilities);
        ((TransformGroupRetained)this.retained).setTransform(t1);
    }

    @Override
    void createRetained() {
        this.retained = new TransformGroupRetained();
        this.retained.setSource(this);
    }

    public void setTransform(Transform3D t1) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransformGroup1"));
        }
        if (!t1.isAffine()) {
            throw new BadTransformException(J3dI18N.getString("TransformGroup0"));
        }
        ((TransformGroupRetained)this.retained).setTransform(t1);
    }

    public void getTransform(Transform3D t1) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransformGroup2"));
        }
        ((TransformGroupRetained)this.retained).getTransform(t1);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        TransformGroup tg = new TransformGroup();
        tg.duplicateNode(this, forceDuplicate);
        return tg;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        Transform3D t = new Transform3D();
        ((TransformGroupRetained)originalNode.retained).getTransform(t);
        ((TransformGroupRetained)this.retained).setTransform(t);
    }
}

