/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class Utils {
    private static final double ZERO_TOL = 1.0E-5;

    Utils() {
    }

    static final double ptToSegSquare(Point3d pt, Point3d start, Point3d end, Point3d closest) {
        Vector3d dir = new Vector3d();
        dir.sub((Tuple3d)end, (Tuple3d)start);
        Vector3d dt = new Vector3d();
        dt.sub((Tuple3d)pt, (Tuple3d)start);
        double proj = dir.dot(dt);
        if (proj <= 0.0) {
            if (closest != null) {
                closest.set((Tuple3d)start);
            }
            return dt.lengthSquared();
        }
        double segSquared = dir.lengthSquared();
        if (proj >= segSquared) {
            if (closest != null) {
                closest.set((Tuple3d)end);
            }
            dt.sub((Tuple3d)pt, (Tuple3d)end);
            return dt.lengthSquared();
        }
        dt.scaleAdd(proj / segSquared, (Tuple3d)dir, (Tuple3d)start);
        if (closest != null) {
            closest.set((Tuple3d)dt);
        }
        dt.sub((Tuple3d)pt, (Tuple3d)dt);
        return dt.lengthSquared();
    }

    static final double ptToRaySquare(Point3d pt, Point3d start, Vector3d dir, Point3d closest) {
        Vector3d dt = new Vector3d();
        dt.sub((Tuple3d)pt, (Tuple3d)start);
        double proj = dir.dot(dt);
        if (proj <= 0.0) {
            if (closest != null) {
                closest.set((Tuple3d)start);
            }
            return dt.lengthSquared();
        }
        double raySquared = dir.lengthSquared();
        dt.scaleAdd(proj / raySquared, (Tuple3d)dir, (Tuple3d)start);
        if (closest != null) {
            closest.set((Tuple3d)dt);
        }
        dt.sub((Tuple3d)pt, (Tuple3d)dt);
        return dt.lengthSquared();
    }

    public static double rayToSegment(Point3d rayorig, Vector3d raydir, Point3d segstart, Point3d segend, Point3d rayint, Point3d segint, double[] param) {
        Vector3d diff = new Vector3d();
        diff.sub((Tuple3d)rayorig, (Tuple3d)segstart);
        Vector3d segdir = new Vector3d();
        segdir.sub((Tuple3d)segend, (Tuple3d)segstart);
        double A = raydir.dot(raydir);
        double B = -raydir.dot(segdir);
        double C = segdir.dot(segdir);
        double D = raydir.dot(diff);
        double F = diff.dot(diff);
        double det = Math.abs(A * C - B * B);
        if (det >= 1.0E-5) {
            double E = -segdir.dot(diff);
            double s = B * E - C * D;
            double t = B * D - A * E;
            if (s >= 0.0) {
                if (t >= 0.0) {
                    if (t <= det) {
                        double invDet = 1.0 / det;
                        s *= invDet;
                        t *= invDet;
                        if (rayint != null) {
                            rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
                        }
                        if (segint != null) {
                            segint.scaleAdd(t, (Tuple3d)segdir, (Tuple3d)segstart);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(s * (A * s + B * t + 2.0 * D) + t * (B * s + C * t + 2.0 * E) + F);
                    }
                    t = 1.0;
                    if (D >= 0.0) {
                        s = 0.0;
                        if (rayint != null) {
                            rayint.set((Tuple3d)rayorig);
                        }
                        if (segint != null) {
                            segint.set((Tuple3d)segend);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(C + 2.0 * E + F);
                    }
                    s = -D / A;
                    if (rayint != null) {
                        rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segend);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs((D + 2.0 * B) * s + C + 2.0 * E + F);
                }
                t = 0.0;
                if (D >= 0.0) {
                    s = 0.0;
                    if (rayint != null) {
                        rayint.set((Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segstart);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(F);
                }
                s = -D / A;
                if (rayint != null) {
                    rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.set((Tuple3d)segstart);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(D * s + F);
            }
            if (t <= 0.0) {
                if (D < 0.0) {
                    s = -D / A;
                    t = 0.0;
                    if (rayint != null) {
                        rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segstart);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(D * s + F);
                }
                s = 0.0;
                if (E >= 0.0) {
                    t = 0.0;
                    if (rayint != null) {
                        rayint.set((Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segstart);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(F);
                }
                if (-E >= C) {
                    t = 1.0;
                    if (rayint != null) {
                        rayint.set((Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segend);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(C + 2.0 * E + F);
                }
                t = -E / C;
                if (rayint != null) {
                    rayint.set((Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.scaleAdd(t, (Tuple3d)segdir, (Tuple3d)segstart);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(E * t + F);
            }
            if (t <= det) {
                s = 0.0;
                if (E >= 0.0) {
                    t = 0.0;
                    if (rayint != null) {
                        rayint.set((Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segstart);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(F);
                }
                if (-E >= C) {
                    t = 1.0;
                    if (rayint != null) {
                        rayint.set((Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segend);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(C + 2.0 * E + F);
                }
                t = -E / C;
                if (rayint != null) {
                    rayint.set((Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.scaleAdd(t, (Tuple3d)segdir, (Tuple3d)segstart);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(E * t + F);
            }
            double tmp = B + D;
            if (tmp < 0.0) {
                s = -tmp / A;
                t = 1.0;
                if (rayint != null) {
                    rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.set((Tuple3d)segend);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(tmp * s + C + 2.0 * E + F);
            }
            s = 0.0;
            if (E >= 0.0) {
                t = 0.0;
                if (rayint != null) {
                    rayint.set((Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.set((Tuple3d)segstart);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(F);
            }
            if (-E >= C) {
                t = 1.0;
                if (rayint != null) {
                    rayint.set((Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.set((Tuple3d)segend);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(C + 2.0 * E + F);
            }
            t = -E / C;
            if (rayint != null) {
                rayint.set((Tuple3d)rayorig);
            }
            if (segint != null) {
                segint.scaleAdd(t, (Tuple3d)segdir, (Tuple3d)segstart);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Math.abs(E * t + F);
        }
        if (B > 0.0) {
            double t = 0.0;
            if (D >= 0.0) {
                double s = 0.0;
                if (rayint != null) {
                    rayint.set((Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.set((Tuple3d)segstart);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(F);
            }
            double s = -D / A;
            if (rayint != null) {
                rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
            }
            if (segint != null) {
                segint.set((Tuple3d)segstart);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Math.abs(D * s + F);
        }
        double E = segdir.dot(diff);
        double t = 1.0;
        double tmp = B + D;
        if (tmp >= 0.0) {
            double s = 0.0;
            if (rayint != null) {
                rayint.set((Tuple3d)rayorig);
            }
            if (segint != null) {
                segint.set((Tuple3d)segend);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Math.abs(C + 2.0 * E + F);
        }
        double s = -tmp / A;
        if (rayint != null) {
            rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
        }
        if (segint != null) {
            segint.set((Tuple3d)segend);
        }
        if (param != null) {
            param[0] = s;
            param[1] = t;
        }
        return Math.abs(tmp * s + C + 2.0 * E + F);
    }

    public static double segmentToSegment(Point3d s0start, Point3d s0end, Point3d s1start, Point3d s1end, Point3d s0int, Point3d s1int, double[] param) {
        Vector3d diff = new Vector3d();
        diff.sub((Tuple3d)s0start, (Tuple3d)s1start);
        Vector3d seg0dir = new Vector3d();
        seg0dir.sub((Tuple3d)s0end, (Tuple3d)s0start);
        Vector3d seg1dir = new Vector3d();
        seg1dir.sub((Tuple3d)s1end, (Tuple3d)s1start);
        double A = seg0dir.dot(seg0dir);
        double B = -seg0dir.dot(seg1dir);
        double C = seg1dir.dot(seg1dir);
        double D = seg0dir.dot(diff);
        double F = diff.dot(diff);
        double det = Math.abs(A * C - B * B);
        if (det >= 1.0E-5) {
            double E = -seg1dir.dot(diff);
            double s = B * E - C * D;
            double t = B * D - A * E;
            if (s >= 0.0) {
                if (s <= det) {
                    if (t >= 0.0) {
                        if (t <= det) {
                            double invDet = 1.0 / det;
                            s *= invDet;
                            t *= invDet;
                            if (s0int != null) {
                                s0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)s0start);
                            }
                            if (s1int != null) {
                                s1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)s1start);
                            }
                            if (param != null) {
                                param[0] = s;
                                param[1] = t;
                            }
                            return Math.abs(s * (A * s + B * t + 2.0 * D) + t * (B * s + C * t + 2.0 * E) + F);
                        }
                        t = 1.0;
                        double tmp = B + D;
                        if (tmp >= 0.0) {
                            s = 0.0;
                            if (s0int != null) {
                                s0int.set((Tuple3d)s0start);
                            }
                            if (s1int != null) {
                                s1int.set((Tuple3d)s1end);
                            }
                            if (param != null) {
                                param[0] = s;
                                param[1] = t;
                            }
                            return Math.abs(C + 2.0 * E + F);
                        }
                        if (-tmp >= A) {
                            s = 1.0;
                            if (s0int != null) {
                                s0int.set((Tuple3d)s0end);
                            }
                            if (s1int != null) {
                                s1int.set((Tuple3d)s1end);
                            }
                            if (param != null) {
                                param[0] = s;
                                param[1] = t;
                            }
                            return Math.abs(A + C + F + 2.0 * (E + tmp));
                        }
                        s = -tmp / A;
                        if (s0int != null) {
                            s0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)s0start);
                        }
                        if (s1int != null) {
                            s1int.set((Tuple3d)s1end);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(tmp * s + C + 2.0 * E + F);
                    }
                    t = 0.0;
                    if (D >= 0.0) {
                        s = 0.0;
                        if (s0int != null) {
                            s0int.set((Tuple3d)s0start);
                        }
                        if (s1int != null) {
                            s1int.set((Tuple3d)s1start);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(F);
                    }
                    if (-D >= A) {
                        s = 1.0;
                        if (s0int != null) {
                            s0int.set((Tuple3d)s0end);
                        }
                        if (s1int != null) {
                            s1int.set((Tuple3d)s1start);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(A + 2.0 * D + F);
                    }
                    s = -D / A;
                    if (s0int != null) {
                        s0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)s0start);
                    }
                    if (s1int != null) {
                        s1int.set((Tuple3d)s1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(D * s + F);
                }
                if (t >= 0.0) {
                    if (t <= det) {
                        s = 1.0;
                        double tmp = B + E;
                        if (tmp >= 0.0) {
                            t = 0.0;
                            if (s0int != null) {
                                s0int.set((Tuple3d)s0end);
                            }
                            if (s1int != null) {
                                s1int.set((Tuple3d)s1start);
                            }
                            if (param != null) {
                                param[0] = s;
                                param[1] = t;
                            }
                            return Math.abs(A + 2.0 * D + F);
                        }
                        if (-tmp >= C) {
                            t = 1.0;
                            if (s0int != null) {
                                s0int.set((Tuple3d)s0end);
                            }
                            if (s1int != null) {
                                s1int.set((Tuple3d)s1end);
                            }
                            if (param != null) {
                                param[0] = s;
                                param[1] = t;
                            }
                            return Math.abs(A + C + F + 2.0 * (D + tmp));
                        }
                        t = -tmp / C;
                        if (s0int != null) {
                            s0int.set((Tuple3d)s0end);
                        }
                        if (s1int != null) {
                            s1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)s1start);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(tmp * t + A + 2.0 * D + F);
                    }
                    double tmp = B + D;
                    if (-tmp <= A) {
                        t = 1.0;
                        if (tmp >= 0.0) {
                            s = 0.0;
                            if (s0int != null) {
                                s0int.set((Tuple3d)s0start);
                            }
                            if (s1int != null) {
                                s1int.set((Tuple3d)s1end);
                            }
                            if (param != null) {
                                param[0] = s;
                                param[1] = t;
                            }
                            return Math.abs(C + 2.0 * E + F);
                        }
                        s = -tmp / A;
                        if (s0int != null) {
                            s0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)s0start);
                        }
                        if (s1int != null) {
                            s1int.set((Tuple3d)s1end);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(tmp * s + C + 2.0 * E + F);
                    }
                    s = 1.0;
                    tmp = B + E;
                    if (tmp >= 0.0) {
                        t = 0.0;
                        if (s0int != null) {
                            s0int.set((Tuple3d)s0end);
                        }
                        if (s1int != null) {
                            s1int.set((Tuple3d)s1start);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(A + 2.0 * D + F);
                    }
                    if (-tmp >= C) {
                        t = 1.0;
                        if (s0int != null) {
                            s0int.set((Tuple3d)s0end);
                        }
                        if (s1int != null) {
                            s1int.set((Tuple3d)s1end);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(A + C + F + 2.0 * (D + tmp));
                    }
                    t = -tmp / C;
                    if (s0int != null) {
                        s0int.set((Tuple3d)s0end);
                    }
                    if (s1int != null) {
                        s1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)s1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(tmp * t + A + 2.0 * D + F);
                }
                if (-D < A) {
                    t = 0.0;
                    if (D >= 0.0) {
                        s = 0.0;
                        if (s0int != null) {
                            s0int.set((Tuple3d)s0start);
                        }
                        if (s1int != null) {
                            s1int.set((Tuple3d)s1start);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(F);
                    }
                    s = -D / A;
                    if (s0int != null) {
                        s0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)s0start);
                    }
                    if (s1int != null) {
                        s1int.set((Tuple3d)s1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(D * s + F);
                }
                s = 1.0;
                double tmp = B + E;
                if (tmp >= 0.0) {
                    t = 0.0;
                    if (s0int != null) {
                        s0int.set((Tuple3d)s0end);
                    }
                    if (s1int != null) {
                        s1int.set((Tuple3d)s1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(A + 2.0 * D + F);
                }
                if (-tmp >= C) {
                    t = 1.0;
                    if (s0int != null) {
                        s0int.set((Tuple3d)s0end);
                    }
                    if (s1int != null) {
                        s1int.set((Tuple3d)s1end);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(A + C + F + 2.0 * (D + tmp));
                }
                t = -tmp / C;
                if (s0int != null) {
                    s0int.set((Tuple3d)s0end);
                }
                if (s1int != null) {
                    s1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)s1start);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(tmp * t + A + 2.0 * D + F);
            }
            if (t >= 0.0) {
                if (t <= det) {
                    s = 0.0;
                    if (E >= 0.0) {
                        t = 0.0;
                        if (s0int != null) {
                            s0int.set((Tuple3d)s0start);
                        }
                        if (s1int != null) {
                            s1int.set((Tuple3d)s1start);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(F);
                    }
                    if (-E >= C) {
                        t = 1.0;
                        if (s0int != null) {
                            s0int.set((Tuple3d)s0start);
                        }
                        if (s1int != null) {
                            s1int.set((Tuple3d)s1end);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(C + 2.0 * E + F);
                    }
                    t = -E / C;
                    if (s0int != null) {
                        s0int.set((Tuple3d)s0start);
                    }
                    if (s1int != null) {
                        s1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)s1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(E * t + F);
                }
                double tmp = B + D;
                if (tmp < 0.0) {
                    t = 1.0;
                    if (-tmp >= A) {
                        s = 1.0;
                        if (s0int != null) {
                            s0int.set((Tuple3d)s0end);
                        }
                        if (s1int != null) {
                            s1int.set((Tuple3d)s1end);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Math.abs(A + C + F + 2.0 * (E + tmp));
                    }
                    s = -tmp / A;
                    if (s0int != null) {
                        s0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)s0start);
                    }
                    if (s1int != null) {
                        s1int.set((Tuple3d)s1end);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(tmp * s + C + 2.0 * E + F);
                }
                s = 0.0;
                if (E >= 0.0) {
                    t = 0.0;
                    if (s0int != null) {
                        s0int.set((Tuple3d)s0start);
                    }
                    if (s1int != null) {
                        s1int.set((Tuple3d)s1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(F);
                }
                if (-E >= C) {
                    t = 1.0;
                    if (s0int != null) {
                        s0int.set((Tuple3d)s0start);
                    }
                    if (s1int != null) {
                        s1int.set((Tuple3d)s1end);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(C + 2.0 * E + F);
                }
                t = -E / C;
                if (s0int != null) {
                    s0int.set((Tuple3d)s0start);
                }
                if (s1int != null) {
                    s1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)s1start);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(E * t + F);
            }
            if (D < 0.0) {
                t = 0.0;
                if (-D >= A) {
                    s = 1.0;
                    if (s0int != null) {
                        s0int.set((Tuple3d)s0end);
                    }
                    if (s1int != null) {
                        s1int.set((Tuple3d)s1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Math.abs(A + 2.0 * D + F);
                }
                s = -D / A;
                if (s0int != null) {
                    s0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)s0start);
                }
                if (s1int != null) {
                    s1int.set((Tuple3d)s1start);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(D * s + F);
            }
            s = 0.0;
            if (E >= 0.0) {
                t = 0.0;
                if (s0int != null) {
                    s0int.set((Tuple3d)s0start);
                }
                if (s1int != null) {
                    s1int.set((Tuple3d)s1start);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(F);
            }
            if (-E >= C) {
                t = 1.0;
                if (s0int != null) {
                    s0int.set((Tuple3d)s0start);
                }
                if (s1int != null) {
                    s1int.set((Tuple3d)s1end);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(C + 2.0 * E + F);
            }
            t = -E / C;
            if (s0int != null) {
                s0int.set((Tuple3d)s0start);
            }
            if (s1int != null) {
                s1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)s1start);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Math.abs(E * t + F);
        }
        if (B > 0.0) {
            if (D >= 0.0) {
                double s = 0.0;
                double t = 0.0;
                if (s0int != null) {
                    s0int.set((Tuple3d)s0start);
                }
                if (s1int != null) {
                    s1int.set((Tuple3d)s1start);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(F);
            }
            if (-D <= A) {
                double s = -D / A;
                double t = 0.0;
                if (s0int != null) {
                    s0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)s0start);
                }
                if (s1int != null) {
                    s1int.set((Tuple3d)s1start);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(D * s + F);
            }
            double E = -seg1dir.dot(diff);
            double s = 1.0;
            double tmp = A + D;
            if (-tmp >= B) {
                double t = 1.0;
                if (s0int != null) {
                    s0int.set((Tuple3d)s0end);
                }
                if (s1int != null) {
                    s1int.set((Tuple3d)s1end);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Math.abs(A + C + F + 2.0 * (B + D + E));
            }
            double t = -tmp / B;
            if (s0int != null) {
                s0int.set((Tuple3d)s0end);
            }
            if (s1int != null) {
                s1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)s1start);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Math.abs(A + 2.0 * D + F + t * (C * t + 2.0 * (B + E)));
        }
        if (-D >= A) {
            double s = 1.0;
            double t = 0.0;
            if (s0int != null) {
                s0int.set((Tuple3d)s0end);
            }
            if (s1int != null) {
                s1int.set((Tuple3d)s1start);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Math.abs(A + 2.0 * D + F);
        }
        if (D <= 0.0) {
            double s = -D / A;
            double t = 0.0;
            if (s0int != null) {
                s0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)s0start);
            }
            if (s1int != null) {
                s1int.set((Tuple3d)s1start);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Math.abs(D * s + F);
        }
        double E = -seg1dir.dot(diff);
        double s = 0.0;
        if (D >= -B) {
            double t = 1.0;
            if (s0int != null) {
                s0int.set((Tuple3d)s0start);
            }
            if (s1int != null) {
                s1int.set((Tuple3d)s1end);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Math.abs(C + 2.0 * E + F);
        }
        double t = -D / B;
        if (s0int != null) {
            s0int.set((Tuple3d)s0start);
        }
        if (s1int != null) {
            s1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)s1start);
        }
        if (param != null) {
            param[0] = s;
            param[1] = t;
        }
        return Math.abs(F + t * (2.0 * E + C * t));
    }
}

