/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.j3d.BehaviorScheduler;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryStructure;
import javax.media.j3d.GraphStructureChangeListener;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dQueryProps;
import javax.media.j3d.Locale;
import javax.media.j3d.MasterControl;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Renderer;
import javax.media.j3d.RenderingEnvironmentStructure;
import javax.media.j3d.RenderingError;
import javax.media.j3d.RenderingErrorListener;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.ShaderError;
import javax.media.j3d.ShaderErrorListener;
import javax.media.j3d.ShaderProgram;
import javax.media.j3d.SoundStructure;
import javax.media.j3d.TransformStructure;
import javax.media.j3d.VersionInfo;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatformRetained;

public class VirtualUniverse {
    static MasterControl mc = null;
    Object sceneGraphLock = new Object();
    Object behaviorLock = new Object();
    Vector<Locale> listOfLocales = new Vector();
    private ArrayList<ViewPlatformRetained> viewPlatforms = new ArrayList();
    private boolean vpChanged = false;
    private ViewPlatformRetained[] viewPlatformList = new ViewPlatformRetained[0];
    BehaviorScheduler behaviorScheduler = null;
    GeometryStructure geometryStructure = null;
    TransformStructure transformStructure = null;
    BehaviorStructure behaviorStructure = null;
    SoundStructure soundStructure = null;
    RenderingEnvironmentStructure renderingEnvironmentStructure = null;
    int renderingEnvironmentStructureRefCount = 0;
    long nodeIdCount = 0L;
    int viewIdCount = 0;
    Vector<String> nodeIdFreeList = new Vector();
    ArrayList<Integer> viewIdFreeList = new ArrayList();
    int numNodes = 0;
    SetLiveState setLiveState;
    ObjectUpdate[] updateObjects = new ObjectUpdate[16];
    int updateObjectsLen = 0;
    View currentView;
    boolean inBehavior = false;
    boolean enableComponent = false;
    boolean enableFocus = false;
    boolean enableKey = false;
    boolean enableMouse = false;
    boolean enableMouseMotion = false;
    boolean enableMouseWheel = false;
    int activeViewCount = 0;
    static ThreadGroup rootThreadGroup;
    private static J3dQueryProps properties;
    View regViewWaiting = null;
    View unRegViewWaiting = null;
    boolean isSceneGraphLock = false;
    private Object waitLock = new Object();
    private HashSet<GraphStructureChangeListener> structureChangeListenerSet = null;
    private HashSet<ShaderErrorListener> shaderErrorListenerSet = null;
    private ShaderErrorListener defaultShaderErrorListener = ShaderProgram.getDefaultErrorListener();
    private static HashSet<RenderingErrorListener> renderingErrorListenerSet;
    private static RenderingErrorListener defaultRenderingErrorListener;

    public VirtualUniverse() {
        this.setLiveState = new SetLiveState(this);
        this.initMCStructure();
    }

    void initMCStructure() {
        if (this.geometryStructure != null) {
            this.geometryStructure.cleanup();
        }
        this.geometryStructure = new GeometryStructure(this);
        if (this.transformStructure != null) {
            this.transformStructure.cleanup();
        }
        this.transformStructure = new TransformStructure(this);
        if (this.behaviorStructure != null) {
            this.behaviorStructure.cleanup();
        }
        this.behaviorStructure = new BehaviorStructure(this);
        if (this.soundStructure != null) {
            this.soundStructure.cleanup();
        }
        this.soundStructure = new SoundStructure(this);
        if (this.renderingEnvironmentStructure != null) {
            this.renderingEnvironmentStructure.cleanup();
        }
        this.renderingEnvironmentStructure = new RenderingEnvironmentStructure(this);
    }

    static void loadLibraries() {
    }

    void addLocale(Locale locale) {
        this.listOfLocales.addElement(locale);
    }

    public void removeLocale(Locale locale) {
        if (locale.getVirtualUniverse() != this) {
            throw new IllegalArgumentException(J3dI18N.getString("VirtualUniverse0"));
        }
        this.listOfLocales.removeElement(locale);
        locale.removeFromUniverse();
        if (this.isEmpty()) {
            mc.postRequest(MasterControl.EMPTY_UNIVERSE, this);
        }
        this.setLiveState.reset(null);
    }

    public void removeAllLocales() {
        int i;
        for (i = this.listOfLocales.size() - 1; i > 0; --i) {
            this.listOfLocales.get(i).removeFromUniverse();
        }
        if (i >= 0) {
            Locale loc = this.listOfLocales.get(0);
            this.listOfLocales.clear();
            loc.removeFromUniverse();
        }
        mc.postRequest(MasterControl.EMPTY_UNIVERSE, this);
        this.setLiveState.reset(null);
    }

    public Enumeration<Locale> getAllLocales() {
        return this.listOfLocales.elements();
    }

    public int numLocales() {
        return this.listOfLocales.size();
    }

    public static void setJ3DThreadPriority(int priority) {
        if (priority > 10) {
            priority = 10;
        } else if (priority < 1) {
            priority = 1;
        }
        mc.setThreadPriority(priority);
    }

    public static int getJ3DThreadPriority() {
        return mc.getThreadPriority();
    }

    public static final Map getProperties() {
        if (properties == null) {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<Object> values = new ArrayList<Object>();
            keys.add("j3d.version");
            values.add(VersionInfo.getVersion());
            keys.add("j3d.vendor");
            values.add(VersionInfo.getVendor());
            keys.add("j3d.specification.version");
            values.add(VersionInfo.getSpecificationVersion());
            keys.add("j3d.specification.vendor");
            values.add(VersionInfo.getSpecificationVendor());
            keys.add("j3d.renderer");
            values.add(Pipeline.getPipeline().getRendererName());
            keys.add("j3d.pipeline");
            values.add(Pipeline.getPipeline().getPipelineName());
            properties = new J3dQueryProps(keys, values);
        }
        return properties;
    }

    String getNodeId() {
        String str;
        if (this.nodeIdFreeList.size() == 0) {
            str = Long.toString(this.nodeIdCount);
            ++this.nodeIdCount;
        } else {
            int idx = this.nodeIdFreeList.size() - 1;
            str = this.nodeIdFreeList.remove(idx);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getViewId() {
        Integer id;
        ArrayList<Integer> arrayList = this.viewIdFreeList;
        synchronized (arrayList) {
            int size = this.viewIdFreeList.size();
            id = size == 0 ? new Integer(this.viewIdCount++) : this.viewIdFreeList.remove(size - 1);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addViewIdToFreeList(Integer viewId) {
        ArrayList<Integer> arrayList = this.viewIdFreeList;
        synchronized (arrayList) {
            this.viewIdFreeList.add(viewId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addViewPlatform(ViewPlatformRetained vp) {
        ArrayList<ViewPlatformRetained> arrayList = this.viewPlatforms;
        synchronized (arrayList) {
            this.vpChanged = true;
            this.viewPlatforms.add(vp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeViewPlatform(ViewPlatformRetained vp) {
        ArrayList<ViewPlatformRetained> arrayList = this.viewPlatforms;
        synchronized (arrayList) {
            if (this.viewPlatforms.remove(vp)) {
                this.vpChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ViewPlatformRetained[] getViewPlatformList() {
        ArrayList<ViewPlatformRetained> arrayList = this.viewPlatforms;
        synchronized (arrayList) {
            if (this.vpChanged) {
                this.viewPlatformList = this.viewPlatforms.toArray(new ViewPlatformRetained[this.viewPlatforms.size()]);
                this.vpChanged = false;
            }
            return this.viewPlatformList;
        }
    }

    void checkForEnableEvents() {
        if (this.enableFocus) {
            this.enableFocusEvents();
        }
        if (this.enableKey) {
            this.enableKeyEvents();
        }
        if (this.enableMouse) {
            this.enableMouseEvents();
        }
        if (this.enableMouseMotion) {
            this.enableMouseMotionEvents();
        }
        if (this.enableMouseWheel) {
            this.enableMouseWheelEvents();
        }
    }

    void disableFocusEvents() {
        ViewPlatformRetained[] vps = this.getViewPlatformList();
        this.enableFocus = false;
        for (int i = 0; i < vps.length; ++i) {
            View[] views = vps[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                Enumeration<Canvas3D> cvs = views[j].getAllCanvas3Ds();
                while (cvs.hasMoreElements()) {
                    Canvas3D cv = cvs.nextElement();
                    if (cv.eventCatcher == null) continue;
                    cv.eventCatcher.disableFocusEvents();
                }
            }
        }
    }

    void enableFocusEvents() {
        ViewPlatformRetained[] vps = this.getViewPlatformList();
        this.enableFocus = true;
        for (int i = 0; i < vps.length; ++i) {
            View[] views = vps[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                Enumeration<Canvas3D> cvs = views[j].getAllCanvas3Ds();
                while (cvs.hasMoreElements()) {
                    Canvas3D cv = cvs.nextElement();
                    if (cv.eventCatcher == null) continue;
                    cv.eventCatcher.enableFocusEvents();
                }
            }
        }
    }

    void disableKeyEvents() {
        ViewPlatformRetained[] vps = this.getViewPlatformList();
        this.enableKey = false;
        for (int i = 0; i < vps.length; ++i) {
            View[] views = vps[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                Enumeration<Canvas3D> cvs = views[j].getAllCanvas3Ds();
                while (cvs.hasMoreElements()) {
                    Canvas3D cv = cvs.nextElement();
                    if (cv.eventCatcher == null) continue;
                    cv.eventCatcher.disableKeyEvents();
                }
            }
        }
    }

    void enableKeyEvents() {
        ViewPlatformRetained[] vps = this.getViewPlatformList();
        this.enableKey = true;
        for (int i = 0; i < vps.length; ++i) {
            View[] views = vps[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                Enumeration<Canvas3D> cvs = views[j].getAllCanvas3Ds();
                while (cvs.hasMoreElements()) {
                    Canvas3D cv = cvs.nextElement();
                    if (cv.eventCatcher == null) continue;
                    cv.eventCatcher.enableKeyEvents();
                }
            }
        }
    }

    void disableMouseEvents() {
        ViewPlatformRetained[] vps = this.getViewPlatformList();
        this.enableMouse = false;
        for (int i = 0; i < vps.length; ++i) {
            View[] views = vps[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                Enumeration<Canvas3D> cvs = views[j].getAllCanvas3Ds();
                while (cvs.hasMoreElements()) {
                    Canvas3D cv = cvs.nextElement();
                    if (cv.eventCatcher == null) continue;
                    cv.eventCatcher.disableMouseEvents();
                }
            }
        }
    }

    void enableMouseEvents() {
        ViewPlatformRetained[] vps = this.getViewPlatformList();
        this.enableMouse = true;
        for (int i = 0; i < vps.length; ++i) {
            View[] views = vps[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                Enumeration<Canvas3D> cvs = views[j].getAllCanvas3Ds();
                while (cvs.hasMoreElements()) {
                    Canvas3D cv = cvs.nextElement();
                    if (cv.eventCatcher == null) continue;
                    cv.eventCatcher.enableMouseEvents();
                }
            }
        }
    }

    void disableMouseMotionEvents() {
        ViewPlatformRetained[] vps = this.getViewPlatformList();
        this.enableMouseMotion = false;
        for (int i = 0; i < vps.length; ++i) {
            View[] views = vps[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                Enumeration<Canvas3D> cvs = views[j].getAllCanvas3Ds();
                while (cvs.hasMoreElements()) {
                    Canvas3D cv = cvs.nextElement();
                    if (cv.eventCatcher == null) continue;
                    cv.eventCatcher.disableMouseMotionEvents();
                }
            }
        }
    }

    void enableMouseMotionEvents() {
        ViewPlatformRetained[] vps = this.getViewPlatformList();
        this.enableMouseMotion = true;
        for (int i = 0; i < vps.length; ++i) {
            View[] views = vps[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                Enumeration<Canvas3D> cvs = views[j].getAllCanvas3Ds();
                while (cvs.hasMoreElements()) {
                    Canvas3D cv = cvs.nextElement();
                    if (cv.eventCatcher == null) continue;
                    cv.eventCatcher.enableMouseMotionEvents();
                }
            }
        }
    }

    void disableMouseWheelEvents() {
        ViewPlatformRetained[] vps = this.getViewPlatformList();
        this.enableMouseWheel = false;
        for (int i = 0; i < vps.length; ++i) {
            View[] views = vps[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                Enumeration<Canvas3D> cvs = views[j].getAllCanvas3Ds();
                while (cvs.hasMoreElements()) {
                    Canvas3D cv = cvs.nextElement();
                    if (cv.eventCatcher == null) continue;
                    cv.eventCatcher.disableMouseWheelEvents();
                }
            }
        }
    }

    void enableMouseWheelEvents() {
        ViewPlatformRetained[] vps = this.getViewPlatformList();
        this.enableMouseWheel = true;
        for (int i = 0; i < vps.length; ++i) {
            View[] views = vps[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                Enumeration<Canvas3D> cvs = views[j].getAllCanvas3Ds();
                while (cvs.hasMoreElements()) {
                    Canvas3D cv = cvs.nextElement();
                    if (cv.eventCatcher == null) continue;
                    cv.eventCatcher.enableMouseWheelEvents();
                }
            }
        }
    }

    final void setCurrentView(View view) {
        this.currentView = view;
    }

    final View getCurrentView() {
        return this.currentView;
    }

    static ThreadGroup getRootThreadGroup() {
        return rootThreadGroup;
    }

    boolean isEmpty() {
        Enumeration<Locale> elm = this.listOfLocales.elements();
        while (elm.hasMoreElements()) {
            Locale loc = elm.nextElement();
            if (loc.branchGroups.isEmpty()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetWaitMCFlag() {
        Object object = this.waitLock;
        synchronized (object) {
            this.regViewWaiting = null;
            this.unRegViewWaiting = null;
            this.isSceneGraphLock = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForMC() {
        Object object = this.waitLock;
        synchronized (object) {
            if (this.unRegViewWaiting != null && (this.regViewWaiting == null || this.regViewWaiting != this.unRegViewWaiting)) {
                while (!this.unRegViewWaiting.doneUnregister) {
                    MasterControl.threadYield();
                }
                this.unRegViewWaiting.doneUnregister = false;
                this.unRegViewWaiting = null;
            }
            if (this.regViewWaiting != null) {
                while (!mc.isRegistered(this.regViewWaiting)) {
                    MasterControl.threadYield();
                }
                this.regViewWaiting = null;
            }
            this.isSceneGraphLock = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphStructureChangeListener(GraphStructureChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.structureChangeListenerSet == null) {
            this.structureChangeListenerSet = new HashSet();
        }
        HashSet<GraphStructureChangeListener> hashSet = this.structureChangeListenerSet;
        synchronized (hashSet) {
            this.structureChangeListenerSet.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGraphStructureChangeListener(GraphStructureChangeListener listener) {
        if (this.structureChangeListenerSet == null) {
            return;
        }
        HashSet<GraphStructureChangeListener> hashSet = this.structureChangeListenerSet;
        synchronized (hashSet) {
            this.structureChangeListenerSet.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyStructureChangeListeners(boolean add, Object parent, BranchGroup child) {
        if (this.structureChangeListenerSet == null) {
            return;
        }
        HashSet<GraphStructureChangeListener> hashSet = this.structureChangeListenerSet;
        synchronized (hashSet) {
            for (GraphStructureChangeListener listener : this.structureChangeListenerSet) {
                try {
                    if (add) {
                        listener.branchGroupAdded(parent, child);
                        continue;
                    }
                    listener.branchGroupRemoved(parent, child);
                }
                catch (RuntimeException e) {
                    System.err.println("Exception occurred in GraphStructureChangeListener:");
                    e.printStackTrace();
                }
                catch (Error e) {
                    System.err.println("Error occurred in GraphStructureChangeListener:");
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyStructureChangeListeners(Object oldParent, Object newParent, BranchGroup child) {
        if (this.structureChangeListenerSet == null) {
            return;
        }
        HashSet<GraphStructureChangeListener> hashSet = this.structureChangeListenerSet;
        synchronized (hashSet) {
            for (GraphStructureChangeListener listener : this.structureChangeListenerSet) {
                try {
                    listener.branchGroupMoved(oldParent, newParent, child);
                }
                catch (RuntimeException e) {
                    System.err.println("Exception occurred in GraphStructureChangeListener:");
                    e.printStackTrace();
                }
                catch (Error e) {
                    System.err.println("Error occurred in GraphStructureChangeListener:");
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShaderErrorListener(ShaderErrorListener listener) {
        if (listener == null) {
            return;
        }
        if (this.shaderErrorListenerSet == null) {
            this.shaderErrorListenerSet = new HashSet();
        }
        HashSet<ShaderErrorListener> hashSet = this.shaderErrorListenerSet;
        synchronized (hashSet) {
            this.shaderErrorListenerSet.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShaderErrorListener(ShaderErrorListener listener) {
        if (this.shaderErrorListenerSet == null) {
            return;
        }
        HashSet<ShaderErrorListener> hashSet = this.shaderErrorListenerSet;
        synchronized (hashSet) {
            this.shaderErrorListenerSet.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyShaderErrorListeners(ShaderError error) {
        boolean errorReported = false;
        if (this.shaderErrorListenerSet != null) {
            HashSet<ShaderErrorListener> hashSet = this.shaderErrorListenerSet;
            synchronized (hashSet) {
                for (ShaderErrorListener listener : this.shaderErrorListenerSet) {
                    try {
                        listener.errorOccurred(error);
                    }
                    catch (RuntimeException e) {
                        System.err.println("Exception occurred in ShaderErrorListener:");
                        e.printStackTrace();
                    }
                    catch (Error e) {
                        System.err.println("Error occurred in ShaderErrorListener:");
                        e.printStackTrace();
                    }
                    errorReported = true;
                }
            }
        }
        if (!errorReported) {
            this.defaultShaderErrorListener.errorOccurred(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRenderingErrorListener(RenderingErrorListener listener) {
        if (listener == null) {
            return;
        }
        if (renderingErrorListenerSet == null) {
            renderingErrorListenerSet = new HashSet();
        }
        HashSet<RenderingErrorListener> hashSet = renderingErrorListenerSet;
        synchronized (hashSet) {
            renderingErrorListenerSet.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRenderingErrorListener(RenderingErrorListener listener) {
        if (renderingErrorListenerSet == null) {
            return;
        }
        HashSet<RenderingErrorListener> hashSet = renderingErrorListenerSet;
        synchronized (hashSet) {
            renderingErrorListenerSet.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyRenderingErrorListeners(RenderingError error) {
        boolean errorReported = false;
        if (renderingErrorListenerSet != null) {
            HashSet<RenderingErrorListener> hashSet = renderingErrorListenerSet;
            synchronized (hashSet) {
                for (RenderingErrorListener listener : renderingErrorListenerSet) {
                    try {
                        listener.errorOccurred(error);
                    }
                    catch (RuntimeException e) {
                        System.err.println("Exception occurred in RenderingErrorListener:");
                        e.printStackTrace();
                    }
                    catch (Error e) {
                        System.err.println("Error occurred in RenderingErrorListener:");
                        e.printStackTrace();
                    }
                    errorReported = true;
                }
            }
        }
        if (!errorReported) {
            defaultRenderingErrorListener.errorOccurred(error);
        }
    }

    static {
        properties = null;
        renderingErrorListenerSet = null;
        defaultRenderingErrorListener = Renderer.getDefaultErrorListener();
        boolean isLoggableConfig = MasterControl.isCoreLoggable(Level.CONFIG);
        Logger logger = MasterControl.getCoreLogger();
        if (!isLoggableConfig) {
            // empty if block
        }
        StringBuffer strBuf = new StringBuffer("3D ");
        strBuf.append("[dev] ");
        strBuf.append(VersionInfo.getVersion());
        String str = strBuf.toString();
        if (isLoggableConfig) {
            logger.config(str);
        } else {
            System.err.println(str);
            System.err.println();
        }
        if (isLoggableConfig) {
            strBuf = new StringBuffer();
            strBuf.append("Initializing 3D runtime system:\n").append("    version = ").append(VersionInfo.getVersion()).append("\n").append("    vendor = ").append(VersionInfo.getVendor()).append("\n").append("    specification.version = ").append(VersionInfo.getSpecificationVersion()).append("\n").append("    specification.vendor = ").append(VersionInfo.getSpecificationVendor());
            str = strBuf.toString();
            if (isLoggableConfig) {
                logger.config(str);
            } else {
                System.err.println(str);
                System.err.println();
            }
        }
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        MasterControl.loadLibraries();
        mc = new MasterControl();
        if (isLoggableConfig) {
            strBuf = new StringBuffer();
            strBuf.append("3D system initialized\n").append("    rendering pipeline = ").append(Pipeline.getPipeline().getPipelineName());
            str = strBuf.toString();
            if (isLoggableConfig) {
                logger.config(str);
            } else {
                System.err.println(str);
                System.err.println();
            }
        }
    }
}

