/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Type;
import java.util.Collection;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.Converter;
import org.scijava.plugin.AbstractHandlerPlugin;
import org.scijava.util.ConversionUtils;
import org.scijava.util.GenericUtils;

public abstract class AbstractConverter<I, O>
extends AbstractHandlerPlugin<ConversionRequest>
implements Converter<I, O> {
    @Override
    public boolean canConvert(ConversionRequest request) {
        Object src = request.sourceObject();
        if (src == null) {
            Class<?> srcClass = request.sourceClass();
            if (request.destType() != null) {
                return this.canConvert(srcClass, request.destType());
            }
            return this.canConvert(srcClass, request.destClass());
        }
        if (request.destType() != null) {
            return this.canConvert(src, request.destType());
        }
        return this.canConvert(src, request.destClass());
    }

    @Override
    public boolean canConvert(Object src, Type dest) {
        if (src == null) {
            return false;
        }
        Class<?> srcClass = src.getClass();
        return this.canConvert(srcClass, dest);
    }

    @Override
    public boolean canConvert(Object src, Class<?> dest) {
        if (src == null) {
            return false;
        }
        Class<?> srcClass = src.getClass();
        return this.canConvert(srcClass, dest);
    }

    @Override
    public boolean canConvert(Class<?> src, Class<?> dest) {
        return ConversionUtils.canCast(src, this.getInputType()) && ConversionUtils.canCast(dest, this.getOutputType());
    }

    @Override
    public Object convert(Object src, Type dest) {
        Class<?> destClass = GenericUtils.getClass(dest);
        return this.convert(src, destClass);
    }

    @Override
    public Object convert(ConversionRequest request) {
        if (request.destType() != null) {
            return this.convert(request.sourceObject(), request.destType());
        }
        return this.convert(request.sourceObject(), request.destClass());
    }

    @Override
    public void populateInputCandidates(Collection<Object> objects) {
    }

    @Override
    public boolean supports(ConversionRequest request) {
        return this.canConvert(request);
    }

    @Override
    public Class<ConversionRequest> getType() {
        return ConversionRequest.class;
    }

    @Override
    @Deprecated
    public boolean canConvert(Class<?> src, Type dest) {
        Class<?> destClass = GenericUtils.getClass(dest);
        return this.canConvert(src, destClass);
    }
}

