/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.console;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.scijava.console.ConsoleArgument;
import org.scijava.plugin.AbstractHandlerPlugin;

public abstract class AbstractConsoleArgument
extends AbstractHandlerPlugin<LinkedList<String>>
implements ConsoleArgument {
    private int numArgs;
    private Set<String> aliasFlags;

    public AbstractConsoleArgument() {
        this(1, new String[0]);
    }

    public AbstractConsoleArgument(String ... aliases) {
        this(1, aliases);
    }

    public AbstractConsoleArgument(int requiredArgs, String ... aliases) {
        this.numArgs = requiredArgs;
        this.aliasFlags = new HashSet<String>();
        for (String s : aliases) {
            this.aliasFlags.add(s);
        }
    }

    @Override
    public boolean supports(LinkedList<String> args) {
        if (args == null || args.size() < this.numArgs) {
            return false;
        }
        return this.isAlias(args);
    }

    @Override
    public Class<LinkedList<String>> getType() {
        return String.class;
    }

    protected boolean isAlias(LinkedList<String> args) {
        return this.aliasFlags.isEmpty() || this.aliasFlags.contains(args.getFirst());
    }
}

