/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.scijava.Context;
import org.scijava.Contextual;
import org.scijava.NullContextException;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.module.AbstractModule;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.util.FileUtils;

public class ScriptModule
extends AbstractModule
implements Contextual {
    public static final String RETURN_VALUE = "result";
    private final ScriptInfo info;
    @Parameter
    private Context context;
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private ConvertService conversionService;
    @Parameter
    private LogService log;
    private ScriptLanguage scriptLanguage;
    private ScriptEngine scriptEngine;
    private Writer output;
    private Writer error;

    public ScriptModule(ScriptInfo info) {
        this.info = info;
    }

    public ScriptLanguage getLanguage() {
        if (this.scriptLanguage == null) {
            String path = this.getInfo().getPath();
            String extension = FileUtils.getExtension(path);
            this.scriptLanguage = this.scriptService.getLanguageByExtension(extension);
        }
        return this.scriptLanguage;
    }

    public void setLanguage(ScriptLanguage scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public void setOutputWriter(Writer output) {
        this.output = output;
    }

    public void setErrorWriter(Writer error) {
        this.error = error;
    }

    public ScriptEngine getEngine() {
        if (this.scriptEngine == null) {
            this.scriptEngine = this.getLanguage().getScriptEngine();
        }
        return this.scriptEngine;
    }

    public Object getReturnValue() {
        return this.getOutput(RETURN_VALUE);
    }

    @Override
    public ScriptInfo getInfo() {
        return this.info;
    }

    @Override
    public void run() {
        PrintWriter errorPrinter;
        ScriptEngine engine = this.getEngine();
        String path = this.getInfo().getPath();
        engine.put("javax.script.filename", path);
        engine.put(ScriptModule.class.getName(), this);
        ScriptContext scriptContext = engine.getContext();
        if (this.output != null) {
            scriptContext.setWriter(this.output);
        }
        if (this.error != null) {
            scriptContext.setErrorWriter(this.error);
            errorPrinter = new PrintWriter(this.error);
        } else {
            errorPrinter = null;
        }
        for (ModuleItem<?> item : this.getInfo().inputs()) {
            String name = item.getName();
            engine.put(name, this.getInput(name));
        }
        Object returnValue = null;
        try {
            BufferedReader reader = this.getInfo().getReader();
            returnValue = reader == null ? engine.eval(new FileReader(path)) : engine.eval(reader);
        }
        catch (Throwable e) {
            while (e instanceof ScriptException && e.getCause() != null) {
                e = e.getCause();
            }
            if (this.error == null) {
                this.log.error(e);
            }
            e.printStackTrace(errorPrinter);
        }
        ScriptLanguage language = this.getLanguage();
        for (ModuleItem moduleItem : this.getInfo().outputs()) {
            String name = moduleItem.getName();
            if (this.isResolved(name)) continue;
            Object value = RETURN_VALUE.equals(name) && !this.getInfo().isReturnValueDeclared() ? returnValue : engine.get(name);
            Object decoded = language.decode(value);
            Object typed = this.conversionService.convert(decoded, moduleItem.getType());
            this.setOutput(name, typed);
            this.setResolved(name, true);
        }
        if (this.output != null) {
            try {
                this.output.flush();
            }
            catch (IOException e) {
                if (this.error == null) {
                    this.log.error(e);
                }
                e.printStackTrace(errorPrinter);
            }
        }
        if (errorPrinter != null) {
            errorPrinter.flush();
        }
    }

    @Override
    public Context context() {
        if (this.context == null) {
            throw new NullContextException();
        }
        return this.context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        context.inject(this);
    }
}

