/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.event.EventService;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.handle.DataHandles;
import org.scijava.io.location.BytesLocation;
import org.scijava.io.location.Location;
import org.scijava.task.DefaultTask;
import org.scijava.task.Task;
import org.scijava.thread.ThreadService;
import org.scijava.util.MersenneTwisterFast;

public class DataHandlesTest {
    private static final int TEST_SIZE = 2938740;
    private DataHandleService handles;
    private Location inFile;
    private BytesLocation outFile;
    private byte[] data;
    private ThreadService threadService;
    private EventService eventService;

    @Before
    public void classSetup() {
        Context ctx = new Context(new Class[]{DataHandleService.class, ThreadService.class, EventService.class});
        this.handles = (DataHandleService)ctx.service(DataHandleService.class);
        this.threadService = (ThreadService)ctx.service(ThreadService.class);
        this.eventService = (EventService)ctx.service(EventService.class);
        this.data = this.randomBytes(-1161905474L);
        this.inFile = new BytesLocation(this.data);
        this.outFile = new BytesLocation(2938740);
    }

    @After
    public void cleanup() {
        this.handles.context().dispose();
    }

    @Test
    public void testDefaultCopy() throws IOException {
        try (DataHandle src = (DataHandle)this.handles.create((Object)this.inFile);
             DataHandle dest = (DataHandle)this.handles.create((Object)this.outFile);){
            DataHandles.copy((DataHandle)src, (DataHandle)dest);
            this.assertHandleEquals(this.data, (DataHandle<Location>)dest);
        }
    }

    @Test
    public void testCopyTask() throws IOException {
        try (DataHandle src = (DataHandle)this.handles.create((Object)this.inFile);
             DataHandle dest = (DataHandle)this.handles.create((Object)this.outFile);){
            DefaultTask t = new DefaultTask(this.threadService, this.eventService);
            DataHandles.copy((DataHandle)src, (DataHandle)dest, (Task)t);
            Assert.assertEquals((long)t.getProgressValue(), (long)src.length());
            this.assertHandleEquals(this.data, (DataHandle<Location>)dest);
        }
    }

    @Test
    public void testCopyLength() throws IOException {
        int sliceSize = 50000;
        try (DataHandle src = (DataHandle)this.handles.create((Object)this.inFile);
             DataHandle dest = (DataHandle)this.handles.create((Object)this.outFile);){
            DataHandles.copy((DataHandle)src, (DataHandle)dest, (int)50000);
            byte[] expected = new byte[50000];
            System.arraycopy(this.data, 0, expected, 0, 50000);
            this.assertHandleEquals(expected, (DataHandle<Location>)dest);
        }
    }

    @Test
    public void testCopyLengthTask() throws IOException {
        int sliceSize = 50000;
        try (DataHandle src = (DataHandle)this.handles.create((Object)this.inFile);
             DataHandle dest = (DataHandle)this.handles.create((Object)this.outFile);){
            DefaultTask t = new DefaultTask(this.threadService, this.eventService);
            DataHandles.copy((DataHandle)src, (DataHandle)dest, (long)50000L, (Task)t);
            Assert.assertEquals((long)t.getProgressValue(), (long)50000L);
            byte[] expected = new byte[50000];
            System.arraycopy(this.data, 0, expected, 0, 50000);
            this.assertHandleEquals(expected, (DataHandle<Location>)dest);
        }
    }

    private void assertHandleEquals(byte[] expected, DataHandle<Location> handle) throws IOException {
        handle.seek(0L);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((long)expected[i], (long)handle.readByte());
        }
    }

    private byte[] randomBytes(long seed) {
        MersenneTwisterFast r = new MersenneTwisterFast(seed);
        byte[] ldata = new byte[2938740];
        for (int i = 0; i < ldata.length; ++i) {
            ldata[i] = r.nextByte();
        }
        return ldata;
    }
}

