/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="eclipse-helper", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class EclipseHelperMojo
extends AbstractMojo {
    private static final String SCIJAVA_COMMON_ARTIFACTID = "scijava-common";
    private static final String SCIJAVA_COMMON_GROUPID = "org.scijava";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject currentProject;

    public void execute() throws MojoExecutionException {
        Build build = this.currentProject.getBuild();
        if (build == null) {
            return;
        }
        String buildDirectoryName = build.getDirectory();
        if (buildDirectoryName == null) {
            return;
        }
        File buildDirectory = new File(buildDirectoryName);
        if (!buildDirectory.exists()) {
            return;
        }
        if (!this.dependsOnScijavaCommon(this.currentProject)) {
            return;
        }
        this.getLog().info((CharSequence)"Parsing SciJava annotations");
        try {
            List elements = this.currentProject.getCompileClasspathElements();
            URL[] classpath = new URL[elements.size() + 1];
            classpath[0] = buildDirectory.toURI().toURL();
            for (int i = 1; i < classpath.length; ++i) {
                classpath[i] = new URL("file:" + (String)elements.get(i - 1));
            }
            this.getLog().debug((CharSequence)("Using class path '" + classpath + "' to execute EclipseHelper"));
            URLClassLoader loader = new URLClassLoader(classpath);
            Class<?> helper = loader.loadClass("org.scijava.annotations.EclipseHelper");
            Method main = helper.getMethod("main", String[].class);
            Thread thread = Thread.currentThread();
            ClassLoader previousLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(loader);
                main.invoke(null, new Object[]{new String[0]});
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not execute EclipseHelper's main() method", e);
            }
            finally {
                thread.setContextClassLoader(previousLoader);
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not get the class path", (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Could not build class path for EclipseHelper", (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not load EclipseHelper. If you are using Eclipse and have scijava-common open - close it.", (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("Could not find EclipseHelper's main() method", (Exception)e);
        }
        catch (SecurityException e) {
            throw new MojoExecutionException("Could not access EclipseHelper's main() method", (Exception)e);
        }
    }

    private boolean dependsOnScijavaCommon(MavenProject project) {
        List dependencies;
        try {
            dependencies = project.getCompileDependencies();
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            return false;
        }
        if (dependencies == null) {
            return false;
        }
        for (Dependency dependency : dependencies) {
            if (dependency == null || !SCIJAVA_COMMON_ARTIFACTID.equals(dependency.getArtifactId()) || !SCIJAVA_COMMON_GROUPID.equals(dependency.getGroupId())) continue;
            return true;
        }
        return false;
    }
}

