/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.plugin;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.plugin.BeanUtilsPlugin;

public class CommonsBeanUtilsPlugin
implements BeanUtilsPlugin {
    final Logger logger = LoggerFactory.getLogger(CommonsBeanUtilsPlugin.class);

    public Object getInstance(SqlRuntimeContext runtimeCtx, Class<?> clazz) {
        try {
            int isAstract = clazz.getModifiers() & 0x400;
            if (isAstract != 0) {
                this.logger.warn("getInstance: " + String.valueOf(clazz) + " is abstract");
                return null;
            }
            return ConstructorUtils.invokeConstructor(clazz, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            this.logger.error("getInstance", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            this.logger.error("getInstance", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            this.logger.error("getInstance", (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            this.logger.error("getInstance", (Throwable)e);
            return null;
        }
    }

    protected PropertyDescriptor getAttributeDescriptor(Class<?> clazz, String attrName) {
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(clazz);
        PropertyDescriptor descriptor = null;
        if (descriptors != null) {
            for (PropertyDescriptor _descriptor : descriptors) {
                if (!_descriptor.getName().equalsIgnoreCase(attrName)) continue;
                descriptor = _descriptor;
                break;
            }
        }
        if (descriptor == null) {
            this.logger.error("There's no attribute " + attrName + " in " + clazz.getName());
        }
        return descriptor;
    }

    public Class<?> getAttributeType(SqlRuntimeContext runtimeCtx, Class<?> clazz, String attrName) {
        PropertyDescriptor descriptor = this.getAttributeDescriptor(clazz, attrName);
        if (descriptor == null) {
            this.logger.error("getAttributeType: there's no attribute " + attrName + " in " + clazz.getName());
            return null;
        }
        return descriptor.getPropertyType();
    }

    public Class<?>[] getAttributeParameterizedTypes(SqlRuntimeContext runtimeCtx, Class<?> clazz, String attrName) {
        PropertyDescriptor descriptor = this.getAttributeDescriptor(clazz, attrName);
        if (descriptor == null) {
            this.logger.error("getAttributeType: there's no attribute " + attrName + " in " + clazz.getName());
            return null;
        }
        try {
            Field f = clazz.getDeclaredField(attrName);
            if (f.getGenericType() != null && f.getGenericType() instanceof ParameterizedType) {
                return (Class[])((ParameterizedType)f.getGenericType()).getActualTypeArguments();
            }
        }
        catch (NoSuchFieldException | SecurityException e) {
            this.logger.error("getAttributeParameterizedType: " + String.valueOf(clazz) + " for " + attrName, (Throwable)e);
        }
        return null;
    }

    protected Method getGetter(SqlRuntimeContext runtimeCtx, Class<?> clazz, String attrName, boolean onlyCheck) {
        PropertyDescriptor descriptor = this.getAttributeDescriptor(clazz, attrName);
        if (descriptor == null) {
            if (!onlyCheck) {
                this.logger.error("getGetter: there's no attribute " + attrName + " in " + clazz.getName());
            }
            return null;
        }
        Method getter = PropertyUtils.getReadMethod((PropertyDescriptor)descriptor);
        if (getter == null) {
            if (!onlyCheck) {
                this.logger.error("getGetter: there's no getter " + attrName + " in " + clazz.getName());
            }
            return null;
        }
        return getter;
    }

    public BeanUtilsPlugin.GetterType getGetterType(SqlRuntimeContext runtimeCtx, Class<?> clazz, String attrName) {
        Method m = this.getGetter(runtimeCtx, clazz, attrName, false);
        if (m == null) {
            return null;
        }
        return new BeanUtilsPlugin.GetterType(m);
    }

    public BeanUtilsPlugin.GetterType getGetterType(SqlRuntimeContext runtimeCtx, Object bean, String attrName) {
        return this.getGetterType(runtimeCtx, bean.getClass(), attrName);
    }

    public boolean checkAttribute(SqlRuntimeContext runtimeCtx, Object bean, String attrName) {
        return this.getGetter(runtimeCtx, bean.getClass(), attrName, true) != null;
    }

    public Object getAttribute(SqlRuntimeContext runtimeCtx, Object bean, String attrName) throws SqlRuntimeException {
        try {
            return PropertyUtils.getSimpleProperty((Object)bean, (String)attrName);
        }
        catch (IllegalAccessException e) {
            throw new SqlRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SqlRuntimeException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new SqlRuntimeException((Throwable)e);
        }
    }

    protected Method getSetter(SqlRuntimeContext runtimeCtx, Class<?> clazz, String attrName, boolean onlyCheck, Class<?> ... attrTypes) {
        Method _setter;
        PropertyDescriptor descriptor = this.getAttributeDescriptor(clazz, attrName);
        if (descriptor == null && !onlyCheck) {
            this.logger.error("getSetter: there's no attribute " + attrName + " in " + clazz.getName());
        }
        if ((_setter = PropertyUtils.getWriteMethod((PropertyDescriptor)descriptor)) == null) {
            if (!onlyCheck) {
                this.logger.error("getSetter: there's no setter " + attrName + " in " + clazz.getName());
            }
            return null;
        }
        if (_setter.getParameterTypes() == null || _setter.getParameterTypes().length != 1) {
            if (!onlyCheck) {
                this.logger.error("getSetter: there's no setter " + attrName + " in " + clazz.getName());
            }
            return null;
        }
        Method setter = null;
        if (attrTypes == null) {
            setter = _setter;
        } else {
            Class<?> setterType = _setter.getParameterTypes()[0];
            for (Class<?> _clazz : attrTypes) {
                if (!_clazz.isAssignableFrom(setterType)) continue;
                setter = _setter;
            }
        }
        if (setter == null) {
            if (!onlyCheck) {
                this.logger.error("getSetter: there's no setter " + attrName + " in " + clazz.getName());
            }
            return null;
        }
        return setter;
    }

    protected Method getSetter(SqlRuntimeContext runtimeCtx, Object bean, String attrName, Class<?> ... attrTypes) {
        return this.getSetter(runtimeCtx, bean.getClass(), attrName, true, attrTypes);
    }

    public boolean simpleSetAttribute(SqlRuntimeContext runtimeCtx, Object bean, String attrName, Object attrValue, Class<?> ... attrTypes) {
        Method setter = this.getSetter(runtimeCtx, bean, attrName, attrTypes);
        if (setter != null) {
            this.invokeMethod(runtimeCtx, bean, setter, attrValue);
            return true;
        }
        return false;
    }

    public void setAttribute(SqlRuntimeContext runtimeCtx, Object bean, String attrName, Object attrValue) throws SqlRuntimeException {
        try {
            PropertyUtils.setSimpleProperty((Object)bean, (String)attrName, (Object)attrValue);
        }
        catch (IllegalAccessException e) {
            throw new SqlRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SqlRuntimeException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new SqlRuntimeException((Throwable)e);
        }
    }

    protected Object invokeMethod(SqlRuntimeContext runtimeCtx, Object bean, Method method, Object ... args) throws SqlRuntimeException {
        try {
            if (!method.canAccess(bean)) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException se) {
                    this.logger.warn("invokeMethod: " + String.valueOf(bean.getClass()) + " " + se.getMessage());
                }
            }
            return method.invoke(bean, args);
        }
        catch (IllegalAccessException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, method, args), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, method, args), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, method, args), (Throwable)e);
        }
    }

    public boolean checkMethod(SqlRuntimeContext runtimeCtx, Class<?> clazz, String methodName, Class<?> ... argTypes) {
        return MethodUtils.getMatchingAccessibleMethod(clazz, (String)methodName, (Class[])argTypes) != null;
    }

    public boolean checkMethod(SqlRuntimeContext runtimeCtx, Object bean, String methodName, Object ... args) {
        return MethodUtils.getMatchingAccessibleMethod(bean.getClass(), (String)methodName, (Class[])this.toParameterTypes(args)) != null;
    }

    public Object invokeMethod(SqlRuntimeContext runtimeCtx, Class<?> clazz, String methodName, Object ... args) throws SqlRuntimeException {
        return this.invokeMethod(runtimeCtx, clazz, null, methodName, args);
    }

    public Object invokeMethod(SqlRuntimeContext runtimeCtx, Object bean, String methodName, Object ... args) throws SqlRuntimeException {
        return this.invokeMethod(runtimeCtx, bean.getClass(), bean, methodName, args);
    }

    protected Object invokeMethod(SqlRuntimeContext runtimeCtx, Class<?> clazz, Object bean, String methodName, Object ... args) throws SqlRuntimeException {
        try {
            if (bean == null) {
                return MethodUtils.invokeStaticMethod(clazz, (String)methodName, (Object[])args);
            }
            return MethodUtils.invokeMethod((Object)bean, (String)methodName, (Object[])args);
        }
        catch (IllegalAccessException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, methodName, null, args), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, methodName, null, args), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, methodName, null, args), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, methodName, null, args), (Throwable)e);
        }
    }

    public Object getEnumToValue(SqlRuntimeContext runtimeCtx, Object bean) {
        if (bean == null) {
            return null;
        }
        for (String methodName : runtimeCtx.getFeatures(SqlFeature.METHODS_ENUM_IN.name())) {
            try {
                return MethodUtils.invokeMethod((Object)bean, (String)methodName, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public Class<?> getEnumToClass(SqlRuntimeContext runtimeCtx, Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        for (String methodName : runtimeCtx.getFeatures(SqlFeature.METHODS_ENUM_IN.name())) {
            Method m = MethodUtils.getMatchingAccessibleMethod(clazz, (String)methodName, (Class[])new Class[0]);
            if (m == null) continue;
            return m.getReturnType();
        }
        return null;
    }

    public Object getValueToEnum(SqlRuntimeContext runtimeCtx, Class<?> clazz, Object val) {
        if (val == null) {
            return null;
        }
        for (String methodName : runtimeCtx.getFeatures(SqlFeature.METHODS_ENUM_OUT.name())) {
            try {
                return MethodUtils.invokeStaticMethod(clazz, (String)methodName, (Object)val);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected String attrTypes2String(Class<?> ... attrTypes) {
        if (attrTypes == null || attrTypes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(".");
        boolean first = true;
        for (Class<?> attrType : attrTypes) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(attrType.getName());
        }
        return sb.toString();
    }

    protected Object[] toArray(Object arg) {
        Object[] args = null;
        if (arg != null) {
            args = new Object[]{arg};
        }
        return args;
    }

    protected Class<?>[] toParameterTypes(Object arg) {
        if (arg == null) {
            return new Class[0];
        }
        return new Class[]{arg.getClass()};
    }

    protected Class<?>[] toParameterTypes(Object[] args) {
        if (args == null) {
            return new Class[0];
        }
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return parameterTypes;
    }

    protected String debugInfo(String msg, Object bean, Method method, Object ... args) {
        return this.debugInfo(msg, bean, method != null ? method.getName() : null, method, args);
    }

    protected String debugInfo(String msg, Object bean, String methodName, Method method, Object ... args) {
        StringBuilder sb = new StringBuilder(msg);
        sb.append(": bean=").append(bean != null ? bean.getClass() : "null");
        sb.append(", method=").append(methodName);
        if (args != null) {
            Class<?>[] parameterTypes = this.toParameterTypes(args);
            sb.append(", args=").append(this.attrTypes2String(parameterTypes));
        }
        if (method != null) {
            sb.append(", method params=").append(method.getParameterTypes() != null ? Arrays.asList(method.getParameterTypes()) : "empty");
        }
        return sb.toString();
    }
}

