/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.jdbc.type.JdbcTypeFactory;
import org.sqlproc.engine.type.SqlMetaType;

public class JdbcDefaultType
extends SqlMetaType {
    static Map<Class<?>, Object> jdbcTypes = new HashMap();

    @Override
    public void addScalar(SqlQuery query, String dbName, Class<?> attributeType) {
        Object type = jdbcTypes.get(attributeType);
        if (type != null) {
            query.addScalar(dbName, type);
        } else {
            query.addScalar(dbName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setResult(Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        Class<?> attributeType;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult DEFAULT: resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue + ", resultType" + (resultValue != null ? resultValue.getClass() : null));
        }
        if ((attributeType = BeanUtils.getFieldType(resultInstance.getClass(), attributeName)) == null) {
            if (!ingoreError) throw new SqlRuntimeException("There's problem with attribute type for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
            this.logger.error("There's problem with attribute type for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
            return;
        }
        if (attributeType.isEnum()) {
            Method m = BeanUtils.getSetter(resultInstance, attributeName, attributeType);
            if (m != null) {
                if (resultValue != null && resultValue instanceof BigDecimal) {
                    resultValue = ((BigDecimal)resultValue).intValue();
                }
                Object enumInstance = SqlUtils.getValueToEnum(attributeType, resultValue);
                BeanUtils.simpleInvokeMethod(m, resultInstance, enumInstance);
                return;
            } else {
                if (!ingoreError) throw new SqlRuntimeException("There's no setter for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
                this.logger.error("There's no getter for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
            }
            return;
        } else {
            Method m = BeanUtils.getSetter(resultInstance, attributeName, attributeType);
            if (resultValue != null && resultValue instanceof BigDecimal) {
                resultValue = SqlUtils.convertBigDecimal(attributeType, resultValue);
            }
            if (m != null) {
                BeanUtils.simpleInvokeMethod(m, resultInstance, resultValue);
                return;
            } else {
                if (!ingoreError) throw new SqlRuntimeException("There's no setter for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
                this.logger.error("There's no getter for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParameter(SqlQuery query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter DEFAULT: paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (!(inputValue instanceof Collection)) {
            if (inputType.isEnum()) {
                Class clazz = SqlUtils.getEnumToClass(inputType);
                if (clazz == String.class) {
                    JdbcTypeFactory.ENUM_STRING.setParameter(query, paramName, inputValue, inputType, ingoreError);
                    return;
                } else if (clazz == Integer.class) {
                    JdbcTypeFactory.ENUM_INT.setParameter(query, paramName, inputValue, inputType, ingoreError);
                    return;
                } else {
                    if (!ingoreError) throw new SqlRuntimeException("Incorrect type based enum " + inputValue + " for " + paramName);
                    this.logger.error("Incorrect type based enum " + inputValue + " for " + paramName);
                }
                return;
            } else {
                SqlMetaType type = SqlProcessContext.getTypeFactory().getMetaType(inputType);
                if (type != null) {
                    type.setParameter(query, paramName, inputValue, inputType, ingoreError);
                    return;
                } else {
                    if (!ingoreError) throw new SqlRuntimeException("Incorrect default type " + inputValue + " for " + paramName);
                    this.logger.error("Incorrect default type " + inputValue + " for " + paramName);
                }
            }
            return;
        } else {
            ArrayList<Object> vals = new ArrayList<Object>();
            boolean isEnum = false;
            for (Object val : (Collection)inputValue) {
                if (!val.getClass().isEnum()) break;
                isEnum = true;
                Object o = SqlUtils.getEnumToValue(val);
                if (o != null) {
                    vals.add(o);
                    continue;
                }
                if (!ingoreError) throw new SqlRuntimeException("Incorrect type based enum item value " + o + " for " + paramName);
                this.logger.error("Incorrect type based enum item value " + o + " for " + paramName);
            }
            if (isEnum) {
                query.setParameterList(paramName, vals.toArray());
                return;
            } else {
                query.setParameterList(paramName, ((Collection)inputValue).toArray());
            }
        }
    }

    static {
        jdbcTypes.put(Integer.TYPE, JdbcTypeFactory.INTEGER);
        jdbcTypes.put(Integer.class, JdbcTypeFactory.INTEGER);
        jdbcTypes.put(Long.TYPE, JdbcTypeFactory.LONG);
        jdbcTypes.put(Long.class, JdbcTypeFactory.LONG);
        jdbcTypes.put(Short.TYPE, JdbcTypeFactory.SHORT);
        jdbcTypes.put(Short.class, JdbcTypeFactory.SHORT);
        jdbcTypes.put(Byte.TYPE, JdbcTypeFactory.BYTE);
        jdbcTypes.put(Byte.class, JdbcTypeFactory.BYTE);
        jdbcTypes.put(Float.TYPE, JdbcTypeFactory.FLOAT);
        jdbcTypes.put(Float.class, JdbcTypeFactory.FLOAT);
        jdbcTypes.put(Double.TYPE, JdbcTypeFactory.DOUBLE);
        jdbcTypes.put(Double.class, JdbcTypeFactory.DOUBLE);
        jdbcTypes.put(Character.TYPE, JdbcTypeFactory.CHAR);
        jdbcTypes.put(Character.class, JdbcTypeFactory.CHAR);
        jdbcTypes.put(String.class, JdbcTypeFactory.STRING);
        jdbcTypes.put(java.util.Date.class, JdbcTypeFactory.TIMESTAMP);
        jdbcTypes.put(Timestamp.class, JdbcTypeFactory.TIMESTAMP);
        jdbcTypes.put(Date.class, JdbcTypeFactory.DATE);
        jdbcTypes.put(Time.class, JdbcTypeFactory.TIME);
        jdbcTypes.put(Boolean.TYPE, JdbcTypeFactory.BOOLEAN);
        jdbcTypes.put(Boolean.class, JdbcTypeFactory.BOOLEAN);
        jdbcTypes.put(BigInteger.class, JdbcTypeFactory.BIG_INTEGER);
        jdbcTypes.put(BigDecimal.class, JdbcTypeFactory.BIG_DECIMAL);
        jdbcTypes.put(byte[].class, JdbcTypeFactory.BYTE_ARRAY);
        jdbcTypes.put(Byte[].class, JdbcTypeFactory.BYTE_ARRAY_WRAPPER);
        jdbcTypes.put(Blob.class, JdbcTypeFactory.BLOB);
        jdbcTypes.put(Clob.class, JdbcTypeFactory.CLOB);
    }
}

