/*
 * Code Dx API
 * Code Dx provides a variety of REST APIs, allowing external applications and scripts to interface with core functionality. This guide documents the various REST resources provided by Code Dx.  ## Authentication  Authentication is a requirement when accessing API endpoints. There are two methods by which authentication may be performed.  ### API Keys  The primary method for authentication is passing an `API-Key` header containing a valid API key with all requests.  For example&#58;  `API-Key: 550e8400-e29b-41d4-a716-44665544000`  API keys may be generated by Code Dx admins. Once they are generated, in most cases, they behave like regular users. They will need to be assigned user roles for any projects they will be used with. Although it is possible to assign the *admin* [role](UserGuide.html#UserRolesConfiguration) to an API key, the recommendation is to avoid doing so unless absolutely necessary.  See the user guide for an overview about how to create and manage [API keys](UserGuide.html#APIKeysAdministration).  ### HTTP Basic Authentication  HTTP Basic authentication may be used to authenticate with the API as a regular user. This is accomplished by including an `Authorization` header containing a typical authorization credential.  ## Error Handling  ### Bad Requests  For API calls that accept input, invalid values will trigger an HTTP 400 Bad Request status code.  ### Server Errors  For any API call, if an unexpected error occurs, an HTTP 500 Internal Server Error status code will be returned. If an error message is available, the response will include a basic message body describing the error&#58;  ` {   \"error\": \"error message\" } `  The error property will contain a string message indicating the nature of the error.  ### Errors with Third-Party Applications  Sometimes Code Dx must communicate with third-party applications like JIRA, Git, and certain enterprise tools. Some users may have in-house versions of these with self-signed certificates which may not be \"trusted\". In these cases, the API will respond with an HTTP 502 BAD GATEWAY status. If this happens, refer to [Trusting Self-Signed Certificates](InstallGuide.html#TrustingSelfSignedCertificates) in the install guide.  ### API Unavailable  In special circumstances, particularly during the installation and update phases, the API will be unavailable. When the API is unavailable, all calls will return an HTTP 503 Service Unavailable status, and no actions or side effects will occur as a result of the calls.  ## Examples  Code Dx's API uses REST over HTTP. As such, you can use any language/utility that supports making HTTP requests to interact with the API. The examples below use <a href=\"https://curl.haxx.se/\" target=\"_blank\">curl</a>, a popular command-line utility, to do so.  First, you'll need to [generate an API Key](UserGuide.html#APIKeysAdministration). Second, while you can create projects through the API, these examples will assume that you've already created one. You'll need to know its project id number, which you can find by looking at the URL for the [Findings Page](UserGuide.html#Findings), which will end in a number.  **Note:** Many API endpoints require a JSON body in the request. Most JSON will contain double-quotes (`\"`) and spaces, which have special meaning when used on the command line. In order to ensure your JSON body is interpreted as a single argument, you must <a href=\"https://en.wikipedia.org/wiki/Escape_character\" target=\"_blank\">escape</a> it properly. For example, if you wanted to `POST` the following JSON body&#58;  ``` { \"name\": \"John Doe\" } ```  You would put a backslash (`\\`) before each double-quote (`\"`), and surround the whole thing with double-quotes&#58;  ``` \"{ \\\"name\\\": \\\"John Doe\\\" }\" ```  The outermost double-quotes tell the command-line interpreter that everything within them is to be treated as a single argument (as opposed to the usual space-separated behavior). The backslash before each inner double-quote tells the command-line interpreter that you mean the literal double-quote character, and not the end of the quoted argument.  In many *non-Windows* operating systems, you can also use a single-quote (`'`) to surround the argument, and skip the backslashes&#58;  ``` '{ \"name\": \"John Doe\" }' ```  The examples below will use the double-quotes and backslashes style, as it works on most (if not all) operating systems.  ### Running an Analysis  To start an analysis, you can run  ``` curl -F file1=@src.zip -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/analysis ```  Make sure you use your own values for the `src.zip` file, the API Key, the hostname for your Code Dx server, and the project id.  **Note:** This endpoint is not listed below due to a swagger limitation.  ### Retrieving Finding Data  There is a wide variety of data available for the findings of a project after running an analysis. Two examples are provided here.  ### Findings Table Data  You can retrieve the data that's used to populate the [findings table](UserGuide.html#FindingsTable)&#58;  ``` curl -H \"Content-Type: application/json\" -X POST -d \"{\\\"filter\\\":{},\\\"sort\\\":{\\\"by\\\":\\\"id\\\",\\\"direction\\\":\\\"ascending\\\"},\\\"pagination\\\":{\\\"page\\\":1,\\\"perPage\\\":10}}\" -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/findings/table ```  Additional information about how to construct more useful filter and sort requests can be found in the documentation.  ### Finding Metadata  You can retrieve metadata for a finding, if you know the finding id. You can take the ID for a finding from the Findings Table&#58;  ``` curl -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/findings/<finding id> ```  ### Generating a Report  You can use the API to generate a PDF [report](UserGuide.html#GenerateReport).  ``` curl -H \"Content-Type: application/json\" -X POST -d \"{\\\"filter\\\":{},\\\"config\\\":{\\\"summaryMode\\\":\\\"simple\\\",\\\"detailsMode\\\":\\\"simple\\\",\\\"includeResultDetails\\\":true,\\\"includeComments\\\":false}}\" -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/report/pdf ```  ## Generating a Client SDK  If you require a client SDK for Code Dx, you can generate one using [Swagger Code Generator](https://github.com/swagger-api/swagger-codegen). Detailed instructions are available on the github page and our swagger spec can be found [here](swagger/swagger.json). 
 *
 * OpenAPI spec version: 3.5.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.codedx.client.model;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import java.util.HashMap;
import java.util.Map;

/**
 * Filter objects serve to communicate the filters to be applied to a data query. Filter objects are simple JS objects containing a field for each filtered field. Filter fields are ANDed together along with the base filter (which presently filters by findings not pending a purge action). Fields may contain a single value or an array of values. The possible filter fields and their expected values are described below. The IDs provided by the grouped-counts data endpoint fit the expected values. - &#x60;cwe&#x60;&amp;#58; CWE ID (\&quot;398\&quot; or 398, must be positive) or \&quot;none\&quot; - &#x60;finding&#x60;&amp;#58; finding ID (\&quot;1234\&quot; or 1234) - &#x60;detectionMethod&#x60;&amp;#58; The ID value of the detection method (e.g. 1 for &#39;Static Analysis&#39;) - &#x60;path&#x60;&amp;#58; full path (\&quot;/foo/bar/baz.java\&quot;), may contain asterisks as wildcard (e.g., folder name (\&quot;/foo/bar/\&quot;)); may begin with \&quot;!{path-type}\&quot; to narrow down on path type as well (see &#x60;pathType&#x60; below); &#x60;\\\\\\\\ and ! may be escaped with the backslash character to use them literally - &#x60;pathType&#x60;&amp;#58; path type to match (\&quot;file\&quot;) - &#x60;descriptor&#x60;&amp;#58; descriptor ID (\&quot;descriptor&amp;#58;123\&quot;), descriptor code (\&quot;code&amp;#58;FOO-BAR\&quot;), or descriptor group ID (\&quot;group&amp;#58;32\&quot;) - &#x60;resultDescriptor&#x60;&amp;#58; same as descriptor but matches findings containing a tool result with the given descriptor. Additionally accepts criteria regarding manually-entered results with no tool (\&quot;manual-descriptor&amp;#58;no-tool\&quot;), a specific tool (\&quot;manual-descriptor&amp;#58;&lt;url-encoded tool name&gt;\&quot; e.g. \&quot;manual-descriptor&amp;#58;FindBugs\&quot;), and specific manual descriptors with and without specific tools (\&quot;manual-descriptor&amp;#58;FindBugs&amp;#58;123\&quot;, \&quot;manual-descriptor&amp;#58;no-tool&amp;#58;123\&quot;). - &#x60;severity&#x60;&amp;#58; formal name of severity (\&quot;High\&quot;) or numeric value (\&quot;2\&quot; or 2) - &#x60;status&#x60;&amp;#58; Encoded triage status (\&quot;6\&quot; or \&quot;8&amp;#58;3\&quot; - these are provided by the Project Statuses endpoint), triage status name (\&quot;new\&quot;, \&quot;false-positive\&quot;, etc.), \&quot;assigned&amp;#58;\&quot; (to match findings assigned to the given username), \&quot;assigned\&quot; (or \&quot;assigned&amp;#58;*\&quot;) (to match any assigned status regardless of the target) - &#x60;toolOverlap&#x60;&amp;#58; number of detecting tools (\&quot;tool-count&amp;#58;2\&quot;) or group of detecting tools (\&quot;tool-list&amp;#58;Findbugs;PMD\&quot;) - &#x60;issueTrackerAssociationExists&#x60;&amp;#58; whether or not an issue tracker assocation exists (true or false) - &#x60;issueTrackerAssociationStatus&#x60;&amp;#58; existence flag (\&quot;exists&amp;#58;false\&quot;), issue tracker status (\&quot;status&amp;#58;new\&quot;), or issue tracker key (\&quot;issue-key&amp;#58;foo\&quot;)  - &#x60;issueTrackerAssociationResolution&#x60;: existence flag (\&quot;exists&amp;#58;false\&quot;), resolved flag - true will return findings that have an associated issue that is resolved while false will return findings that have an associated issue that is not resolved - (\&quot;exists:false\&quot;), issue tracker resolution (\&quot;resolution:resolution name\&quot;) - &#x60;age&#x60;&amp;#58; an age bucket specifier (described in more detail in the &#x60;countBy&#x60; section), without the title, e.g. &#x60;\&quot;90d-30d\&quot;&#x60; - &#x60;firstSeen&#x60;&amp;#58;  a Date Range object indicating a time during which the matched findings were first seen (i.e. created) - &#x60;lastModified&#x60;&amp;#58; a Date Range object indicating a time during which the matched findings were last modified (e.g. edited, status changed). - &#x60;includeDescendantProjects&#x60;&amp;#58;  must be either true or false (arrays are not supported with this field). If true, results will include all findings in all projects descending from (and including) the project with which the filter object is used, and which you have permission to view. In other words, all findings in the current project group.  Filter object fields may be negated by prefixing a tilde (&#x60;~&#x60;) to the field name. 
 */
@ApiModel(description = "Filter objects serve to communicate the filters to be applied to a data query. Filter objects are simple JS objects containing a field for each filtered field. Filter fields are ANDed together along with the base filter (which presently filters by findings not pending a purge action). Fields may contain a single value or an array of values. The possible filter fields and their expected values are described below. The IDs provided by the grouped-counts data endpoint fit the expected values. - `cwe`&#58; CWE ID (\"398\" or 398, must be positive) or \"none\" - `finding`&#58; finding ID (\"1234\" or 1234) - `detectionMethod`&#58; The ID value of the detection method (e.g. 1 for 'Static Analysis') - `path`&#58; full path (\"/foo/bar/baz.java\"), may contain asterisks as wildcard (e.g., folder name (\"/foo/bar/\")); may begin with \"!{path-type}\" to narrow down on path type as well (see `pathType` below); `\\\\\\\\ and ! may be escaped with the backslash character to use them literally - `pathType`&#58; path type to match (\"file\") - `descriptor`&#58; descriptor ID (\"descriptor&#58;123\"), descriptor code (\"code&#58;FOO-BAR\"), or descriptor group ID (\"group&#58;32\") - `resultDescriptor`&#58; same as descriptor but matches findings containing a tool result with the given descriptor. Additionally accepts criteria regarding manually-entered results with no tool (\"manual-descriptor&#58;no-tool\"), a specific tool (\"manual-descriptor&#58;<url-encoded tool name>\" e.g. \"manual-descriptor&#58;FindBugs\"), and specific manual descriptors with and without specific tools (\"manual-descriptor&#58;FindBugs&#58;123\", \"manual-descriptor&#58;no-tool&#58;123\"). - `severity`&#58; formal name of severity (\"High\") or numeric value (\"2\" or 2) - `status`&#58; Encoded triage status (\"6\" or \"8&#58;3\" - these are provided by the Project Statuses endpoint), triage status name (\"new\", \"false-positive\", etc.), \"assigned&#58;\" (to match findings assigned to the given username), \"assigned\" (or \"assigned&#58;*\") (to match any assigned status regardless of the target) - `toolOverlap`&#58; number of detecting tools (\"tool-count&#58;2\") or group of detecting tools (\"tool-list&#58;Findbugs;PMD\") - `issueTrackerAssociationExists`&#58; whether or not an issue tracker assocation exists (true or false) - `issueTrackerAssociationStatus`&#58; existence flag (\"exists&#58;false\"), issue tracker status (\"status&#58;new\"), or issue tracker key (\"issue-key&#58;foo\")  - `issueTrackerAssociationResolution`: existence flag (\"exists&#58;false\"), resolved flag - true will return findings that have an associated issue that is resolved while false will return findings that have an associated issue that is not resolved - (\"exists:false\"), issue tracker resolution (\"resolution:resolution name\") - `age`&#58; an age bucket specifier (described in more detail in the `countBy` section), without the title, e.g. `\"90d-30d\"` - `firstSeen`&#58;  a Date Range object indicating a time during which the matched findings were first seen (i.e. created) - `lastModified`&#58; a Date Range object indicating a time during which the matched findings were last modified (e.g. edited, status changed). - `includeDescendantProjects`&#58;  must be either true or false (arrays are not supported with this field). If true, results will include all findings in all projects descending from (and including) the project with which the filter object is used, and which you have permission to view. In other words, all findings in the current project group.  Filter object fields may be negated by prefixing a tilde (`~`) to the field name. ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-12-07T19:30:21.793Z")
public class Filter extends HashMap<String, Object> {

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    return super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Filter {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

