/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.client.api;

import com.codedx.client.ApiCallback;
import com.codedx.client.ApiClient;
import com.codedx.client.ApiException;
import com.codedx.client.ApiResponse;
import com.codedx.client.Configuration;
import com.codedx.client.Pair;
import com.codedx.client.ProgressRequestBody;
import com.codedx.client.ProgressResponseBody;
import com.codedx.client.model.ActivityEvent;
import com.codedx.client.model.Count;
import com.codedx.client.model.Finding;
import com.codedx.client.model.FindingDescription;
import com.codedx.client.model.FlowData;
import com.codedx.client.model.FlowRequest;
import com.codedx.client.model.GroupedCount;
import com.codedx.client.model.GroupedCountsRequest;
import com.codedx.client.model.Query;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FindingDataApi {
    private ApiClient apiClient;

    public FindingDataApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FindingDataApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getFindingDataCall(Integer n, List<String> list, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string = "/api/findings/{finding-id}".replaceAll("\\{finding-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        if (list != null) {
            arrayList2.addAll(this.apiClient.parameterToPairs("csv", "expand", list));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getFindingDataValidateBeforeCall(Integer n, List<String> list, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'findingId' when calling getFindingData(Async)");
        }
        Call call = this.getFindingDataCall(n, list, progressListener, progressRequestListener);
        return call;
    }

    public Finding getFindingData(Integer n, List<String> list) throws ApiException {
        ApiResponse<Finding> apiResponse = this.getFindingDataWithHttpInfo(n, list);
        return apiResponse.getData();
    }

    public ApiResponse<Finding> getFindingDataWithHttpInfo(Integer n, List<String> list) throws ApiException {
        Call call = this.getFindingDataValidateBeforeCall(n, list, null, null);
        Type type = new TypeToken<Finding>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getFindingDataAsync(Integer n, List<String> list, final ApiCallback<Finding> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getFindingDataValidateBeforeCall(n, list, progressListener, progressRequestListener);
        Type type = new TypeToken<Finding>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getFindingDescriptionCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/findings/{finding-id}/description".replaceAll("\\{finding-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getFindingDescriptionValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'findingId' when calling getFindingDescription(Async)");
        }
        Call call = this.getFindingDescriptionCall(n, progressListener, progressRequestListener);
        return call;
    }

    public FindingDescription getFindingDescription(Integer n) throws ApiException {
        ApiResponse<FindingDescription> apiResponse = this.getFindingDescriptionWithHttpInfo(n);
        return apiResponse.getData();
    }

    public ApiResponse<FindingDescription> getFindingDescriptionWithHttpInfo(Integer n) throws ApiException {
        Call call = this.getFindingDescriptionValidateBeforeCall(n, null, null);
        Type type = new TypeToken<FindingDescription>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getFindingDescriptionAsync(Integer n, final ApiCallback<FindingDescription> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getFindingDescriptionValidateBeforeCall(n, progressListener, progressRequestListener);
        Type type = new TypeToken<FindingDescription>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getFindingFlowCall(Integer n, FlowRequest flowRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        FlowRequest flowRequest2 = flowRequest;
        String string = "/api/projects/{project-id}/findings/flow".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, flowRequest2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getFindingFlowValidateBeforeCall(Integer n, FlowRequest flowRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getFindingFlow(Async)");
        }
        Call call = this.getFindingFlowCall(n, flowRequest, progressListener, progressRequestListener);
        return call;
    }

    public List<FlowData> getFindingFlow(Integer n, FlowRequest flowRequest) throws ApiException {
        ApiResponse<List<FlowData>> apiResponse = this.getFindingFlowWithHttpInfo(n, flowRequest);
        return apiResponse.getData();
    }

    public ApiResponse<List<FlowData>> getFindingFlowWithHttpInfo(Integer n, FlowRequest flowRequest) throws ApiException {
        Call call = this.getFindingFlowValidateBeforeCall(n, flowRequest, null, null);
        Type type = new TypeToken<List<FlowData>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getFindingFlowAsync(Integer n, FlowRequest flowRequest, final ApiCallback<List<FlowData>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getFindingFlowValidateBeforeCall(n, flowRequest, progressListener, progressRequestListener);
        Type type = new TypeToken<List<FlowData>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getFindingHistoryCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/findings/{finding-id}/history".replaceAll("\\{finding-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getFindingHistoryValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'findingId' when calling getFindingHistory(Async)");
        }
        Call call = this.getFindingHistoryCall(n, progressListener, progressRequestListener);
        return call;
    }

    public List<ActivityEvent> getFindingHistory(Integer n) throws ApiException {
        ApiResponse<List<ActivityEvent>> apiResponse = this.getFindingHistoryWithHttpInfo(n);
        return apiResponse.getData();
    }

    public ApiResponse<List<ActivityEvent>> getFindingHistoryWithHttpInfo(Integer n) throws ApiException {
        Call call = this.getFindingHistoryValidateBeforeCall(n, null, null);
        Type type = new TypeToken<List<ActivityEvent>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getFindingHistoryAsync(Integer n, final ApiCallback<List<ActivityEvent>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getFindingHistoryValidateBeforeCall(n, progressListener, progressRequestListener);
        Type type = new TypeToken<List<ActivityEvent>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getFindingsCountCall(Integer n, Query query, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Query query2 = query;
        String string = "/api/projects/{project-id}/findings/count".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, query2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getFindingsCountValidateBeforeCall(Integer n, Query query, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getFindingsCount(Async)");
        }
        Call call = this.getFindingsCountCall(n, query, progressListener, progressRequestListener);
        return call;
    }

    public Count getFindingsCount(Integer n, Query query) throws ApiException {
        ApiResponse<Count> apiResponse = this.getFindingsCountWithHttpInfo(n, query);
        return apiResponse.getData();
    }

    public ApiResponse<Count> getFindingsCountWithHttpInfo(Integer n, Query query) throws ApiException {
        Call call = this.getFindingsCountValidateBeforeCall(n, query, null, null);
        Type type = new TypeToken<Count>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getFindingsCountAsync(Integer n, Query query, final ApiCallback<Count> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getFindingsCountValidateBeforeCall(n, query, progressListener, progressRequestListener);
        Type type = new TypeToken<Count>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getFindingsGroupCountCall(Integer n, GroupedCountsRequest groupedCountsRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GroupedCountsRequest groupedCountsRequest2 = groupedCountsRequest;
        String string = "/api/projects/{project-id}/findings/grouped-counts".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, groupedCountsRequest2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getFindingsGroupCountValidateBeforeCall(Integer n, GroupedCountsRequest groupedCountsRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getFindingsGroupCount(Async)");
        }
        Call call = this.getFindingsGroupCountCall(n, groupedCountsRequest, progressListener, progressRequestListener);
        return call;
    }

    public List<GroupedCount> getFindingsGroupCount(Integer n, GroupedCountsRequest groupedCountsRequest) throws ApiException {
        ApiResponse<List<GroupedCount>> apiResponse = this.getFindingsGroupCountWithHttpInfo(n, groupedCountsRequest);
        return apiResponse.getData();
    }

    public ApiResponse<List<GroupedCount>> getFindingsGroupCountWithHttpInfo(Integer n, GroupedCountsRequest groupedCountsRequest) throws ApiException {
        Call call = this.getFindingsGroupCountValidateBeforeCall(n, groupedCountsRequest, null, null);
        Type type = new TypeToken<List<GroupedCount>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getFindingsGroupCountAsync(Integer n, GroupedCountsRequest groupedCountsRequest, final ApiCallback<List<GroupedCount>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getFindingsGroupCountValidateBeforeCall(n, groupedCountsRequest, progressListener, progressRequestListener);
        Type type = new TypeToken<List<GroupedCount>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getFindingsTableCall(Integer n, Query query, List<String> list, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Query query2 = query;
        String string = "/api/projects/{project-id}/findings/table".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        if (list != null) {
            arrayList2.addAll(this.apiClient.parameterToPairs("csv", "expand", list));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, query2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getFindingsTableValidateBeforeCall(Integer n, Query query, List<String> list, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getFindingsTable(Async)");
        }
        Call call = this.getFindingsTableCall(n, query, list, progressListener, progressRequestListener);
        return call;
    }

    public List<Finding> getFindingsTable(Integer n, Query query, List<String> list) throws ApiException {
        ApiResponse<List<Finding>> apiResponse = this.getFindingsTableWithHttpInfo(n, query, list);
        return apiResponse.getData();
    }

    public ApiResponse<List<Finding>> getFindingsTableWithHttpInfo(Integer n, Query query, List<String> list) throws ApiException {
        Call call = this.getFindingsTableValidateBeforeCall(n, query, list, null, null);
        Type type = new TypeToken<List<Finding>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getFindingsTableAsync(Integer n, Query query, List<String> list, final ApiCallback<List<Finding>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getFindingsTableValidateBeforeCall(n, query, list, progressListener, progressRequestListener);
        Type type = new TypeToken<List<Finding>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getSourceFileContentsCall(Integer n, Integer n2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string = "/api/projects/{project-id}/files/{path-id}".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString())).replaceAll("\\{path-id\\}", this.apiClient.escapeString(n2.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"text/plain"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getSourceFileContentsValidateBeforeCall(Integer n, Integer n2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getSourceFileContents(Async)");
        }
        if (n2 == null) {
            throw new ApiException("Missing the required parameter 'pathId' when calling getSourceFileContents(Async)");
        }
        Call call = this.getSourceFileContentsCall(n, n2, progressListener, progressRequestListener);
        return call;
    }

    public String getSourceFileContents(Integer n, Integer n2) throws ApiException {
        ApiResponse<String> apiResponse = this.getSourceFileContentsWithHttpInfo(n, n2);
        return apiResponse.getData();
    }

    public ApiResponse<String> getSourceFileContentsWithHttpInfo(Integer n, Integer n2) throws ApiException {
        Call call = this.getSourceFileContentsValidateBeforeCall(n, n2, null, null);
        Type type = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getSourceFileContentsAsync(Integer n, Integer n2, final ApiCallback<String> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getSourceFileContentsValidateBeforeCall(n, n2, progressListener, progressRequestListener);
        Type type = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getSourceFileContentsFromPathCall(Integer n, String string, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string2 = "/api/projects/{project-id}/files/tree/{path}".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString())).replaceAll("\\{path\\}", this.apiClient.escapeString(string.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"text/plain"};
        String string3 = this.apiClient.selectHeaderAccept(stringArray);
        if (string3 != null) {
            hashMap.put("Accept", string3);
        }
        String[] stringArray2 = new String[]{};
        String string4 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string4);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string2, "GET", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getSourceFileContentsFromPathValidateBeforeCall(Integer n, String string, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getSourceFileContentsFromPath(Async)");
        }
        if (string == null) {
            throw new ApiException("Missing the required parameter 'path' when calling getSourceFileContentsFromPath(Async)");
        }
        Call call = this.getSourceFileContentsFromPathCall(n, string, progressListener, progressRequestListener);
        return call;
    }

    public String getSourceFileContentsFromPath(Integer n, String string) throws ApiException {
        ApiResponse<String> apiResponse = this.getSourceFileContentsFromPathWithHttpInfo(n, string);
        return apiResponse.getData();
    }

    public ApiResponse<String> getSourceFileContentsFromPathWithHttpInfo(Integer n, String string) throws ApiException {
        Call call = this.getSourceFileContentsFromPathValidateBeforeCall(n, string, null, null);
        Type type = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getSourceFileContentsFromPathAsync(Integer n, String string, final ApiCallback<String> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getSourceFileContentsFromPathValidateBeforeCall(n, string, progressListener, progressRequestListener);
        Type type = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }
}

