/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.client.api;

import com.codedx.client.ApiCallback;
import com.codedx.client.ApiClient;
import com.codedx.client.ApiException;
import com.codedx.client.ApiResponse;
import com.codedx.client.Configuration;
import com.codedx.client.Pair;
import com.codedx.client.ProgressRequestBody;
import com.codedx.client.ProgressResponseBody;
import com.codedx.client.model.CreateRule;
import com.codedx.client.model.ModifyRuleResponse;
import com.codedx.client.model.Rule;
import com.codedx.client.model.RuleCriteria;
import com.codedx.client.model.RuleSet;
import com.codedx.client.model.RuleSetContents;
import com.codedx.client.model.RuleSetDeleteResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RuleSetsApi {
    private ApiClient apiClient;

    public RuleSetsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RuleSetsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addRuleCriteriaCall(Integer n, Integer n2, RuleCriteria ruleCriteria, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RuleCriteria ruleCriteria2 = ruleCriteria;
        String string = "/api/ruleset/{ruleset-id}/rule/{rule-id}/criteria".replaceAll("\\{ruleset-id\\}", this.apiClient.escapeString(n.toString())).replaceAll("\\{rule-id\\}", this.apiClient.escapeString(n2.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, ruleCriteria2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call addRuleCriteriaValidateBeforeCall(Integer n, Integer n2, RuleCriteria ruleCriteria, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling addRuleCriteria(Async)");
        }
        if (n2 == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling addRuleCriteria(Async)");
        }
        if (ruleCriteria == null) {
            throw new ApiException("Missing the required parameter 'ruleCriteria' when calling addRuleCriteria(Async)");
        }
        Call call = this.addRuleCriteriaCall(n, n2, ruleCriteria, progressListener, progressRequestListener);
        return call;
    }

    public void addRuleCriteria(Integer n, Integer n2, RuleCriteria ruleCriteria) throws ApiException {
        this.addRuleCriteriaWithHttpInfo(n, n2, ruleCriteria);
    }

    public ApiResponse<Void> addRuleCriteriaWithHttpInfo(Integer n, Integer n2, RuleCriteria ruleCriteria) throws ApiException {
        Call call = this.addRuleCriteriaValidateBeforeCall(n, n2, ruleCriteria, null, null);
        return this.apiClient.execute(call);
    }

    public Call addRuleCriteriaAsync(Integer n, Integer n2, RuleCriteria ruleCriteria, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.addRuleCriteriaValidateBeforeCall(n, n2, ruleCriteria, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call cloneRuleSetCall(Integer n, RuleSet ruleSet, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RuleSet ruleSet2 = ruleSet;
        String string = "/api/ruleset/{ruleset-id}/clone".replaceAll("\\{ruleset-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, ruleSet2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call cloneRuleSetValidateBeforeCall(Integer n, RuleSet ruleSet, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling cloneRuleSet(Async)");
        }
        if (ruleSet == null) {
            throw new ApiException("Missing the required parameter 'ruleSet' when calling cloneRuleSet(Async)");
        }
        Call call = this.cloneRuleSetCall(n, ruleSet, progressListener, progressRequestListener);
        return call;
    }

    public RuleSet cloneRuleSet(Integer n, RuleSet ruleSet) throws ApiException {
        ApiResponse<RuleSet> apiResponse = this.cloneRuleSetWithHttpInfo(n, ruleSet);
        return apiResponse.getData();
    }

    public ApiResponse<RuleSet> cloneRuleSetWithHttpInfo(Integer n, RuleSet ruleSet) throws ApiException {
        Call call = this.cloneRuleSetValidateBeforeCall(n, ruleSet, null, null);
        Type type = new TypeToken<RuleSet>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call cloneRuleSetAsync(Integer n, RuleSet ruleSet, final ApiCallback<RuleSet> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.cloneRuleSetValidateBeforeCall(n, ruleSet, progressListener, progressRequestListener);
        Type type = new TypeToken<RuleSet>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call createRuleCall(Integer n, CreateRule createRule, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateRule createRule2 = createRule;
        String string = "/api/ruleset/{ruleset-id}/rule".replaceAll("\\{ruleset-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, createRule2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call createRuleValidateBeforeCall(Integer n, CreateRule createRule, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling createRule(Async)");
        }
        if (createRule == null) {
            throw new ApiException("Missing the required parameter 'rule' when calling createRule(Async)");
        }
        Call call = this.createRuleCall(n, createRule, progressListener, progressRequestListener);
        return call;
    }

    public Rule createRule(Integer n, CreateRule createRule) throws ApiException {
        ApiResponse<Rule> apiResponse = this.createRuleWithHttpInfo(n, createRule);
        return apiResponse.getData();
    }

    public ApiResponse<Rule> createRuleWithHttpInfo(Integer n, CreateRule createRule) throws ApiException {
        Call call = this.createRuleValidateBeforeCall(n, createRule, null, null);
        Type type = new TypeToken<Rule>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call createRuleAsync(Integer n, CreateRule createRule, final ApiCallback<Rule> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.createRuleValidateBeforeCall(n, createRule, progressListener, progressRequestListener);
        Type type = new TypeToken<Rule>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call createRuleSetCall(RuleSet ruleSet, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RuleSet ruleSet2 = ruleSet;
        String string = "/api/ruleset";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, ruleSet2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call createRuleSetValidateBeforeCall(RuleSet ruleSet, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ruleSet == null) {
            throw new ApiException("Missing the required parameter 'ruleSet' when calling createRuleSet(Async)");
        }
        Call call = this.createRuleSetCall(ruleSet, progressListener, progressRequestListener);
        return call;
    }

    public RuleSet createRuleSet(RuleSet ruleSet) throws ApiException {
        ApiResponse<RuleSet> apiResponse = this.createRuleSetWithHttpInfo(ruleSet);
        return apiResponse.getData();
    }

    public ApiResponse<RuleSet> createRuleSetWithHttpInfo(RuleSet ruleSet) throws ApiException {
        Call call = this.createRuleSetValidateBeforeCall(ruleSet, null, null);
        Type type = new TypeToken<RuleSet>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call createRuleSetAsync(RuleSet ruleSet, final ApiCallback<RuleSet> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.createRuleSetValidateBeforeCall(ruleSet, progressListener, progressRequestListener);
        Type type = new TypeToken<RuleSet>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call deleteRuleCall(Integer n, Integer n2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string = "/api/ruleset/{ruleset-id}/rule/{rule-id}".replaceAll("\\{ruleset-id\\}", this.apiClient.escapeString(n.toString())).replaceAll("\\{rule-id\\}", this.apiClient.escapeString(n2.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "DELETE", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call deleteRuleValidateBeforeCall(Integer n, Integer n2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling deleteRule(Async)");
        }
        if (n2 == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling deleteRule(Async)");
        }
        Call call = this.deleteRuleCall(n, n2, progressListener, progressRequestListener);
        return call;
    }

    public void deleteRule(Integer n, Integer n2) throws ApiException {
        this.deleteRuleWithHttpInfo(n, n2);
    }

    public ApiResponse<Void> deleteRuleWithHttpInfo(Integer n, Integer n2) throws ApiException {
        Call call = this.deleteRuleValidateBeforeCall(n, n2, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteRuleAsync(Integer n, Integer n2, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.deleteRuleValidateBeforeCall(n, n2, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call deleteRuleCriteriaCall(Integer n, Integer n2, RuleCriteria ruleCriteria, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RuleCriteria ruleCriteria2 = ruleCriteria;
        String string = "/api/ruleset/{ruleset-id}/rule/{rule-id}/criteria".replaceAll("\\{ruleset-id\\}", this.apiClient.escapeString(n.toString())).replaceAll("\\{rule-id\\}", this.apiClient.escapeString(n2.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "DELETE", arrayList, arrayList2, ruleCriteria2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call deleteRuleCriteriaValidateBeforeCall(Integer n, Integer n2, RuleCriteria ruleCriteria, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling deleteRuleCriteria(Async)");
        }
        if (n2 == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling deleteRuleCriteria(Async)");
        }
        if (ruleCriteria == null) {
            throw new ApiException("Missing the required parameter 'ruleCriteria' when calling deleteRuleCriteria(Async)");
        }
        Call call = this.deleteRuleCriteriaCall(n, n2, ruleCriteria, progressListener, progressRequestListener);
        return call;
    }

    public void deleteRuleCriteria(Integer n, Integer n2, RuleCriteria ruleCriteria) throws ApiException {
        this.deleteRuleCriteriaWithHttpInfo(n, n2, ruleCriteria);
    }

    public ApiResponse<Void> deleteRuleCriteriaWithHttpInfo(Integer n, Integer n2, RuleCriteria ruleCriteria) throws ApiException {
        Call call = this.deleteRuleCriteriaValidateBeforeCall(n, n2, ruleCriteria, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteRuleCriteriaAsync(Integer n, Integer n2, RuleCriteria ruleCriteria, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.deleteRuleCriteriaValidateBeforeCall(n, n2, ruleCriteria, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call deleteRuleSetCall(Integer n, Boolean bl, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string = "/api/ruleset/{ruleset-id}".replaceAll("\\{ruleset-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        if (bl != null) {
            arrayList.addAll(this.apiClient.parameterToPair("force", bl));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "DELETE", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call deleteRuleSetValidateBeforeCall(Integer n, Boolean bl, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling deleteRuleSet(Async)");
        }
        Call call = this.deleteRuleSetCall(n, bl, progressListener, progressRequestListener);
        return call;
    }

    public RuleSetDeleteResponse deleteRuleSet(Integer n, Boolean bl) throws ApiException {
        ApiResponse<RuleSetDeleteResponse> apiResponse = this.deleteRuleSetWithHttpInfo(n, bl);
        return apiResponse.getData();
    }

    public ApiResponse<RuleSetDeleteResponse> deleteRuleSetWithHttpInfo(Integer n, Boolean bl) throws ApiException {
        Call call = this.deleteRuleSetValidateBeforeCall(n, bl, null, null);
        Type type = new TypeToken<RuleSetDeleteResponse>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call deleteRuleSetAsync(Integer n, Boolean bl, final ApiCallback<RuleSetDeleteResponse> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.deleteRuleSetValidateBeforeCall(n, bl, progressListener, progressRequestListener);
        Type type = new TypeToken<RuleSetDeleteResponse>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call exportRuleSetCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/ruleset/{ruleset-id}/export".replaceAll("\\{ruleset-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"text/xml"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call exportRuleSetValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling exportRuleSet(Async)");
        }
        Call call = this.exportRuleSetCall(n, progressListener, progressRequestListener);
        return call;
    }

    public File exportRuleSet(Integer n) throws ApiException {
        ApiResponse<File> apiResponse = this.exportRuleSetWithHttpInfo(n);
        return apiResponse.getData();
    }

    public ApiResponse<File> exportRuleSetWithHttpInfo(Integer n) throws ApiException {
        Call call = this.exportRuleSetValidateBeforeCall(n, null, null);
        Type type = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call exportRuleSetAsync(Integer n, final ApiCallback<File> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.exportRuleSetValidateBeforeCall(n, progressListener, progressRequestListener);
        Type type = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getAllRuleSetsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var3_3 = null;
        String string = "/api/ruleset/all";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var3_3, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getAllRuleSetsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAllRuleSetsCall(progressListener, progressRequestListener);
        return call;
    }

    public List<RuleSet> getAllRuleSets() throws ApiException {
        ApiResponse<List<RuleSet>> apiResponse = this.getAllRuleSetsWithHttpInfo();
        return apiResponse.getData();
    }

    public ApiResponse<List<RuleSet>> getAllRuleSetsWithHttpInfo() throws ApiException {
        Call call = this.getAllRuleSetsValidateBeforeCall(null, null);
        Type type = new TypeToken<List<RuleSet>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getAllRuleSetsAsync(final ApiCallback<List<RuleSet>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getAllRuleSetsValidateBeforeCall(progressListener, progressRequestListener);
        Type type = new TypeToken<List<RuleSet>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getRuleDataCall(Integer n, Integer n2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string = "/api/ruleset/{ruleset-id}/rule/{rule-id}".replaceAll("\\{ruleset-id\\}", this.apiClient.escapeString(n.toString())).replaceAll("\\{rule-id\\}", this.apiClient.escapeString(n2.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getRuleDataValidateBeforeCall(Integer n, Integer n2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling getRuleData(Async)");
        }
        if (n2 == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling getRuleData(Async)");
        }
        Call call = this.getRuleDataCall(n, n2, progressListener, progressRequestListener);
        return call;
    }

    public Rule getRuleData(Integer n, Integer n2) throws ApiException {
        ApiResponse<Rule> apiResponse = this.getRuleDataWithHttpInfo(n, n2);
        return apiResponse.getData();
    }

    public ApiResponse<Rule> getRuleDataWithHttpInfo(Integer n, Integer n2) throws ApiException {
        Call call = this.getRuleDataValidateBeforeCall(n, n2, null, null);
        Type type = new TypeToken<Rule>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getRuleDataAsync(Integer n, Integer n2, final ApiCallback<Rule> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getRuleDataValidateBeforeCall(n, n2, progressListener, progressRequestListener);
        Type type = new TypeToken<Rule>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getRuleSetContentsCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/ruleset/{ruleset-id}".replaceAll("\\{ruleset-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getRuleSetContentsValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling getRuleSetContents(Async)");
        }
        Call call = this.getRuleSetContentsCall(n, progressListener, progressRequestListener);
        return call;
    }

    public RuleSetContents getRuleSetContents(Integer n) throws ApiException {
        ApiResponse<RuleSetContents> apiResponse = this.getRuleSetContentsWithHttpInfo(n);
        return apiResponse.getData();
    }

    public ApiResponse<RuleSetContents> getRuleSetContentsWithHttpInfo(Integer n) throws ApiException {
        Call call = this.getRuleSetContentsValidateBeforeCall(n, null, null);
        Type type = new TypeToken<RuleSetContents>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getRuleSetContentsAsync(Integer n, final ApiCallback<RuleSetContents> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getRuleSetContentsValidateBeforeCall(n, progressListener, progressRequestListener);
        Type type = new TypeToken<RuleSetContents>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call modifyRuleDataCall(Integer n, Integer n2, CreateRule createRule, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateRule createRule2 = createRule;
        String string = "/api/ruleset/{ruleset-id}/rule/{rule-id}".replaceAll("\\{ruleset-id\\}", this.apiClient.escapeString(n.toString())).replaceAll("\\{rule-id\\}", this.apiClient.escapeString(n2.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "PUT", arrayList, arrayList2, createRule2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call modifyRuleDataValidateBeforeCall(Integer n, Integer n2, CreateRule createRule, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling modifyRuleData(Async)");
        }
        if (n2 == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling modifyRuleData(Async)");
        }
        if (createRule == null) {
            throw new ApiException("Missing the required parameter 'rule' when calling modifyRuleData(Async)");
        }
        Call call = this.modifyRuleDataCall(n, n2, createRule, progressListener, progressRequestListener);
        return call;
    }

    public ModifyRuleResponse modifyRuleData(Integer n, Integer n2, CreateRule createRule) throws ApiException {
        ApiResponse<ModifyRuleResponse> apiResponse = this.modifyRuleDataWithHttpInfo(n, n2, createRule);
        return apiResponse.getData();
    }

    public ApiResponse<ModifyRuleResponse> modifyRuleDataWithHttpInfo(Integer n, Integer n2, CreateRule createRule) throws ApiException {
        Call call = this.modifyRuleDataValidateBeforeCall(n, n2, createRule, null, null);
        Type type = new TypeToken<ModifyRuleResponse>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call modifyRuleDataAsync(Integer n, Integer n2, CreateRule createRule, final ApiCallback<ModifyRuleResponse> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.modifyRuleDataValidateBeforeCall(n, n2, createRule, progressListener, progressRequestListener);
        Type type = new TypeToken<ModifyRuleResponse>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call renameRuleSetCall(Integer n, RuleSet ruleSet, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RuleSet ruleSet2 = ruleSet;
        String string = "/api/ruleset/{ruleset-id}".replaceAll("\\{ruleset-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "PUT", arrayList, arrayList2, ruleSet2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call renameRuleSetValidateBeforeCall(Integer n, RuleSet ruleSet, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling renameRuleSet(Async)");
        }
        if (ruleSet == null) {
            throw new ApiException("Missing the required parameter 'ruleSet' when calling renameRuleSet(Async)");
        }
        Call call = this.renameRuleSetCall(n, ruleSet, progressListener, progressRequestListener);
        return call;
    }

    public RuleSet renameRuleSet(Integer n, RuleSet ruleSet) throws ApiException {
        ApiResponse<RuleSet> apiResponse = this.renameRuleSetWithHttpInfo(n, ruleSet);
        return apiResponse.getData();
    }

    public ApiResponse<RuleSet> renameRuleSetWithHttpInfo(Integer n, RuleSet ruleSet) throws ApiException {
        Call call = this.renameRuleSetValidateBeforeCall(n, ruleSet, null, null);
        Type type = new TypeToken<RuleSet>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call renameRuleSetAsync(Integer n, RuleSet ruleSet, final ApiCallback<RuleSet> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.renameRuleSetValidateBeforeCall(n, ruleSet, progressListener, progressRequestListener);
        Type type = new TypeToken<RuleSet>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call updateRuleSetCall(File file, Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] stringArray;
        String string;
        Object var5_5 = null;
        String string2 = "/api/ruleset/{ruleset-id}/update".replaceAll("\\{ruleset-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        if (file != null) {
            hashMap2.put("ruleSetXml", file);
        }
        if ((string = this.apiClient.selectHeaderAccept(stringArray = new String[0])) != null) {
            hashMap.put("Accept", string);
        }
        String[] stringArray2 = new String[]{"multipart/form-data"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string2, "POST", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call updateRuleSetValidateBeforeCall(File file, Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'ruleSetXml' when calling updateRuleSet(Async)");
        }
        if (n == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling updateRuleSet(Async)");
        }
        Call call = this.updateRuleSetCall(file, n, progressListener, progressRequestListener);
        return call;
    }

    public RuleSet updateRuleSet(File file, Integer n) throws ApiException {
        ApiResponse<RuleSet> apiResponse = this.updateRuleSetWithHttpInfo(file, n);
        return apiResponse.getData();
    }

    public ApiResponse<RuleSet> updateRuleSetWithHttpInfo(File file, Integer n) throws ApiException {
        Call call = this.updateRuleSetValidateBeforeCall(file, n, null, null);
        Type type = new TypeToken<RuleSet>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call updateRuleSetAsync(File file, Integer n, final ApiCallback<RuleSet> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.updateRuleSetValidateBeforeCall(file, n, progressListener, progressRequestListener);
        Type type = new TypeToken<RuleSet>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call uploadRuleSetCall(File file, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] stringArray;
        String string;
        Object var4_4 = null;
        String string2 = "/api/ruleset/import";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        if (file != null) {
            hashMap2.put("ruleSetXml", file);
        }
        if ((string = this.apiClient.selectHeaderAccept(stringArray = new String[0])) != null) {
            hashMap.put("Accept", string);
        }
        String[] stringArray2 = new String[]{"multipart/form-data"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string2, "POST", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call uploadRuleSetValidateBeforeCall(File file, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'ruleSetXml' when calling uploadRuleSet(Async)");
        }
        Call call = this.uploadRuleSetCall(file, progressListener, progressRequestListener);
        return call;
    }

    public RuleSet uploadRuleSet(File file) throws ApiException {
        ApiResponse<RuleSet> apiResponse = this.uploadRuleSetWithHttpInfo(file);
        return apiResponse.getData();
    }

    public ApiResponse<RuleSet> uploadRuleSetWithHttpInfo(File file) throws ApiException {
        Call call = this.uploadRuleSetValidateBeforeCall(file, null, null);
        Type type = new TypeToken<RuleSet>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call uploadRuleSetAsync(File file, final ApiCallback<RuleSet> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.uploadRuleSetValidateBeforeCall(file, progressListener, progressRequestListener);
        Type type = new TypeToken<RuleSet>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }
}

