/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.datadoghq.datadog_lambda_java.DDLogger;
import com.datadoghq.datadog_lambda_java.DDTraceContext;
import com.datadoghq.datadog_lambda_java.XRayTraceContext;
import com.datadoghq.datadog_lambda_java.XraySubsegment;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

class ConverterSubsegment {
    private String name = "datadog-metadata";
    private String id;
    private Double start_time = (double)new Date().getTime() / 1000.0;
    private Double end_time;
    private String type = "subsegment";
    private DDTraceContext ddt;
    private XRayTraceContext xrt;

    public void setId(String id) {
        this.id = id;
    }

    public void setStart_time(Double start_time) {
        this.start_time = start_time;
    }

    public void setEnd_time(Double end_time) {
        this.end_time = end_time;
    }

    public ConverterSubsegment(DDTraceContext ctx, XRayTraceContext xrt) {
        byte[] idBytes = new byte[8];
        Random rnd = new Random();
        rnd.nextBytes(idBytes);
        this.id = "";
        for (byte b : idBytes) {
            this.id = this.id + String.format("%02x", b);
        }
        this.end_time = (double)new Date().getTime() / 1000.0;
        this.ddt = ctx;
        this.xrt = xrt;
    }

    public String toJSONString() {
        XraySubsegment.XraySubsegmentBuilder xrb = new XraySubsegment.XraySubsegmentBuilder();
        XraySubsegment xrs = xrb.name(this.name).id(this.id).startTime(this.start_time).endTime(this.end_time).type(this.type).parentId(this.xrt.getParentId()).traceId(this.xrt.getTraceId()).ddTraceId(this.ddt.getTraceID()).ddSamplingPriority(this.ddt.getSamplingPriority()).ddParentId(this.ddt.getParentID()).build();
        Gson g = new Gson();
        return g.toJson((Object)xrs);
    }

    public boolean sendToXRay() {
        DatagramSocket socket;
        int daemon_port;
        InetAddress daemon_address;
        if (this.id == null || this.id.equals("")) {
            return false;
        }
        String daemon_address_port = System.getenv("AWS_XRAY_DAEMON_ADDRESS");
        if (daemon_address_port != null) {
            if (daemon_address_port.split(":").length != 2) {
                DDLogger.getLoggerImpl().error("Unexpected AWS_XRAY_DAEMON_ADDRESS value: ", daemon_address_port);
                return false;
            }
        } else {
            DDLogger.getLoggerImpl().error("Unable to get AWS_XRAY_DAEMON_ADDRESS from environment vars", new Object[0]);
            return false;
        }
        String s_daemon_ip = daemon_address_port.split(":")[0];
        String s_daemon_port = daemon_address_port.split(":")[1];
        DDLogger.getLoggerImpl().debug("AWS XRay Address: ", s_daemon_ip);
        DDLogger.getLoggerImpl().debug("AWS XRay Port: ", s_daemon_port);
        try {
            daemon_address = InetAddress.getByName(s_daemon_ip);
        }
        catch (UnknownHostException e) {
            DDLogger.getLoggerImpl().error("Unexpected exception looking up the AWS_XRAY_DAEMON_ADDRESS. This address should be a dotted quad and not require host resolution.", new Object[0]);
            return false;
        }
        try {
            daemon_port = Integer.parseInt(s_daemon_port);
        }
        catch (NumberFormatException ne) {
            DDLogger.getLoggerImpl().error("Excepting parsing daemon port" + ne.getMessage(), new Object[0]);
            return false;
        }
        HashMap<String, Object> prefixMap = new HashMap<String, Object>();
        prefixMap.put("format", "json");
        prefixMap.put("version", 1);
        String s_message = this.toJSONString();
        Gson g = new Gson();
        String s_payload = g.toJson(prefixMap) + "\n" + s_message;
        byte[] payload = s_payload.getBytes();
        DatagramPacket packet = new DatagramPacket(payload, payload.length, daemon_address, daemon_port);
        try {
            socket = new DatagramSocket();
        }
        catch (SocketException e) {
            DDLogger.getLoggerImpl().error("Unable to bind to an available socket! " + e.getMessage(), new Object[0]);
            return false;
        }
        try {
            socket.send(packet);
        }
        catch (IOException e) {
            DDLogger.getLoggerImpl().error("Couldn't send packet! " + e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }
}

