/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.amazonaws.services.lambda.runtime.Context;
import com.datadoghq.datadog_lambda_java.ColdStart;
import com.datadoghq.datadog_lambda_java.DDLogger;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class EnhancedMetric {
    EnhancedMetric() {
    }

    public static Map<String, Object> makeTagsFromContext(Context ctx) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (ctx != null) {
            String[] arnParts = ctx.getInvokedFunctionArn().split(":");
            String region = "";
            String accountId = "";
            String alias = "";
            if (arnParts.length > 3) {
                region = arnParts[3];
            }
            if (arnParts.length > 4) {
                accountId = arnParts[4];
            }
            if (arnParts.length > 7) {
                alias = arnParts[7];
            }
            if (!alias.isEmpty()) {
                if (alias.startsWith("$")) {
                    alias = alias.substring(1);
                } else if (!StringUtils.isNumeric((CharSequence)alias)) {
                    m.put("executedversion", ctx.getFunctionVersion());
                }
                m.put("resource", ctx.getFunctionName() + ":" + alias);
            } else {
                m.put("resource", ctx.getFunctionName());
            }
            m.put("functionname", ctx.getFunctionName());
            m.put("region", region);
            m.put("account_id", accountId);
            m.put("memorysize", ctx.getMemoryLimitInMB());
            m.put("cold_start", ColdStart.getColdStart(ctx));
            m.put("datadog_lambda", "0.3.2");
        } else {
            DDLogger.getLoggerImpl().debug("Unable to enhance metrics: context was null.", new Object[0]);
        }
        String runtime = "java" + System.getProperty("java.version");
        m.put("runtime", runtime);
        return m;
    }
}

