/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.datatype.json.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientSimpleSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSimpleSubscriber.class);
    private final Session session = Diffusion.sessions().principal("client").password("password").open("ws://diffusion.example.com:80");

    public ClientSimpleSubscriber() {
        Topics topics = (Topics)this.session.feature(Topics.class);
        topics.addStream(">Foo", String.class, (Topics.ValueStream)new FooStream());
        topics.addStream(">Bar//", JSON.class, (Topics.ValueStream)new BarStream());
        topics.subscribe(Diffusion.topicSelectors().anyOf(new String[]{"Foo", "Bar//"})).whenComplete((voidResult, exception) -> {
            if (exception != null) {
                LOG.info("subscription failed", exception);
            }
        });
    }

    public void close() {
        this.session.close();
    }

    private class BarStream
    extends Topics.ValueStream.Default<JSON> {
        private BarStream() {
        }

        public void onValue(String topicPath, TopicSpecification specification, JSON oldValue, JSON newValue) {
            LOG.info(newValue.toJsonString());
        }
    }

    private class FooStream
    extends Topics.ValueStream.Default<String> {
        private FooStream() {
        }

        public void onValue(String topicPath, TopicSpecification specification, String oldValue, String newValue) {
            LOG.info(newValue);
        }
    }
}

