/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.datatype.json.JSONDataType;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ControlClientPartiallyUpdatingTopic {
    private static final JSONDataType JSON_DATATYPE = Diffusion.dataTypes().json();
    private final Session session;
    private final TopicUpdate topicUpdate;

    public ControlClientPartiallyUpdatingTopic(String serverUrl) {
        this.session = Diffusion.sessions().principal("control").password("password").open(serverUrl);
        this.topicUpdate = (TopicUpdate)this.session.feature(TopicUpdate.class);
    }

    public void applySimpleJsonPatch(String topicPath) throws ExecutionException, InterruptedException, TimeoutException {
        TopicSpecification specification = Diffusion.newTopicSpecification((TopicType)TopicType.JSON);
        JSON initialValue = JSON_DATATYPE.fromJsonString("{}");
        this.topicUpdate.addAndSet(topicPath, specification, JSON.class, (Object)initialValue).get(5L, TimeUnit.SECONDS);
        String addArrayPatch = "[{\"op\": \"add\", \"path\": \"/array\", \"value\": [0, 1, 2]}]";
        TopicUpdate.JsonPatchResult result = (TopicUpdate.JsonPatchResult)this.topicUpdate.applyJsonPatch(topicPath, "[{\"op\": \"add\", \"path\": \"/array\", \"value\": [0, 1, 2]}]").get(5L, TimeUnit.SECONDS);
        result.failedOperation().ifPresent(failedOperation -> {});
    }
}

