/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples.runnable;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.binary.Binary;
import com.pushtechnology.diffusion.examples.runnable.AbstractClient;
import com.pushtechnology.diffusion.examples.runnable.RandomData;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ProducingBinary
extends AbstractClient {
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private volatile Future<?> updateTask;

    public ProducingBinary(String url, String principal) {
        super(url, principal);
    }

    @Override
    public void onStarted(Session session) {
        TopicControl topicControl = (TopicControl)session.feature(TopicControl.class);
        TopicSpecification specification = Diffusion.newTopicSpecification((TopicType)TopicType.BINARY).withProperty("REMOVAL", "when this session closes");
        topicControl.addTopic("binary/random", specification);
    }

    @Override
    public void onConnected(Session session) {
        final TopicUpdate topicUpdate = (TopicUpdate)session.feature(TopicUpdate.class);
        this.updateTask = EXECUTOR.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                topicUpdate.set("binary/random", Binary.class, (Object)RandomData.toBinary(RandomData.next()));
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void onDisconnected() {
        this.updateTask.cancel(false);
    }

    public static void main(String[] args) throws InterruptedException {
        ProducingBinary client = new ProducingBinary("ws://diffusion.example.com:80", "auth");
        client.start("auth_secret");
        client.waitForStopped();
    }
}

