/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples.runnable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.examples.runnable.AbstractClient;
import com.pushtechnology.diffusion.examples.runnable.RandomData;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProducingJson
extends AbstractClient {
    private static final Logger LOG = LoggerFactory.getLogger(ProducingJson.class);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private volatile Future<?> updateTask;

    public ProducingJson(String url, String principal) {
        super(url, principal);
    }

    @Override
    public void onStarted(Session session) {
        TopicControl topicControl = (TopicControl)session.feature(TopicControl.class);
        TopicSpecification specification = Diffusion.newTopicSpecification((TopicType)TopicType.JSON).withProperty("REMOVAL", "when this session closes");
        topicControl.addTopic("json/random", specification);
    }

    @Override
    public void onConnected(Session session) {
        final TopicUpdate topicUpdate = (TopicUpdate)session.feature(TopicUpdate.class);
        this.updateTask = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    topicUpdate.set("json/random", JSON.class, (Object)RandomData.toJSON(RandomData.next()));
                }
                catch (JsonProcessingException e) {
                    LOG.warn("Failed to transform data", (Throwable)e);
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void onDisconnected() {
        this.updateTask.cancel(false);
    }

    public static void main(String[] args) throws InterruptedException {
        ProducingJson client = new ProducingJson("ws://diffusion.example.com:80", "auth");
        client.start("auth_secret");
        client.waitForStopped();
    }
}

